/*
 *  winnls.h    Win32 National Language Support (NLS) functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _WINNLS_
#define _WINNLS_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Macro to specify normalization functions */
#define WINNORMALIZEAPI DECLSPEC_IMPORT

/* NLS primitive data types */
typedef DWORD   LGRPID;
typedef DWORD   LCTYPE;
typedef DWORD   CALTYPE;
typedef DWORD   CALID;
typedef DWORD   NLS_FUNCTION;
typedef LONG    GEOID;
typedef DWORD   GEOTYPE;
typedef DWORD   GEOCLASS;

/* Maximum lengths */
#define MAX_LEADBYTES   12
#define MAX_DEFAULTCHAR 2

/* Surrogate pair lengths */
#define HIGH_SURROGATE_START    0xD800
#define HIGH_SURROGATE_END      0xDBFF
#define LOW_SURROGATE_START     0xDC00
#define LOW_SURROGATE_END       0xDFFF

/* MultiByteToWideChar() flags */
#define MB_PRECOMPOSED          0x00000001L
#define MB_COMPOSITE            0x00000002L
#define MB_USEGLYPHCHARS        0x00000004L
#define MB_ERR_INVALID_CHARS    0x00000008L

/* WideCharToMultiByte() flags */
#define WC_DISCARDNS                0x00000010L
#define WC_SEPCHARS                 0x00000020L
#define WC_DEFAULTCHAR              0x00000040L
#define WC_COMPOSITECHECK           0x00000200L
#if (WINVER >= 0x0500)
    #define WC_NO_BEST_FIT_CHARS    0x00000400L
#endif

/* Character information types */
#define CT_CTYPE1   0x00000001L
#define CT_CTYPE2   0x00000002L
#define CT_CTYPE3   0x00000004L

/* Character information flags used with CT_CTYPE1 */
#define C1_UPPER    0x0001
#define C1_LOWER    0x0002
#define C1_DIGIT    0x0004
#define C1_SPACE    0x0008
#define C1_PUNCT    0x0010
#define C1_CNTRL    0x0020
#define C1_BLANK    0x0040
#define C1_XDIGIT   0x0080
#define C1_ALPHA    0x0100
#define C1_DEFINED  0x0200

/* Character information flags used with CT_CTYPE2 */
#define C2_LEFTTORIGHT      0x0001
#define C2_RIGHTTOLEFT      0x0002
#define C2_EUROPENUMBER     0x0003
#define C2_EUROPESEPARATOR  0x0004
#define C2_EUROPETERMINATOR 0x0005
#define C2_ARABICNUMBER     0x0006
#define C2_COMMONSEPARATOR  0x0007
#define C2_BLOCKSEPARATOR   0x0008
#define C2_SEGMENTSEPARATOR 0x0009
#define C2_WHITESPACE       0x000A
#define C2_OTHERNEUTRAL     0x000B
#define C2_NOTAPPLICABLE    0x0000

/* Character information flags used with CT_CTYPE3 */
#define C3_NONSPACING       0x0001
#define C3_DIACRITIC        0x0002
#define C3_VOWELMARK        0x0004
#define C3_SYMBOL           0x0008
#define C3_KATAKANA         0x0010
#define C3_HIRAGANA         0x0020
#define C3_HALFWIDTH        0x0040
#define C3_FULLWIDTH        0x0080
#define C3_IDEOGRAPH        0x0100
#define C3_KASHIDA          0x0200
#define C3_LEXICAL          0x0400
#define C3_HIGHSURROGATE    0x0800
#define C3_LOWSURROGATE     0x1000
#define C3_ALPHA            0x8000
#define C3_NOTAPPLICABLE    0x0000

/* CompareString() and LCMapString() flags */
#define NORM_IGNORECASE             0x00000001L
#define NORM_IGNORENONSPACE         0x00000002L
#define NORM_IGNORESYMBOLS          0x00000004L
#define LINGUISTIC_IGNORECASE       0x00000010L
#define LINGUISTIC_IGNOREDIACRITIC  0x00000020L
#define NORM_IGNOREKANATYPE         0x00010000L
#define NORM_IGNOREWIDTH            0x00020000L
#define NORM_LINGUISTIC_CASING      0x08000000L

/* FoldString() flags */
#define MAP_FOLDCZONE               0x00000010L
#define MAP_PRECOMPOSED             0x00000020L
#define MAP_COMPOSITE               0x00000040L
#define MAP_FOLDDIGITS              0x00000080L
#if (WINVER >= 0x0500)
    #define MAP_EXPAND_LIGATURES    0x00002000L
#endif

/* LCMapString() flags */
#define LCMAP_LOWERCASE             0x00000100L
#define LCMAP_UPPERCASE             0x00000200L
#if (WINVER >= 0x0601)
    #define LCMAP_TITLECASE         0x00000300L
#endif
#define LCMAP_SORTKEY               0x00000400L
#define LCMAP_BYTEREV               0x00000800L
#define LCMAP_HIRAGANA              0x00100000L
#define LCMAP_KATAKANA              0x00200000L
#define LCMAP_HALFWIDTH             0x00400000L
#define LCMAP_FULLWIDTH             0x00800000L
#define LCMAP_LINGUISTIC_CASING     0x01000000L
#define LCMAP_SIMPLIFIED_CHINESE    0x02000000L
#define LCMAP_TRADITIONAL_CHINESE   0x04000000L

/* FindNLSString() flags */
#define FIND_STARTSWITH 0x00100000L
#define FIND_ENDSWITH   0x00200000L
#define FIND_FROMSTART  0x00400000L
#define FIND_FROMEND    0x00800000L

/* EnumSystemLocalesEx() flags */
#if (WINVER >= 0x0600)
    #define LOCALE_ALL              0x00000000L
    #define LOCALE_WINDOWS          0x00000001L
    #define LOCALE_SUPPLEMENTAL     0x00000002L
    #define LOCALE_ALTERNATE_SORTS  0x00000004L
    #define LOCALE_REPLACEMENT      0x00000008L
#endif
#if (WINVER >= 0x0601)
    #define LOCALE_NEUTRALDATA      0x00000010L
    #define LOCALE_SPECIFICDATA     0x00000020L
#endif

/* EnumSystemLanguageGroups() flags */
#define LGRPID_INSTALLED    0x00000001L
#define LGRPID_SUPPORTED    0x00000002L

/* EnumSystemLocales() flags */
#define LCID_INSTALLED          0x00000001L
#define LCID_SUPPORTED          0x00000002L
#define LCID_ALTERNATE_SORTS    0x00000004L

/* EnumSystemCodePages() flags */
#define CP_INSTALLED    0x00000001L
#define CP_SUPPORTED    0x00000002L

/* CompareString() flags */
#define SORT_STRINGSORT             0x00001000L
#if (WINVER >= 0x0601)
    #define SORT_DIGITSASNUMBERS    0x00000008L
#endif

/* CompareString() return values */
#define CSTR_LESS_THAN      1
#define CSTR_EQUAL          2
#define CSTR_GREATER_THAN   3

/* Code page identifiers */
#define CP_ACP          0
#define CP_OEMCP        1
#define CP_MACCP        2
#define CP_THREAD_ACP   3
#define CP_SYMBOL       42
#define CP_UTF7         65000
#define CP_UTF8         65001

/* Country codes */
#define CTRY_DEFAULT            0
#define CTRY_ALBANIA            355
#define CTRY_ALGERIA            213
#define CTRY_ARGENTINA          54
#define CTRY_ARMENIA            374
#define CTRY_AUSTRALIA          61
#define CTRY_AUSTRIA            43
#define CTRY_AZERBAIJAN         994
#define CTRY_BAHRAIN            973
#define CTRY_BELARUS            375
#define CTRY_BELGIUM            32
#define CTRY_BELIZE             501
#define CTRY_BOLIVIA            591
#define CTRY_BRAZIL             55
#define CTRY_BRUNEI_DARUSSALAM  673
#define CTRY_BULGARIA           359
#define CTRY_CANADA             2
#define CTRY_CARIBBEAN          1
#define CTRY_CHILE              56
#define CTRY_COLOMBIA           57
#define CTRY_COSTA_RICA         506
#define CTRY_CROATIA            385
#define CTRY_CZECH              420
#define CTRY_DENMARK            45
#define CTRY_DOMINICAN_REPUBLIC 1
#define CTRY_ECUADOR            593
#define CTRY_EGYPT              20
#define CTRY_EL_SALVADOR        503
#define CTRY_ESTONIA            372
#define CTRY_FAEROE_ISLANDS     298
#define CTRY_FINLAND            358
#define CTRY_FRANCE             33
#define CTRY_GEORGIA            995
#define CTRY_GERMANY            49
#define CTRY_GREECE             30
#define CTRY_GUATEMALA          502
#define CTRY_HONDURAS           504
#define CTRY_HONG_KONG          852
#define CTRY_HUNGARY            36
#define CTRY_ICELAND            354
#define CTRY_INDIA              91
#define CTRY_INDONESIA          62
#define CTRY_IRAN               981
#define CTRY_IRAQ               964
#define CTRY_IRELAND            353
#define CTRY_ISRAEL             972
#define CTRY_ITALY              39
#define CTRY_JAMAICA            1
#define CTRY_JAPAN              81
#define CTRY_JORDAN             962
#define CTRY_KAZAKSTAN          7
#define CTRY_KENYA              254
#define CTRY_KUWAIT             965
#define CTRY_KYRGYZSTAN         996
#define CTRY_LATVIA             371
#define CTRY_LEBANON            961
#define CTRY_LIBYA              218
#define CTRY_LIECHTENSTEIN      41
#define CTRY_LITHUANIA          370
#define CTRY_LUXEMBOURG         352
#define CTRY_MACAU              853
#define CTRY_MACEDONIA          389
#define CTRY_MALAYSIA           60
#define CTRY_MALDIVES           960
#define CTRY_MEXICO             52
#define CTRY_MONACO             33
#define CTRY_MONGOLIA           976
#define CTRY_MOROCCO            212
#define CTRY_NETHERLANDS        31
#define CTRY_NEW_ZEALAND        64
#define CTRY_NICARAGUA          505
#define CTRY_NORWAY             47
#define CTRY_OMAN               968
#define CTRY_PAKISTAN           92
#define CTRY_PANAMA             507
#define CTRY_PARAGUAY           595
#define CTRY_PERU               51
#define CTRY_PHILIPPINES        63
#define CTRY_POLAND             48
#define CTRY_PORTUGAL           351
#define CTRY_PRCHINA            86
#define CTRY_PEURTO_RICO        1
#define CTRY_QATAR              974
#define CTRY_ROMANIA            40
#define CTRY_RUSSIA             7
#define CTRY_SAUDI_ARABIA       966
#define CTRY_SERBIA             381
#define CTRY_SINGAPORE          65
#define CTRY_SLOVAK             421
#define CTRY_SLOVENIA           386
#define CTRY_SOUTH_AFRICA       27
#define CTRY_SOUTH_KOREA        82
#define CTRY_SPAIN              34
#define CTRY_SWEDEN             46
#define CTRY_SWITZERLAND        41
#define CTRY_SYRIA              963
#define CTRY_TAIWAN             886
#define CTRY_TATARSTAN          7
#define CTRY_THAILAND           66
#define CTRY_TRINIDAD_Y_TOBAGO  1
#define CTRY_TUNISIA            216
#define CTRY_TURKEY             90
#define CTRY_UAE                971
#define CTRY_UKRAINE            380
#define CTRY_UNITED_KINGDOM     44
#define CTRY_UNITED_STATES      1
#define CTRY_URUGUAY            598
#define CTRY_UZBEKISTAN         7
#define CTRY_VENEZUELA          58
#define CTRY_VIET_NAM           84
#define CTRY_YEMEN              967
#define CTRY_ZIMBABWE           263

/* Locale information type flags */
#define LOCALE_NOUSEROVERRIDE               0x80000000L
#define LOCALE_USE_CP_ACP                   0x40000000L
#if (WINVER >= 0x0400)
    #define LOCALE_RETURN_NUMBER            0x20000000L
#endif
#if (WINVER >= 0x0601)
    #define LOCALE_RETURN_GENITIVE_NAMES    0x10000000L
    #define LOCALE_ALLOW_NEUTRAL_NAMES      0x08000000L
#endif

/* Locale information types */
#define LOCALE_ILANGUAGE                    0x00000001L
#define LOCALE_SLANGUAGE                    0x00000002L
#define LOCALE_SENGLANGUAGE                 0x00001001L
#define LOCALE_SABBREVLANGNAME              0x00000003L
#define LOCALE_SNATIVELANGNAME              0x00000004L
#define LOCALE_ICOUNTRY                     0x00000005L
#define LOCALE_SCOUNTRY                     0x00000006L
#define LOCALE_SENGCOUNTRY                  0x00001002L
#define LOCALE_SABBREVCTRYNAME              0x00000007L
#define LOCALE_SNATIVECTRYNAME              0x00000008L
#define LOCALE_IGEOID                       0x0000005BL
#define LOCALE_IDEFAULTLANGUAGE             0x00000009L
#define LOCALE_IDEFAULTCOUNTRY              0x0000000AL
#define LOCALE_IDEFAULTCODEPAGE             0x0000000BL
#define LOCALE_IDEFAULTANSICODEPAGE         0x00001004L
#define LOCALE_IDEFAULTMACCODEPAGE          0x00001011L
#define LOCALE_SLIST                        0x0000000CL
#define LOCALE_IMEASURE                     0x0000000DL
#define LOCALE_SDECIMAL                     0x0000000EL
#define LOCALE_STHOUSAND                    0x0000000FL
#define LOCALE_SGROUPING                    0x00000010L
#define LOCALE_IDIGITS                      0x00000011L
#define LOCALE_ILZERO                       0x00000012L
#define LOCALE_INEGNUMBER                   0x00001010L
#define LOCALE_SNATIVEDIGITS                0x00000013L
#define LOCALE_SCURRENCY                    0x00000014L
#define LOCALE_SINTLSYMBOL                  0x00000015L
#define LOCALE_SMONDECIMALSEP               0x00000016L
#define LOCALE_SMONTHOUSANDSEP              0x00000017L
#define LOCALE_SMONGROUPING                 0x00000018L
#define LOCALE_ICURRDIGITS                  0x00000019L
#define LOCALE_IINTLCURRDIGITS              0x0000001AL
#define LOCALE_ICURRENCY                    0x0000001BL
#define LOCALE_INEGCURR                     0x0000001CL
#define LOCALE_SDATE                        0x0000001DL
#define LOCALE_STIME                        0x0000001EL
#define LOCALE_SSHORTDATE                   0x0000001FL
#define LOCALE_SLONGDATE                    0x00000020L
#define LOCALE_STIMEFORMAT                  0x00001003L
#define LOCALE_IDATE                        0x00000021L
#define LOCALE_ILDATE                       0x00000022L
#define LOCALE_ITIME                        0x00000023L
#define LOCALE_ITIMEMARKPOSN                0x00001005L
#define LOCALE_ICENTURY                     0x00000024L
#define LOCALE_ITLZERO                      0x00000025L
#define LOCALE_IDAYLZERO                    0x00000026L
#define LOCALE_IMONLZERO                    0x00000027L
#define LOCALE_S1159                        0x00000028L
#define LOCALE_S2359                        0x00000029L
#define LOCALE_ICALENDARTYPE                0x00001009L
#define LOCALE_IOPTIONALCALENDAR            0x0000100BL
#define LOCALE_IFIRSTDAYOFWEEK              0x0000100CL
#define LOCALE_IFIRSTWEEKOFYEAR             0x0000100DL
#define LOCALE_SDAYNAME1                    0x0000002AL
#define LOCALE_SDAYNAME2                    0x0000002BL
#define LOCALE_SDAYNAME3                    0x0000002CL
#define LOCALE_SDAYNAME4                    0x0000002DL
#define LOCALE_SDAYNAME5                    0x0000002EL
#define LOCALE_SDAYNAME6                    0x0000002FL
#define LOCALE_SDAYNAME7                    0x00000030L
#define LOCALE_SABBREVDAYNAME1              0x00000031L
#define LOCALE_SABBREVDAYNAME2              0x00000032L
#define LOCALE_SABBREVDAYNAME3              0x00000033L
#define LOCALE_SABBREVDAYNAME4              0x00000034L
#define LOCALE_SABBREVDAYNAME5              0x00000035L
#define LOCALE_SABBREVDAYNAME6              0x00000036L
#define LOCALE_SABBREVDAYNAME7              0x00000037L
#define LOCALE_SMONTHNAME1                  0x00000038L
#define LOCALE_SMONTHNAME2                  0x00000039L
#define LOCALE_SMONTHNAME3                  0x0000003AL
#define LOCALE_SMONTHNAME4                  0x0000003BL
#define LOCALE_SMONTHNAME5                  0x0000003CL
#define LOCALE_SMONTHNAME6                  0x0000003DL
#define LOCALE_SMONTHNAME7                  0x0000003EL
#define LOCALE_SMONTHNAME8                  0x0000003FL
#define LOCALE_SMONTHNAME9                  0x00000040L
#define LOCALE_SMONTHNAME10                 0x00000041L
#define LOCALE_SMONTHNAME11                 0x00000042L
#define LOCALE_SMONTHNAME12                 0x00000043L
#define LOCALE_SMONTHNAME13                 0x0000100EL
#define LOCALE_SABBREVMONTHNAME1            0x00000044L
#define LOCALE_SABBREVMONTHNAME2            0x00000045L
#define LOCALE_SABBREVMONTHNAME3            0x00000046L
#define LOCALE_SABBREVMONTHNAME4            0x00000047L
#define LOCALE_SABBREVMONTHNAME5            0x00000048L
#define LOCALE_SABBREVMONTHNAME6            0x00000049L
#define LOCALE_SABBREVMONTHNAME7            0x0000004AL
#define LOCALE_SABBREVMONTHNAME8            0x0000004BL
#define LOCALE_SABBREVMONTHNAME9            0x0000004CL
#define LOCALE_SABBREVMONTHNAME10           0x0000004DL
#define LOCALE_SABBREVMONTHNAME11           0x0000004EL
#define LOCALE_SABBREVMONTHNAME12           0x0000004FL
#define LOCALE_SABBREVMONTHNAME13           0x0000100FL
#define LOCALE_SPOSITIVESIGN                0x00000050L
#define LOCALE_SNEGATIVESIGN                0x00000051L
#define LOCALE_IPOSSIGNPOSN                 0x00000052L
#define LOCALE_INEGSIGNPOSN                 0x00000053L
#define LOCALE_IPOSSYMPRECEDES              0x00000054L
#define LOCALE_IPOSSEPBYSPACE               0x00000055L
#define LOCALE_INEGSYMPRECEDES              0x00000056L
#define LOCALE_INEGSEPBYSPACE               0x00000057L
#if (WINVER >= 0x0400)
    #define LOCALE_FONTSIGNATURE            0x00000058L
    #define LOCALE_SISO639LANGNAME          0x00000059L
    #define LOCALE_SISO3166CTRYNAME         0x0000005AL
#endif
#if (WINVER >= 0x0500)
    #define LOCALE_IDEFAULTEBCDICCODEPAGE   0x00001012L
    #define LOCALE_IPAPERSIZE               0x0000100AL
    #define LOCALE_SENGCURRNAME             0x00001007L
    #define LOCALE_SNATIVECURRNAME          0x00001008L
    #define LOCALE_SYEARMONTH               0x00001006L
    #define LOCALE_SSORTNAME                0x00001013L
    #define LOCALE_IDIGITSUBSTITUTION       0x00001014L
#endif
#if (WINVER >= 0x0600)
    #define LOCALE_SNAME                    0x0000005CL
    #define LOCALE_SDURATION                0x0000005DL
    #define LOCALE_SKEYBOARDSTOINSTALL      0x0000005EL
    #define LOCALE_SSHORTESTDAYNAME1        0x00000060L
    #define LOCALE_SSHORTESTDAYNAME2        0x00000061L
    #define LOCALE_SSHORTESTDAYNAME3        0x00000062L
    #define LOCALE_SSHORTESTDAYNAME4        0x00000063L
    #define LOCALE_SSHORTESTDAYNAME5        0x00000064L
    #define LOCALE_SSHORTESTDAYNAME6        0x00000065L
    #define LOCALE_SSHORTESTDAYNAME7        0x00000066L
    #define LOCALE_SISO639LANGNAME2         0x00000067L
    #define LOCALE_SISO3166CTRYNAME2        0x00000068L
    #define LOCALE_SNAN                     0x00000069L
    #define LOCALE_SPOSINFINITY             0x0000006AL
    #define LOCALE_SNEGINFINITY             0x0000006BL
    #define LOCALE_SSCRIPTS                 0x0000006CL
    #define LOCALE_SPARENT                  0x0000006DL
    #define LOCALE_SCONSOLEFALLBACKNAME     0x0000006EL
    #define LOCALE_SLANGDISPLAYNAME         0x0000006FL
#endif
#if (WINVER >= 0x0700)
    #define LOCALE_IREADINGLAYOUT           0x00000070L
    #define LOCALE_INEUTRAL                 0x00000071L
    #define LOCALE_INEGATIVEPERCENT         0x00000074L
    #define LOCALE_IPOSITIVEPERCENT         0x00000075L
    #define LOCALE_SPERCENT                 0x00000076L
    #define LOCALE_SPERMILLE                0x00000077L
    #define LOCALE_SMONTHDAY                0x00000078L
    #define LOCALE_SSHORTTIME               0x00000079L
    #define LOCALE_SOPENTYPELANGUAGETAG     0x0000007AL
    #define LOCALE_SSORTLOCALE              0x0000007BL
#endif

/* New locale information types */
#define LOCALE_SLOCALIZEDDISPLAYNAME        0x00000002L
#if (WINVER >= 0x0601)
    #define LOCALE_SENGLISHDISPLAYNAME      0x00000072L
    #define LOCALE_SNATIVEDISPLAYNAME       0x00000073L
#endif
#if (WINVER >= 0x0600)
    #define LOCALE_SLOCALIZEDLANGUAGENAME   0x0000006FL
#endif
#define LOCALE_SENGLISHLANGUAGENAME         0x00001001L
#define LOCALE_SNATIVELANGUAGENAME          0x00000004L
#define LOCALE_SLOCALIZEDCOUNTRYNAME        0x00000006L
#define LOCALE_SENGLISHCOUNTRYNAME          0x00001002L
#define LOCALE_SNATIVECOUNTRYNAME           0x00000008L

/* GetTimeFormat() flags */
#define TIME_NOMINUTESORSECONDS 0x00000001L
#define TIME_NOSECONDS          0x00000002L
#define TIME_NOTIMEMARKER       0x00000004L
#define TIME_FORCE24HOURFORMAT  0x00000008L

/* GetDateFormat() flags */
#define DATE_SHORTDATE          0x00000001L
#define DATE_LONGDATE           0x00000002L
#define DATE_USE_ALT_CALENDAR   0x00000004L
#if (WINVER >= 0x0500)
    #define DATE_YEARMONTH      0x00000008L
    #define DATE_LTRREADING     0x00000010L
    #define DATE_RTLREADING     0x00000020L
#endif
#if (WINVER >= 0x0601)
    #define DATE_AUTOLAYOUT     0x00000040L
#endif

/* Calendar information type flags */
#if (WINVER >= 0x0500)
    #define CAL_NOUSEROVERRIDE          LOCALE_NOUSEROVERRIDE
    #define CAL_USE_CP_ACP              LOCALE_USE_CP_ACP
    #define CAL_RETURN_NUMBER           LOCALE_RETURN_NUMBER
#endif
#if (WINVER >= 0x0601)
    #define CAL_RETURN_GENITIVE_NAMES   LOCALE_RETURN_GENITIVE_NAMES
#endif

/* Calendar information types */
#define CAL_ICALINTVALUE            0x00000001L
#define CAL_SCALNAME                0x00000002L
#define CAL_IYEAROFFSETRANGE        0x00000003L
#define CAL_SERASTRING              0x00000004L
#define CAL_SSHORTDATE              0x00000005L
#define CAL_SLONGDATE               0x00000006L
#define CAL_SDAYNAME1               0x00000007L
#define CAL_SDAYNAME2               0x00000008L
#define CAL_SDAYNAME3               0x00000009L
#define CAL_SDAYNAME4               0x0000000AL
#define CAL_SDAYNAME5               0x0000000BL
#define CAL_SDAYNAME6               0x0000000CL
#define CAL_SDAYNAME7               0x0000000DL
#define CAL_SABBREVDAYNAME1         0x0000000EL
#define CAL_SABBREVDAYNAME2         0x0000000FL
#define CAL_SABBREVDAYNAME3         0x00000010L
#define CAL_SABBREVDAYNAME4         0x00000011L
#define CAL_SABBREVDAYNAME5         0x00000012L
#define CAL_SABBREVDAYNAME6         0x00000013L
#define CAL_SABBREVDAYNAME7         0x00000014L
#define CAL_SMONTHNAME1             0x00000015L
#define CAL_SMONTHNAME2             0x00000016L
#define CAL_SMONTHNAME3             0x00000017L
#define CAL_SMONTHNAME4             0x00000018L
#define CAL_SMONTHNAME5             0x00000019L
#define CAL_SMONTHNAME6             0x0000001AL
#define CAL_SMONTHNAME7             0x0000001BL
#define CAL_SMONTHNAME8             0x0000001CL
#define CAL_SMONTHNAME9             0x0000001DL
#define CAL_SMONTHNAME10            0x0000001EL
#define CAL_SMONTHNAME11            0x0000001FL
#define CAL_SMONTHNAME12            0x00000020L
#define CAL_SMONTHNAME13            0x00000021L
#define CAL_SABBREVMONTHNAME1       0x00000022L
#define CAL_SABBREVMONTHNAME2       0x00000023L
#define CAL_SABBREVMONTHNAME3       0x00000024L
#define CAL_SABBREVMONTHNAME4       0x00000025L
#define CAL_SABBREVMONTHNAME5       0x00000026L
#define CAL_SABBREVMONTHNAME6       0x00000027L
#define CAL_SABBREVMONTHNAME7       0x00000028L
#define CAL_SABBREVMONTHNAME8       0x00000029L
#define CAL_SABBREVMONTHNAME9       0x0000002AL
#define CAL_SABBREVMONTHNAME10      0x0000002BL
#define CAL_SABBREVMONTHNAME11      0x0000002CL
#define CAL_SABBREVMONTHNAME12      0x0000002DL
#define CAL_SABBREVMONTHNAME13      0x0000002EL
#if (WINVER >= 0x0500)
    #define CAL_SYEARMONTH          0x0000002FL
    #define CAL_ITWODIGITYEARMAX    0x00000030L
#endif
#if (WINVER >= 0x0600)
    #define CAL_SSHORTESTDAYNAME1   0x00000031L
    #define CAL_SSHORTESTDAYNAME2   0x00000032L
    #define CAL_SSHORTESTDAYNAME3   0x00000033L
    #define CAL_SSHORTESTDAYNAME4   0x00000034L
    #define CAL_SSHORTESTDAYNAME5   0x00000035L
    #define CAL_SSHORTESTDAYNAME6   0x00000036L
    #define CAL_SSHORTESTDAYNAME7   0x00000037L
#endif
#if (WINVER >= 0x0601)
    #define CAL_SMONTHDAY           0x00000038L
    #define CAL_SABBREVERASTRING    0x00000039L
#endif

/* Special calendar identifier for EnumCalendarInfo() */
#define ENUM_ALL_CALENDARS  0xFFFFFFFFL

/* Calendar identifiers */
#define CAL_GREGORIAN               1L
#define CAL_GREGORIAN_US            2L
#define CAL_JAPAN                   3L
#define CAL_TAIWAN                  4L
#define CAL_KOREA                   5L
#define CAL_HIJRI                   6L
#define CAL_THAI                    7L
#define CAL_HEBREW                  8L
#define CAL_GREGORIAN_ME_FRENCH     9L
#define CAL_GREGORIAN_ARABIC        10L
#define CAL_GREGORIAN_XLIT_ENGLISH  11L
#define CAL_GREGORIAN_XLIT_FRENCH   12L
#define CAL_UMALQURA                23L

/* Language group identifiers */
#define LGRPID_WESTERN_EUROPE       0x00000001L
#define LGRPID_CENTRAL_EUROPE       0x00000002L
#define LGRPID_BALTIC               0x00000003L
#define LGRPID_GREEK                0x00000004L
#define LGRPID_CYRILLIC             0x00000005L
#define LGRPID_TURKIC               0x00000006L
#define LGRPID_TURKISH              0x00000006L
#define LGRPID_JAPANESE             0x00000007L
#define LGPRID_KOREAN               0x00000008L
#define LGRPID_TRADITIONAL_CHINESE  0x00000009L
#define LGRPID_SIMPLIFIED_CHINESE   0x0000000AL
#define LGRPID_THAI                 0x0000000BL
#define LGRPID_HEBREW               0x0000000CL
#define LGRPID_ARABIC               0x0000000DL
#define LGRPID_VIETNAMESE           0x0000000EL
#define LGRPID_INDIC                0x0000000FL
#define LGRPID_GEORGIAN             0x00000010L
#define LGRPID_ARMENIAN             0x00000011L

/* Multilingual User Interface (MUI) flags */
#if (WINVER >= 0x0600)
    #define MUI_LANGUAGE_ID                     0x00000004L
    #define MUI_LANGUAGE_NAME                   0x00000008L
    #define MUI_MERGE_SYSTEM_FALLBACK           0x00000010L
    #define MUI_MERGE_USER_FALLBACK             0x00000020L
    #define MUI_UI_FALLBACK \
        (MUI_MERGE_SYSTEM_FALLBACK | MUI_MERGE_USER_FALLBACK)
    #define MUI_THREAD_LANGUAGES                0x00000040L
    #define MUI_CONSOLE_FILTER                  0x00000100L
    #define MUI_COMPLEX_SCRIPT_FILTER           0x00000200L
    #define MUI_RESET_FILTERS                   0x00000001L
    #define MUI_USER_PREFERRED_UI_LANGUAGES     0x00000010L
    #define MUI_USE_INSTALLED_LANGUAGES         0x00000020L
    #define MUI_USE_SEARCH_ALL_LANGUAGES        0x00000040L
    #define MUI_LANG_NEUTRAL_PE_FILE            0x00000100L
    #define MUI_NON_LANG_NEUTRAL_FILE           0x00000200L
    #define MUI_MACHINE_LANGUAGE_SETTINGS       0x00000400L
    #define MUI_FILETYPE_NOT_LANGUAGE_NEUTRAL   0x00000001L
    #define MUI_FILETYPE_LANGUAGE_NEUTRAL_MAIN  0x00000002L
    #define MUI_FILETYPE_LANGUAGE_NEUTRAL_MUI   0x00000004L
    #define MUI_QUERY_TYPE                      0x00000001L
    #define MUI_QUERY_CHECKSUM                  0x00000002L
    #define MUI_QUERY_LANGUAGE_NAME             0x00000004L
    #define MUI_QUERY_RESOURCE_TYPES            0x00000008L
    #define MUI_FILEINFO_VERSION                0x00000001L
    #define MUI_FULL_LANGUAGE                   0x00000001L
    #define MUI_PARTIAL_LANGUAGE                0x00000002L
    #define MUI_LIP_LANGUAGE                    0x00000004L
    #define MUI_LANGUAGE_INSTALLED              0x00000020L
    #define MUI_LANGUAGE_LICENSED               0x00000040L
#endif

/* Special value returned by GetUserGeoID() */
#define GEOID_NOT_AVAILABLE (-1L)

/* International Domain Name flags */
#if (WINVER >= 0x0600)
    #define IDN_ALLOW_UNASSIGNED        0x00000001L
    #define IDN_USE_STD3_ASCII_RULES    0x00000002L
#endif

/* VerifyScripts() flags */
#if (WINVER >= 0x0600)
    #define VS_ALLOW_LATIN  0x00000001L
#endif

/* GetScriptStrings() flags */
#if (WINVER >= 0x0600)
    #define GSS_ALLOWED_INHERITED_COMMON    0x00000001L
#endif

/* Locale name special values */
#if (WINVER >= 0x0600)
    #define LOCALE_NAME_USER_DEFAULT    NULL
    #define LOCALE_NAME_INVARIANT       L""
    #define LOCALE_NAME_SYSTEM_DEFAULT  L"!sys-default-locale"
#endif

/* NLS functions */
enum SYSNLS_FUNCTION {
    COMPARE_STRING  = 0x00000001L
};

/* Geographical information types */
enum SYSGEOTYPE {
    GEO_NATION              = 0x00000001L,
    GEO_LATITUDE            = 0x00000002L,
    GEO_LONGITUDE           = 0x00000003L,
    GEO_ISO2                = 0x00000004L,
    GEO_ISO3                = 0x00000005L,
    GEO_RFC1766             = 0x00000006L,
    GEO_LCID                = 0x00000007L,
    GEO_FRIENDLYNAME        = 0x00000008L,
    GEO_OFFICIALNAME        = 0x00000009L,
    GEO_TIMEZONES           = 0x0000000AL,
    GEO_OFFICIALLANGUAGES   = 0x0000000BL
};

/* Geographical location classes */
enum SYSGEOCLASS {
    GEOCLASS_NATION = 16L,
    GEOCLASS_REGION = 14L
};

/* Code page information */
typedef struct _cpinfo {
    UINT    MaxCharSize;
    BYTE    DefaultChar[MAX_DEFAULTCHAR];
    BYTE    LeadByte[MAX_LEADBYTES];
} CPINFO;
typedef CPINFO  *LPCPINFO;

/* Code page information (extended version) */
typedef struct _cpinfoexA {
    UINT    MaxCharSize;
    BYTE    DefaultChar[MAX_DEFAULTCHAR];
    BYTE    LeadByte[MAX_LEADBYTES];
    WCHAR   UnicodeDefaultChar;
    UINT    CodePage;
    CHAR    CodePageName[MAX_PATH];
} CPINFOEXA;
typedef CPINFOEXA   *LPCPINFOEXA;
typedef struct _cpinfoexW {
    UINT    MaxCharSize;
    BYTE    DefaultChar[MAX_DEFAULTCHAR];
    BYTE    LeadByte[MAX_LEADBYTES];
    WCHAR   UnicodeDefaultChar;
    UINT    CodePage;
    WCHAR   CodePageName[MAX_PATH];
} CPINFOEXW;
typedef CPINFOEXW   *LPCPINFOEXW;
#ifdef UNICODE
typedef CPINFOEXW   CPINFOEX;
typedef LPCPINFOEXW LPCPINFOEX;
#else
typedef CPINFOEXA   CPINFOEX;
typedef LPCPINFOEXA LPCPINFOEX;
#endif

/* Number format information */
typedef struct _numberfmtA {
    UINT    NumDigits;
    UINT    LeadingZero;
    UINT    Grouping;
    LPSTR   lpDecimalSep;
    LPSTR   lpThousandSep;
    UINT    NegativeOrder;
} NUMBERFMTA;
typedef NUMBERFMTA      *LPNUMBERFMTA;
typedef struct _numberfmtW {
    UINT    NumDigits;
    UINT    LeadingZero;
    UINT    Grouping;
    LPWSTR  lpDecimalSep;
    LPWSTR  lpThousandSep;
    UINT    NegativeOrder;
} NUMBERFMTW;
typedef NUMBERFMTW      *LPNUMBERFMTW;
#ifdef UNICODE
typedef NUMBERFMTW      NUMBERFMT;
typedef LPNUMBERFMTW    LPNUMBERFMT;
#else
typedef NUMBERFMTA      NUMBERFMT;
typedef LPNUMBERFMTA    LPNUMBERFMT;
#endif

/* Currency format information */
typedef struct _currencyfmtA {
    UINT    NumDigits;
    UINT    LeadingZero;
    UINT    Grouping;
    LPSTR   lpDecimalSep;
    LPSTR   lpThousandSep;
    UINT    NegativeOrder;
    UINT    PositiveOrder;
    LPSTR   lpCurrencySymbol;
} CURRENCYFMTA;
typedef CURRENCYFMTA    *LPCURRENCYFMTA;
typedef struct _currencyfmtW {
    UINT    NumDigits;
    UINT    LeadingZero;
    UINT    Grouping;
    LPWSTR  lpDecimalSep;
    LPWSTR  lpThousandSep;
    UINT    NegativeOrder;
    UINT    PositiveOrder;
    LPWSTR  lpCurrencySymbol;
} CURRENCYFMTW;
typedef CURRENCYFMTW    *LPCURRENCYFMTW;
#ifdef UNICODE
typedef CURRENCYFMTW    CURRENCYFMT;
typedef LPCURRENCYFMTW  LPCURRENCYFMT;
#else
typedef CURRENCYFMTA    CURRENCYFMT;
typedef LPCURRENCYFMTA  LPCURRENCYFMT;
#endif

/* NLS version information */
typedef struct _nlsversioninfo {
    DWORD   dwNLSVersionInfoSize;
    DWORD   dwNLSVersion;
    DWORD   dwDefinedVersion;
} NLSVERSIONINFO;
typedef NLSVERSIONINFO  *LPNLSVERSIONINFO;

/* NLS version information (extended version) */
typedef struct _nlsversioninfoex {
    DWORD   dwNLSVersionInfoSize;
    DWORD   dwNLSVersion;
    DWORD   dwDefinedVersion;
    DWORD   dwEffectiveId;
    GUID    guidCustomVersion;
} NLSVERSIONINFOEX;
typedef NLSVERSIONINFOEX    *LPNLSVERSIONINFOEX;

/* Normalization forms */
#if (WINVER >= 0x0600)
typedef enum _NORM_FORM {
    NormalizationOther  = 0,
    NormalizationC      = 1,
    NormalizationD      = 2,
    NormalizationKC     = 5,
    NormalizationKD     = 6
} NORM_FORM;
#endif

/* MUI file information */
typedef struct _FILEMUIINFO {
    DWORD   dwSize;
    DWORD   dwVersion;
    DWORD   dwFileType;
    BYTE    pChecksum[16];
    BYTE    pServiceChecksum[16];
    DWORD   dwLanguageNameOffset;
    DWORD   dwTypeIDMainSize;
    DWORD   dwTypeIDMainOffset;
    DWORD   dwTypeNameMainOffset;
    DWORD   dwTypeIDMUISize;
    DWORD   dwTypeIDMUIOffset;
    DWORD   dwTypeNameMUIOffset;
    BYTE    abBuffer[8];
} FILEMUIINFO;
typedef FILEMUIINFO *PFILEMUIINFO;

/* Callback functions */
typedef BOOL (CALLBACK *CALINFO_ENUMPROCA)( LPSTR );
typedef BOOL (CALLBACK *CALINFO_ENUMPROCEXA)( LPSTR, CALID );
typedef BOOL (CALLBACK *CALINFO_ENUMPROCEXW)( LPWSTR, CALID );
typedef BOOL (CALLBACK *CALINFO_ENUMPROCW)( LPWSTR );
typedef BOOL (CALLBACK *CODEPAGE_ENUMPROCA)( LPSTR );
typedef BOOL (CALLBACK *CODEPAGE_ENUMPROCW)( LPWSTR );
typedef BOOL (CALLBACK *DATEFMT_ENUMPROCA)( LPSTR );
typedef BOOL (CALLBACK *DATEFMT_ENUMPROCEXA)( LPSTR, CALID );
typedef BOOL (CALLBACK *DATEFMT_ENUMPROCEXW)( LPWSTR, CALID );
typedef BOOL (CALLBACK *DATEFMT_ENUMPROCW)( LPWSTR );
typedef BOOL (CALLBACK *GEO_ENUMPROC)( GEOID );
typedef BOOL (CALLBACK *LANGUAGEGROUP_ENUMPROCA)( LGRPID, LPSTR, LPSTR, DWORD, LONG_PTR );
typedef BOOL (CALLBACK *LANGUAGEGROUP_ENUMPROCW)( LGRPID, LPWSTR, LPWSTR, DWORD, LONG_PTR );
typedef BOOL (CALLBACK *LANGGROUPLOCALE_ENUMPROCA)( LGRPID, LCID, LPSTR, LONG_PTR );
typedef BOOL (CALLBACK *LANGGROUPLOCALE_ENUMPROCW)( LGRPID, LCID, LPWSTR, LONG_PTR );
typedef BOOL (CALLBACK *LOCALE_ENUMPROCA)( LPSTR );
typedef BOOL (CALLBACK *LOCALE_ENUMPROCW)( LPWSTR );
typedef BOOL (CALLBACK *TIMEFMT_ENUMPROCA)( LPSTR );
typedef BOOL (CALLBACK *TIMEFMT_ENUMPROCW)( LPWSTR );
typedef BOOL (CALLBACK *UILANGUAGE_ENUMPROCA)( LPSTR, LONG_PTR );
typedef BOOL (CALLBACK *UILANGUAGE_ENUMPROCW)( LPWSTR, LONG_PTR );
#if (WINVER >= 0x0600)
typedef BOOL (CALLBACK *CALINFO_ENUMPROCEXEX)( LPWSTR, CALID, LPWSTR, LPARAM );
typedef BOOL (CALLBACK *DATEFMT_ENUMPROCEXEX)( LPWSTR, CALID, LPARAM );
typedef BOOL (CALLBACK *LOCALE_ENUMPROCEX)( LPWSTR, WORD, LPARAM );
typedef BOOL (CALLBACK *TIMEFMT_ENUMPROCEX)( LPWSTR, LPARAM );
#endif
#ifdef UNICODE
    #define CALINFO_ENUMPROC            CALINFO_ENUMPROCW
    #define CALINFO_ENUMPROCEX          CALINFO_ENUMPROCEXW
    #define CODEPAGE_ENUMPROC           CODEPAGE_ENUMPROCW
    #define DATEFMT_ENUMPROC            DATEFMT_ENUMPROCW
    #define DATEFMT_ENUMPROCEX          DATEFMT_ENUMPROCEXW
    #define LANGUAGEGROUP_ENUMPROC      LANGUAGEGROUP_ENUMPROCW
    #define LANGGROUPLOCALE_ENUMPROC    LANGGROUPLOCALE_ENUMPROCW
    #define LOCALE_ENUMPROC             LOCALE_ENUMPROCW
    #define TIMEFMT_ENUMPROC            TIMEFMT_ENUMPROCW
    #define UILANGUAGE_ENUMPROC         UILANGUAGE_ENUMPROCW
#else
    #define CALINFO_ENUMPROC            CALINFO_ENUMPROCA
    #define CALINFO_ENUMPROCEX          CALINFO_ENUMPROCEXA
    #define CODEPAGE_ENUMPROC           CODEPAGE_ENUMPROCA
    #define DATEFMT_ENUMPROC            DATEFMT_ENUMPROCA
    #define DATEFMT_ENUMPROCEX          DATEFMT_ENUMPROCEXA
    #define LANGUAGEGROUP_ENUMPROC      LANGUAGEGROUP_ENUMPROCA
    #define LANGGROUPLOCALE_ENUMPROC    LANGGROUPLOCALE_ENUMPROCA
    #define LOCALE_ENUMPROC             LOCALE_ENUMPROCA
    #define TIMEFMT_ENUMPROC            TIMEFMT_ENUMPROCA
    #define UILANGUAGE_ENUMPROC         UILANGUAGE_ENUMPROCA
#endif

/* Surrogate pair macros */
#define IS_HIGH_SURROGATE( x ) \
    (((x) >= HIGH_SURROGATE_START) && ((x) <= HIGH_SURROGATE_END))
#define IS_LOW_SURROGATE( x ) \
    (((x) >= LOW_SURROGATE_START) && ((x) <= LOW_SURROGATE_END))
#define IS_SURROGATE_PAIR( p1, p2 ) \
    (IS_HIGH_SURROGATE( p1 ) && IS_LOW_SURROGATE( p2 ))

/* MUI file information macros */
#define FILEMUIINFO_GET_CULTURE( x ) \
    ((LPWSTR)(((x)->dwLanguageNameOffset > 0) ? \
    (ULONG_PTR)(x) + (x)->dwLanguageNameOffset : NULL))
#define FILEMUIINFO_GET_MAIN_TYPEIDS( x ) \
    ((DWORD *)(((x)->dwTypeIDMainOffset > 0) ? \
    (ULONG_PTR)(x) + (x)->dwTypeIDMainOffset : NULL))
#define FILEMUIINFO_GET_MAIN_TYPEID( p1, p2 ) \
    ((((p2) < (p1)->dwTypeIDMainSize) && ((p1)->dwTypeIDMainOffset > 0)) ? \
    *((DWORD *)((ULONG_PTR)(p1) + (p1)->dwTypeIDMainOffset) + (p2)) : 0)
#define FILEMUIINFO_GET_MAIN_TYPENAMES( x ) \
    ((LPWSTR)(((x)->dwTypeNameMainOffset > 0) ? \
    (ULONG_PTR)(x) + (x)->dwTypeNameMainOffset : NULL))
#define FILEMUIINFO_GET_MUI_TYPEIDS( x ) \
    ((DWORD *)(((x)->dwTypeIDMUIOffset > 0) ? \
    (ULONG_PTR)(x) + (x)->dwTypeIDMUIOffset : NULL))
#define FILEMUIINFO_GET_MUI_TYPEID( p1, p2 ) \
    ((((p2) < (p1)->dwTypeIDMUISize) && ((p1)->dwTypeIDMUIOffset > 0)) ? \
    *((DWORD *)((ULONG_PTR)(p1) + (p1)->dwTypeIDMUIOffset) + (p2)) : 0)
#define FILEMUIINFO_GET_MUI_TYPENAMES( x ) \
    ((LPWSTR)(((x)->dwTypeNameMUIOffset > 0) ? \
    (ULONG_PTR)(x) + (x)->dwTypeNameMUIOffset : NULL))

/* Functions in KERNEL32.DLL */
WINBASEAPI int WINAPI       CompareStringA( LCID, DWORD, PCNZCH, int, PCNZCH, int );
WINBASEAPI int WINAPI       CompareStringW( LCID, DWORD, PCNZWCH, int, PCNZWCH, int );
WINBASEAPI LCID WINAPI      ConvertDefaultLocale( LCID );
WINBASEAPI BOOL WINAPI      EnumCalendarInfoA( CALINFO_ENUMPROCA, LCID, CALID, CALTYPE );
WINBASEAPI BOOL WINAPI      EnumCalendarInfoW( CALINFO_ENUMPROCW, LCID, CALID, CALTYPE );
WINBASEAPI BOOL WINAPI      EnumDateFormatsA( DATEFMT_ENUMPROCA, LCID, DWORD );
WINBASEAPI BOOL WINAPI      EnumDateFormatsW( DATEFMT_ENUMPROCW, LCID, DWORD );
WINBASEAPI BOOL WINAPI      EnumSystemCodePagesA( CODEPAGE_ENUMPROCA, DWORD );
WINBASEAPI BOOL WINAPI      EnumSystemCodePagesW( CODEPAGE_ENUMPROCW, DWORD );
WINBASEAPI BOOL WINAPI      EnumSystemGeoID( GEOCLASS, GEOID, GEO_ENUMPROC );
WINBASEAPI BOOL WINAPI      EnumSystemLocalesA( LOCALE_ENUMPROCA, DWORD );
WINBASEAPI BOOL WINAPI      EnumSystemLocalesW( LOCALE_ENUMPROCW, DWORD );
WINBASEAPI BOOL WINAPI      EnumTimeFormatsA( TIMEFMT_ENUMPROCA, LCID, DWORD );
WINBASEAPI BOOL WINAPI      EnumTimeFormatsW( TIMEFMT_ENUMPROCW, LCID, DWORD );
WINBASEAPI int WINAPI       FoldStringA( DWORD, LPCSTR, int, LPSTR, int );
WINBASEAPI int WINAPI       FoldStringW( DWORD, LPCWSTR, int, LPWSTR, int );
WINBASEAPI UINT WINAPI      GetACP( void );
WINBASEAPI BOOL WINAPI      GetCPInfo( UINT, LPCPINFO );
WINBASEAPI BOOL WINAPI      GetCPInfoExA( UINT, DWORD, LPCPINFOEXA );
WINBASEAPI BOOL WINAPI      GetCPInfoExW( UINT, DWORD, LPCPINFOEXW );
WINBASEAPI int WINAPI       GetCurrencyFormatA( LCID, DWORD, LPCSTR, CONST CURRENCYFMTA *, LPSTR, int );
WINBASEAPI int WINAPI       GetCurrencyFormatW( LCID, DWORD, LPCWSTR, CONST CURRENCYFMTW *, LPWSTR, int );
WINBASEAPI int WINAPI       GetDateFormatA( LCID, DWORD, CONST SYSTEMTIME *, LPCSTR, LPSTR, int );
WINBASEAPI int WINAPI       GetDateFormatW( LCID, DWORD, CONST SYSTEMTIME *, LPCWSTR, LPWSTR, int );
WINBASEAPI int WINAPI       GetGeoInfoA( GEOID, GEOTYPE, LPSTR, int, LANGID );
WINBASEAPI int WINAPI       GetGeoInfoW( GEOID, GEOTYPE, LPWSTR, int, LANGID );
WINBASEAPI int WINAPI       GetLocaleInfoA( LCID, LCTYPE, LPSTR, int );
WINBASEAPI int WINAPI       GetLocaleInfoW( LCID, LCTYPE, LPWSTR, int );
WINBASEAPI BOOL WINAPI      GetNLSVersion( NLS_FUNCTION, LCID, LPNLSVERSIONINFO );
WINBASEAPI int WINAPI       GetNumberFormatA( LCID, DWORD, LPCSTR, CONST NUMBERFMTA *, LPSTR, int );
WINBASEAPI int WINAPI       GetNumberFormatW( LCID, DWORD, LPCWSTR, CONST NUMBERFMTW *, LPWSTR, int );
WINBASEAPI UINT WINAPI      GetOEMCP( void );
WINBASEAPI BOOL WINAPI      GetStringTypeA( LCID, DWORD, LPCSTR, int, LPWORD );
WINBASEAPI BOOL WINAPI      GetStringTypeExA( LCID, DWORD, LPCSTR, int, LPWORD );
WINBASEAPI BOOL WINAPI      GetStringTypeExW( LCID, DWORD, LPCWSTR, int, LPWORD );
WINBASEAPI BOOL WINAPI      GetStringTypeW( DWORD, LPCWSTR, int, LPWORD );
WINBASEAPI LCID WINAPI      GetSystemDefaultLCID( void );
WINBASEAPI LANGID WINAPI    GetSystemDefaultLangID( void );
WINBASEAPI LCID WINAPI      GetThreadLocale( void );
WINBASEAPI int WINAPI       GetTimeFormatA( LCID, DWORD, CONST SYSTEMTIME *, LPCSTR, LPSTR, int );
WINBASEAPI int WINAPI       GetTimeFormatW( LCID, DWORD, CONST SYSTEMTIME *, LPCWSTR, LPWSTR, int );
WINBASEAPI LCID WINAPI      GetUserDefaultLCID( void );
WINBASEAPI LANGID WINAPI    GetUserDefaultLangID( void );
WINBASEAPI GEOID WINAPI     GetUserGeoID( GEOCLASS );
WINBASEAPI BOOL WINAPI      IsDBCSLeadByte( BYTE );
WINBASEAPI BOOL WINAPI      IsDBCSLeadByteEx( UINT, BYTE );
WINBASEAPI BOOL WINAPI      IsNLSDefinedString( NLS_FUNCTION, DWORD, LPNLSVERSIONINFO, LPCWSTR, INT );
WINBASEAPI BOOL WINAPI      IsValidCodePage( UINT );
WINBASEAPI BOOL WINAPI      IsValidLocale( LCID, DWORD );
WINBASEAPI int WINAPI       LCMapStringA( LCID, DWORD, LPCSTR, int, LPSTR, int );
WINBASEAPI int WINAPI       LCMapStringW( LCID, DWORD, LPCWSTR, int, LPWSTR, int );
WINBASEAPI int WINAPI       MultiByteToWideChar( UINT, DWORD, LPCSTR, int, LPWSTR, int );
WINBASEAPI BOOL WINAPI      SetLocaleInfoA( LCID, LCTYPE, LPCSTR );
WINBASEAPI BOOL WINAPI      SetLocaleInfoW( LCID, LCTYPE, LPCWSTR );
WINBASEAPI BOOL WINAPI      SetThreadLocale( LCID );
WINBASEAPI LANGID WINAPI    SetThreadUILanguage( LANGID );
WINBASEAPI BOOL WINAPI      SetUserGeoID( GEOID );
WINBASEAPI int WINAPI       WideCharToMultiByte( UINT, DWORD, LPCWSTR, int, LPSTR, int, LPCSTR, LPBOOL );
#if (WINVER >= 0x040A)
WINBASEAPI int WINAPI       GetCalendarInfoA( LCID, CALID, CALTYPE, LPSTR, int, LPDWORD );
WINBASEAPI int WINAPI       GetCalendarInfoW( LCID, CALID, CALTYPE, LPWSTR, int, LPDWORD );
WINBASEAPI BOOL WINAPI      SetCalendarInfoA( LCID, CALID, CALTYPE, LPCSTR );
WINBASEAPI BOOL WINAPI      SetCalendarInfoW( LCID, CALID, CALTYPE, LPCWSTR );
#endif
#if (WINVER >= 0x0500)
WINBASEAPI BOOL WINAPI      EnumCalendarInfoExA( CALINFO_ENUMPROCEXA, LCID, CALID, CALTYPE );
WINBASEAPI BOOL WINAPI      EnumCalendarInfoExW( CALINFO_ENUMPROCEXW, LCID, CALID, CALTYPE );
WINBASEAPI BOOL WINAPI      EnumDateFormatsExA( DATEFMT_ENUMPROCEXA, LCID, DWORD );
WINBASEAPI BOOL WINAPI      EnumDateFormatsExW( DATEFMT_ENUMPROCEXW, LCID, DWORD );
WINBASEAPI BOOL WINAPI      EnumLanguageGroupLocalesA( LANGGROUPLOCALE_ENUMPROCA, LGRPID, DWORD, LONG_PTR );
WINBASEAPI BOOL WINAPI      EnumLanguageGroupLocalesW( LANGGROUPLOCALE_ENUMPROCW, LGRPID, DWORD, LONG_PTR );
WINBASEAPI BOOL WINAPI      EnumSystemLanguageGroupsA( LANGUAGEGROUP_ENUMPROCA, DWORD, LONG_PTR );
WINBASEAPI BOOL WINAPI      EnumSystemLanguageGroupsW( LANGUAGEGROUP_ENUMPROCW, DWORD, LONG_PTR );
WINBASEAPI BOOL WINAPI      EnumUILanguagesA( UILANGUAGE_ENUMPROCA, DWORD, LONG_PTR );
WINBASEAPI BOOL WINAPI      EnumUILanguagesW( UILANGUAGE_ENUMPROCW, DWORD, LONG_PTR );
WINBASEAPI LANGID WINAPI    GetSystemDefaultUILanguage( void );
WINBASEAPI LANGID WINAPI    GetUserDefaultUILanguage( void );
WINBASEAPI BOOL WINAPI      IsValidLanguageGroup( LGRPID, DWORD );
#endif
#if (WINVER >= 0x0600)
WINBASEAPI int WINAPI       CompareStringEx( LPCWSTR, DWORD, LPCWSTR, int, LPCWSTR, int, LPNLSVERSIONINFO, LPVOID, LPARAM );
WINBASEAPI int WINAPI       CompareStringOrdinal( LPCWSTR, int, LPCWSTR, int, BOOL );
WINBASEAPI BOOL WINAPI      EnumCalendarInfoExEx( CALINFO_ENUMPROCEXEX, LPCWSTR, CALID, LPCWSTR, CALTYPE, LPARAM );
WINBASEAPI BOOL WINAPI      EnumDateFormatsExEx( DATEFMT_ENUMPROCEXEX, LPCWSTR, DWORD, LPARAM );
WINBASEAPI BOOL WINAPI      EnumSystemLocalesEx( LOCALE_ENUMPROCEX, DWORD, LPARAM, LPVOID );
WINBASEAPI BOOL WINAPI      EnumTimeFormatsEx( TIMEFMT_ENUMPROCEX, LPCWSTR, DWORD, LPARAM );
WINBASEAPI int WINAPI       FindNLSString( LCID, DWORD, LPCWSTR, int, LPCWSTR, int, LPINT );
WINBASEAPI int WINAPI       FindNLSStringEx( LPCWSTR, DWORD, LPCWSTR, int, LPCWSTR, int, int, LPINT, LPNLSVERSIONINFO, LPVOID, LPARAM );
WINBASEAPI int WINAPI       GetCalendarInfoEx( LPCWSTR, CALID, LPCWSTR, CALTYPE, LPWSTR, int, LPDWORD );
WINBASEAPI int WINAPI       GetCurrencyFormatEx( LPCWSTR, DWORD, LPCWSTR, CONST CURRENCYFMTW *, LPWSTR, int );
WINBASEAPI int WINAPI       GetDateFormatEx( LPCWSTR, DWORD, CONST SYSTEMTIME *, LPCWSTR, LPWSTR, int, LPCWSTR );
WINBASEAPI int WINAPI       GetDurationFormat( LCID, DWORD, CONST SYSTEMTIME *, ULONGLONG, LPCWSTR, LPWSTR, int );
WINBASEAPI int WINAPI       GetDurationFormatEx( LPCWSTR, DWORD, CONST SYSTEMTIME *, ULONGLONG, LPCWSTR, LPWSTR, int );
WINBASEAPI BOOL WINAPI      GetFileMUIInfo( DWORD, PCWSTR, PFILEMUIINFO, DWORD * );
WINBASEAPI BOOL WINAPI      GetFileMUIPath( DWORD, PCWSTR, PWSTR, PULONG, PWSTR, PULONG, PULONGLONG );
WINBASEAPI int WINAPI       GetLocaleInfoEx( LPCWSTR, LCTYPE, LPWSTR, int );
WINBASEAPI BOOL WINAPI      GetNLSVersionEx( NLS_FUNCTION, LPCWSTR, LPNLSVERSIONINFOEX );
WINBASEAPI int WINAPI       GetNumberFormatEx( LPCWSTR, DWORD, LPCWSTR, CONST NUMBERFMTW *, LPWSTR, int );
WINBASEAPI BOOL WINAPI      GetProcessPreferredUILanguages( DWORD, PULONG, PZZWSTR, PULONG );
WINBASEAPI int WINAPI       GetStringScripts( DWORD, LPCWSTR, int, LPWSTR, int );
WINBASEAPI int WINAPI       GetSystemDefaultLocaleName( LPWSTR, int );
WINBASEAPI BOOL WINAPI      GetSystemPreferredUILanguages( DWORD, PULONG, PZZWSTR, PULONG );
WINBASEAPI BOOL WINAPI      GetThreadPreferredUILanguages( DWORD, PULONG, PZZWSTR, PULONG );
WINBASEAPI LANGID WINAPI    GetThreadUILanguage( void );
WINBASEAPI int WINAPI       GetTimeFormatEx( LPCWSTR, DWORD, CONST SYSTEMTIME *, LPCWSTR, LPWSTR, int );
WINBASEAPI BOOL WINAPI      GetUILanguageInfo( DWORD, PCZZWSTR, PZZWSTR, PDWORD, PDWORD );
WINBASEAPI int WINAPI       GetUserDefaultLocaleName( LPWSTR, int );
WINBASEAPI BOOL WINAPI      GetUserPreferredUILanguages( DWORD, PULONG, PZZWSTR, PULONG );
WINBASEAPI BOOL WINAPI      IsValidLocaleName( LPCWSTR );
WINBASEAPI int WINAPI       LCIDToLocaleName( LCID, LPWSTR, int, DWORD );
WINBASEAPI int WINAPI       LCMapStringEx( LPCWSTR, DWORD, LPCWSTR, int, LPWSTR, int, LPNLSVERSIONINFO, LPVOID, LPARAM );
WINBASEAPI LCID WINAPI      LocaleNameToLCID( LPCWSTR, DWORD );
WINBASEAPI BOOL WINAPI      NotifyUILanguageChange( DWORD, PCWSTR, PCWSTR, DWORD, PDWORD );
WINBASEAPI BOOL WINAPI      SetProcessPreferredUILanguages( DWORD, PCZZWSTR, PULONG );
WINBASEAPI BOOL WINAPI      SetThreadPreferredUILanguages( DWORD, PCZZWSTR, PULONG );
WINBASEAPI BOOL WINAPI      VerifyScripts( DWORD, LPCWSTR, int, LPCWSTR, int );
#endif
#if (WINVER >= 0x0601)
WINBASEAPI int WINAPI       FindStringOrdinal( DWORD, LPCWSTR, int, LPCWSTR, int, BOOL );
WINBASEAPI int WINAPI       ResolveLocaleName( LPCWSTR, LPWSTR, int );
#endif

/* Functions in NORMALIZ.DLL */
#if (WINVER >= 0x0600)
WINNORMALIZEAPI int WINAPI  IdnToAscii( DWORD, LPCWSTR, int, LPWSTR, int );
WINNORMALIZEAPI int WINAPI  IdnToNameprepUnicode( DWORD, LPCWSTR, int, LPWSTR, int );
WINNORMALIZEAPI int WINAPI  IdnToUnicode( DWORD, LPCWSTR, int, LPWSTR, int );
WINNORMALIZEAPI BOOL WINAPI IsNormalizedString( NORM_FORM, LPCWSTR, int );
WINNORMALIZEAPI int WINAPI  NormalizeString( NORM_FORM, LPCWSTR, int, LPWSTR, int );
#endif

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define CompareString                   CompareStringW
    #define EnumCalendarInfo                EnumCalendarInfoW
    #define EnumDateFormats                 EnumDateFormatsW
    #define EnumSystemCodePages             EnumSystemCodePagesW
    #define EnumSystemLocales               EnumSystemLocalesW
    #define EnumTimeFormats                 EnumTimeFormatsW
    #define FoldString                      FoldStringW
    #define GetCPInfoEx                     GetCPInfoExW
    #define GetCurrencyFormat               GetCurrencyFormatW
    #define GetDateFormat                   GetDateFormatW
    #define GetGeoInfo                      GetGeoInfoW
    #define GetLocaleInfo                   GetLocaleInfoW
    #define GetNumberFormat                 GetNumberFormatW
    /* GetStringTypeA() and GetStringTypeW() have different signatures, so the
     * generic GetStringType() does not exist.
     */
    #define GetStringTypeEx                 GetStringTypeExW
    #define GetTimeFormat                   GetTimeFormatW
    #define LCMapString                     LCMapStringW
    #define SetLocaleInfo                   SetLocaleInfoW
    #if (WINVER >= 0x040A)
        #define GetCalendarInfo             GetCalendarInfoW
        #define SetCalendarInfo             SetCalendarInfoW
    #endif
    #if (WINVER >= 0x0500)
        #define EnumCalendarInfoEx          EnumCalendarInfoExW
        #define EnumDateFormatsEx           EnumDateFormatsExW
        #define EnumLanguageGroupLocales    EnumLanguageGroupLocalesW
        #define EnumSystemLanguageGroups    EnumSystemLanguageGroupsW
        #define EnumUILanguages             EnumUILanguagesW
    #endif
#else
    #define CompareString                   CompareStringA
    #define EnumCalendarInfo                EnumCalendarInfoA
    #define EnumDateFormats                 EnumDateFormatsA
    #define EnumSystemCodePages             EnumSystemCodePagesA
    #define EnumSystemLocales               EnumSystemLocalesA
    #define EnumTimeFormats                 EnumTimeFormatsA
    #define FoldString                      FoldStringA
    #define GetCPInfoEx                     GetCPInfoExA
    #define GetCurrencyFormat               GetCurrencyFormatA
    #define GetDateFormat                   GetDateFormatA
    #define GetGeoInfo                      GetGeoInfoA
    #define GetLocaleInfo                   GetLocaleInfoA
    #define GetNumberFormat                 GetNumberFormatA
    /* GetStringTypeA() and GetStringTypeW() have different signatures, so the
     * generic GetStringType() does not exist.
     */
    #define GetStringTypeEx                 GetStringTypeExA
    #define GetTimeFormat                   GetTimeFormatA
    #define LCMapString                     LCMapStringA
    #define SetLocaleInfo                   SetLocaleInfoA
    #if (WINVER >= 0x040A)
        #define GetCalendarInfo             GetCalendarInfoA
        #define SetCalendarInfo             SetCalendarInfoA
    #endif
    #if (WINVER >= 0x0500)
        #define EnumCalendarInfoEx          EnumCalendarInfoExA
        #define EnumDateFormatsEx           EnumDateFormatsExA
        #define EnumLanguageGroupLocales    EnumLanguageGroupLocalesA
        #define EnumSystemLanguageGroups    EnumSystemLanguageGroupsA
        #define EnumUILanguages             EnumUILanguagesA
    #endif
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _WINNLS_ */
