/*
 *  winscard.h  Win32 smart card functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _WINSCARD_H_
#define _WINSCARD_H_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <wtypes.h>
#include <winioctl.h>
#include <winsmcrd.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Macros to specify smart card functions and global variables */
#define WINSCARDAPI     DECLSPEC_IMPORT
#define WINSCARDDATA    DECLSPEC_IMPORT

/* Smart card primitive data types */
typedef const BYTE  *LPCBYTE;

/* Smart card handle data types */
typedef ULONG_PTR       SCARDCONTEXT;
typedef SCARDCONTEXT    *PSCARDCONTEXT;
typedef SCARDCONTEXT    *LPSCARDCONTEXT;
typedef ULONG_PTR       SCARDHANDLE;
typedef SCARDCONTEXT    *PSCARDHANDLE;
typedef SCARDCONTEXT    *LPSCARDHANDLE;

/* Special value */
#define SCARD_AUTOALLOCATE  0xFFFFFFFFL

/* Smart card scopes */
#define SCARD_SCOPE_USER        0L
#define SCARD_SCOPE_TERMINAL    1L
#define SCARD_SCOPE_SYSTEM      2L

/* Smart card reader groups */
#define SCARD_ALL_READERS       TEXT("SCard$AllReaders\000")
#define SCARD_DEFAULT_READERS   TEXT("SCard$DefaultReaders\000")
#define SCARD_LOCAL_READERS     TEXT("SCard$LocalReaders\000")
#define SCARD_SYSTEM_READERS    TEXT("SCard$SystemReaders\000")

/* Smart card providers */
#define SCARD_PROVIDER_PRIMARY  1L
#define SCARD_PROVIDER_CSP      2L
#define SCARD_PROVIDER_KSP      3L

/* Smart card reader state flags */
#define SCARD_STATE_UNAWARE     0x00000000L
#define SCARD_STATE_IGNORE      0x00000001L
#define SCARD_STATE_CHANGED     0x00000002L
#define SCARD_STATE_UNKNOWN     0x00000004L
#define SCARD_STATE_UNAVAILABLE 0x00000008L
#define SCARD_STATE_EMPTY       0x00000010L
#define SCARD_STATE_PRESENT     0x00000020L
#define SCARD_STATE_ATRMATCH    0x00000040L
#define SCARD_STATE_EXCLUSIVE   0x00000080L
#define SCARD_STATE_INUSE       0x00000100L
#define SCARD_STATE_MUTE        0x00000200L
#define SCARD_STATE_UNPOWERED   0x00000400L

/* Smart card sharing modes */
#define SCARD_SHARE_EXCLUSIVE   1L
#define SCARD_SHARE_SHARED      2L
#define SCARD_SHARE_DIRECT      3L

/* Smart card disposition values */
#define SCARD_LEAVE_CARD    0L
#define SCARD_RESET_CARD    1L
#define SCARD_UNPOWER_CARD  2L
#define SCARD_EJECT_CARD    3L

/* Smart card dialog flags */
#define SC_DLG_MINIMAL_UI   0x00000001L
#define SC_DLG_NO_UI        0x00000002L
#define SC_DLG_FORCE_UI     0x00000004L

/* Smart card dialog error codes */
#define SCERR_NOCARDNAME    0x00004000L
#define SCERR_NOGUIDS       0x00008000L

/* Smart card reader state */
typedef struct {
    LPCSTR  szReader;
    LPVOID  pvUserData;
    DWORD   dwCurrentState;
    DWORD   dwEventState;
    DWORD   cbAtr;
    BYTE    rgbAtr[36];
} SCARD_READERSTATEA;
typedef SCARD_READERSTATEA      *PSCARD_READERSTATEA;
typedef SCARD_READERSTATEA      *LPSCARD_READERSTATEA;
typedef struct {
    LPCWSTR szReader;
    LPVOID  pvUserData;
    DWORD   dwCurrentState;
    DWORD   dwEventState;
    DWORD   cbAtr;
    BYTE    rgbAtr[36];
} SCARD_READERSTATEW;
typedef SCARD_READERSTATEW      *PSCARD_READERSTATEW;
typedef SCARD_READERSTATEW      *LPSCARD_READERSTATEW;
#ifdef UNICODE
typedef SCARD_READERSTATEW      SCARD_READERSTATE;
typedef PSCARD_READERSTATEW     PSCARD_READERSTATE;
typedef LPSCARD_READERSTATEW    LPSCARD_READERSTATE;
#else
typedef SCARD_READERSTATEA      SCARD_READERSTATE;
typedef PSCARD_READERSTATEA     PSCARD_READERSTATE;
typedef LPSCARD_READERSTATEA    LPSCARD_READERSTATE;
#endif
#define SCARD_READERSTATE_A     SCARD_READERSTATEA
#define SCARD_READERSTATE_W     SCARD_READERSTATEW
#define PSCARD_READERSTATE_A    PSCARD_READERSTATEA
#define PSCARD_READERSTATE_W    PSCARD_READERSTATEW
#define LPSCARD_READERSTATE_A   LPSCARD_READERSTATEA
#define LPSCARD_READERSTATE_W   LPSCARD_READERSTATEW

/* Smart card ATR mask */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct _SCARD_ATRMASK {
    DWORD   cbAtr;
    BYTE    rgbAtr[36];
    BYTE    rgbMask[36];
} SCARD_ATRMASK;
typedef SCARD_ATRMASK   *PSCARD_ATRMASK;
typedef SCARD_ATRMASK   *LPSCARD_ATRMASK;
#endif

/* Smart card dialog callbacks */
typedef SCARDHANDLE (WINAPI *LPOCNCONNPROCA)( SCARDCONTEXT, LPSTR, LPSTR, PVOID );
typedef SCARDHANDLE (WINAPI *LPOCNCONNPROCW)( SCARDCONTEXT, LPWSTR, LPWSTR, PVOID );
typedef BOOL (WINAPI *LPOCNCHKPROC)( SCARDCONTEXT, SCARDHANDLE, PVOID );
typedef void (WINAPI *LPOCNDSCPROC)( SCARDCONTEXT, SCARDHANDLE, PVOID );
#ifdef UNICODE
    #define LPOCNCONNPROC   LPOCNCONNPROCW
#else
    #define LPOCNCONNPROC   LPOCNCONNPROCA
#endif

/* Smart card dialog search criteria */
typedef struct {
    DWORD           dwStructSize;
    LPSTR           lpstrGroupNames;
    DWORD           nMaxGroupNames;
    LPCGUID         rgguidInterfaces;
    DWORD           cguidInterfaces;
    LPSTR           lpstrCardNames;
    DWORD           nMaxCardNames;
    LPOCNCHKPROC    lpfnCheck;
    LPOCNCONNPROCA  lpfnConnect;
    LPOCNDSCPROC    lpfnDisconnect;
    LPVOID          pvUserData;
    DWORD           dwShareMode;
    DWORD           dwPreferredProtocols;
} OPENCARD_SEARCH_CRITERIAA;
typedef OPENCARD_SEARCH_CRITERIAA   *POPENCARD_SEARCH_CRITERIAA;
typedef OPENCARD_SEARCH_CRITERIAA   *LPOPENCARD_SEARCH_CRITERIAA;
typedef struct {
    DWORD           dwStructSize;
    LPWSTR          lpstrGroupNames;
    DWORD           nMaxGroupNames;
    LPCGUID         rgguidInterfaces;
    DWORD           cguidInterfaces;
    LPWSTR          lpstrCardNames;
    DWORD           nMaxCardNames;
    LPOCNCHKPROC    lpfnCheck;
    LPOCNCONNPROCW  lpfnConnect;
    LPOCNDSCPROC    lpfnDisconnect;
    LPVOID          pvUserData;
    DWORD           dwShareMode;
    DWORD           dwPreferredProtocols;
} OPENCARD_SEARCH_CRITERIAW;
typedef OPENCARD_SEARCH_CRITERIAW   *POPENCARD_SEARCH_CRITERIAW;
typedef OPENCARD_SEARCH_CRITERIAW   *LPOPENCARD_SEARCH_CRITERIAW;
#ifdef UNICODE
typedef OPENCARD_SEARCH_CRITERIAW   OPENCARD_SEARCH_CRITERIA;
typedef POPENCARD_SEARCH_CRITERIAW  POPENCARD_SEARCH_CRITERIA;
typedef LPOPENCARD_SEARCH_CRITERIAW LPOPENCARD_SEARCH_CRITERIA;
#else
typedef OPENCARD_SEARCH_CRITERIAA   OPENCARD_SEARCH_CRITERIA;
typedef POPENCARD_SEARCH_CRITERIAA  POPENCARD_SEARCH_CRITERIA;
typedef LPOPENCARD_SEARCH_CRITERIAA LPOPENCARD_SEARCH_CRITERIA;
#endif

/* SCardUIDlgSelectCard() parameters */
typedef struct {
    DWORD                       dwStructSize;
    SCARDCONTEXT                hSCardContext;
    HWND                        hwndOwner;
    DWORD                       dwFlags;
    LPCSTR                      lpstrTitle;
    LPCSTR                      lpstrSearchDesc;
    HICON                       hIcon;
    POPENCARD_SEARCH_CRITERIAA  pOpenCardSearchCriteria;
    LPOCNCONNPROCA              lpfnConnect;
    LPVOID                      pvUserData;
    DWORD                       dwShareMode;
    DWORD                       dwPreferredProtocols;
    LPSTR                       lpstrRdr;
    DWORD                       nMaxRdr;
    LPSTR                       lpstrCard;
    DWORD                       nMaxCard;
    DWORD                       dwActiveProtocol;
    SCARDHANDLE                 hCardHandle;
} OPENCARDNAME_EXA;
typedef OPENCARDNAME_EXA    *POPENCARDNAME_EXA;
typedef OPENCARDNAME_EXA    *LPOPENCARDNAME_EXA;
typedef struct {
    DWORD                       dwStructSize;
    SCARDCONTEXT                hSCardContext;
    HWND                        hwndOwner;
    DWORD                       dwFlags;
    LPCWSTR                     lpstrTitle;
    LPCWSTR                     lpstrSearchDesc;
    HICON                       hIcon;
    POPENCARD_SEARCH_CRITERIAW  pOpenCardSearchCriteria;
    LPOCNCONNPROCW              lpfnConnect;
    LPVOID                      pvUserData;
    DWORD                       dwShareMode;
    DWORD                       dwPreferredProtocols;
    LPWSTR                      lpstrRdr;
    DWORD                       nMaxRdr;
    LPWSTR                      lpstrCard;
    DWORD                       nMaxCard;
    DWORD                       dwActiveProtocol;
    SCARDHANDLE                 hCardHandle;
} OPENCARDNAME_EXW;
typedef OPENCARDNAME_EXW    *POPENCARDNAME_EXW;
typedef OPENCARDNAME_EXW    *LPOPENCARDNAME_EXW;
#ifdef UNICODE
typedef OPENCARDNAME_EXW    OPENCARDNAME_EX;
typedef POPENCARDNAME_EXW   POPENCARDNAME_EX;
typedef LPOPENCARDNAME_EXW  LPOPENCARDNAME_EX;
#else
typedef OPENCARDNAME_EXA    OPENCARDNAME_EX;
typedef POPENCARDNAME_EXA   POPENCARDNAME_EX;
typedef LPOPENCARDNAME_EXA  LPOPENCARDNAME_EX;
#endif
#define OPENCARDNAMEA_EX    OPENCARDNAME_EXA
#define OPENCARDNAMEW_EX    OPENCARDNAME_EXW
#define POPENCARDNAMEA_EX   POPENCARDNAME_EXA
#define POPENCARDNAMEW_EX   POPENCARDNAME_EXW
#define LPOPENCARDNAMEA_EX  LPOPENCARDNAME_EXA
#define LPOPENCARDNAMEW_EX  LPOPENCARDNAME_EXW

/* GetOpenCardName() parameters */
typedef struct {
    DWORD           dwStructSize;
    HWND            hwndOwner;
    SCARDCONTEXT    hSCardContext;
    LPSTR           lpstrGroupNames;
    DWORD           nMaxGroupNames;
    LPSTR           lpstrCardNames;
    DWORD           nMaxCardNames;
    LPCGUID         rgguidInterfaces;
    DWORD           cguidInterfaces;
    LPSTR           lpstrRdr;
    DWORD           nMaxRdr;
    LPSTR           lpstrCard;
    DWORD           nMaxCard;
    LPCSTR          lpstrTitle;
    DWORD           dwFlags;
    LPVOID          pvUserData;
    DWORD           dwShareMode;
    DWORD           dwPreferredProtocols;
    DWORD           dwActiveProtocol;
    LPOCNCONNPROCA  lpfnConnect;
    LPOCNCHKPROC    lpfnCheck;
    LPOCNDSCPROC    lpfnDisconnect;
    SCARDHANDLE     hCardHandle;
} OPENCARDNAMEA;
typedef OPENCARDNAMEA       *POPENCARDNAMEA;
typedef OPENCARDNAMEA       *LPOPENCARDNAMEA;
typedef struct {
    DWORD           dwStructSize;
    HWND            hwndOwner;
    SCARDCONTEXT    hSCardContext;
    LPWSTR          lpstrGroupNames;
    DWORD           nMaxGroupNames;
    LPWSTR          lpstrCardNames;
    DWORD           nMaxCardNames;
    LPCGUID         rgguidInterfaces;
    DWORD           cguidInterfaces;
    LPWSTR          lpstrRdr;
    DWORD           nMaxRdr;
    LPWSTR          lpstrCard;
    DWORD           nMaxCard;
    LPCWSTR         lpstrTitle;
    DWORD           dwFlags;
    LPVOID          pvUserData;
    DWORD           dwShareMode;
    DWORD           dwPreferredProtocols;
    DWORD           dwActiveProtocol;
    LPOCNCONNPROCW  lpfnConnect;
    LPOCNCHKPROC    lpfnCheck;
    LPOCNDSCPROC    lpfnDisconnect;
    SCARDHANDLE     hCardHandle;
} OPENCARDNAMEW;
typedef OPENCARDNAMEW       *POPENCARDNAMEW;
typedef OPENCARDNAMEW       *LPOPENCARDNAMEW;
#ifdef UNICODE
typedef OPENCARDNAMEW       OPENCARDNAME;
typedef POPENCARDNAMEW      POPENCARDNAME;
typedef LPOPENCARDNAMEW     LPOPENCARDNAME;
#else
typedef OPENCARDNAMEA       OPENCARDNAME;
typedef POPENCARDNAMEA      POPENCARDNAME;
typedef LPOPENCARDNAMEA     LPOPENCARDNAME;
#endif
#define OPENCARDNAME_A      OPENCARDNAMEA
#define OPENCARDNAME_W      OPENCARDNAMEW
#define POPENCARDNAME_A     POPENCARDNAMEA
#define POPENCARDNAME_W     POPENCARDNAMEW
#define LPOPENCARDNAME_A    LPOPENCARDNAMEA
#define LPOPENCARDNAME_W    LPOPENCARDNAMEW

/* Global variables in WINSCARD.DLL */
WINSCARDDATA extern const SCARD_IO_REQUEST  __cdecl g_rgSCardT0Pci;
WINSCARDDATA extern const SCARD_IO_REQUEST  __cdecl g_rgSCardT1Pci;
WINSCARDDATA extern const SCARD_IO_REQUEST  __cdecl g_rgSCardRawPci;

/* Functions in WINSCARD.DLL */
WINSCARDAPI LONG WINAPI     SCardAddReaderToGroupA( SCARDCONTEXT, LPCSTR, LPCSTR );
WINSCARDAPI LONG WINAPI     SCardAddReaderToGroupW( SCARDCONTEXT, LPCWSTR, LPCWSTR );
WINSCARDAPI LONG WINAPI     SCardBeginTransaction( SCARDHANDLE );
WINSCARDAPI LONG WINAPI     SCardCancel( SCARDCONTEXT );
WINSCARDAPI LONG WINAPI     SCardCancelTransaction( SCARDHANDLE );
WINSCARDAPI LONG WINAPI     SCardConnectA( SCARDCONTEXT, LPCSTR, DWORD, DWORD, LPSCARDHANDLE, LPDWORD );
WINSCARDAPI LONG WINAPI     SCardConnectW( SCARDCONTEXT, LPCWSTR, DWORD, DWORD, LPSCARDHANDLE, LPDWORD );
WINSCARDAPI LONG WINAPI     SCardControl( SCARDHANDLE, DWORD, LPCVOID, DWORD, LPVOID, DWORD, LPDWORD );
WINSCARDAPI LONG WINAPI     SCardDisconnect( SCARDHANDLE, DWORD );
WINSCARDAPI LONG WINAPI     SCardEndTransaction( SCARDHANDLE, DWORD );
WINSCARDAPI LONG WINAPI     SCardEstablishContext( DWORD, LPCVOID, LPCVOID, LPSCARDCONTEXT );
WINSCARDAPI LONG WINAPI     SCardForgetCardTypeA( SCARDCONTEXT, LPCSTR );
WINSCARDAPI LONG WINAPI     SCardForgetCardTypeW( SCARDCONTEXT, LPCWSTR );
WINSCARDAPI LONG WINAPI     SCardForgetReaderA( SCARDCONTEXT, LPCSTR );
WINSCARDAPI LONG WINAPI     SCardForgetReaderGroupA( SCARDCONTEXT, LPCSTR );
WINSCARDAPI LONG WINAPI     SCardForgetReaderGroupW( SCARDCONTEXT, LPCWSTR );
WINSCARDAPI LONG WINAPI     SCardForgetReaderW( SCARDCONTEXT, LPCWSTR );
WINSCARDAPI LONG WINAPI     SCardFreeMemory( SCARDCONTEXT, LPCVOID );
WINSCARDAPI LONG WINAPI     SCardGetAttrib( SCARDHANDLE, DWORD, LPBYTE, LPDWORD );
WINSCARDAPI LONG WINAPI     SCardGetCardTypeProviderNameA( SCARDCONTEXT, LPCSTR, DWORD, LPSTR, LPDWORD );
WINSCARDAPI LONG WINAPI     SCardGetCardTypeProviderNameW( SCARDCONTEXT, LPCWSTR, DWORD, LPWSTR, LPDWORD );
WINSCARDAPI LONG WINAPI     SCardGetProviderIdA( SCARDCONTEXT, LPCSTR, LPGUID );
WINSCARDAPI LONG WINAPI     SCardGetProviderIdW( SCARDCONTEXT, LPCWSTR, LPGUID );
WINSCARDAPI LONG WINAPI     SCardGetStatusChangeA( SCARDCONTEXT, DWORD, LPSCARD_READERSTATEA, DWORD );
WINSCARDAPI LONG WINAPI     SCardGetStatusChangeW( SCARDCONTEXT, DWORD, LPSCARD_READERSTATEW, DWORD );
WINSCARDAPI LONG WINAPI     SCardIntroduceCardTypeA( SCARDCONTEXT, LPCSTR, LPCGUID, LPCGUID, DWORD, LPCBYTE, LPCBYTE, DWORD );
WINSCARDAPI LONG WINAPI     SCardIntroduceCardTypeW( SCARDCONTEXT, LPCWSTR, LPCGUID, LPCGUID, DWORD, LPCBYTE, LPCBYTE, DWORD );
WINSCARDAPI LONG WINAPI     SCardIntroduceReaderA( SCARDCONTEXT, LPCSTR, LPCSTR );
WINSCARDAPI LONG WINAPI     SCardIntroduceReaderGroupA( SCARDCONTEXT, LPCSTR );
WINSCARDAPI LONG WINAPI     SCardIntroduceReaderGroupW( SCARDCONTEXT, LPCWSTR );
WINSCARDAPI LONG WINAPI     SCardIntroduceReaderW( SCARDCONTEXT, LPCWSTR, LPCWSTR );
WINSCARDAPI LONG WINAPI     SCardIsValidContext( SCARDCONTEXT );
WINSCARDAPI LONG WINAPI     SCardListCardsA( SCARDCONTEXT, LPCBYTE, LPCGUID, DWORD, LPSTR, LPDWORD );
WINSCARDAPI LONG WINAPI     SCardListCardsW( SCARDCONTEXT, LPCBYTE, LPCGUID, DWORD, LPWSTR, LPDWORD );
WINSCARDAPI LONG WINAPI     SCardListInterfacesA( SCARDCONTEXT, LPCSTR, LPGUID, LPDWORD );
WINSCARDAPI LONG WINAPI     SCardListInterfacesW( SCARDCONTEXT, LPCWSTR, LPGUID, LPDWORD );
WINSCARDAPI LONG WINAPI     SCardListReaderGroupsA( SCARDCONTEXT, LPSTR, LPDWORD );
WINSCARDAPI LONG WINAPI     SCardListReaderGroupsW( SCARDCONTEXT, LPWSTR, LPDWORD );
WINSCARDAPI LONG WINAPI     SCardListReadersA( SCARDCONTEXT, LPCSTR, LPSTR, LPDWORD );
WINSCARDAPI LONG WINAPI     SCardListReadersW( SCARDCONTEXT, LPCWSTR, LPWSTR, LPDWORD );
WINSCARDAPI LONG WINAPI     SCardLocateCardsA( SCARDCONTEXT, LPCSTR, LPSCARD_READERSTATEA, DWORD );
WINSCARDAPI LONG WINAPI     SCardLocateCardsW( SCARDCONTEXT, LPCWSTR, LPSCARD_READERSTATEW, DWORD );
WINSCARDAPI LONG WINAPI     SCardReconnect( SCARDHANDLE, DWORD, DWORD, DWORD, LPDWORD );
WINSCARDAPI LONG WINAPI     SCardReleaseContext( SCARDCONTEXT );
WINSCARDAPI LONG WINAPI     SCardRemoveReaderFromGroupA( SCARDCONTEXT, LPCSTR, LPCSTR );
WINSCARDAPI LONG WINAPI     SCardRemoveReaderFromGroupW( SCARDCONTEXT, LPCWSTR, LPCWSTR );
WINSCARDAPI LONG WINAPI     SCardSetAttrib( SCARDHANDLE, DWORD, LPCBYTE, DWORD );
WINSCARDAPI LONG WINAPI     SCardSetCardTypeProviderNameA( SCARDCONTEXT, LPCSTR, DWORD, LPCSTR );
WINSCARDAPI LONG WINAPI     SCardSetCardTypeProviderNameW( SCARDCONTEXT, LPCWSTR, DWORD, LPCWSTR );
WINSCARDAPI LONG WINAPI     SCardState( SCARDHANDLE, LPDWORD, LPDWORD, LPBYTE, LPDWORD );
WINSCARDAPI LONG WINAPI     SCardStatusA( SCARDHANDLE, LPSTR, LPDWORD, LPDWORD, LPDWORD, LPBYTE, LPDWORD );
WINSCARDAPI LONG WINAPI     SCardStatusW( SCARDHANDLE, LPWSTR, LPDWORD, LPDWORD, LPDWORD, LPBYTE, LPDWORD );
WINSCARDAPI LONG WINAPI     SCardTransmit( SCARDHANDLE, LPSCARD_IO_REQUEST, LPCBYTE, DWORD, LPSCARD_IO_REQUEST, LPBYTE, LPDWORD );
#if (NTDDI_VERSION >= 0x05010000)
WINSCARDAPI HANDLE WINAPI   SCardAccessStartedEvent( void );
WINSCARDAPI LONG WINAPI     SCardLocateCardsByATRA( SCARDCONTEXT, LPSCARD_ATRMASK, DWORD, LPSCARD_READERSTATEA, DWORD );
WINSCARDAPI LONG WINAPI     SCardLocateCardsByATRW( SCARDCONTEXT, LPSCARD_ATRMASK, DWORD, LPSCARD_READERSTATEW, DWORD );
WINSCARDAPI void WINAPI     SCardReleaseStartedEvent( void );
#endif
#if (NTDDI_VERSION >= 0x06000000)
WINSCARDAPI LONG WINAPI     SCardGetTransmitCount( SCARDHANDLE, LPDWORD );
WINSCARDAPI LONG WINAPI     SCardReadCacheA( SCARDCONTEXT, UUID *, DWORD, LPSTR, PBYTE, DWORD * );
WINSCARDAPI LONG WINAPI     SCardReadCacheW( SCARDCONTEXT, UUID *, DWORD, LPWSTR, PBYTE, DWORD * );
WINSCARDAPI LONG WINAPI     SCardWriteCacheA( SCARDCONTEXT, UUID *, DWORD, LPSTR, PBYTE, DWORD );
WINSCARDAPI LONG WINAPI     SCardWriteCacheW( SCARDCONTEXT, UUID *, DWORD, LPWSTR, PBYTE, DWORD );
#endif

/* Functions in SCARDDLG.DLL */
WINSCARDAPI LONG WINAPI     GetOpenCardNameA( LPOPENCARDNAMEA );
WINSCARDAPI LONG WINAPI     GetOpenCardNameW( LPOPENCARDNAMEW );
WINSCARDAPI LONG WINAPI     SCardDlgExtendedError( void );
WINSCARDAPI LONG WINAPI     SCardUIDlgSelectCardA( LPOPENCARDNAMEA_EX );
WINSCARDAPI LONG WINAPI     SCardUIDlgSelectCardW( LPOPENCARDNAMEW_EX );

/* Map generic function names to the appropriate ANSI or Unicode version. */
#ifdef UNICODE
    #define GetOpenCardName                 GetOpenCardNameW
    #define SCardAddReaderToGroup           SCardAddReaderToGroupW
    #define SCardConnect                    SCardConnectW
    #define SCardForgetCardType             SCardForgetCardTypeW
    #define SCardForgetReader               SCardForgetReaderW
    #define SCardForgetReaderGroup          SCardForgetReaderGroupW
    #define SCardGetCardTypeProviderName    SCardGetCardTypeProviderNameW
    #define SCardGetProviderId              SCardGetProviderIdW
    #define SCardGetStatusChange            SCardGetStatusChangeW
    #define SCardIntroduceCardType          SCardIntroduceCardTypeW
    #define SCardIntroduceReader            SCardIntroduceReaderW
    #define SCardIntroduceReaderGroup       SCardIntroduceReaderGroupW
    #define SCardListCards                  SCardListCardsW
    #define SCardListInterfaces             SCardListInterfacesW
    #define SCardListReaderGroups           SCardListReaderGroupsW
    #define SCardListReaders                SCardListReadersW
    #define SCardLocateCards                SCardLocateCardsW
    #define SCardRemoveReaderFromGroup      SCardRemoveReaderFromGroupW
    #define SCardSetCardTypeProviderName    SCardSetCardTypeProviderNameW
    #define SCardStatus                     SCardStatusW
    #define SCardUIDlgSelectCard            SCardUIDlgSelectCardW
    #if (NTDDI_VERSION >= 0x05010000)
        #define SCardLocateCardsByATR       SCardLocateCardsByATRW
    #endif
    #if (NTDDI_VERSION >= 0x06000000)
        #define SCardReadCache              SCardReadCacheW
        #define SCardWriteCache             SCardWriteCacheW
    #endif
#else
    #define GetOpenCardName                 GetOpenCardNameA
    #define SCardAddReaderToGroup           SCardAddReaderToGroupA
    #define SCardConnect                    SCardConnectA
    #define SCardForgetCardType             SCardForgetCardTypeA
    #define SCardForgetReader               SCardForgetReaderA
    #define SCardForgetReaderGroup          SCardForgetReaderGroupA
    #define SCardGetCardTypeProviderName    SCardGetCardTypeProviderNameA
    #define SCardGetProviderId              SCardGetProviderIdA
    #define SCardGetStatusChange            SCardGetStatusChangeA
    #define SCardIntroduceCardType          SCardIntroduceCardTypeA
    #define SCardIntroduceReader            SCardIntroduceReaderA
    #define SCardIntroduceReaderGroup       SCardIntroduceReaderGroupA
    #define SCardListCards                  SCardListCardsA
    #define SCardListInterfaces             SCardListInterfacesA
    #define SCardListReaderGroups           SCardListReaderGroupsA
    #define SCardListReaders                SCardListReadersA
    #define SCardLocateCards                SCardLocateCardsA
    #define SCardRemoveReaderFromGroup      SCardRemoveReaderFromGroupA
    #define SCardSetCardTypeProviderName    SCardSetCardTypeProviderNameA
    #define SCardStatus                     SCardStatusA
    #define SCardUIDlgSelectCard            SCardUIDlgSelectCardA
    #if (NTDDI_VERSION >= 0x05010000)
        #define SCardLocateCardsByATR       SCardLocateCardsByATRA
    #endif
    #if (NTDDI_VERSION >= 0x06000000)
        #define SCardReadCache              SCardReadCacheA
        #define SCardWriteCache             SCardWriteCacheA
    #endif
#endif

/* Aliases */
#define SCardGetReaderCapabilities  SCardGetAttrib
#define SCardListCardTypes          SCardListCards
#define SCardSetReaderCapabilities  SCardSetAttrib

/* Alternate name for SCardIntroduceCardType with different parameter order */
#define PCSCardIntroduceCardType( p1, p2, p3, p4, p5, p6, p7, p8 ) \
    SCardIntroduceCardType( p1, p2, p6, p7, p8, p3, p4, p5 )

/* Macros to access global variables */
#define SCARD_PCI_T0    (&g_rgSCardT0Pci)
#define SCARD_PCI_T1    (&g_rgSCardT1Pci)
#define SCARD_PCI_RAW   (&g_rgSCardRawPci)

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _WINSCARD_H_ */
