/*
 *  ws2ipdef.h  Windows Sockets (version 2) IP definitions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#ifndef _WS2IPDEF_
#define _WS2IPDEF_

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#include <in6addr.h>

#ifdef __cplusplus
extern "C" {
#endif

/* Interface information flags */
#define IFF_UP              0x00000001L
#define IFF_BROADCAST       0x00000002L
#define IFF_LOOPBACK        0x00000004L
#define IFF_POINTTOPOINT    0x00000008L
#define IFF_MULTICAST       0x00000010L

/* IP socket options */
#define IP_OPTIONS                  1
#define IP_HDRINCL                  2
#define IP_TOS                      3
#define IP_TTL                      4
#define IP_MULTICAST_IF             9
#define IP_MULTICAST_TTL            10
#define IP_MULTICAST_LOOP           11
#define IP_ADD_MEMBERSHIP           12
#define IP_DROP_MEMBERSHIP          13
#define IP_DONTFRAGMENT             14
#define IP_ADD_SOURCE_MEMBERSHIP    15
#define IP_DROP_SOURCE_MEMBERSHIP   16
#define IP_BLOCK_SOURCE             17
#define IP_UNBLOCK_SOURCE           18
#define IP_PKTINFO                  19
#define IP_HOPLIMIT                 21
#define IP_RECEIVE_BROADCAST        22
#define IP_RECVIF                   24
#define IP_RECVDSTADDR              25
#define IP_IFLIST                   28
#define IP_ADD_IFLIST               29
#define IP_DEL_IFLIST               30
#define IP_UNICAST_IF               31
#define IP_RTHDR                    32
#define IP_RECVRTHDR                38
#define IP_TCLASS                   39
#define IP_RECVTCLASS               40
#define IP_ORIGINAL_ARRIVAL_IF      47

/* Macro to extract port from socket address */
#define SS_PORT( x )    (((PSOCKADDR_IN)(x))->sin_port)

/* Specific IPv6 addresses */
#if (NTDDI_VERSION >= 0x05000100)
    #define IN6ADDR_ANY_INIT                { 0 }
    #define IN6ADDR_LOOPBACK_INIT \
        { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x01 }
    #define IN6ADDR_ALLNODESONNODE_INIT \
        { 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x01 }
    #define IN6ADDR_ALLNODESONLINK_INIT \
        { 0xFF, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x01 }
    #define IN6ADDR_ALLROUTERSONLINK_INIT \
        { 0xFF, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x02 }
    #define IN6ADDR_ALLMLDV2ROUTERSONLINK_INIT \
        { 0xFF, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
        0x00, 0x00, 0x16 }
    #define IN6ADDR_TEREDOINITIALLINKLOCALADDRESS_INIT \
        { 0xFE, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, \
        0xFF, 0xFF, 0xFE }
    #define IN6ADDR_TEREDOOLDLINKLOCALADDRESSXP_INIT \
        { 0xFE, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 'T', 'E', R', \
        'E', 'D', 'O' }
    #define IN6ADDR_TEREDOOLDLINKLOCALADDRESSVISTA_INIT \
        { 0xFE, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, \
        0xFF, 0xFF, 0xFF }
    #define IN6ADDR_LINKLOCALPREFIX_INIT    { 0xFE, 0x80 }
    #define IN6ADDR_MULTICASTPREFIX_INIT    { 0xFF, 0x00 }
    #define IN6ADDR_SOLICITEDNODEMULTICASTPREFIX_INIT \
        { 0xFF, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF }
    #define IN6ADDR_V4MAPPEDPREFIX_INIT \
        { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF }
    #define IN6ADDR_6TO4PREFIX_INIT         { 0x20, 0x02 }
    #define IN6ADDR_TEREDOPREFIX_INIT       { 0x20, 0x01, 0x00, 0x00 }
    #define IN6ADDR_TEREDOPREFIX_INIT_OLD   { 0x3F, 0xFE, 0x83, 0x1F }
    #define IN6ADDR_LINKLOCALPREFIX_LENGTH  64
    #define IN6ADDR_MULTICASTPREFIX_LENGTH  8
    #define IN6ADDR_SOLICITEDNODEMULTICASTPREFIX_LENGTH 104
    #define IN6ADDR_V4MAPPEDPREFIX_LENGTH   96
    #define IN6ADDR_6TO4PREFIX_LENGTH       16
    #define IN6ADDR_TEREDOPREFIX_LENGTH     32
#endif

/* Macros to manipulate IP addresses */
#if (NTDDI_VERSION >= 0x05010000)
    #define IN6_ADDR_EQUAL( p1, p2 ) \
        (BOOLEAN)((((__int64 *)(p1))[0] == ((__int64 *)(p2))[0]) && \
        (((__int64 *)(p1))[1] == ((__int64 *)(p2))[1]))
    #define IN6_ARE_ADDR_EQUAL  IN6_ADDR_EQUAL
    #define IN6_IS_ADDR_UNSPECIFIED( x ) \
        (BOOLEAN)(((x)->s6_words[0] == 0) && ((x)->s6_words[1] == 0) && \
        ((x)->s6_words[2] == 0) && ((x)->s6_words[3] == 0) && \
        ((x)->s6_words[4] == 0) && ((x)->s6_words[5] == 0) && \
        ((x)->s6_words[6] == 0) && ((x)->s6_words[7] == 0))
    #define IN6_IS_ADDR_LOOPBACK( x ) \
        (BOOLEAN)(((x)->s6_words[0] == 0) && ((x)->s6_words[1] == 0) && \
        ((x)->s6_words[2] == 0) && ((x)->s6_words[3] == 0) && \
        ((x)->s6_words[4] == 0) && ((x)->s6_words[5] == 0) && \
        ((x)->s6_words[6] == 0) && ((x)->s6_words[7] == 0x0100))
    #define IN6_IS_ADDR_MULTICAST( x ) \
        (BOOLEAN)((x)->s6_bytes[0] == 0xFF)
    #define IN6_IS_ADDR_EUI64( x ) \
        (BOOLEAN)((((x)->s6_bytes[0] & 0xE0) != 0) && !IN6_IS_ADDR_MULTICAST( x ))
    #define IN6_IS_ADDR_SUBNET_ROUTER_ANYCAST( x ) \
        (BOOLEAN)(IN6_IS_ADDR_EUI64( x ) && ((x)->s6_words[4] == 0) && \
        ((x)->s6_words[5] == 0) && ((x)->s6_words[6] == 0) && \
        ((x)->s6_words[7] == 0))
    #define IN6_IS_ADDR_SUBNET_RESERVED_ANYCAST( x ) \
        (BOOLEAN)(IN6_IS_ADDR_EUI64( x ) && ((x)->s6_words[4] == 0xFFFD) && \
        ((x)->s6_words[5] == 0xFFFF) && ((x)->s6_words[6] == 0xFFFF) && \
        (((x)->s6_words[7] & 0x80FF) == 0x80FF))
    #define IN6_IS_ADDR_ANYCAST( x ) \
        (IN6_IS_ADDR_SUBNET_RESERVED_ANYCAST( x ) || \
        IN6_IS_ADDR_SUBNET_ROUTER_ANYCAST( x ))
    #define IN6_IS_ADDR_LINKLOCAL( x ) \
        (BOOLEAN)(((x)->s6_bytes[0] == 0xFE) && (((x)->s6_bytes[1] & 0xC0) == 0x80))
    #define IN6_IS_ADDR_SITELOCAL( x ) \
        (BOOLEAN)(((x)->s6_bytes[0] == 0xFE) && (((x)->s6_bytes[1] & 0xC0) == 0xC0))
    #define IN6_IS_ADDR_GLOBAL( x ) \
        (BOOLEAN)((((x)->s6_bytes[0] & 0xF0) != 0) && \
        (((x)->s6_bytes[0] & 0xF0) != 0xF0))
    #define IN6_IS_ADDR_V4MAPPED( x ) \
        (BOOLEAN)(((x)->s6_words[0] == 0) && ((x)->s6_words[1] == 0) && \
        ((x)->s6_words[2] == 0) && ((x)->s6_words[3] == 0) && \
        ((x)->s6_words[4] == 0) && ((x)->s6_words[5] == 0xFFFF))
    #define IN6_IS_ADDR_V4COMPAT( x ) \
        (BOOLEAN)(((x)->s6_words[0] == 0) && ((x)->s6_words[1] == 0) && \
        ((x)->s6_words[2] == 0) && ((x)->s6_words[3] == 0) && \
        ((x)->s6_words[4] == 0) && ((x)->s6_words[5] == 0) && \
        !(((x)->s6_words[6] == 0) && ((x)->s6_addr[14] == 0) && \
        (((x)->s6_addr[15] == 0) || ((x)->s6_addr[15] == 1))))
    #define IN6_IS_ADDR_V4TRANSLATED( x ) \
        (BOOLEAN)(((x)->s6_words[0] == 0) && ((x)->s6_words[1] == 0) && \
        ((x)->s6_words[2] == 0) && ((x)->s6_words[3] == 0) && \
        ((x)->s6_words[4] == 0xFFFF) && ((x)->s6_words[5] == 0))
    #define IN6_IS_ADDR_MC_NODELOCAL( x ) \
        (BOOLEAN)(IN6_IS_ADDR_MULTICAST( x ) && (((x)->s6_bytes[1] & 0x0F) == 1))
    #define IN6_IS_ADDR_MC_LINKLOCAL( x ) \
        (BOOLEAN)(IN6_IS_ADDR_MULTICAST( x ) && (((x)->s6_bytes[1] & 0x0F) == 2))
    #define IN6_IS_ADDR_MC_SITELOCAL( x ) \
        (BOOLEAN)(IN6_IS_ADDR_MULTICAST( x ) && (((x)->s6_bytes[1] & 0x0F) == 5))
    #define IN6_IS_ADDR_MC_ORGLOCAL( x ) \
        (BOOLEAN)(IN6_IS_ADDR_MULTICAST( x ) && (((x)->s6_bytes[1] & 0x0F) == 8))
    #define IN6_IS_ADDR_MC_GLOBAL( x ) \
        (BOOLEAN)(IN6_IS_ADDR_MULTICAST( x ) && (((x)->s6_bytes[1] & 0x0F) == 0x0E))
    #define IN6_SET_ADDR_UNSPECIFIED( x ) \
        memset( (x)->s6_bytes, 0, sizeof( IN6_ADDR ) )
    #define IN6_SET_ADDR_LOOPBACK( x ) \
        { \
            memset( (x)->s6_bytes, 0, sizeof( IN6_ADDR ) ); \
            (x)->s6_bytes[15] = 1; \
        }
    #define IN6ADDR_SETANY( x ) \
        { \
            (x)->sin6_family = AF_INET6; \
            (x)->sin6_port = 0; \
            (x)->sin6_flowinfo = 0; \
            IN6_SET_ADDR_UNSPECIFIED( &(x)->sin6_addr ); \
            (x)->sin6_scope_id = 0; \
        }
    #define IN6ADDR_SETLOOPBACK( x ) \
        { \
            (x)->sin6_family = AF_INET6; \
            (x)->sin6_port = 0; \
            (x)->sin6_flowinfo = 0; \
            IN6_SET_ADDR_UNSPECIFIED( &(x)->sin6_addr ); \
            (x)->sin6_scope_id = 0; \
        }
    #define IN6ADDR_ISANY( x ) \
        IN6_IS_ADDR_UNSPECIFIED( &(x)->sin6_addr )
    #define IN6ADDR_LOOPBACK( x ) \
        IN6_IS_ADDR_LOOPBACK( &(x)->sin6_addr )
    #define IN6ADDR_ISEQUAL( p1, p2 ) \
        (BOOLEAN)((p1)->sin6_scope_id == (p2)->sin6_scope_id && \
        IN6_ADDR_EQUAL( &(p1)->sin6_addr, &(p2)->sin6_addr ))
    #define IN6ADDR_ISUNSPECIFIED( x ) \
        (BOOLEAN)((x)->sin6_scope_id == 0 && IN6_IS_ADDR_UNSPECIFIED( &(x)->sin6_addr ))
#endif

/* TCP/IP I/O control codes */
#define SIO_GET_INTERFACE_LIST              _IOR( 't', 127, ULONG )
#define SIO_GET_INTERFACE_LIST_EX           _IOR( 't', 126, ULONG )
#define SIO_SET_MULTICAST_FILTER            _IOW( 't', 125, ULONG )
#define SIO_GET_MULTICAST_FILTER            _IOW( 't', 124 | IOC_IN, ULONG )
#define SIOCSIPMSFILTER                     SIO_SET_MULTICAST_FILTER
#define SIOCGIPMSFILTER                     SIO_GET_MULTICAST_FILTER
#define SIOCSMSFILTER                       _IOW( 't', 126, ULONG )
#define SIOCGMSFILTER                       _IOW( 't', 127 | IOC_IN, ULONG )
#if (NTDDI_VERSION >= 0x06000100)
    #define IDEAL_SEND_BACKLOG_IOCTLS
    #define SIO_IDEAL_SEND_BACKLOG_QUERY    _IOR( 't', 123, ULONG )
    #define SIO_IDEAL_SEND_BACKLOG_CHANGE   _IO( 't', 122 )
#endif

/* Multicast filter options */
#define MCAST_JOIN_GROUP            41
#define MCAST_LEAVE_GROUP           42
#define MCAST_BLOCK_SOURCE          43
#define MCAST_UNBLOCK_SOURCE        44
#define MCAST_JOIN_SOURCE_GROUP     45
#define MCAST_LEAVE_SOURCE_GROUP    46

/* IPv6 socket options */
#define IPV6_HOPOPTS            1
#define IPV6_HDRINCL            2
#define IPV6_UNICAST_HOPS       4
#define IPV6_MULTICAST_IF       9
#define IPV6_MULTICAST_HOPS     10
#define IPV6_MULTICAST_LOOP     11
#define IPV6_ADD_MEMBERSHIP     12
#define IPV6_JOIN_GROUP         IPV6_ADD_MEMBERSHIP
#define IPV6_DROP_MEMBERSHIP    13
#define IPV6_LEAVE_GROUP        IPV6_DROP_MEMBERSHIP
#define IPV6_DONTFRAG           14
#define IPV6_PKTINFO            19
#define IPV6_HOPLIMIT           21
#define IPV6_PROTECTION_LEVEL   23
#define IPV6_RECVIF             24
#define IPV6_RECVDSTADDR        25
#define IPV6_CHECKSUM           26
#define IPV6_V6ONLY             27
#define IPV6_IFLIST             28
#define IPV6_ADD_IFLIST         29
#define IPV6_DEL_IFLIST         30
#define IPV6_UNICAST_IF         31
#define IPV6_RTHDR              32
#define IPV6_RECVRTHDR          38
#define IPV6_TCLASS             39
#define IPV6_RECVTCLASS         40
#define IP_PROTECTION_LEVEL     IPV6_PROTECTION_LEVEL

/* IP hop limit special value */
#define IP_UNSPECIFIED_HOP_LIMIT    (-1)

/* IPv6 protection levels */
#define PROTECTION_LEVEL_UNRESTRICTED   10
#define PROTECTION_LEVEL_EDGERESTRICTED 20
#define PROTECTION_LEVEL_RESTRICTED     30
#if (NTDDI_VERSION < 0x06000000)
    #define PROTECTION_LEVEL_DEFAULT    PROTECTION_LEVEL_EDGERESTRICTED
#else
    #define PROTECTION_LEVEL_DEFAULT    ((UINT)-1)
#endif

/* Maximum address length */
#define INET_ADDRSTRLEN     22
#define INET6_ADDRSTRLEN    65

/* TCP offload preference values */
#define TCP_OFFLOAD_NO_PREFERENCE   0
#define TCP_OFFLOAD_NOT_PREFERRED   1
#define TCP_OFFLOAD_PREFERRED       2

/* TCP options */
#define TCP_KEEPALIVE               3
#define TCP_MAXSEG                  4
#define TCP_MAXRT                   5
#define TCP_STDURG                  6
#define TCP_NOURG                   7
#define TCP_ATMARK                  8
#define TCP_NOSYNRETRIES            9
#define TCP_TIMESTAMPS              10
#define TCP_OFFLOAD_PREFERENCE      11
#define TCP_CONGESTION_ALGORITHM    12
#define TCP_DELAY_FIN_ACK           13

/* Old IPv6 socket address */
struct sockaddr_in6_old {
    SHORT       sin6_family;
    USHORT      sin6_port;
    ULONG       sin6_flowinfo;
    IN6_ADDR    sin6_addr;
};

/* General socket address */
typedef union sockaddr_gen {
    struct sockaddr         Address;
    struct sockaddr_in      AddressIn;
    struct sockaddr_in6_old AddressIn6;
} sockaddr_gen;

/* Interface information */
typedef struct _INTERFACE_INFO {
    ULONG           iiFlags;
    sockaddr_gen    iiAddress;
    sockaddr_gen    iiBroadcastAddress;
    sockaddr_gen    iiNetmask;
} INTERFACE_INFO;
typedef INTERFACE_INFO  *LPINTERFACE_INFO;

/* Interface information (extended version) */
typedef struct _INTERFACE_INFO_EX {
    ULONG           iiFlags;
    SOCKET_ADDRESS  iiAddress;
    SOCKET_ADDRESS  iiBroadcastAddress;
    SOCKET_ADDRESS  iiNetmask;
} INTERFACE_INFO_EX;
typedef INTERFACE_INFO_EX   *LPINTERFACE_INFO_EX;

/* IPv6 socket address */
typedef struct sockaddr_in6 {
    ADDRESS_FAMILY  sin6_family;
    USHORT          sin6_port;
    ULONG           sin6_flowinfo;
    IN6_ADDR        sin6_addr;
    union {
        ULONG       sin6_scope_id;
        SCOPE_ID    sin6_scope_struct;
    };
} SOCKADDR_IN6_LH;
typedef SOCKADDR_IN6_LH     *PSOCKADDR_IN6_LH;
typedef SOCKADDR_IN6_LH     *LPSOCKADDR_IN6_LH;
typedef struct sockaddr_in6_w2ksp1 {
    short           sin6_family;
    USHORT          sin6_port;
    ULONG           sin6_flowinfo;
    struct in6_addr sin6_addr;
    ULONG           sin6_scope_id;
} SOCKADDR_IN6_W2KSP1;
typedef SOCKADDR_IN6_W2KSP1 *PSOCKADDR_IN6_W2KSP1;
typedef SOCKADDR_IN6_W2KSP1 *LPSOCKADDR_IN6_W2KSP1;
#if (NTDDI_VERSION >= 0x05000100) && (NTDDI_VERSION < 0x06000000)
typedef SOCKADDR_IN6_W2KSP1 SOCKADDR_IN6;
typedef SOCKADDR_IN6_W2KSP1 *PSOCKADDR_IN6;
typedef SOCKADDR_IN6_W2KSP1 *LPSOCKADDR_IN6;
#else
typedef SOCKADDR_IN6_LH     SOCKADDR_IN6;
typedef SOCKADDR_IN6_LH     *PSOCKADDR_IN6;
typedef SOCKADDR_IN6_LH     *LPSOCKADDR_IN6;
#endif

/* Internet socket address */
typedef union _SOCKADDR_INET {
    SOCKADDR_IN     Ipv4;
    SOCKADDR_IN6    Ipv6;
    ADDRESS_FAMILY  si_family;
} SOCKADDR_INET;
typedef SOCKADDR_INET   *PSOCKADDR_INET;

/* IPv6 socket address pair */
typedef struct _sockaddr_in6_pair {
    PSOCKADDR_IN6   SourceAddress;
    PSOCKADDR_IN6   DestinationAddress;
} SOCKADDR_IN6_PAIR;
typedef SOCKADDR_IN6_PAIR   *PSOCKADDR_IN6_PAIR;

/* Multicast mode types */
typedef enum {
    MCAST_INCLUDE   = 0,
    MCAST_EXCLUDE   = 1
} MULTICAST_MODE_TYPE;

/* IP membership requirement */
typedef struct ip_mreq {
    IN_ADDR imr_multiaddr;
    IN_ADDR imr_interface;
} IP_MREQ;
typedef IP_MREQ *PIP_MREQ;

/* IP membership requirement source */
typedef struct ip_mreq_source {
    IN_ADDR imr_multiaddr;
    IN_ADDR imr_sourceaddr;
    IN_ADDR imr_interface;
} IP_MREQ_SOURCE;
typedef IP_MREQ_SOURCE  *PIP_MREQ_SOURCE;

/* IP Microsoft filter information */
typedef struct ip_msfilter {
    IN_ADDR             imsf_multiaddr;
    IN_ADDR             imsf_interface;
    MULTICAST_MODE_TYPE imsf_fmode;
    ULONG               imsf_numsrc;
    IN_ADDR             imsf_slist[1];
} IP_MSFILTER;
typedef IP_MSFILTER *PIP_MSFILTER;
#define IP_MSFILTER_SIZE( x ) \
    (sizeof( IP_MSFILTER ) - sizeof( IN_ADDR ) + (x) * sizeof( IN_ADDR ))

/* IPv6 membership requirement */
typedef struct ipv6_mreq {
    IN6_ADDR    ipv6mr_multiaddr;
    ULONG       ipv6mr_interface;
} IPV6_MREQ;
typedef IPV6_MREQ   *PIPV6_MREQ;

/* Group requirement */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct group_req {
    ULONG               gr_interface;
    SOCKADDR_STORAGE    gr_group;
} GROUP_REQ;
typedef GROUP_REQ   *PGROUP_REQ;
#endif

/* Group source requirement */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct group_storage_req {
    ULONG               gsr_interface;
    SOCKADDR_STORAGE    gsr_group;
    SOCKADDR_STORAGE    gsr_source;
} GROUP_STORAGE_REQ;
typedef GROUP_STORAGE_REQ   *PGROUP_STORAGE_GROUP;
#endif

/* Group filter */
#if (NTDDI_VERSION >= 0x05010000)
typedef struct group_filter {
    ULONG               gf_interface;
    SOCKADDR_STORAGE    gf_group;
    MULTICAST_MODE_TYPE gf_fmode;
    ULONG               gf_numsrc;
    SOCKADDR_STORAGE    gf_slist[1];
} GROUP_FILTER;
typedef GROUP_FILTER    *PGROUP_FILTER;
#define GROUP_FITLER_SIZE( x ) \
    (sizeof( GROUP_FILTER ) - sizeof( SOCKADDR_STORAGE ) + (x) * \
    sizeof( SOCKADDR_STORAGE ))
#endif

/* IP packet information */
typedef struct in_pktinfo {
    IN_ADDR ipi_addr;
    ULONG   ipi_ifindex;
} IN_PKTINFO;
typedef IN_PKTINFO  *PIN_PKTINFO;

/* IPv6 packet information */
typedef struct in6_pktinfo {
    IN6_ADDR    ipi6_addr;
    ULONG       ipi6_ifindex;
} IN6_PKTINFO;
typedef IN6_PKTINFO *PIN6_PKTINFO;

/* These addresses are in network byte order. */

extern const IN_ADDR __cdecl in4addr_any;
extern const IN_ADDR __cdecl in4addr_loopback;
extern const IN_ADDR __cdecl in4addr_broadcast;
extern const IN_ADDR __cdecl in4addr_allnodesonlink;
extern const IN_ADDR __cdecl in4addr_allroutersonlink;
extern const IN_ADDR __cdecl in4addr_alligmpv3routersonlink;
extern const IN_ADDR __cdecl in4addr_allteredohostsonlink;
extern const IN_ADDR __cdecl in4addr_linklocalprefix;
extern const IN_ADDR __cdecl in4addr_multicastprefix;

extern const IN6_ADDR __cdecl in6addr_any;
extern const IN6_ADDR __cdecl in6addr_loopback;
extern const IN6_ADDR __cdecl in6addr_allnodesonnode;
extern const IN6_ADDR __cdecl in6addr_allnodesonlink;
extern const IN6_ADDR __cdecl in6addr_allroutersonlink;
extern const IN6_ADDR __cdecl in6addr_allmldv2routersonlink;
extern const IN6_ADDR __cdecl in6addr_teredoinitiallinklocaladdress;
extern const IN6_ADDR __cdecl in6addr_linklocalprefix;
extern const IN6_ADDR __cdecl in6addr_multicastprefix;
extern const IN6_ADDR __cdecl in6addr_solicitednodemulticastprefix;
extern const IN6_ADDR __cdecl in6addr_v4mappedprefix;
extern const IN6_ADDR __cdecl in6addr_6to4prefix;
extern const IN6_ADDR __cdecl in6addr_teredoprefix;
extern const IN6_ADDR __cdecl in6addr_teredoprefix_old;

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* _WS2IPDEF_ */
