/*
 *  strings.h POSIX string manipulation routines
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _STRINGS_H_INCLUDED
#define _STRINGS_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef __cplusplus
 #ifndef _STDSIZE_T_DEFINED
 #define _STDSIZE_T_DEFINED
  namespace std {
    typedef unsigned size_t;
  }
  typedef std::size_t __w_size_t;
 #endif
 #ifndef _SIZE_T_DEFINED
 #define _SIZE_T_DEFINED
  #define _SIZE_T_DEFINED_
  using std::size_t;
 #endif
#else  /* __cplusplus not defined */
 #ifndef _SIZE_T_DEFINED
 #define _SIZE_T_DEFINED
  #define _SIZE_T_DEFINED_
  typedef unsigned size_t;
  typedef size_t   __w_size_t;
 #endif
#endif /* __cplusplus not defined */

/* Legacy functions */

_WCRTLINK extern int    bcmp( const void *__s1, const void *__s2, __w_size_t __n );
_WCRTLINK extern void   bcopy( const void *__s1, void *__s2, __w_size_t __n );
_WCRTLINK extern void   bzero( void *__s, __w_size_t __n );
_WCRTLINK extern char   *index( const char *s, int c );
_WCRTLINK extern char   *rindex( const char *s, int c );

/* Non-legacy functions */

_WCRTLINK extern int    ffs( int __i );
_WCRTLINK extern int    strcasecmp( const char *__s1, const char *__s2 );
_WCRTLINK extern int    strncasecmp( const char *__s1, const char *__s2, __w_size_t __n );

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
