/*
 *  alloca.h    Dynamic stack storage allocation
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _ALLOCA_H_INCLUDED
#define _ALLOCA_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifdef __cplusplus
 #ifndef _STDSIZE_T_DEFINED
 #define _STDSIZE_T_DEFINED
  namespace std {
    typedef unsigned size_t;
  }
  typedef std::size_t __w_size_t;
 #endif
 #ifndef _SIZE_T_DEFINED
 #define _SIZE_T_DEFINED
  #define _SIZE_T_DEFINED_
  using std::size_t;
 #endif
#else  /* __cplusplus not defined */
 #ifndef _SIZE_T_DEFINED
 #define _SIZE_T_DEFINED
  #define _SIZE_T_DEFINED_
  typedef unsigned size_t;
  typedef size_t   __w_size_t;
 #endif
#endif /* __cplusplus not defined */

#ifndef NULL
#ifdef __cplusplus
  #define NULL 0
#else
 #define NULL ((void *)0)
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifndef alloca
 _WCRTLINK extern unsigned stackavail( void );
 _WCRTLINK extern unsigned _stackavail( void );
 #ifdef _M_IX86
  #pragma aux stackavail __modify __nomemory
  #pragma aux _stackavail __modify __nomemory

  #if defined(__COMPACT__) || defined(__LARGE__) || defined(__HUGE__) || defined(__SW_ZU)
   extern void __based(__segname("_STACK")) *__doalloca(__w_size_t __size);
  #else
   extern void *__doalloca(__w_size_t __size);
  #endif
   #pragma aux __doalloca = \
           "sub esp,eax"   \
       __parm __nomemory [__eax] \
       __value [__esp] \
       __modify __exact __nomemory [__esp]

  #define __ALLOCA_ALIGN( s )   (((s)+(sizeof(int)-1))&~(sizeof(int)-1))
  #define __alloca( s )         __doalloca(__ALLOCA_ALIGN(s))

   #define alloca( s )  ((__ALLOCA_ALIGN(s)<stackavail())?__alloca(s): (void *)0)
   #define _alloca( s ) ((__ALLOCA_ALIGN(s)<stackavail())?__alloca(s): (void *)0)

 #else
  extern void *__builtin_alloca(__w_size_t __size);
  #pragma intrinsic(__builtin_alloca)

  #define __alloca( s ) (__builtin_alloca(s))

  #define alloca( s )   ((s<stackavail())?__alloca(s):(void *)0)
  #define _alloca( s )  ((s<stackavail())?__alloca(s):(void *)0)
 #endif
#endif

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
