/*
 *  arch/i386/termios.h
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

#define NCCS 19
struct termios {
    tcflag_t        c_iflag;
    tcflag_t        c_oflag;
    tcflag_t        c_cflag;
    tcflag_t        c_lflag;
    cc_t            c_line;
    cc_t            c_cc[NCCS];
    speed_t         c_ispeed;
    speed_t         c_ospeed;
};

/*
 * Special Control Character indices into c_cc[]
 */
#define VINTR       0
#define VQUIT       1
#define VERASE      2
#define VKILL       3
#define VEOF        4
#define VTIME       5
#define VMIN        6
#define VSWTC       7
#define VSTART      8
#define VSTOP       9
#define VSUSP       10
#define VEOL        11
#define VREPRINT    12
#define VDISCARD    13
#define VWERASE     14
#define VLNEXT      15
#define VEOL2       16

/*
 * Input modes (c_iflag)
 */
#define IUCLC       0x0200
#define IXON        0x0400
#define IXOFF       0x1000

/*
 * Ouput Modes (c_oflag)
 */
#define OLCUC       0x00002
#define ONLCR       0x00004
#define VTDLY       0x04000
#define   VT0       0x00000
#define   VT1       0x04000

/*
 * Attributes (c_cflag), Baud rates
 */
#define CSIZE       0x0030
#define  CS5        0x0000
#define  CS6        0x0010
#define  CS7        0x0020
#define  CS8        0x0030

#define CSTOPB      0x0040
#define CREAD       0x0080
#define PARENB      0x0100
#define PARODD      0x0200
#define HUPCL       0x0400
#define CLOCAL      0x0800

#define CBAUD       0x100F
#define CBAUDEX     0x1000
#define  B57600     0x1001
#define  B115200    0x1002
#define  B230400    0x1003
#define  B460800    0x1004
#define  B500000    0x1005
#define  B576000    0x1006
#define  B921600    0x1007
#define  B1000000   0x1008
#define  B1152000   0x1009
#define  B1500000   0x100A
#define  B2000000   0x100B
#define  B2500000   0x100C
#define  B3000000   0x100D
#define  B3500000   0x100E
#define  B4000000   0x100F

#define CIBAUD      0x100f0000

/*
 * Local Modes (c_lflag)
 */
#define ISIG        0x00001
#define ICANON      0x00002
#define XCASE       0x00004
#define ECHO        0x00008
#define ECHOE       0x00010
#define ECHOK       0x00020
#define ECHONL      0x00040
#define NOFLSH      0x00080
#define TOSTOP      0x00100
#define ECHOCTL     0x00200
#define ECHOPRT     0x00400
#define ECHOKE      0x00800
#define FLUSHO      0x01000
#define PENDIN      0x04000
#define IEXTEN      0x08000
#define EXTPROC     0x10000
