/*
 *  arch/mips/sys/stat.h
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */

/* 
 *  POSIX 1003.1 types
 */
#ifndef _DEV_T_DEFINED_
 #define _DEV_T_DEFINED_
 typedef unsigned long  dev_t;  /* Combination of node and device   */
#endif
#ifndef _INO_T_DEFINED_
 #define _INO_T_DEFINED_
 typedef unsigned long  ino_t;  /* Used for file serial numbers     */
#endif
#ifndef _MODE_T_DEFINED_
 #define _MODE_T_DEFINED_
 typedef unsigned long  mode_t; /* Used for some file attributes    */
#endif
#ifndef _NLINK_T_DEFINED_
 #define _NLINK_T_DEFINED_
 typedef unsigned long  nlink_t;/* Used for link counts             */
#endif
#ifndef _UID_T_DEFINED_
 #define _UID_T_DEFINED_
 typedef long           uid_t;  /* Used for user IDs                */
#endif
#ifndef _GID_T_DEFINED_
 #define _GID_T_DEFINED_
 typedef long           gid_t;  /* Used for group IDs               */
#endif
#ifndef _BLKSIZE_T_DEFINED_
 #define _BLKSIZE_T_DEFINED_
 typedef unsigned long  blksize_t;
#endif
#ifndef _BLKCNT_T_DEFINED_
 #define _BLKCNT_T_DEFINED_
 typedef unsigned long  blkcnt_t;
#endif

struct stat {
    unsigned        st_dev;
    long            st_pad1[3];             /* Reserved for network id */
    ino_t           st_ino;
    mode_t          st_mode;
    nlink_t         st_nlink;
    uid_t           st_uid;
    gid_t           st_gid;
    unsigned        st_rdev;
    long            st_pad2[2];
    off_t           st_size;
    long            st_pad3;
    struct timespec st_atim;
    struct timespec st_mtim;
    struct timespec st_ctim;
    long            st_blksize;
    long            st_blocks;
    long            st_pad4[14];
};

struct stat64 {
    unsigned long       st_dev;
    unsigned long       st_pad0[3];     /* Reserved for st_dev expansion  */
    unsigned long long  st_ino;
    mode_t              st_mode;
    nlink_t             st_nlink;
    uid_t               st_uid;
    gid_t               st_gid;
    unsigned long       st_rdev;
    unsigned long       st_pad1[3];     /* Reserved for st_rdev expansion  */
    long long           st_size;
    struct timespec     st_atim;
    struct timespec     st_mtim;
    struct timespec     st_ctim;
    unsigned long       st_blksize;
    unsigned long       st_pad2;
    long long           st_blocks;
};

/* Tell code we have these members.  */
#define _STATBUF_ST_BLKSIZE
#define _STATBUF_ST_RDEV

#define STAT_HAVE_NSEC 1
