/*
 *  fnmatch.h   POSIX filename pattern matching
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _FNMATCH_H_INCLUDED
#define _FNMATCH_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#define FNM_NOMATCH     1           /* Failed to match. */

#define FNM_NOESCAPE    0x01        /* No backslash escaping. */
#define FNM_PATHNAME    0x02        /* Slash in string only matched by slash in pattern. */
#define FNM_PERIOD      0x04        /* Leading period in string only matched by period in pattern. */

#define FNM_NOSYS       (-1)        /* Reserved, obsolete. */

#if defined( _LINUX_SOURCE ) || !defined( _NO_EXT_KEYS ) /* extensions enabled */
#define FNM_IGNORECASE  0x08        /* Case insensitive matching. */
#define FNM_LEADING_DIR 0x10        /* Ignore final path component. */
#define FNM_CASEFOLD    FNM_IGNORECASE
#define FNM_NOCASE      FNM_IGNORECASE
#endif /* extensions enabled */

#ifdef __cplusplus
extern "C" {
#endif

_WCRTLINK extern int    fnmatch( const char *__pattern, const char *__string, int __flags );

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
