/*
 *  pthread.h   POSIX threads interface
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _PTHREAD_H_INCLUDED
#define _PTHREAD_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifndef _TIME_H_INCLUDED
 #include <time.h>
#endif

#ifndef _SCHED_H_INCLUDED
 #include <sched.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#pragma pack( __push, 4 )

#ifndef _SEM_T_DEFINED_
 #define _SEM_T_DEFINED_
 typedef struct {
     volatile int futex;
     volatile int value;
 } sem_t;
#endif
#ifndef _PTHREAD_T_DEFINED_
 #define _PTHREAD_T_DEFINED_
 typedef pid_t          pthread_t;
#endif
#ifndef _PTHREAD_ATTR_T_DEFINED_
 #define _PTHREAD_ATTR_T_DEFINED_
 typedef struct {
     __w_size_t         stack_size;
     void               *stack_addr;
     int                detached;
     int                sched_policy;
     int                sched_inherit;
     struct sched_param *sched_params;
 } pthread_attr_t;
#endif
#ifndef _PTHREAD_X_DEFINED_
 #define _PTHREAD_X_DEFINED_
 typedef struct {
     sem_t           mutex;
     volatile pid_t  owner;
     int             type;
 } pthread_mutex_t;
 typedef struct {
     int         type;
 } pthread_mutexattr_t;
 typedef struct {
    sem_t           wait_block;
    sem_t           clear_block;
    volatile int    waiters;
 } pthread_cond_t;
 typedef struct pthread_condattr_t pthread_condattr_t;
 typedef int     pthread_key_t;
 typedef struct {
     pthread_mutex_t access;
     int             executed;
 } pthread_once_t;
 typedef struct {
     pthread_mutex_t block_mutex;
     int         read_waiters;
 } pthread_rwlock_t;
 typedef struct pthread_rwlockattr_t pthread_rwlockattr_t;
 typedef struct {
     int         *value;
 } pthread_spinlock_t;
 typedef struct {
     pthread_mutex_t *access;
     pthread_cond_t  *cond;
     unsigned        count;
     unsigned        limit;
 } pthread_barrier_t;
 typedef struct pthread_barrierattr_t pthread_barrierattr_t;
#endif

#define PTHREAD_CANCEL_DISABLE      0
#define PTHREAD_CANCEL_ENABLE       1
#define PTHREAD_CANCEL_DEFERRED     2
#define PTHREAD_CANCEL_ASYNCHRONOUS 4

#define PTHREAD_CREATE_JOINABLE     0
#define PTHREAD_CREATE_DETACHED     1

#define PTHREAD_SCOPE_PROCESS       0
#define PTHREAD_SCOPE_SYSTEM        1

#define PTHREAD_PRIO_NONE           0
#define PTHREAD_PRIO_INHERIT        1
#define PTHREAD_PRIO_PROTECT        2

#define PTHREAD_PROCESS_PRIVATE     0
#define PTHREAD_PROCESS_SHARED      1

#define PTHREAD_MUTEX_NORMAL        0
#define PTHREAD_MUTEX_ERRORCHECK    1
#define PTHREAD_MUTEX_RECURSIVE     2
#define PTHREAD_MUTEX_DEFAULT       1

#define PTHREAD_EXPLICIT_SCHED      0
#define PTHREAD_INHERIT_SCHED       1

#define PTHREAD_BARRIER_SERIAL_THREAD   (-1)

#define PTHREAD_CANCELED            ((void *)1)

/* Creation/destruction */
_WCRTLINK extern int  pthread_create( pthread_t *__thread, const pthread_attr_t *__attr, void *(_WCCALLBACK *__start_routine)(void *), void *__arg );
_WCRTLINK _WCNORETURN extern void pthread_exit( void *__exit_val );

/* Thread cleanup */
_WCRTLINK extern void pthread_cleanup_push( void (_WCCALLBACK *__routine)(void*), void *__arg );
_WCRTLINK extern void pthread_cleanup_pop( int __execute );

/* Mutexes */
_WCRTLINK extern int pthread_mutex_init( pthread_mutex_t *__mutex, const pthread_mutexattr_t *__attr );
_WCRTLINK extern int pthread_mutex_destroy( pthread_mutex_t *__mutex );
_WCRTLINK extern int pthread_mutex_trylock( pthread_mutex_t *__mutex );
_WCRTLINK extern int pthread_mutex_lock( pthread_mutex_t *__mutex );
_WCRTLINK extern int pthread_mutex_unlock( pthread_mutex_t *__mutex );
_WCRTLINK extern int pthread_mutex_setprioceiling( pthread_mutex_t *__mutex, int __prioceiling, int *__old_ceiling );
_WCRTLINK extern int pthread_mutex_getprioceiling( const pthread_mutex_t *__mutex, int *__prioceiling );

/* Thread joining */
_WCRTLINK extern int pthread_join( pthread_t __thread, void **__value_ptr );

/* Thread detach */
_WCRTLINK extern int pthread_detach( pthread_t __thread );

/* Self */
_WCRTLINK extern pthread_t pthread_self( void );

/* Cancellation */
_WCRTLINK extern int pthread_cancel( pthread_t __thread );
_WCRTLINK extern int pthread_setcancelstate( int __state, int *__oldstate );
_WCRTLINK extern int pthread_setcanceltype( int __type, int *__oldtype );
_WCRTLINK extern void pthread_testcancel( void );

/* Equality */
_WCRTLINK extern int pthread_equal( pthread_t __pt1, pthread_t __pt2 );

/* Conditions */
_WCRTLINK extern int pthread_cond_init( pthread_cond_t *__cond, const pthread_condattr_t *__attr );
_WCRTLINK extern int pthread_cond_destroy( pthread_cond_t *__cond );
_WCRTLINK extern int pthread_cond_signal( pthread_cond_t *__cond );
_WCRTLINK extern int pthread_cond_broadcast( pthread_cond_t *__cond );
_WCRTLINK extern int pthread_cond_wait( pthread_cond_t *__cond, pthread_mutex_t *__mutex );
_WCRTLINK extern int pthread_cond_timedwait( pthread_cond_t *__cond, pthread_mutex_t *__mutex, const struct timespec *__abstime );

/* Thread-specific keys */
_WCRTLINK extern int pthread_key_create( pthread_key_t *__key, void (_WCCALLBACK *__destructor)(void*) );
_WCRTLINK extern int pthread_key_delete(pthread_key_t __key);
_WCRTLINK extern int pthread_setspecific(pthread_key_t __key, void *__value);
_WCRTLINK extern void *pthread_getspecific(pthread_key_t __key);

/* Read-Write locks */
_WCRTLINK extern int pthread_rwlock_init( pthread_rwlock_t *__rwlock, const pthread_rwlockattr_t *__attr );
_WCRTLINK extern int pthread_rwlock_destroy( pthread_rwlock_t *__rwlock );
_WCRTLINK extern int pthread_rwlock_unlock( pthread_rwlock_t *__rwlock );
_WCRTLINK extern int pthread_rwlock_tryrdlock( pthread_rwlock_t *__rwlock );
_WCRTLINK extern int pthread_rwlock_rdlock( pthread_rwlock_t *__rwlock );
_WCRTLINK extern int pthread_rwlock_trywrlock( pthread_rwlock_t *__rwlock );
_WCRTLINK extern int pthread_rwlock_wrlock( pthread_rwlock_t *__rwlock );

/* Barriers */
_WCRTLINK extern int pthread_barrier_init( pthread_barrier_t *__barrier,
                                           const pthread_barrierattr_t *__attr,
                                           unsigned __count );
_WCRTLINK extern int pthread_barrier_destroy( pthread_barrier_t *__barrier );
_WCRTLINK extern int pthread_barrier_wait( pthread_barrier_t *__barrier );

/* Thread concurrency */
_WCRTLINK extern int pthread_getconcurrency(void);
_WCRTLINK extern int pthread_setconcurrency(int __new_level);

/* Scheduling */
_WCRTLINK extern int pthread_getschedparam( pthread_t __thr, int *__policy, struct sched_param *__param );
_WCRTLINK extern int pthread_setschedparam( pthread_t __thr, int __policy, const struct sched_param *__param );

/* Spin locks (Linux only due to use of atomic ops) */
_WCRTLINK extern int pthread_spin_init( pthread_spinlock_t *__lock, int __ignored_pshared );
_WCRTLINK extern int pthread_spin_destroy( pthread_spinlock_t *__lock );
_WCRTLINK extern int pthread_spin_lock( pthread_spinlock_t *__lock );
_WCRTLINK extern int pthread_spin_trylock( pthread_spinlock_t *__lock );
_WCRTLINK extern int pthread_spin_unlock( pthread_spinlock_t *__lock );

/* Thread Attributes */
_WCRTLINK extern int pthread_attr_init( pthread_attr_t *__attr );
_WCRTLINK extern int pthread_attr_destroy( pthread_attr_t *__attr );
_WCRTLINK extern int pthread_attr_setdetachstate( pthread_attr_t *__attr, int __detachstate );
_WCRTLINK extern int pthread_attr_getdetachstate( const pthread_attr_t *__attr, int *__detachstate );
_WCRTLINK extern int pthread_attr_getguardsize( const pthread_attr_t *__attr, size_t *__guardsize );
_WCRTLINK extern int pthread_attr_setguardsize (pthread_attr_t *__attr, size_t __guardsize );
_WCRTLINK extern int pthread_attr_setinheritsched( pthread_attr_t *__attr, int __inheritsched );
_WCRTLINK extern int pthread_attr_getinheritsched( const pthread_attr_t *__attr, int *__inheritsched );
_WCRTLINK extern int pthread_attr_setschedpolicy( pthread_attr_t *__attr, int __policy );
_WCRTLINK extern int pthread_attr_getschedpolicy( const pthread_attr_t *__attr, int *__policy );
_WCRTLINK extern int pthread_attr_setschedparam( pthread_attr_t *__attr, const struct sched_param *__params );
_WCRTLINK extern int pthread_attr_getschedparam( const pthread_attr_t *__attr, struct sched_param *__params );
_WCRTLINK extern int pthread_attr_setscope( pthread_attr_t *__attr, int __contentionscope );
_WCRTLINK extern int pthread_attr_getscope( const pthread_attr_t *__attr, int *__contentionscope );
_WCRTLINK extern int pthread_attr_setstackaddr( pthread_attr_t *__attr, void *__stackaddr );
_WCRTLINK extern int pthread_attr_getstackaddr( const pthread_attr_t *__attr, void **__stackaddr );
_WCRTLINK extern int pthread_attr_setstacksize( pthread_attr_t *__attr, size_t __stacksize );
_WCRTLINK extern int pthread_attr_getstacksize( const pthread_attr_t *__attr, size_t *__stacksize );
_WCRTLINK extern int pthread_attr_setstack( pthread_attr_t *__attr, void *__stackaddr, size_t __stacksize );
_WCRTLINK extern int pthread_attr_getstack( const pthread_attr_t *__attr, void **__stackaddr, size_t *__stacksize );

/* Mutex attributes */
_WCRTLINK extern int pthread_mutexattr_init( pthread_mutexattr_t *__attr );
_WCRTLINK extern int pthread_mutexattr_destroy( pthread_mutexattr_t *__attr );
_WCRTLINK extern int pthread_mutexattr_setprioceiling( pthread_mutexattr_t *__attr, int __prioceiling );
_WCRTLINK extern int pthread_mutexattr_getprioceiling( const pthread_mutexattr_t *__attr, int *__prioceiling );
_WCRTLINK extern int pthread_mutexattr_setprotocol( pthread_mutexattr_t *__attr, int __protocol );
_WCRTLINK extern int pthread_mutexattr_getprotocol( const pthread_mutexattr_t *__attr, int *__protocol );
_WCRTLINK extern int pthread_mutexattr_getpshared( const pthread_mutexattr_t *__attr, int *__pshared );
_WCRTLINK extern int pthread_mutexattr_setpshared( pthread_mutexattr_t *__attr, int __pshared );
_WCRTLINK extern int pthread_mutexattr_gettype( const pthread_mutexattr_t *__attr, int *__type );
_WCRTLINK extern int pthread_mutexattr_settype( pthread_mutexattr_t *__attr, int __type );

/* Barrier attributes */
_WCRTLINK extern int pthread_barrierattr_init( pthread_barrierattr_t *__attr );
_WCRTLINK extern int pthread_barrierattr_destroy( pthread_barrierattr_t *__attr );
_WCRTLINK extern int pthread_barrierattr_getpshared( const pthread_barrierattr_t *__attr, int *__pshared );
_WCRTLINK extern int pthread_barrierattr_setpshared( pthread_barrierattr_t *__attr, int __pshared );

/* Condition attributes */
_WCRTLINK extern int pthread_condattr_init( pthread_condattr_t *__attr );
_WCRTLINK extern int pthread_condattr_destroy( pthread_condattr_t *__attr );
_WCRTLINK extern int pthread_condattr_getpshared( const pthread_condattr_t *__attr, int *__pshared );
_WCRTLINK extern int pthread_condattr_setpshared( pthread_condattr_t *__attr, int __pshared );
_WCRTLINK extern int pthread_condattr_getclock( pthread_condattr_t *__attr, clockid_t *__clk );
_WCRTLINK extern int pthread_condattr_setclock( pthread_condattr_t *__attr, clockid_t __clk );

/* Read-write lock attributes */
_WCRTLINK extern int pthread_rwlockattr_init( pthread_rwlockattr_t *__attr );
_WCRTLINK extern int pthread_rwlockattr_destroy( pthread_rwlockattr_t *__attr );
_WCRTLINK extern int pthread_rwlockattr_getpshared( const pthread_rwlockattr_t *__attr, int *__pshared );
_WCRTLINK extern int pthread_rwlockattr_setpshared( pthread_rwlockattr_t *__attr, int __pshared );

/* Execute-once routine */
_WCRTLINK extern int pthread_once( pthread_once_t *__once_control, void (_WCCALLBACK *__init_routine)(void) );

/* Obsolescent routines, not implemented */
_WCRTLINK extern int pthread_atfork(void (_WCCALLBACK *__prepare)(void), void (_WCCALLBACK *__parent)(void),
                                    void(_WCCALLBACK *__child)(void));

/* Initializers */
#define PTHREAD_MUTEX_INITIALIZER   { { 1, 1 }, (pid_t)(-1), PTHREAD_MUTEX_DEFAULT }
#define PTHREAD_COND_INITIALIZER    { { 1, 0 }, { 1, 1 }, 0 }
#define PTHREAD_ONCE_INIT           { PTHREAD_MUTEX_INITIALIZER, 0 }
#define PTHREAD_RWLOCK_INITIALIZER  { PTHREAD_MUTEX_INITIALIZER, 0 }

#pragma pack( __pop )

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* !_PTHREAD_H_INCLUDED */
