/*
 *  sched.h
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _SCHED_H_INCLUDED
#define _SCHED_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* 
 *  ISO C types
 */
#ifdef __cplusplus
 #ifndef _STDTIME_T_DEFINED
 #define _STDTIME_T_DEFINED
  namespace std {
    typedef signed long time_t;
  }
  typedef std::time_t __w_time_t;
 #endif
 #ifndef _TIME_T_DEFINED
 #define _TIME_T_DEFINED
  #define _TIME_T_DEFINED_
  using std::time_t;
 #endif
#else  /* __cplusplus not defined */
 #ifndef _TIME_T_DEFINED
 #define _TIME_T_DEFINED
  #define _TIME_T_DEFINED_
  typedef signed long time_t;
  typedef time_t __w_time_t;
 #endif
#endif /* __cplusplus not defined */

/* 
 *  POSIX 1003.1 types
 */
#ifndef _PID_T_DEFINED_
 #define _PID_T_DEFINED_
 typedef int            pid_t;  /* Used for process IDs & group IDs */
#endif

#ifndef _TIMESPEC_DEFINED
 #define _TIMESPEC_DEFINED
 struct timespec {
     __w_time_t tv_sec;
     long       tv_nsec;
 };
#endif /* _TIMESPEC_DEFINED */

#ifndef SCHED_PARAM_DEFINED
 #define SCHED_PARAM_DEFINED
 struct sched_param {
     int sched_priority;
 };
#endif /* SCHED_PARAM_DEFINED */

/* Scheduling policies per the Linux kernel */
#define SCHED_NORMAL            0
#define SCHED_FIFO              1
#define SCHED_RR                2
#define SCHED_BATCH             3
#define SCHED_IDLE              5
#define SCHED_DEADLINE          6

/* Flags for clone() on Linux*/
#define CSIGNAL                 0x000000ff  /* signal mask to be sent at exit */
#define CLONE_VM                0x00000100  /* set if VM shared between processes */
#define CLONE_FS                0x00000200  /* set if fs info shared between processes */
#define CLONE_FILES             0x00000400  /* set if open files shared between processes */
#define CLONE_SIGHAND           0x00000800  /* set if signal handlers and blocked signals shared */
#define CLONE_PTRACE            0x00002000  /* set if we want to let tracing continue on the child too */
#define CLONE_VFORK             0x00004000  /* set if the parent wants the child to wake it up on mm_release */
#define CLONE_PARENT            0x00008000  /* set if we want to have the same parent as the cloner */
#define CLONE_THREAD            0x00010000  /* Same thread group? */
#define CLONE_NEWNS             0x00020000  /* New mount namespace group */
#define CLONE_SYSVSEM           0x00040000  /* share system V SEM_UNDO semantics */
#define CLONE_SETTLS            0x00080000  /* create a new TLS for the child */
#define CLONE_PARENT_SETTID     0x00100000  /* set the TID in the parent */
#define CLONE_CHILD_CLEARTID    0x00200000  /* clear the TID in the child */
#define CLONE_UNTRACED          0x00800000  /* set if the tracing process can't force CLONE_PTRACE on this clone */
#define CLONE_CHILD_SETTID      0x01000000  /* set the TID in the child */
#define CLONE_NEWUTS            0x04000000  /* New utsname namespace */
#define CLONE_NEWIPC            0x08000000  /* New ipc namespace */
#define CLONE_NEWUSER           0x10000000  /* New user namespace */
#define CLONE_NEWPID            0x20000000  /* New pid namespace */
#define CLONE_NEWNET            0x40000000  /* New network namespace */
#define CLONE_IO                0x80000000  /* Clone io context */

/* For GNU compatibility, define SCHED_OTHER to be
 * simply SCHED_NORMAL
 */
#define SCHED_OTHER     SCHED_NORMAL

_WCRTLINK extern int    sched_yield( void );

_WCRTLINK extern int    sched_get_priority_max( int __policy );
_WCRTLINK extern int    sched_get_priority_min( int __policy );

_WCRTLINK extern int    sched_getscheduler( pid_t __pid );
_WCRTLINK extern int    sched_setscheduler( pid_t __pid, int __policy, const struct sched_param *__sp );

_WCRTLINK extern int    sched_getparam( pid_t __pid, struct sched_param *__sp );
_WCRTLINK extern int    sched_setparam( pid_t __pid, const struct sched_param *__sp );

_WCRTLINK extern int    sched_rr_get_interval( pid_t __pid, struct timespec *__ts );

_WCRTLINK extern pid_t  clone( int (_WCCALLBACK *__fn)(void *), void *__child_stack, int __flags, void *__args, ... );

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
