/*
 *  sys/statvfs.h
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _SYS_STATVFS_H_INCLUDED
#define _SYS_STATVFS_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#pragma pack( __push, 4 )

#ifndef _FSTYPES_DEFINED_
#define _FSTYPES_DEFINED_
typedef unsigned long   fsblkcnt_t;
typedef unsigned long   fsfilcnt_t;
#endif

struct statvfs {
    unsigned long       f_bsize;
    unsigned long       f_frsize;
    fsblkcnt_t          f_blocks;
    fsblkcnt_t          f_bfree;
    fsblkcnt_t          f_bavail;
    fsfilcnt_t          f_files;
    fsfilcnt_t          f_ffree;
    fsfilcnt_t          f_favail;
    unsigned long       f_fsid;
    unsigned long       f_flag;
    unsigned long       f_namemax;
};

#if defined( _LINUX_SOURCE ) || !defined( _NO_EXT_KEYS ) /* extensions enabled */
struct statvfs64 {
    unsigned long       f_bsize;
    unsigned long       f_frsize;
    unsigned long long  f_blocks;
    unsigned long long  f_bfree;
    unsigned long long  f_bavail;
    unsigned long long  f_files;
    unsigned long long  f_ffree;
    unsigned long long  f_favail;
    unsigned long       f_fsid;
    unsigned long       f_flag;
    unsigned long       f_namemax;
};
#endif /* extensions enabled */

#define ST_RDONLY   0x0001  /* read-only file system */
#define ST_NOSUID   0x0002  /* ignore suid and sgid file bits */

_WCRTLINK extern int statvfs( const char *restrict __filename, struct statvfs *restrict __statvfs );
_WCRTLINK extern int fstatvfs( int __fh, struct statvfs *__statvfs );

#if defined( _LINUX_SOURCE ) || !defined( _NO_EXT_KEYS ) /* extensions enabled */
_WCRTLINK extern int statvfs64( const char *restrict __filename, struct statvfs64 *restrict __statvfs );
_WCRTLINK extern int fstatvfs64( int __fh, struct statvfs64 *__statvfs );
#endif /* extensions enabled */

#pragma pack( __pop )

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* !_SYS_STATVFS_H_INCLUDED */
