/*
 *  sys/types.h Defined system types
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _SYS_TYPES_H_INCLUDED
#define _SYS_TYPES_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifndef _ARCH_DIR
 #ifdef __386__
  #define _ARCH_DIR i386
 #elif defined(__MIPS__)
  #define _ARCH_DIR mips
 #elif defined(__PPC__)
  #define _ARCH_DIR ppc
 #else
  #error unknown platform
  #define _ARCH_DIR
 #endif
 #define _ARCH_INCLUDE(hdr) <arch/ ## _ARCH_DIR ## / ## hdr ## >
#endif /* !_ARCH_DIR */

#ifndef _LIMITS_H_INCLUDED
 #include <limits.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#pragma pack( __push, 8 )

/* 
 *  ISO C types
 */
#ifdef __cplusplus
 #ifndef _STDTIME_T_DEFINED
 #define _STDTIME_T_DEFINED
  namespace std {
    typedef signed long time_t;
  }
  typedef std::time_t __w_time_t;
 #endif
 #ifndef _TIME_T_DEFINED
 #define _TIME_T_DEFINED
  #define _TIME_T_DEFINED_
  using std::time_t;
 #endif
#else  /* __cplusplus not defined */
 #ifndef _TIME_T_DEFINED
 #define _TIME_T_DEFINED
  #define _TIME_T_DEFINED_
  typedef signed long time_t;
  typedef time_t __w_time_t;
 #endif
#endif /* __cplusplus not defined */
#ifdef __cplusplus
 #ifndef _STDSIZE_T_DEFINED
 #define _STDSIZE_T_DEFINED
  namespace std {
    typedef unsigned size_t;
  }
  typedef std::size_t __w_size_t;
 #endif
 #ifndef _SIZE_T_DEFINED
 #define _SIZE_T_DEFINED
  #define _SIZE_T_DEFINED_
  using std::size_t;
 #endif
#else  /* __cplusplus not defined */
 #ifndef _SIZE_T_DEFINED
 #define _SIZE_T_DEFINED
  #define _SIZE_T_DEFINED_
  typedef unsigned size_t;
  typedef size_t   __w_size_t;
 #endif
#endif /* __cplusplus not defined */
/* Exact-width types. */
#ifndef _EXACT_WIDTH_INTS
 #define _EXACT_WIDTH_INTS
 typedef signed char         int8_t;
 typedef unsigned char       uint8_t;
 typedef short               int16_t;
 typedef unsigned short      uint16_t;
 typedef int                 int32_t;
 typedef unsigned int        uint32_t;
 typedef long long           int64_t;
 typedef unsigned long long  uint64_t;
#endif /* _EXACT_WIDTH_INTS */

/*
 *  POSIX 1003.1 types
 */
#ifndef _SSIZE_T_DEFINED_
 #define _SSIZE_T_DEFINED_
 typedef signed         ssize_t;
#endif
#ifndef _PID_T_DEFINED_
 #define _PID_T_DEFINED_
 typedef int            pid_t;  /* Used for process IDs & group IDs */
#endif
#ifndef _OFF_T_DEFINED_
 #define _OFF_T_DEFINED_
 typedef long           off_t;  /* Used for file sizes, offsets     */
#endif
#ifndef _TIMER_T_DEFINED_
 #define _TIMER_T_DEFINED_
 typedef int            timer_t;
#endif
#ifndef _CLOCKID_T_DEFINED_
 #define _CLOCKID_T_DEFINED_
 typedef int            clockid_t;
#endif
#ifndef SCHED_PARAM_DEFINED
 #define SCHED_PARAM_DEFINED
 struct sched_param {
     int sched_priority;
 };
#endif /* SCHED_PARAM_DEFINED */
typedef long    suseconds_t;
#ifndef _SEM_T_DEFINED_
 #define _SEM_T_DEFINED_
 typedef struct {
     volatile int futex;
     volatile int value;
 } sem_t;
#endif
#ifndef _PTHREAD_T_DEFINED_
 #define _PTHREAD_T_DEFINED_
 typedef pid_t          pthread_t;
#endif
#ifndef _PTHREAD_ATTR_T_DEFINED_
 #define _PTHREAD_ATTR_T_DEFINED_
 typedef struct {
     __w_size_t         stack_size;
     void               *stack_addr;
     int                detached;
     int                sched_policy;
     int                sched_inherit;
     struct sched_param *sched_params;
 } pthread_attr_t;
#endif
#ifndef _PTHREAD_X_DEFINED_
 #define _PTHREAD_X_DEFINED_
 typedef struct {
     sem_t           mutex;
     volatile pid_t  owner;
     int             type;
 } pthread_mutex_t;
 typedef struct {
     int         type;
 } pthread_mutexattr_t;
 typedef struct {
    sem_t           wait_block;
    sem_t           clear_block;
    volatile int    waiters;
 } pthread_cond_t;
 typedef struct pthread_condattr_t pthread_condattr_t;
 typedef int     pthread_key_t;
 typedef struct {
     pthread_mutex_t access;
     int             executed;
 } pthread_once_t;
 typedef struct {
     pthread_mutex_t block_mutex;
     int         read_waiters;
 } pthread_rwlock_t;
 typedef struct pthread_rwlockattr_t pthread_rwlockattr_t;
 typedef struct {
     int         *value;
 } pthread_spinlock_t;
 typedef struct {
     pthread_mutex_t *access;
     pthread_cond_t  *cond;
     unsigned        count;
     unsigned        limit;
 } pthread_barrier_t;
 typedef struct pthread_barrierattr_t pthread_barrierattr_t;
#endif

#include _ARCH_INCLUDE(sys/types.h)
#include _ARCH_INCLUDE(sys/sysmacros.h)

typedef unsigned char   u_char;
typedef unsigned short  u_short;
typedef unsigned int    u_int;
typedef unsigned long   u_long;
typedef unsigned long long u_quad_t;
typedef long long       quad_t;
typedef quad_t          *qaddr_t;
typedef int             key_t;
#if defined( _LINUX_SOURCE ) || !defined( _NO_EXT_KEYS ) /* extensions enabled */
#ifndef _LOFF_T_DEFINED_
 #define _LOFF_T_DEFINED_
 typedef __int64        loff_t; /* Used for large file sizes, offsets     */
#endif
#ifndef _OFF64_T_DEFINED_
 #define _OFF64_T_DEFINED_
 typedef long long      off64_t;    /* Used for file sizes, offsets     */
#endif
#ifndef _FSTYPES_DEFINED_
#define _FSTYPES_DEFINED_
typedef unsigned long   fsblkcnt_t;
typedef unsigned long   fsfilcnt_t;
#endif
#endif /* extensions enabled */

#pragma pack( __pop )

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
