/*
 *  termios.h
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _TERMIOS_H_INCLUDED
#define _TERMIOS_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifndef _ARCH_DIR
 #ifdef __386__
  #define _ARCH_DIR i386
 #elif defined(__MIPS__)
  #define _ARCH_DIR mips
 #elif defined(__PPC__)
  #define _ARCH_DIR ppc
 #else
  #error unknown platform
  #define _ARCH_DIR
 #endif
 #define _ARCH_INCLUDE(hdr) <arch/ ## _ARCH_DIR ## / ## hdr ## >
#endif /* !_ARCH_DIR */

#ifndef _TIME_H_INCLUDED
 #include <time.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#pragma pack( __push, 4 )

#ifndef _PID_T_DEFINED_
 #define _PID_T_DEFINED_
 typedef int            pid_t;  /* Used for process IDs & group IDs */
#endif

/*
 * Input modes (c_iflag)
 */
#define IGNBRK      0x0001
#define BRKINT      0x0002
#define IGNPAR      0x0004
#define PARMRK      0x0008
#define INPCK       0x0010
#define ISTRIP      0x0020
#define INLCR       0x0040
#define IGNCR       0x0080
#define ICRNL       0x0100
#define IXANY       0x0800
#define IMAXBEL     0x2000
#define IUTF8       0x4000

/*
 * Ouput Modes (c_oflag)
 */
#define OPOST       0x0001
#define OCRNL       0x0008
#define ONOCR       0x0010
#define ONLRET      0x0020
#define OFILL       0x0040
#define OFDEL       0x0080

/*
 * Attributes (c_cflag), Baud rates
 */
#define B0          0x0000
#define B50         0x0001
#define B75         0x0002
#define B110        0x0003
#define B134        0x0004
#define B150        0x0005
#define B200        0x0006
#define B300        0x0007
#define B600        0x0008
#define B1200       0x0009
#define B1800       0x000A
#define B2400       0x000B
#define B4800       0x000C
#define B9600       0x000D
#define B19200      0x000E
#define B38400      0x000F
#define EXTA        B19200
#define EXTB        B38400

#define IBSHIFT     16

/*
 * Actions for tcflow()
 */
#define TCOOFF      0
#define TCOON       1
#define TCIOFF      2
#define TCION       3

/*
 * queue_selectors for tcflush()
 */
#define TCIFLUSH    0
#define TCOFLUSH    1
#define TCIOFLUSH   2

/*
 * Optional Actions for tcsetattr()
 */
#define TCSANOW     0
#define TCSADRAIN   1
#define TCSAFLUSH   2

typedef unsigned char   cc_t;
typedef unsigned int    speed_t;
typedef unsigned int    tcflag_t;

#include _ARCH_INCLUDE(termios.h)

_WCRTLINK extern speed_t cfgetispeed( const struct termios *__termios_p );
_WCRTLINK extern speed_t cfgetospeed( const struct termios *__termios_p );
_WCRTLINK extern int     cfsetispeed( struct termios *__termios_p, speed_t __speed );
_WCRTLINK extern int     cfsetospeed( struct termios *__termios_p, speed_t __speed );
_WCRTLINK extern int     tcgetattr( int __fd, struct termios *__termios_p );
_WCRTLINK extern int     tcsetattr( int __fd, int __optional_actions, const struct termios *__termios_p );
_WCRTLINK extern void    cfmakeraw( struct termios *__termios_p );
_WCRTLINK extern int     tcsendbreak( int __fd, int __duration );
_WCRTLINK extern int     tcdrain( int __fd );
_WCRTLINK extern int     tcflush( int __fd, int __queue_selector );
_WCRTLINK extern int     tcflow( int __fd, int __action );
_WCRTLINK extern pid_t   tcgetsid( int __fildes );

#pragma pack( __pop )

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* !_TERMIOS_H_INCLUDED */
