/***************************************************************************
 * FILE: signal.h/csignal (Signal definitions)
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 *
 * Description: This header is part of the C/C++ standard library. It
 *              declares facilities for handling signals in programs.
 ***************************************************************************/
#ifndef _SIGNAL_H_INCLUDED
#define _SIGNAL_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifdef __cplusplus

#include <csignal>

// C99 types in signal.h.
using std::sig_atomic_t;

// C99 functions in signal.h.
using std::signal;
using std::raise;

#else /* __cplusplus not defined */

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#pragma pack( __push, 1 )

/* 
 *  ISO C types
 */
 #ifndef _TIME_T_DEFINED
 #define _TIME_T_DEFINED
  #define _TIME_T_DEFINED_
  typedef unsigned long time_t;
  typedef time_t __w_time_t;
 #endif

/* 
 *  POSIX 1003.1 types
 */
#ifndef _UID_T_DEFINED_
 #define _UID_T_DEFINED_
 typedef long           uid_t;  /* user identifier */
#endif
#ifndef _PID_T_DEFINED_
 #define _PID_T_DEFINED_
 typedef int            pid_t;  /* Used for process IDs & group IDs */
#endif

typedef int sig_atomic_t;

typedef void (_WCCALLBACK *__sig_func)( int );

#if !defined( _NO_EXT_KEYS ) /* extensions enabled */
typedef void _WCCALLBACK __sigfpe_func( int, int );
#endif /* extensions enabled */


#if defined( _POSIX_SOURCE ) || !defined( _NO_EXT_KEYS ) /* extensions enabled */

union sigval {
    int     sival_int;
    void    *sival_ptr;
};

#define SIGEV_NONE      1
#define SIGEV_THREAD    2

struct sigevent {
    int          sigev_signo;
    union sigval sigev_value;
    int          sigev_notify;
};
struct msigevent {
    long         sigev_signo;
    union sigval sigev_value;
    int          sigev_notify;
};

#endif /* extensions enabled */

#define SIG_IGN         ((__sig_func)1)
#define SIG_DFL         ((__sig_func)2)
#define SIG_ERR         ((__sig_func)3)

#define SIGABRT  1
#define SIGFPE   2
#define SIGILL   3
#define SIGINT   4
#define SIGSEGV  5
#define SIGTERM  6
#define SIGBREAK 7
#define SIGUSR1  8
#define SIGUSR2  9
#define SIGUSR3  10
#define SIGIDIVZ 11
#define SIGIOVFL 12

#define _SIGMAX  12
#define _SIGMIN  1

_WCRTLINK extern int  raise( int __sig );
_WCRTLINK extern void (_WCCALLBACK *signal( int __sig, void (_WCCALLBACK *__func)(int) ) )(int);

#pragma pack( __pop )

#endif /* __cplusplus not defined */

#endif
