/*
 *  sys/socket.h      Socket functions
 *
 * =========================================================================
 *
 *                          Open Watcom Project
 *
 * Copyright (c) 2004-2025 The Open Watcom Contributors. All Rights Reserved.
 * Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _SYS_SOCKET_H_INCLUDED
#define _SYS_SOCKET_H_INCLUDED

#ifndef _ENABLE_AUTODEPEND
 #pragma read_only_file
#endif

#ifndef __COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifndef _UNISTD_H_INCLUDED
 #include <unistd.h>
#endif

#ifndef _SA_FAMILY_T_DEFINED_
#define _SA_FAMILY_T_DEFINED_
typedef unsigned short sa_family_t;
#endif

struct sockaddr {
    sa_family_t sa_family;
    char sa_data[14];
};

struct linger {
    int l_onoff;
    int l_linger;
};

/* Supported address families. */
#define AF_UNSPEC       0
#define AF_INET         2       /* Internet IP Protocol         */
#define AF_MAX          32      /* For now.. */


/* Protocol families, same as address families. */
#define PF_UNSPEC       AF_UNSPEC
#define PF_INET         AF_INET
#define PF_MAX          AF_MAX



#define SOCK_STREAM     1
#define SOCK_DGRAM      2
#define SOCK_MAX        (SOCK_DGRAM+1)

#define SOL_SOCKET      1

#define SO_ERROR        1
#define SO_REUSEADDR    2
#define SO_TYPE         3
#define SO_KEEPALIVE    9

/* Flags for send(2) and recv(2) */
#define MSG_PEEK        0x2

#define SOMAXCONN 1024

/* Cmds for ioctlsocket() */

#define FIONBIO         0x1



typedef unsigned int socklen_t;

_WCRTLINK extern int socket( int __domain, int __type, int __protocol );
_WCRTLINK extern int bind( int __sockfd, const struct sockaddr *__my_addr, socklen_t __addrlen );
_WCRTLINK extern int getsockopt( int __s, int __level, int __optname, void *__optval, socklen_t *__optlen );
_WCRTLINK extern int setsockopt( int __s, int __level, int __optname, const void *__optval, socklen_t __optlen );
_WCRTLINK extern int recv(int __s, void *__buf, size_t __len, int __flags);
_WCRTLINK extern int recvfrom(int __s, void *__buf, size_t __len, int __flags, struct sockaddr *__from, socklen_t *__fromlen);
_WCRTLINK extern int recvmsg(int s, struct msghdr *__msg, int __flags);
_WCRTLINK extern int send( int __s, const void *__msg, size_t __len, int __flags );
_WCRTLINK extern int sendto( int __s, const void *__msg, size_t __len, int __flags, const struct sockaddr *__to, socklen_t __tolen );
_WCRTLINK extern int sendmsg( int __s, const struct msghdr *__msg, int __flags );
_WCRTLINK extern int accept( int __s, struct sockaddr *__addr, socklen_t *__addrlen );
_WCRTLINK extern int listen( int __s, int __backlog );
_WCRTLINK extern int getpeername( int __s, struct sockaddr *__name, socklen_t *__namelen );
_WCRTLINK extern int getsockname( int __s , struct sockaddr *__name, socklen_t *__namelen );
_WCRTLINK extern int connect( int __sockfd, const struct sockaddr *__serv_addr, socklen_t __addrlen );
_WCRTLINK extern int shutdown( int __s, int __how );

_WCRTLINK extern int ioctlsocket (int s, long cmd, char *argp);


#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* !_SYS_SOCKET_H_INCLUDED */
