#!/usr/bin/env node
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var import_node_dns = __toESM(require("node:dns"), 1);
var import_ws = __toESM(require("ws"), 1);
var import_const = require("../lib/const.js");
var import_parse_args = require("../util/parse-args.js");
import_node_dns.default.setDefaultResultOrder("ipv4first");
const args = (0, import_parse_args.parseArgs)(["_", "dump", "node", "schemaVersion"]);
const schemaVersion = args.schemaVersion ? Number(args.schemaVersion) : import_const.maxSchemaVersion;
const url = args._[0] || "ws://localhost:3000";
const filterNode = args.node ? Number(args.node) : void 0;
if (isNaN(schemaVersion) || schemaVersion > import_const.maxSchemaVersion || schemaVersion < 0) {
  console.log("Schema version must be between 0 and ", import_const.maxSchemaVersion);
  process.exit();
}
if (!args.dump) {
  console.info("Connecting to", url);
}
const socket = new import_ws.default(url);
socket.on("open", /* @__PURE__ */ __name(function open() {
  socket.send(JSON.stringify({
    messageId: "api-schema-id",
    command: "set_api_schema",
    schemaVersion
  }));
  socket.send(JSON.stringify({
    messageId: "start-listening-result",
    command: "start_listening"
  }));
}, "open"));
socket.on("message", (data) => {
  const msg = JSON.parse(data.toString());
  if (filterNode) {
    if (msg.type !== "result" && msg.type !== "event") {
      return;
    }
    if (msg.type === "result" && msg.messageId === "start-listening-result" && msg.success) {
      const state = msg.result.state;
      const nodes = state.nodes.filter((node) => node.nodeId === filterNode);
      if (nodes.length !== 1) {
        console.error("Unable to find node", filterNode);
        process.exit(1);
      }
      state.nodes = nodes;
    } else if (msg.type === "event" && msg.event.nodeId !== filterNode) {
      return;
    }
  }
  if (args.dump) {
    console.log(JSON.stringify(msg));
  } else {
    console.dir(msg);
  }
});
let closing = false;
const handleShutdown = /* @__PURE__ */ __name(() => {
  if (closing) {
    process.exit();
  }
  closing = true;
  if (!args.dump) {
    console.log("Shutting down");
  }
  socket.close();
  process.exit();
}, "handleShutdown");
process.on("SIGINT", handleShutdown);
process.on("SIGTERM", handleShutdown);
//# sourceMappingURL=client.js.map
