"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var message_handler_exports = {};
__export(message_handler_exports, {
  ControllerMessageHandler: () => ControllerMessageHandler
});
module.exports = __toCommonJS(message_handler_exports);
var import_zwave_js = require("zwave-js");
var import_error = require("../error.js");
var import_command = require("./command.js");
var import_common = require("../common.js");
var import_inclusion_user_callbacks = require("../inclusion_user_callbacks.js");
var import_state = require("../state.js");
class ControllerMessageHandler {
  static {
    __name(this, "ControllerMessageHandler");
  }
  clientsController;
  driver;
  client;
  constructor(clientsController, driver, client) {
    this.clientsController = clientsController;
    this.driver = driver;
    this.client = client;
  }
  async handle(message) {
    const { command } = message;
    switch (message.command) {
      case import_command.ControllerCommand.beginInclusion: {
        if (this.clientsController.grantSecurityClassesPromise || this.clientsController.validateDSKAndEnterPinPromise)
          throw new import_error.InclusionAlreadyInProgressError();
        const success = await this.driver.controller.beginInclusion(await processInclusionOptions(this.clientsController, this.client, message));
        return { success };
      }
      case import_command.ControllerCommand.grantSecurityClasses: {
        if (!this.clientsController.grantSecurityClassesPromise)
          throw new import_error.InclusionPhaseNotInProgressError("grantSecurityClassesPromise");
        this.clientsController.grantSecurityClassesPromise.resolve(message.inclusionGrant);
        return {};
      }
      case import_command.ControllerCommand.validateDSKAndEnterPIN: {
        if (!this.clientsController.validateDSKAndEnterPinPromise)
          throw new import_error.InclusionPhaseNotInProgressError("validateDSKAndEnterPinPromise");
        this.clientsController.validateDSKAndEnterPinPromise.resolve(message.pin);
        return {};
      }
      case import_command.ControllerCommand.provisionSmartStartNode: {
        if (typeof message.entry === "string") {
          this.driver.controller.provisionSmartStartNode(await (0, import_zwave_js.parseQRCodeString)(message.entry));
        } else {
          this.driver.controller.provisionSmartStartNode(message.entry);
        }
        return {};
      }
      case import_command.ControllerCommand.unprovisionSmartStartNode: {
        this.driver.controller.unprovisionSmartStartNode(message.dskOrNodeId);
        return {};
      }
      case import_command.ControllerCommand.getProvisioningEntry: {
        const dskOrNodeId = message.dskOrNodeId || message.dsk;
        if (!dskOrNodeId) {
          throw new import_error.InvalidParamsPassedToCommandError("Must include one of dsk or dskOrNodeId in call to getProvisioningEntry");
        }
        const entry = this.driver.controller.getProvisioningEntry(dskOrNodeId);
        return { entry };
      }
      case import_command.ControllerCommand.getProvisioningEntries: {
        const entries = this.driver.controller.getProvisioningEntries();
        return { entries };
      }
      case import_command.ControllerCommand.stopInclusion: {
        const success = await this.driver.controller.stopInclusion();
        return { success };
      }
      case import_command.ControllerCommand.cancelSecureBootstrapS2: {
        this.driver.controller.cancelSecureBootstrapS2(message.reason);
        return {};
      }
      case import_command.ControllerCommand.beginExclusion: {
        const success = await this.driver.controller.beginExclusion(processExclusionOptions(message));
        return { success };
      }
      case import_command.ControllerCommand.stopExclusion: {
        const success = await this.driver.controller.stopExclusion();
        return { success };
      }
      case import_command.ControllerCommand.removeFailedNode: {
        await this.driver.controller.removeFailedNode(message.nodeId);
        return {};
      }
      case import_command.ControllerCommand.replaceFailedNode: {
        const success = await this.driver.controller.replaceFailedNode(message.nodeId, await processInclusionOptions(this.clientsController, this.client, message));
        return { success };
      }
      // Schema <= 31
      case import_command.ControllerCommand.healNode:
      case import_command.ControllerCommand.rebuildNodeRoutes: {
        const success = await this.driver.controller.rebuildNodeRoutes(message.nodeId);
        return { success };
      }
      // Schema <= 31
      case import_command.ControllerCommand.beginHealingNetwork: {
        const success = this.driver.controller.beginRebuildingRoutes();
        return { success };
      }
      // Schema >= 32
      case import_command.ControllerCommand.beginRebuildingRoutes: {
        const success = this.driver.controller.beginRebuildingRoutes(message.options);
        return { success };
      }
      // Schema <= 31
      case import_command.ControllerCommand.stopHealingNetwork:
      // Schema >= 32
      case import_command.ControllerCommand.stopRebuildingRoutes: {
        const success = this.driver.controller.stopRebuildingRoutes();
        return { success };
      }
      case import_command.ControllerCommand.isFailedNode: {
        const failed = await this.driver.controller.isFailedNode(message.nodeId);
        return { failed };
      }
      case import_command.ControllerCommand.getAssociationGroups: {
        const groups = {};
        this.driver.controller.getAssociationGroups({
          nodeId: message.nodeId,
          endpoint: message.endpoint
        }).forEach((value, key) => groups[key] = value);
        return { groups };
      }
      case import_command.ControllerCommand.getAssociations: {
        const associations = {};
        this.driver.controller.getAssociations({
          nodeId: message.nodeId,
          endpoint: message.endpoint
        }).forEach((value, key) => associations[key] = value);
        return { associations };
      }
      case import_command.ControllerCommand.checkAssociation: {
        const result = this.driver.controller.checkAssociation({ nodeId: message.nodeId, endpoint: message.endpoint }, message.group, message.association);
        return { result };
      }
      case import_command.ControllerCommand.isAssociationAllowed: {
        const result = this.driver.controller.checkAssociation({ nodeId: message.nodeId, endpoint: message.endpoint }, message.group, message.association);
        return { allowed: result === import_zwave_js.AssociationCheckResult.OK };
      }
      case import_command.ControllerCommand.addAssociations: {
        await this.driver.controller.addAssociations({ nodeId: message.nodeId, endpoint: message.endpoint }, message.group, message.associations);
        return {};
      }
      case import_command.ControllerCommand.removeAssociations: {
        await this.driver.controller.removeAssociations({ nodeId: message.nodeId, endpoint: message.endpoint }, message.group, message.associations);
        return {};
      }
      case import_command.ControllerCommand.removeNodeFromAllAssocations:
      case import_command.ControllerCommand.removeNodeFromAllAssociations: {
        await this.driver.controller.removeNodeFromAllAssociations(message.nodeId);
        return {};
      }
      case import_command.ControllerCommand.getNodeNeighbors: {
        const neighbors = await this.driver.controller.getNodeNeighbors(message.nodeId);
        return { neighbors };
      }
      case import_command.ControllerCommand.supportsFeature: {
        const supported = this.driver.controller.supportsFeature(message.feature);
        return { supported };
      }
      case import_command.ControllerCommand.backupNVMRaw: {
        const nvmDataRaw = await this.driver.controller.backupNVMRaw((bytesRead, total) => {
          this.clientsController.clients.forEach((client) => this.client.sendEvent({
            source: "controller",
            event: "nvm backup progress",
            bytesRead,
            total
          }));
        });
        return { nvmData: Buffer.from(nvmDataRaw.buffer).toString("base64") };
      }
      case import_command.ControllerCommand.restoreNVM: {
        const nvmData = Buffer.from(message.nvmData, "base64");
        await this.driver.controller.restoreNVM(nvmData, (bytesRead, total) => {
          this.clientsController.clients.forEach((client) => this.client.sendEvent({
            source: "controller",
            event: "nvm convert progress",
            bytesRead,
            total
          }));
        }, (bytesWritten, total) => {
          this.clientsController.clients.forEach((client) => this.client.sendEvent({
            source: "controller",
            event: "nvm restore progress",
            bytesWritten,
            total
          }));
        }, message.migrateOptions);
        return {};
      }
      case import_command.ControllerCommand.setRFRegion: {
        const success = await this.driver.controller.setRFRegion(message.region);
        return { success };
      }
      case import_command.ControllerCommand.getRFRegion: {
        const region = await this.driver.controller.getRFRegion();
        return { region };
      }
      case import_command.ControllerCommand.toggleRF: {
        const success = await this.driver.controller.toggleRF(message.enabled);
        return { success };
      }
      case import_command.ControllerCommand.setPowerlevel: {
        const success = await this.driver.controller.setPowerlevel(message.powerlevel, message.measured0dBm);
        return { success };
      }
      case import_command.ControllerCommand.getPowerlevel: {
        return await this.driver.controller.getPowerlevel();
      }
      case import_command.ControllerCommand.getState: {
        const state = (0, import_state.dumpController)(this.driver, this.client.schemaVersion);
        return { state };
      }
      case import_command.ControllerCommand.getKnownLifelineRoutes: {
        const routes = this.driver.controller.getKnownLifelineRoutes();
        return { routes };
      }
      case import_command.ControllerCommand.getAnyFirmwareUpdateProgress:
      case import_command.ControllerCommand.isAnyOTAFirmwareUpdateInProgress: {
        return {
          progress: this.driver.controller.isAnyOTAFirmwareUpdateInProgress()
        };
      }
      case import_command.ControllerCommand.getAvailableFirmwareUpdates: {
        return {
          updates: await this.driver.controller.getAvailableFirmwareUpdates(message.nodeId, {
            apiKey: message.apiKey,
            additionalUserAgentComponents: this.client.additionalUserAgentComponents,
            includePrereleases: message.includePrereleases
          })
        };
      }
      case import_command.ControllerCommand.beginOTAFirmwareUpdate: {
        throw new import_error.NoLongerSupportedError(import_command.ControllerCommand.beginOTAFirmwareUpdate + " is a legacy command that is no longer supported.");
      }
      case import_command.ControllerCommand.firmwareUpdateOTA: {
        if (message.updates !== void 0) {
          throw new import_error.NoLongerSupportedError(import_command.ControllerCommand.firmwareUpdateOTA + " no longer accepts the `updates` parameter and expects `updateInfo` instead.");
        }
        if (message.updateInfo === void 0) {
          throw new import_error.InvalidParamsPassedToCommandError("Missing required parameter `updateInfo`");
        }
        const result = await this.driver.controller.firmwareUpdateOTA(message.nodeId, message.updateInfo);
        return (0, import_common.firmwareUpdateOutgoingMessage)(result, this.client.schemaVersion);
      }
      case import_command.ControllerCommand.firmwareUpdateOTW: {
        const file = Buffer.from(message.file, "base64");
        const { data } = await (0, import_zwave_js.extractFirmware)(file, message.fileFormat ?? (0, import_zwave_js.guessFirmwareFileFormat)(message.filename, file));
        const result = await this.driver.firmwareUpdateOTW(data);
        return (0, import_common.firmwareUpdateOutgoingMessage)(result, this.client.schemaVersion);
      }
      case import_command.ControllerCommand.isFirmwareUpdateInProgress: {
        const progress = this.driver.isOTWFirmwareUpdateInProgress();
        return { progress };
      }
      case import_command.ControllerCommand.setMaxLongRangePowerlevel: {
        const success = await this.driver.controller.setMaxLongRangePowerlevel(message.limit);
        return { success };
      }
      case import_command.ControllerCommand.getMaxLongRangePowerlevel: {
        const limit = await this.driver.controller.getMaxLongRangePowerlevel();
        return {
          limit
        };
      }
      case import_command.ControllerCommand.setLongRangeChannel: {
        const success = await this.driver.controller.setLongRangeChannel(message.channel);
        return { success };
      }
      case import_command.ControllerCommand.getLongRangeChannel: {
        const response = await this.driver.controller.getLongRangeChannel();
        return response;
      }
      default: {
        throw new import_error.UnknownCommandError(command);
      }
    }
  }
}
function processExclusionOptions(message) {
  if ("options" in message) {
    return message.options;
  } else if ("unprovision" in message) {
    if (typeof message.unprovision === "boolean") {
      return {
        strategy: message.unprovision ? import_zwave_js.ExclusionStrategy.Unprovision : import_zwave_js.ExclusionStrategy.ExcludeOnly
      };
    } else if (message.unprovision === "inactive") {
      return {
        strategy: import_zwave_js.ExclusionStrategy.DisableProvisioningEntry
      };
    }
  } else if ("strategy" in message && message.strategy !== void 0) {
    return { strategy: message.strategy };
  }
}
__name(processExclusionOptions, "processExclusionOptions");
async function processInclusionOptions(clientsController, client, message) {
  if ("options" in message) {
    const options = message.options;
    if (options.strategy === import_zwave_js.InclusionStrategy.Default || options.strategy === import_zwave_js.InclusionStrategy.Security_S2) {
      if ("provisioning" in options) {
        if (typeof options.provisioning === "string") {
          options.provisioning = await (0, import_zwave_js.parseQRCodeString)(options.provisioning);
        }
      } else {
        options.userCallbacks = (0, import_inclusion_user_callbacks.inclusionUserCallbacks)(clientsController, client);
      }
    }
    return options;
  }
  if ("includeNonSecure" in message && message.includeNonSecure)
    return {
      strategy: import_zwave_js.InclusionStrategy.Insecure
    };
  return {
    strategy: import_zwave_js.InclusionStrategy.Security_S0
  };
}
__name(processInclusionOptions, "processInclusionOptions");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ControllerMessageHandler
});
//# sourceMappingURL=message_handler.js.map
