"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var error_exports = {};
__export(error_exports, {
  BaseError: () => BaseError,
  EndpointNotFoundError: () => EndpointNotFoundError,
  ErrorCode: () => ErrorCode,
  InclusionAlreadyInProgressError: () => InclusionAlreadyInProgressError,
  InclusionPhaseNotInProgressError: () => InclusionPhaseNotInProgressError,
  InvalidParamsPassedToCommandError: () => InvalidParamsPassedToCommandError,
  NoLongerSupportedError: () => NoLongerSupportedError,
  NodeNotFoundError: () => NodeNotFoundError,
  SchemaIncompatibleError: () => SchemaIncompatibleError,
  UnknownCommandError: () => UnknownCommandError,
  UnknownError: () => UnknownError,
  VirtualEndpointNotFoundError: () => VirtualEndpointNotFoundError
});
module.exports = __toCommonJS(error_exports);
var ErrorCode;
(function(ErrorCode2) {
  ErrorCode2["unknownError"] = "unknown_error";
  ErrorCode2["unknownCommand"] = "unknown_command";
  ErrorCode2["nodeNotFound"] = "node_not_found";
  ErrorCode2["endpointNotFound"] = "endpoint_not_found";
  ErrorCode2["virtualEndpointNotFound"] = "virtual_endpoint_not_found";
  ErrorCode2["schemaIncompatible"] = "schema_incompatible";
  ErrorCode2["zwaveError"] = "zwave_error";
  ErrorCode2["inclusionPhaseNotInProgress"] = "inclusion_phase_not_in_progress";
  ErrorCode2["inclusionAlreadyInProgress"] = "inclusion_already_in_progress";
  ErrorCode2["invalidParamsPassedToCommand"] = "invalid_params_passed_to_command";
  ErrorCode2["noLongerSupported"] = "no_longer_supported";
})(ErrorCode || (ErrorCode = {}));
class BaseError extends Error {
  static {
    __name(this, "BaseError");
  }
  // @ts-ignore
  errorCode;
  constructor(message) {
    super(message);
    Object.setPrototypeOf(this, BaseError.prototype);
    Object.getPrototypeOf(this).name = "BaseError";
  }
}
class UnknownError extends BaseError {
  static {
    __name(this, "UnknownError");
  }
  error;
  errorCode = ErrorCode.unknownError;
  constructor(error) {
    super();
    this.error = error;
    Object.setPrototypeOf(this, UnknownError.prototype);
    Object.getPrototypeOf(this).name = "UnknownError";
  }
}
class UnknownCommandError extends BaseError {
  static {
    __name(this, "UnknownCommandError");
  }
  command;
  errorCode = ErrorCode.unknownCommand;
  constructor(command) {
    super();
    this.command = command;
    Object.setPrototypeOf(this, UnknownCommandError.prototype);
    Object.getPrototypeOf(this).name = "UnknownCommandError";
  }
}
class NodeNotFoundError extends BaseError {
  static {
    __name(this, "NodeNotFoundError");
  }
  nodeId;
  errorCode = ErrorCode.nodeNotFound;
  constructor(nodeId) {
    super();
    this.nodeId = nodeId;
    Object.setPrototypeOf(this, NodeNotFoundError.prototype);
    Object.getPrototypeOf(this).name = "NodeNotFoundError";
  }
}
class SchemaIncompatibleError extends BaseError {
  static {
    __name(this, "SchemaIncompatibleError");
  }
  schemaId;
  errorCode = ErrorCode.schemaIncompatible;
  constructor(schemaId) {
    super();
    this.schemaId = schemaId;
    Object.setPrototypeOf(this, SchemaIncompatibleError.prototype);
    Object.getPrototypeOf(this).name = "SchemaIncompatibleError";
  }
}
class VirtualEndpointNotFoundError extends BaseError {
  static {
    __name(this, "VirtualEndpointNotFoundError");
  }
  index;
  nodeIDs;
  broadcast;
  errorCode = ErrorCode.virtualEndpointNotFound;
  constructor(index, nodeIDs, broadcast) {
    super();
    this.index = index;
    this.nodeIDs = nodeIDs;
    this.broadcast = broadcast;
    Object.setPrototypeOf(this, VirtualEndpointNotFoundError.prototype);
    Object.getPrototypeOf(this).name = "VirtualEndpointNotFoundError";
  }
}
class EndpointNotFoundError extends BaseError {
  static {
    __name(this, "EndpointNotFoundError");
  }
  nodeId;
  index;
  errorCode = ErrorCode.endpointNotFound;
  constructor(nodeId, index) {
    super();
    this.nodeId = nodeId;
    this.index = index;
    Object.setPrototypeOf(this, EndpointNotFoundError.prototype);
    Object.getPrototypeOf(this).name = "EndpointNotFoundError";
  }
}
class InclusionPhaseNotInProgressError extends BaseError {
  static {
    __name(this, "InclusionPhaseNotInProgressError");
  }
  phase;
  errorCode = ErrorCode.inclusionPhaseNotInProgress;
  constructor(phase) {
    super();
    this.phase = phase;
    Object.setPrototypeOf(this, InclusionPhaseNotInProgressError.prototype);
    Object.getPrototypeOf(this).name = "InclusionPhaseNotInProgressError";
  }
}
class InclusionAlreadyInProgressError extends BaseError {
  static {
    __name(this, "InclusionAlreadyInProgressError");
  }
  errorCode = ErrorCode.inclusionAlreadyInProgress;
  constructor() {
    super();
    Object.setPrototypeOf(this, InclusionAlreadyInProgressError.prototype);
    Object.getPrototypeOf(this).name = "InclusionAlreadyInProgressError";
  }
}
class InvalidParamsPassedToCommandError extends BaseError {
  static {
    __name(this, "InvalidParamsPassedToCommandError");
  }
  errorCode = ErrorCode.invalidParamsPassedToCommand;
  constructor(message) {
    super(message);
    Object.setPrototypeOf(this, InvalidParamsPassedToCommandError.prototype);
    Object.getPrototypeOf(this).name = "InvalidParamsPassedToCommandError";
  }
}
class NoLongerSupportedError extends BaseError {
  static {
    __name(this, "NoLongerSupportedError");
  }
  errorCode = ErrorCode.noLongerSupported;
  constructor(message) {
    super(message + " If you are using an application that integrates with Z-Wave JS and you receive this error, you may need to update the application.");
    Object.setPrototypeOf(this, NoLongerSupportedError.prototype);
    Object.getPrototypeOf(this).name = "NoLongerSupportedError";
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  BaseError,
  EndpointNotFoundError,
  ErrorCode,
  InclusionAlreadyInProgressError,
  InclusionPhaseNotInProgressError,
  InvalidParamsPassedToCommandError,
  NoLongerSupportedError,
  NodeNotFoundError,
  SchemaIncompatibleError,
  UnknownCommandError,
  UnknownError,
  VirtualEndpointNotFoundError
});
//# sourceMappingURL=error.js.map
