"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var logging_exports = {};
__export(logging_exports, {
  LoggingEventForwarder: () => LoggingEventForwarder
});
module.exports = __toCommonJS(logging_exports);
var import_winston_transport = __toESM(require("winston-transport"), 1);
var import_triple_beam = require("triple-beam");
var import_node = require("@zwave-js/core/bindings/log/node");
class LoggingEventForwarder {
  static {
    __name(this, "LoggingEventForwarder");
  }
  clients;
  driver;
  logger;
  /**
   * Only load this once the driver is ready.
   *
   * @param clients
   * @param driver
   */
  serverTransport;
  constructor(clients, driver, logger) {
    this.clients = clients;
    this.driver = driver;
    this.logger = logger;
  }
  get started() {
    return this.serverTransport !== void 0;
  }
  start(filter) {
    var { transports, level } = this.driver.getLogConfig();
    this.logger.info("Starting logging event forwarder at " + level + " level");
    this.serverTransport = new WebSocketLogTransport(level, this.clients, filter);
    transports = transports || [];
    transports.push(this.serverTransport);
    this.driver.updateLogConfig({ transports });
  }
  stop() {
    this.logger.info("Stopping logging event forwarder");
    const transports = this.driver.getLogConfig().transports.filter((transport) => transport !== this.serverTransport);
    this.driver.updateLogConfig({ transports });
    delete this.serverTransport;
  }
  restartIfNeeded() {
    var { level } = this.driver.getLogConfig();
    if (this.started && this.serverTransport?.level != level) {
      this.stop();
      this.start();
    }
  }
}
class WebSocketLogTransport extends import_winston_transport.default {
  static {
    __name(this, "WebSocketLogTransport");
  }
  clients;
  filter;
  constructor(level, clients, filter) {
    super({
      format: (0, import_node.createDefaultTransportFormat)(false, false),
      level
    });
    this.clients = clients;
    this.filter = filter;
  }
  log(info, next) {
    const context = info.context;
    if (!this.filter || Object.entries(this.filter).every(([key, value]) => key in context && context[key] === value)) {
      this.clients.clients.filter((cl) => cl.receiveLogs && cl.isConnected).forEach((client) => client.sendEvent({
        source: "driver",
        event: "logging",
        formattedMessage: info[import_triple_beam.MESSAGE],
        ...info
      }));
    }
    next();
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  LoggingEventForwarder
});
//# sourceMappingURL=logging.js.map
