"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var message_handler_exports = {};
__export(message_handler_exports, {
  MulticastGroupMessageHandler: () => MulticastGroupMessageHandler
});
module.exports = __toCommonJS(message_handler_exports);
var import_error = require("../error.js");
var import_command = require("./command.js");
var import_common = require("../common.js");
class MulticastGroupMessageHandler {
  static {
    __name(this, "MulticastGroupMessageHandler");
  }
  driver;
  client;
  constructor(driver, client) {
    this.driver = driver;
    this.client = client;
  }
  async handle(message) {
    const { command } = message;
    const virtualNode = this.driver.controller.getMulticastGroup(message.nodeIDs);
    switch (message.command) {
      case import_command.MulticastGroupCommand.setValue: {
        const result = await virtualNode.setValue(message.valueId, message.value, message.options);
        return (0, import_common.setValueOutgoingMessage)(result, this.client.schemaVersion);
      }
      case import_command.MulticastGroupCommand.getEndpointCount: {
        const count = virtualNode.getEndpointCount();
        return { count };
      }
      case import_command.MulticastGroupCommand.supportsCC: {
        const supported = getVirtualEndpoint(virtualNode, message.nodeIDs, message.index).supportsCC(message.commandClass);
        return { supported };
      }
      case import_command.MulticastGroupCommand.getCCVersion: {
        const version = getVirtualEndpoint(virtualNode, message.nodeIDs, message.index).getCCVersion(message.commandClass);
        return { version };
      }
      case import_command.MulticastGroupCommand.invokeCCAPI: {
        const response = getVirtualEndpoint(virtualNode, message.nodeIDs, message.index).invokeCCAPI(message.commandClass, message.methodName, ...message.args);
        return { response };
      }
      case import_command.MulticastGroupCommand.supportsCCAPI: {
        const supported = getVirtualEndpoint(virtualNode, message.nodeIDs, message.index).supportsCCAPI(message.commandClass);
        return { supported };
      }
      case import_command.MulticastGroupCommand.getDefinedValueIDs: {
        const valueIDs = virtualNode.getDefinedValueIDs();
        return { valueIDs };
      }
      default: {
        throw new import_error.UnknownCommandError(command);
      }
    }
  }
}
function getVirtualEndpoint(virtualNode, nodeIDs, index) {
  if (!index)
    return virtualNode;
  const virtualEndpoint = virtualNode.getEndpoint(index);
  if (!virtualEndpoint) {
    throw new import_error.VirtualEndpointNotFoundError(index, nodeIDs, void 0);
  }
  return virtualEndpoint;
}
__name(getVirtualEndpoint, "getVirtualEndpoint");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  MulticastGroupMessageHandler
});
//# sourceMappingURL=message_handler.js.map
