"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var message_handler_exports = {};
__export(message_handler_exports, {
  NodeMessageHandler: () => NodeMessageHandler
});
module.exports = __toCommonJS(message_handler_exports);
var import_core = require("@zwave-js/core");
var import_error = require("../error.js");
var import_state = require("../state.js");
var import_command = require("./command.js");
var import_common = require("../common.js");
class NodeMessageHandler {
  static {
    __name(this, "NodeMessageHandler");
  }
  clientsController;
  driver;
  client;
  constructor(clientsController, driver, client) {
    this.clientsController = clientsController;
    this.driver = driver;
    this.client = client;
  }
  async handle(message) {
    const { nodeId, command } = message;
    const node = this.driver.controller.nodes.get(nodeId);
    if (!node) {
      throw new import_error.NodeNotFoundError(nodeId);
    }
    switch (message.command) {
      case import_command.NodeCommand.setValue: {
        const result = await node.setValue(message.valueId, message.value, message.options);
        return (0, import_common.setValueOutgoingMessage)(result, this.client.schemaVersion);
      }
      case import_command.NodeCommand.refreshInfo: {
        await node.refreshInfo(message.options);
        return {};
      }
      case import_command.NodeCommand.getDefinedValueIDs: {
        const valueIds = node.getDefinedValueIDs();
        return { valueIds };
      }
      case import_command.NodeCommand.getValueMetadata: {
        if (message.valueId.commandClass == import_core.CommandClasses.Configuration) {
          return (0, import_state.dumpConfigurationMetadata)(node.getValueMetadata(message.valueId), this.client.schemaVersion);
        }
        return (0, import_state.dumpMetadata)(node.getValueMetadata(message.valueId), this.client.schemaVersion);
      }
      case import_command.NodeCommand.beginFirmwareUpdate: {
        const firmwareFile = Buffer.from(message.firmwareFile, "base64");
        let firmware = await (0, import_core.extractFirmware)(firmwareFile, message.firmwareFileFormat ?? (0, import_core.guessFirmwareFileFormat)(message.firmwareFilename, firmwareFile));
        firmware.firmwareTarget = message.target ?? firmware.firmwareTarget;
        const result = await node.updateFirmware([firmware]);
        return (0, import_common.firmwareUpdateOutgoingMessage)(result, this.client.schemaVersion);
      }
      case import_command.NodeCommand.updateFirmware: {
        const updates = [];
        for (const update of message.updates) {
          const file = Buffer.from(update.file, "base64");
          let firmware = await (0, import_core.extractFirmware)(file, update.fileFormat ?? (0, import_core.guessFirmwareFileFormat)(update.filename, file));
          firmware.firmwareTarget = update.firmwareTarget ?? firmware.firmwareTarget;
          updates.push(firmware);
        }
        const result = await node.updateFirmware(updates);
        return (0, import_common.firmwareUpdateOutgoingMessage)(result, this.client.schemaVersion);
      }
      case import_command.NodeCommand.abortFirmwareUpdate: {
        await node.abortFirmwareUpdate();
        return {};
      }
      case import_command.NodeCommand.getFirmwareUpdateCapabilities: {
        const capabilities = await node.getFirmwareUpdateCapabilities();
        return { capabilities };
      }
      case import_command.NodeCommand.getFirmwareUpdateCapabilitiesCached: {
        const capabilities = node.getFirmwareUpdateCapabilitiesCached();
        return { capabilities };
      }
      case import_command.NodeCommand.pollValue: {
        const value = await node.pollValue(message.valueId);
        return { value };
      }
      case import_command.NodeCommand.setRawConfigParameterValue: {
        return (0, import_common.setRawConfigParameterValue)(message, node);
      }
      case import_command.NodeCommand.getRawConfigParameterValue: {
        return (0, import_common.getRawConfigParameterValue)(message, node);
      }
      case import_command.NodeCommand.refreshValues: {
        await node.refreshValues();
        return {};
      }
      case import_command.NodeCommand.refreshCCValues: {
        await node.refreshCCValues(message.commandClass);
        return {};
      }
      case import_command.NodeCommand.ping: {
        const responded = await node.ping();
        return { responded };
      }
      case import_command.NodeCommand.hasSecurityClass: {
        const hasSecurityClass = node.hasSecurityClass(message.securityClass);
        return { hasSecurityClass };
      }
      case import_command.NodeCommand.getHighestSecurityClass: {
        const highestSecurityClass = node.getHighestSecurityClass();
        return { highestSecurityClass };
      }
      case import_command.NodeCommand.testPowerlevel: {
        const framesAcked = await node.testPowerlevel(message.testNodeId, message.powerlevel, message.testFrameCount, (acknowledged, total) => {
          this.clientsController.clients.forEach((client) => client.sendEvent({
            source: "node",
            event: "test powerlevel progress",
            nodeId: message.nodeId,
            acknowledged,
            total
          }));
        });
        return { framesAcked };
      }
      case import_command.NodeCommand.checkLifelineHealth: {
        const summary = await node.checkLifelineHealth(message.rounds, (round, totalRounds, lastRating, lastResult) => {
          const returnEvent0 = {
            source: "node",
            event: "check lifeline health progress",
            nodeId: message.nodeId,
            round,
            totalRounds,
            lastRating
          };
          const returnEvent31 = { ...returnEvent0, lastResult };
          this.clientsController.clients.forEach((client) => {
            client.sendEvent(client.schemaVersion >= 31 ? returnEvent31 : returnEvent0);
          });
        });
        return { summary };
      }
      case import_command.NodeCommand.checkRouteHealth: {
        const summary = await node.checkRouteHealth(message.targetNodeId, message.rounds, (round, totalRounds, lastRating, lastResult) => {
          const returnEvent0 = {
            source: "node",
            event: "check route health progress",
            nodeId: message.nodeId,
            round,
            totalRounds,
            lastRating
          };
          const returnEvent31 = { ...returnEvent0, lastResult };
          this.clientsController.clients.forEach((client) => {
            client.sendEvent(client.schemaVersion >= 31 ? returnEvent31 : returnEvent0);
          });
        });
        return { summary };
      }
      case import_command.NodeCommand.getValue: {
        const value = node.getValue(message.valueId);
        return { value };
      }
      case import_command.NodeCommand.getEndpointCount: {
        const count = node.getEndpointCount();
        return { count };
      }
      case import_command.NodeCommand.interviewCC: {
        await node.interviewCC(message.commandClass);
        return {};
      }
      case import_command.NodeCommand.getState: {
        const state = (0, import_state.dumpNode)(node, this.client.schemaVersion);
        return { state };
      }
      case import_command.NodeCommand.setKeepAwake: {
        node.keepAwake = message.keepAwake;
        return {};
      }
      case import_command.NodeCommand.setLocation: {
        node.location = message.location;
        if ((message.updateCC ?? true) && node.supportsCC(import_core.CommandClasses["Node Naming and Location"])) {
          await node.commandClasses["Node Naming and Location"].setLocation(message.location);
        }
        return {};
      }
      case import_command.NodeCommand.setName: {
        node.name = message.name;
        if ((message.updateCC ?? true) && node.supportsCC(import_core.CommandClasses["Node Naming and Location"])) {
          await node.commandClasses["Node Naming and Location"].setName(message.name);
        }
        return {};
      }
      case import_command.NodeCommand.getFirmwareUpdateProgress:
      case import_command.NodeCommand.isFirmwareUpdateInProgress: {
        const progress = node.isFirmwareUpdateInProgress();
        return { progress };
      }
      case import_command.NodeCommand.waitForWakeup: {
        await node.waitForWakeup();
        return {};
      }
      case import_command.NodeCommand.interview: {
        await node.interview();
        return {};
      }
      case import_command.NodeCommand.getValueTimestamp: {
        const timestamp = node.getValueTimestamp(message.valueId);
        return { timestamp };
      }
      case import_command.NodeCommand.manuallyIdleNotificationValue: {
        if ("valueId" in message) {
          node.manuallyIdleNotificationValue(message.valueId);
        } else {
          node.manuallyIdleNotificationValue(message.notificationType, message.prevValue, message.endpointIndex);
        }
        return {};
      }
      case import_command.NodeCommand.setDateAndTime: {
        const success = await node.setDateAndTime(message.date === void 0 ? void 0 : new Date(message.date));
        return { success };
      }
      case import_command.NodeCommand.getDateAndTime: {
        const dateAndTime = await node.getDateAndTime();
        return { dateAndTime };
      }
      case import_command.NodeCommand.isHealthCheckInProgress: {
        const progress = node.isHealthCheckInProgress();
        return { progress };
      }
      case import_command.NodeCommand.abortHealthCheck: {
        await node.abortHealthCheck();
        return {};
      }
      case import_command.NodeCommand.setDefaultVolume: {
        node.defaultVolume = message.defaultVolume;
        return {};
      }
      case import_command.NodeCommand.setDefaultTransitionDuration: {
        node.defaultTransitionDuration = message.defaultTransitionDuration;
        return {};
      }
      case import_command.NodeCommand.hasDeviceConfigChanged: {
        const changed = node.hasDeviceConfigChanged();
        return { changed };
      }
      case import_command.NodeCommand.createDump: {
        const dump = node.createDump();
        return { dump };
      }
      default: {
        throw new import_error.UnknownCommandError(command);
      }
    }
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  NodeMessageHandler
});
//# sourceMappingURL=message_handler.js.map
