import { type WebSocket } from "ws";
import { Driver, InclusionGrant, ZWaveErrorCodes } from "zwave-js";
import { DeferredPromise } from "alcalzone-shared/deferred-promise";
import type * as OutgoingMessages from "./outgoing_message.js";
import { EventEmitter } from "events";
import { ErrorCode } from "./error.js";
import { LogContexts } from "./logging.js";
export declare class Client {
    private socket;
    private clientsController;
    private driver;
    private logger;
    private remoteController;
    receiveEvents: boolean;
    private _outstandingPing;
    schemaVersion: number;
    receiveLogs: boolean;
    additionalUserAgentComponents?: Record<string, string>;
    private instanceHandlers;
    constructor(socket: WebSocket, clientsController: ClientsController, driver: Driver, logger: Logger, remoteController: ZwavejsServerRemoteController);
    get isConnected(): boolean;
    private setSchemaVersion;
    receiveMessage(data: string): Promise<void>;
    sendVersion(): void;
    sendResultSuccess(messageId: string, result: OutgoingMessages.OutgoingResultMessageSuccess["result"], compress?: boolean): void;
    sendResultError(messageId: string, errorCode: Omit<ErrorCode, "zwaveError">, message: string, args: OutgoingMessages.JSONValue): void;
    sendResultZWaveError(messageId: string, zjsErrorCode: ZWaveErrorCodes, message: string): void;
    sendEvent(event: OutgoingMessages.OutgoingEvent): void;
    sendData(data: OutgoingMessages.OutgoingMessage, compress?: boolean): void;
    checkAlive(): void;
    disconnect(): void;
}
export declare class ClientsController extends EventEmitter {
    driver: Driver;
    private logger;
    private remoteController;
    clients: Array<Client>;
    private pingInterval?;
    private eventForwarder?;
    private cleanupScheduled;
    private loggingEventForwarder?;
    grantSecurityClassesPromise?: DeferredPromise<InclusionGrant | false>;
    validateDSKAndEnterPinPromise?: DeferredPromise<string | false>;
    constructor(driver: Driver, logger: Logger, remoteController: ZwavejsServerRemoteController);
    addSocket(socket: WebSocket): void;
    get loggingEventForwarderStarted(): boolean;
    restartLoggingEventForwarderIfNeeded(): void;
    configureLoggingEventForwarder(filter?: Partial<LogContexts>): void;
    cleanupLoggingEventForwarder(): void;
    private scheduleClientCleanup;
    private cleanupClients;
    disconnect(): void;
}
interface ZwavejsServerOptions {
    port?: number;
    host?: string;
    logger?: Logger;
    enableDNSServiceDiscovery?: boolean;
}
export interface Logger {
    error(message: string | Error, error?: Error): void;
    warn(message: string): void;
    info(message: string): void;
    debug(message: string): void;
}
/**
 * This class allows the hard reset driver command to be passed to the
 * ClientsController, Client, and Message Handler instances without
 * providing access to the base server and eventing system.
 */
export declare class ZwavejsServerRemoteController {
    private driver;
    private zwaveJsServer;
    constructor(driver: Driver, zwaveJsServer: ZwavejsServer);
    hardResetController(): Promise<void>;
}
export declare class ZwavejsServer extends EventEmitter {
    private driver;
    private options;
    private server?;
    private wsServer?;
    private sockets?;
    private logger;
    private defaultPort;
    private responder?;
    private service?;
    private remoteController;
    constructor(driver: Driver, options?: ZwavejsServerOptions);
    start(shouldSetInclusionUserCallbacks?: boolean): Promise<void>;
    setInclusionUserCallbacks(): void;
    private onError;
    destroy(): Promise<void>;
}
export {};
