export declare enum ErrorCode {
    unknownError = "unknown_error",
    unknownCommand = "unknown_command",
    nodeNotFound = "node_not_found",
    endpointNotFound = "endpoint_not_found",
    virtualEndpointNotFound = "virtual_endpoint_not_found",
    schemaIncompatible = "schema_incompatible",
    zwaveError = "zwave_error",
    inclusionPhaseNotInProgress = "inclusion_phase_not_in_progress",
    inclusionAlreadyInProgress = "inclusion_already_in_progress",
    invalidParamsPassedToCommand = "invalid_params_passed_to_command",
    noLongerSupported = "no_longer_supported"
}
export declare class BaseError extends Error {
    errorCode: ErrorCode;
    constructor(message?: string);
}
export declare class UnknownError extends BaseError {
    error: Error;
    errorCode: ErrorCode;
    constructor(error: Error);
}
export declare class UnknownCommandError extends BaseError {
    command: string;
    errorCode: ErrorCode;
    constructor(command: string);
}
export declare class NodeNotFoundError extends BaseError {
    nodeId: number;
    errorCode: ErrorCode;
    constructor(nodeId: number);
}
export declare class SchemaIncompatibleError extends BaseError {
    schemaId: number;
    errorCode: ErrorCode;
    constructor(schemaId: number);
}
export declare class VirtualEndpointNotFoundError extends BaseError {
    index: number;
    nodeIDs?: number[] | undefined;
    broadcast?: boolean | undefined;
    errorCode: ErrorCode;
    constructor(index: number, nodeIDs?: number[] | undefined, broadcast?: boolean | undefined);
}
export declare class EndpointNotFoundError extends BaseError {
    nodeId: number;
    index: number;
    errorCode: ErrorCode;
    constructor(nodeId: number, index: number);
}
export declare class InclusionPhaseNotInProgressError extends BaseError {
    phase: string;
    errorCode: ErrorCode;
    constructor(phase: string);
}
export declare class InclusionAlreadyInProgressError extends BaseError {
    errorCode: ErrorCode;
    constructor();
}
export declare class InvalidParamsPassedToCommandError extends BaseError {
    errorCode: ErrorCode;
    constructor(message: string);
}
export declare class NoLongerSupportedError extends BaseError {
    errorCode: ErrorCode;
    constructor(message: string);
}
