import { isUint8Array } from "node:util/types";
export function stringifyReplacer(key, value) {
    // Ensure that Uint8Arrays are serialized as if they were Buffers
    // to keep the API backwards compatible
    if (isUint8Array(value)) {
        return Buffer.from(value).toJSON();
    }
    return value;
}
