import { createDeferredPromise, } from "alcalzone-shared/deferred-promise";
/** Can be used to asynchronously signal a single listener */
export class Signal {
    _listener;
    _status = false;
    get isSet() {
        return this._status;
    }
    set() {
        if (this._status)
            return;
        this._status = true;
        if (this._listener) {
            this._listener.resolve(undefined);
        }
    }
    reset() {
        this._status = false;
        this._listener = undefined;
    }
    then(onfulfilled) {
        if (this._status) {
            return Promise.resolve(onfulfilled());
        }
        else {
            const p = createDeferredPromise();
            this._listener = p;
            return p.then(onfulfilled);
        }
    }
}
//# sourceMappingURL=signal.js.map