"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var BarrierOperatorCC_exports = {};
__export(BarrierOperatorCC_exports, {
  BarrierOperatorCC: () => BarrierOperatorCC,
  BarrierOperatorCCAPI: () => BarrierOperatorCCAPI,
  BarrierOperatorCCEventSignalingGet: () => BarrierOperatorCCEventSignalingGet,
  BarrierOperatorCCEventSignalingReport: () => BarrierOperatorCCEventSignalingReport,
  BarrierOperatorCCEventSignalingSet: () => BarrierOperatorCCEventSignalingSet,
  BarrierOperatorCCGet: () => BarrierOperatorCCGet,
  BarrierOperatorCCReport: () => BarrierOperatorCCReport,
  BarrierOperatorCCSet: () => BarrierOperatorCCSet,
  BarrierOperatorCCSignalingCapabilitiesGet: () => BarrierOperatorCCSignalingCapabilitiesGet,
  BarrierOperatorCCSignalingCapabilitiesReport: () => BarrierOperatorCCSignalingCapabilitiesReport,
  BarrierOperatorCCValues: () => import_CCValues_generated.BarrierOperatorCCValues
});
module.exports = __toCommonJS(BarrierOperatorCC_exports);
var __validateArgs = __toESM(require("./BarrierOperatorCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_BarrierOperatorCCAPI_set, validateArgs_BarrierOperatorCCAPI_getSignalingCapabilities, validateArgs_BarrierOperatorCCAPI_getEventSignaling, validateArgs_BarrierOperatorCCAPI_setEventSignaling } = __validateArgs;
let BarrierOperatorCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Barrier Operator"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _set_decorators;
  let _getSignalingCapabilities_decorators;
  let _getEventSignaling_decorators;
  let _setEventSignaling_decorators;
  var BarrierOperatorCCAPI2 = class extends _classSuper {
    static {
      __name(this, "BarrierOperatorCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(this, null, _set_decorators, { kind: "method", name: "set", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "set" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.set, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getSignalingCapabilities_decorators, { kind: "method", name: "getSignalingCapabilities", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getSignalingCapabilities" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getSignalingCapabilities, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getEventSignaling_decorators, { kind: "method", name: "getEventSignaling", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getEventSignaling" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getEventSignaling, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _setEventSignaling_decorators, { kind: "method", name: "setEventSignaling", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setEventSignaling" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setEventSignaling, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BarrierOperatorCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.BarrierOperatorCommand.Get:
        case import_Types.BarrierOperatorCommand.Set:
        case import_Types.BarrierOperatorCommand.SignalingCapabilitiesGet:
        case import_Types.BarrierOperatorCommand.EventSignalingGet:
        case import_Types.BarrierOperatorCommand.EventSignalingSet:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
      this.assertSupportsCommand(import_Types.BarrierOperatorCommand, import_Types.BarrierOperatorCommand.Get);
      const cc = new BarrierOperatorCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["currentState", "position"]);
      }
    }
    async set(targetState) {
      this.assertSupportsCommand(import_Types.BarrierOperatorCommand, import_Types.BarrierOperatorCommand.Set);
      const cc = new BarrierOperatorCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        targetState
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async getSignalingCapabilities() {
      this.assertSupportsCommand(import_Types.BarrierOperatorCommand, import_Types.BarrierOperatorCommand.SignalingCapabilitiesGet);
      const cc = new BarrierOperatorCCSignalingCapabilitiesGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.supportedSubsystemTypes;
    }
    async getEventSignaling(subsystemType) {
      this.assertSupportsCommand(import_Types.BarrierOperatorCommand, import_Types.BarrierOperatorCommand.EventSignalingGet);
      const cc = new BarrierOperatorCCEventSignalingGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        subsystemType
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.subsystemState;
    }
    async setEventSignaling(subsystemType, subsystemState) {
      this.assertSupportsCommand(import_Types.BarrierOperatorCommand, import_Types.BarrierOperatorCommand.EventSignalingSet);
      const cc = new BarrierOperatorCCEventSignalingSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        subsystemType,
        subsystemState
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    get [(_set_decorators = [validateArgs_BarrierOperatorCCAPI_set({ strictEnums: true })], _getSignalingCapabilities_decorators = [validateArgs_BarrierOperatorCCAPI_getSignalingCapabilities()], _getEventSignaling_decorators = [validateArgs_BarrierOperatorCCAPI_getEventSignaling({ strictEnums: true })], _setEventSignaling_decorators = [validateArgs_BarrierOperatorCCAPI_setEventSignaling({ strictEnums: true })], import_API.SET_VALUE)]() {
      return async function({ property, propertyKey }, value) {
        if (property === "targetState") {
          if (typeof value !== "number") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
          const targetValue = value === import_Types.BarrierState.Closed ? import_Types.BarrierState.Closed : import_Types.BarrierState.Open;
          return this.set(targetValue);
        } else if (property === "signalingState") {
          if (propertyKey == void 0) {
            (0, import_API.throwMissingPropertyKey)(this.ccId, property);
          } else if (typeof propertyKey !== "number") {
            (0, import_API.throwUnsupportedPropertyKey)(this.ccId, property, propertyKey);
          }
          if (typeof value !== "number") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
          return this.setEventSignaling(propertyKey, value);
        } else {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    [import_API.SET_VALUE_HOOKS] = (__runInitializers(this, _instanceExtraInitializers), ({ property, propertyKey }, value, _options) => {
      const valueId = {
        commandClass: this.ccId,
        property,
        propertyKey
      };
      if (import_CCValues_generated.BarrierOperatorCCValues.targetState.is(valueId)) {
        const currentStateValueId = import_CCValues_generated.BarrierOperatorCCValues.currentState.endpoint(this.endpoint.index);
        const targetValue = value === import_Types.BarrierState.Closed ? import_Types.BarrierState.Closed : import_Types.BarrierState.Open;
        return {
          // Barrier Operator commands may take some time to be executed.
          // Therefore we try to supervise the command execution and delay the
          // optimistic update until the final result is received.
          supervisionDelayedUpdates: true,
          supervisionOnSuccess: /* @__PURE__ */ __name(() => {
            this.tryGetValueDB()?.setValue(currentStateValueId, targetValue);
          }, "supervisionOnSuccess"),
          supervisionOnFailure: /* @__PURE__ */ __name(async () => {
            try {
              await this.get();
            } catch {
            }
          }, "supervisionOnFailure"),
          optimisticallyUpdateRelatedValues: /* @__PURE__ */ __name((supervisedAndSuccessful) => {
            if (!supervisedAndSuccessful)
              return;
            if (this.isSinglecast()) {
              this.tryGetValueDB()?.setValue(currentStateValueId, targetValue);
            } else if (this.isMulticast()) {
              const affectedNodes = this.endpoint.node.physicalNodes.filter((node) => node.getEndpoint(this.endpoint.index)?.supportsCC(this.ccId));
              for (const node of affectedNodes) {
                this.host.tryGetValueDB(node.id)?.setValue(currentStateValueId, targetValue);
              }
            }
          }, "optimisticallyUpdateRelatedValues"),
          verifyChanges: /* @__PURE__ */ __name(() => {
            if (this.isSinglecast()) {
              this.schedulePoll(currentStateValueId, targetValue);
            } else {
            }
          }, "verifyChanges")
        };
      } else if (import_CCValues_generated.BarrierOperatorCCValues.signalingState.is(valueId)) {
        const subsystemType = propertyKey;
        const signalingStateValueId = import_CCValues_generated.BarrierOperatorCCValues.signalingState(subsystemType).endpoint(this.endpoint.index);
        return {
          verifyChanges: /* @__PURE__ */ __name(() => {
            if (this.isSinglecast()) {
              this.schedulePoll(signalingStateValueId, value, {
                // Signaling state changes are fast
                transition: "fast"
              });
            }
          }, "verifyChanges")
        };
      }
    });
    get [import_API.POLL_VALUE]() {
      return async function({ property, propertyKey }) {
        switch (property) {
          case "currentState":
          case "position":
            return (await this.get())?.[property];
          case "signalingState":
            if (propertyKey == void 0) {
              (0, import_API.throwMissingPropertyKey)(this.ccId, property);
            } else if (typeof propertyKey !== "number") {
              (0, import_API.throwUnsupportedPropertyKey)(this.ccId, property, propertyKey);
            }
            return this.getEventSignaling(propertyKey);
          default:
            (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
  };
  return BarrierOperatorCCAPI2 = _classThis;
})();
let BarrierOperatorCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Barrier Operator"]), (0, import_CommandClassDecorators.implementedVersion)(1), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.BarrierOperatorCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var BarrierOperatorCC2 = class extends _classSuper {
    static {
      __name(this, "BarrierOperatorCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BarrierOperatorCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Barrier Operator"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      this.ensureMetadata(ctx, import_CCValues_generated.BarrierOperatorCCValues.targetState);
      ctx.logNode(node.id, {
        message: "Querying signaling capabilities...",
        direction: "outbound"
      });
      const resp = await api.getSignalingCapabilities();
      if (resp) {
        ctx.logNode(node.id, {
          message: `Received supported subsystem types: ${resp.map((t) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_Types.SubsystemType, t)}`).join("")}`,
          direction: "inbound"
        });
        for (const subsystemType of resp) {
          if (!(0, import_shared.isEnumMember)(import_Types.SubsystemType, subsystemType))
            continue;
          ctx.logNode(node.id, {
            message: `Enabling subsystem ${(0, import_shared.getEnumMemberName)(import_Types.SubsystemType, subsystemType)}...`,
            direction: "outbound"
          });
          await api.setEventSignaling(subsystemType, import_Types.SubsystemState.On).catch(import_shared.noop);
        }
      }
      await this.refreshValues(ctx);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Barrier Operator"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      const supportedSubsystems = this.getValue(ctx, import_CCValues_generated.BarrierOperatorCCValues.supportedSubsystemTypes) ?? [];
      for (const subsystemType of supportedSubsystems) {
        if (!(0, import_shared.isEnumMember)(import_Types.SubsystemType, subsystemType))
          continue;
        ctx.logNode(node.id, {
          message: `Querying event signaling state for subsystem ${(0, import_shared.getEnumMemberName)(import_Types.SubsystemType, subsystemType)}...`,
          direction: "outbound"
        });
        const state = await api.getEventSignaling(subsystemType);
        if (state != void 0) {
          ctx.logNode(node.id, {
            message: `Subsystem ${(0, import_shared.getEnumMemberName)(import_Types.SubsystemType, subsystemType)} has state ${(0, import_shared.getEnumMemberName)(import_Types.SubsystemState, state)}`,
            direction: "inbound"
          });
        }
      }
      ctx.logNode(node.id, {
        message: "querying current barrier state...",
        direction: "outbound"
      });
      await api.get();
    }
  };
  return BarrierOperatorCC2 = _classThis;
})();
let BarrierOperatorCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.BarrierOperatorCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = BarrierOperatorCC;
  var BarrierOperatorCCSet2 = class extends _classSuper {
    static {
      __name(this, "BarrierOperatorCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BarrierOperatorCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.targetState = options.targetState;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    targetState;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.targetState]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "target state": this.targetState }
      };
    }
  };
  return BarrierOperatorCCSet2 = _classThis;
})();
let BarrierOperatorCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.BarrierOperatorCommand.Report), (0, import_CommandClassDecorators.ccValueProperty)("currentState", import_CCValues_generated.BarrierOperatorCCValues.currentState), (0, import_CommandClassDecorators.ccValueProperty)("position", import_CCValues_generated.BarrierOperatorCCValues.position)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = BarrierOperatorCC;
  var BarrierOperatorCCReport2 = class extends _classSuper {
    static {
      __name(this, "BarrierOperatorCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BarrierOperatorCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.position = options.position;
      this.currentState = options.currentState;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const payloadValue = raw.payload[0];
      let position;
      if (payloadValue <= 99) {
        position = payloadValue;
      } else if (payloadValue === 255) {
        position = 100;
      } else {
        position = import_core.UNKNOWN_STATE;
      }
      let currentState;
      if (payloadValue === import_Types.BarrierState.Closed || payloadValue >= import_Types.BarrierState.Closing) {
        currentState = payloadValue;
      } else if (payloadValue > 0 && payloadValue <= 99) {
        currentState = import_Types.BarrierState.Stopped;
      } else {
        currentState = import_core.UNKNOWN_STATE;
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        position,
        currentState
      });
    }
    currentState;
    position;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "barrier position": (0, import_core.maybeUnknownToString)(this.position),
          "barrier state": this.currentState != void 0 ? (0, import_shared.getEnumMemberName)(import_Types.BarrierState, this.currentState) : "unknown"
        }
      };
    }
  };
  return BarrierOperatorCCReport2 = _classThis;
})();
let BarrierOperatorCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.BarrierOperatorCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(BarrierOperatorCCReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = BarrierOperatorCC;
  var BarrierOperatorCCGet2 = class extends _classSuper {
    static {
      __name(this, "BarrierOperatorCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BarrierOperatorCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return BarrierOperatorCCGet2 = _classThis;
})();
let BarrierOperatorCCSignalingCapabilitiesReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.BarrierOperatorCommand.SignalingCapabilitiesReport), (0, import_CommandClassDecorators.ccValueProperty)("supportedSubsystemTypes", import_CCValues_generated.BarrierOperatorCCValues.supportedSubsystemTypes)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = BarrierOperatorCC;
  var BarrierOperatorCCSignalingCapabilitiesReport2 = class extends _classSuper {
    static {
      __name(this, "BarrierOperatorCCSignalingCapabilitiesReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BarrierOperatorCCSignalingCapabilitiesReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportedSubsystemTypes = options.supportedSubsystemTypes;
    }
    static from(raw, ctx) {
      const supportedSubsystemTypes = (0, import_core.parseBitMask)(raw.payload, import_Types.SubsystemType.Audible);
      return new this({
        nodeId: ctx.sourceNodeId,
        supportedSubsystemTypes
      });
    }
    supportedSubsystemTypes;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "supported types": this.supportedSubsystemTypes.map((t) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_Types.SubsystemType, t)}`).join("")
        }
      };
    }
  };
  return BarrierOperatorCCSignalingCapabilitiesReport2 = _classThis;
})();
let BarrierOperatorCCSignalingCapabilitiesGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.BarrierOperatorCommand.SignalingCapabilitiesGet), (0, import_CommandClassDecorators.expectedCCResponse)(BarrierOperatorCCSignalingCapabilitiesReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = BarrierOperatorCC;
  var BarrierOperatorCCSignalingCapabilitiesGet2 = class extends _classSuper {
    static {
      __name(this, "BarrierOperatorCCSignalingCapabilitiesGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BarrierOperatorCCSignalingCapabilitiesGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return BarrierOperatorCCSignalingCapabilitiesGet2 = _classThis;
})();
let BarrierOperatorCCEventSignalingSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.BarrierOperatorCommand.EventSignalingSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = BarrierOperatorCC;
  var BarrierOperatorCCEventSignalingSet2 = class extends _classSuper {
    static {
      __name(this, "BarrierOperatorCCEventSignalingSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BarrierOperatorCCEventSignalingSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.subsystemType = options.subsystemType;
      this.subsystemState = options.subsystemState;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    subsystemType;
    subsystemState;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.subsystemType, this.subsystemState]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "subsystem type": (0, import_shared.getEnumMemberName)(import_Types.SubsystemType, this.subsystemType),
          "subsystem state": (0, import_shared.getEnumMemberName)(import_Types.SubsystemState, this.subsystemState)
        }
      };
    }
  };
  return BarrierOperatorCCEventSignalingSet2 = _classThis;
})();
let BarrierOperatorCCEventSignalingReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.BarrierOperatorCommand.EventSignalingReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = BarrierOperatorCC;
  var BarrierOperatorCCEventSignalingReport2 = class extends _classSuper {
    static {
      __name(this, "BarrierOperatorCCEventSignalingReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BarrierOperatorCCEventSignalingReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.subsystemType = options.subsystemType;
      this.subsystemState = options.subsystemState;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const subsystemType = raw.payload[0];
      const subsystemState = raw.payload[1];
      return new this({
        nodeId: ctx.sourceNodeId,
        subsystemType,
        subsystemState
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const signalingStateValue = import_CCValues_generated.BarrierOperatorCCValues.signalingState(this.subsystemType);
      this.ensureMetadata(ctx, signalingStateValue);
      this.setValue(ctx, signalingStateValue, this.subsystemState);
      return true;
    }
    subsystemType;
    subsystemState;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "subsystem type": (0, import_shared.getEnumMemberName)(import_Types.SubsystemType, this.subsystemType),
          "subsystem state": (0, import_shared.getEnumMemberName)(import_Types.SubsystemState, this.subsystemState)
        }
      };
    }
  };
  return BarrierOperatorCCEventSignalingReport2 = _classThis;
})();
let BarrierOperatorCCEventSignalingGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.BarrierOperatorCommand.EventSignalingGet), (0, import_CommandClassDecorators.expectedCCResponse)(BarrierOperatorCCEventSignalingReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = BarrierOperatorCC;
  var BarrierOperatorCCEventSignalingGet2 = class extends _classSuper {
    static {
      __name(this, "BarrierOperatorCCEventSignalingGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      BarrierOperatorCCEventSignalingGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.subsystemType = options.subsystemType;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    subsystemType;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.subsystemType]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "subsystem type": (0, import_shared.getEnumMemberName)(import_Types.SubsystemType, this.subsystemType)
        }
      };
    }
  };
  return BarrierOperatorCCEventSignalingGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  BarrierOperatorCC,
  BarrierOperatorCCAPI,
  BarrierOperatorCCEventSignalingGet,
  BarrierOperatorCCEventSignalingReport,
  BarrierOperatorCCEventSignalingSet,
  BarrierOperatorCCGet,
  BarrierOperatorCCReport,
  BarrierOperatorCCSet,
  BarrierOperatorCCSignalingCapabilitiesGet,
  BarrierOperatorCCSignalingCapabilitiesReport,
  BarrierOperatorCCValues
});
//# sourceMappingURL=BarrierOperatorCC.js.map
