"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ConfigurationCC_exports = {};
__export(ConfigurationCC_exports, {
  ConfigurationCC: () => ConfigurationCC,
  ConfigurationCCAPI: () => ConfigurationCCAPI,
  ConfigurationCCBulkGet: () => ConfigurationCCBulkGet,
  ConfigurationCCBulkReport: () => ConfigurationCCBulkReport,
  ConfigurationCCBulkSet: () => ConfigurationCCBulkSet,
  ConfigurationCCDefaultReset: () => ConfigurationCCDefaultReset,
  ConfigurationCCError: () => ConfigurationCCError,
  ConfigurationCCGet: () => ConfigurationCCGet,
  ConfigurationCCInfoGet: () => ConfigurationCCInfoGet,
  ConfigurationCCInfoReport: () => ConfigurationCCInfoReport,
  ConfigurationCCNameGet: () => ConfigurationCCNameGet,
  ConfigurationCCNameReport: () => ConfigurationCCNameReport,
  ConfigurationCCPropertiesGet: () => ConfigurationCCPropertiesGet,
  ConfigurationCCPropertiesReport: () => ConfigurationCCPropertiesReport,
  ConfigurationCCReport: () => ConfigurationCCReport,
  ConfigurationCCSet: () => ConfigurationCCSet,
  ConfigurationCCValues: () => import_CCValues_generated.ConfigurationCCValues,
  refreshMetadataStringsFromConfigFile: () => refreshMetadataStringsFromConfigFile
});
module.exports = __toCommonJS(ConfigurationCC_exports);
var __validateArgs = __toESM(require("./ConfigurationCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_arrays = require("alcalzone-shared/arrays");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_ConfigurationCCAPI_get, validateArgs_ConfigurationCCAPI_getBulk, validateArgs_ConfigurationCCAPI_set, validateArgs_ConfigurationCCAPI_setBulk, validateArgs_ConfigurationCCAPI_reset, validateArgs_ConfigurationCCAPI_resetBulk, validateArgs_ConfigurationCCAPI_getProperties, validateArgs_ConfigurationCCAPI_getName, validateArgs_ConfigurationCCAPI_getInfo } = __validateArgs;
function configValueToString(value) {
  if (typeof value === "number")
    return value.toString();
  else
    return [...value].join(", ");
}
__name(configValueToString, "configValueToString");
class ConfigurationCCError extends import_core.ZWaveError {
  static {
    __name(this, "ConfigurationCCError");
  }
  message;
  code;
  argument;
  constructor(message, code, argument) {
    super(message, code);
    this.message = message;
    this.code = code;
    this.argument = argument;
    Object.setPrototypeOf(this, ConfigurationCCError.prototype);
  }
}
function createConfigurationCCInstance(endpoint) {
  return import_CommandClass.CommandClass.createInstanceUnchecked(endpoint.virtual ? endpoint.node.physicalNodes[0] : endpoint, ConfigurationCC);
}
__name(createConfigurationCCInstance, "createConfigurationCCInstance");
function normalizeConfigurationCCAPISetOptions(ctx, endpoint, options) {
  if ("bitMask" in options && options.bitMask) {
    const ccc = createConfigurationCCInstance(endpoint);
    const paramInfo = ccc.getParamInformation(ctx, options.parameter, options.bitMask);
    if (!paramInfo.isFromConfig) {
      throw new import_core.ZWaveError("Setting a partial configuration parameter requires it to be defined in a device config file!", import_core.ZWaveErrorCodes.Argument_Invalid);
    }
    return {
      parameter: options.parameter,
      bitMask: options.bitMask,
      value: options.value,
      valueSize: paramInfo.valueSize,
      valueFormat: paramInfo.format
    };
  } else if ("valueSize" in options) {
    return (0, import_shared.pick)(options, [
      "parameter",
      "value",
      "valueSize",
      "valueFormat"
    ]);
  } else {
    const ccc = createConfigurationCCInstance(endpoint);
    const paramInfo = ccc.getParamInformation(ctx, options.parameter, options.bitMask);
    if (!paramInfo.isFromConfig) {
      throw new import_core.ZWaveError("Setting a configuration parameter without specifying a value size and format requires it to be defined in a device config file!", import_core.ZWaveErrorCodes.Argument_Invalid);
    }
    return {
      parameter: options.parameter,
      value: options.value,
      valueSize: paramInfo.valueSize,
      valueFormat: paramInfo.format
    };
  }
}
__name(normalizeConfigurationCCAPISetOptions, "normalizeConfigurationCCAPISetOptions");
function bulkMergePartialParamValues(ctx, endpoint, options) {
  const allParams = options.filter((o) => o.bitMask == void 0);
  const unmergedPartials = /* @__PURE__ */ new Map();
  for (const partial of options.filter((o) => o.bitMask != void 0)) {
    if (!unmergedPartials.has(partial.parameter)) {
      unmergedPartials.set(partial.parameter, []);
    }
    unmergedPartials.get(partial.parameter).push(partial);
  }
  if (unmergedPartials.size) {
    const ccc = createConfigurationCCInstance(endpoint);
    for (const [parameter, partials] of unmergedPartials) {
      allParams.push({
        parameter,
        value: ccc.composePartialParamValues(ctx, parameter, partials.map((p) => ({
          bitMask: p.bitMask,
          partialValue: p.value
        }))),
        valueSize: partials[0].valueSize,
        valueFormat: partials[0].valueFormat
      });
    }
  }
  return allParams;
}
__name(bulkMergePartialParamValues, "bulkMergePartialParamValues");
function isSignedPartial(bitMask, format) {
  return (0, import_core.getBitMaskWidth)(bitMask) > 1 && (format ?? import_core.ConfigValueFormat.SignedInteger) === import_core.ConfigValueFormat.SignedInteger;
}
__name(isSignedPartial, "isSignedPartial");
function reInterpretSignedValue(value, valueSize, targetFormat) {
  const raw = new import_shared.Bytes(valueSize);
  serializeValue(raw, 0, valueSize, import_core.ConfigValueFormat.SignedInteger, value);
  return parseValue(raw, valueSize, targetFormat);
}
__name(reInterpretSignedValue, "reInterpretSignedValue");
function getParamInformationFromConfigFile(ctx, nodeId, endpointIndex) {
  const deviceConfig = ctx.getDeviceConfig?.(nodeId);
  if (endpointIndex === 0) {
    return deviceConfig?.paramInformation ?? deviceConfig?.endpoints?.get(0)?.paramInformation;
  } else {
    return deviceConfig?.endpoints?.get(endpointIndex)?.paramInformation;
  }
}
__name(getParamInformationFromConfigFile, "getParamInformationFromConfigFile");
function refreshMetadataStringsFromConfigFile(ctx, nodeId, endpointIndex) {
  const paramInfo = getParamInformationFromConfigFile(ctx, nodeId, endpointIndex);
  if (!paramInfo)
    return;
  const valueDB = ctx.getValueDB(nodeId);
  for (const [param, info] of paramInfo.entries()) {
    const valueId = import_CCValues_generated.ConfigurationCCValues.paramInformation(param.parameter, param.valueBitMask).endpoint(endpointIndex);
    const existing = valueDB.getMetadata(valueId);
    if (!existing)
      continue;
    if (!existing.isFromConfig)
      continue;
    let didChange = false;
    if (info.label !== existing.label) {
      existing.label = info.label;
      didChange = true;
    }
    if (info.description !== existing.description) {
      existing.description = info.description;
      didChange = true;
    }
    if (info.recommendedValue !== existing.recommended) {
      existing.recommended = info.recommendedValue;
      didChange = true;
    }
    if (existing.states) {
      for (const option of info.options) {
        if (option.value in existing.states && existing.states[option.value] !== option.label) {
          existing.states[option.value] = option.label;
          didChange = true;
        }
      }
    }
    if (didChange)
      valueDB.setMetadata(valueId, existing);
  }
}
__name(refreshMetadataStringsFromConfigFile, "refreshMetadataStringsFromConfigFile");
let ConfigurationCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses.Configuration)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _get_decorators;
  let _getBulk_decorators;
  let _set_decorators;
  let _setBulk_decorators;
  let _reset_decorators;
  let _resetBulk_decorators;
  let _getProperties_decorators;
  let _getName_decorators;
  let _getInfo_decorators;
  var ConfigurationCCAPI2 = class extends _classSuper {
    static {
      __name(this, "ConfigurationCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _get_decorators = [validateArgs_ConfigurationCCAPI_get()];
      _getBulk_decorators = [validateArgs_ConfigurationCCAPI_getBulk()];
      _set_decorators = [validateArgs_ConfigurationCCAPI_set({ strictEnums: true })];
      _setBulk_decorators = [validateArgs_ConfigurationCCAPI_setBulk({ strictEnums: true })];
      _reset_decorators = [validateArgs_ConfigurationCCAPI_reset()];
      _resetBulk_decorators = [validateArgs_ConfigurationCCAPI_resetBulk()];
      _getProperties_decorators = [validateArgs_ConfigurationCCAPI_getProperties()];
      _getName_decorators = [validateArgs_ConfigurationCCAPI_getName()];
      _getInfo_decorators = [validateArgs_ConfigurationCCAPI_getInfo()];
      __esDecorate(this, null, _get_decorators, { kind: "method", name: "get", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "get" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.get, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getBulk_decorators, { kind: "method", name: "getBulk", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getBulk" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getBulk, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _set_decorators, { kind: "method", name: "set", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "set" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.set, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _setBulk_decorators, { kind: "method", name: "setBulk", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setBulk" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setBulk, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _reset_decorators, { kind: "method", name: "reset", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "reset" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.reset, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _resetBulk_decorators, { kind: "method", name: "resetBulk", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "resetBulk" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.resetBulk, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getProperties_decorators, { kind: "method", name: "getProperties", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getProperties" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getProperties, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getName_decorators, { kind: "method", name: "getName", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getName" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getName, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getInfo_decorators, { kind: "method", name: "getInfo", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getInfo" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getInfo, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ConfigurationCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.ConfigurationCommand.Get:
        case import_Types.ConfigurationCommand.Set:
          return true;
        // This is mandatory
        case import_Types.ConfigurationCommand.BulkGet:
        case import_Types.ConfigurationCommand.BulkSet:
          return this.version >= 2;
        case import_Types.ConfigurationCommand.NameGet:
        case import_Types.ConfigurationCommand.InfoGet:
        case import_Types.ConfigurationCommand.PropertiesGet:
          return this.version >= 3;
        case import_Types.ConfigurationCommand.DefaultReset:
          return this.version >= 4;
      }
      return super.supportsCommand(cmd);
    }
    get [import_API.SET_VALUE]() {
      return async function({ property, propertyKey }, value) {
        if (typeof property !== "number") {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
        if (propertyKey != void 0 && typeof propertyKey !== "number") {
          (0, import_API.throwUnsupportedPropertyKey)(this.ccId, property, propertyKey);
        }
        if (typeof value !== "number") {
          (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
        }
        let ccInstance;
        const applHost = this.host;
        if (this.isSinglecast()) {
          ccInstance = createConfigurationCCInstance(this.endpoint);
        } else if (this.isMulticast()) {
          const nodes = this.endpoint.node.physicalNodes;
          if (!nodes.every((node) => node.getEndpoint(this.endpoint.index)?.supportsCC(import_core.CommandClasses.Configuration))) {
            throw new import_core.ZWaveError(`The multicast setValue API for Configuration CC requires all virtual target endpoints to support Configuration CC!`, import_core.ZWaveErrorCodes.CC_Invalid);
          }
          const paramInfos = this.endpoint.node.physicalNodes.map((node) => createConfigurationCCInstance(node.getEndpoint(this.endpoint.index)).getParamInformation(this.host, property, propertyKey));
          if (!paramInfos.length || !paramInfos.every((info, index) => {
            if (index === 0)
              return true;
            return info.valueSize === paramInfos[0].valueSize && info.format === paramInfos[0].format;
          })) {
            throw new import_core.ZWaveError(`The multicast setValue API for Configuration CC requires all virtual target nodes to have the same parameter definition!`, import_core.ZWaveErrorCodes.CC_Invalid);
          }
          ccInstance = createConfigurationCCInstance(this.endpoint);
        } else {
          throw new import_core.ZWaveError(`The setValue API for Configuration CC is not supported via broadcast!`, import_core.ZWaveErrorCodes.CC_NotSupported);
        }
        let { valueSize, format: valueFormat = import_core.ConfigValueFormat.SignedInteger } = ccInstance.getParamInformation(applHost, property);
        let targetValue;
        if (propertyKey) {
          if (!valueSize) {
            valueSize = ccInstance.getParamInformation(applHost, property, propertyKey).valueSize;
          }
          targetValue = ccInstance.composePartialParamValue(applHost, property, propertyKey, value);
          valueFormat = import_core.ConfigValueFormat.UnsignedInteger;
        } else {
          targetValue = value;
        }
        if (!valueSize) {
          valueSize = (0, import_core.getMinIntegerSize)(targetValue, valueFormat === import_core.ConfigValueFormat.SignedInteger);
          if (!valueSize) {
            throw new import_core.ZWaveError(`The value ${targetValue} is not valid for configuration parameters!`, import_core.ZWaveErrorCodes.Argument_Invalid);
          }
        }
        if (!isSafeValue(targetValue, valueSize, valueFormat)) {
          throwInvalidValueError(targetValue, property, valueSize, valueFormat);
        }
        const result = await this.set({
          parameter: property,
          value: targetValue,
          valueSize,
          valueFormat
        });
        if (!(0, import_core.supervisedCommandSucceeded)(result) && this.isSinglecast()) {
          this.schedulePoll(
            { property, propertyKey },
            targetValue,
            // Configuration changes are instant
            { transition: "fast" }
          );
        }
        return result;
      };
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property, propertyKey }) {
        if (typeof property !== "number") {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
        if (propertyKey != void 0 && typeof propertyKey !== "number") {
          (0, import_API.throwUnsupportedPropertyKey)(this.ccId, property, propertyKey);
        }
        return this.get(property, { valueBitMask: propertyKey });
      };
    }
    /**
     * Requests the current value of a given config parameter from the device.
     * This may timeout and return `undefined` if the node does not respond.
     * If the node replied with a different parameter number, a `ConfigurationCCError`
     * is thrown with the `argument` property set to the reported parameter number.
     */
    async get(parameter, options) {
      this.assertPhysicalEndpoint(this.endpoint);
      if (parameter > 255) {
        const result = await this.getBulk([
          {
            parameter,
            bitMask: options?.valueBitMask
          }
        ]);
        return result.find((r) => r.parameter === parameter)?.value;
      }
      this.assertSupportsCommand(import_Types.ConfigurationCommand, import_Types.ConfigurationCommand.Get);
      const { valueBitMask, allowUnexpectedResponse } = options ?? {};
      const cc = new ConfigurationCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        parameter,
        allowUnexpectedResponse
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (!response)
        return;
      if (response.parameter === parameter) {
        if (!valueBitMask)
          return response.value;
        const paramInfo = cc.getParamInformation(this.host, response.parameter, valueBitMask);
        return (0, import_core.parsePartial)(response.value, valueBitMask, isSignedPartial(valueBitMask, paramInfo.format));
      }
      this.host.logNode(this.endpoint.nodeId, {
        endpoint: this.endpoint.index,
        message: `Received unexpected ConfigurationReport (param = ${response.parameter}, value = ${response.value.toString()})`,
        direction: "inbound",
        level: "error"
      });
      throw new ConfigurationCCError(`The first existing parameter on this node is ${response.parameter}`, import_core.ZWaveErrorCodes.ConfigurationCC_FirstParameterNumber, response.parameter);
    }
    /**
     * Requests the current value of the config parameters from the device.
     * When the node does not respond due to a timeout, the `value` in the returned array will be `undefined`.
     */
    async getBulk(options) {
      this.assertPhysicalEndpoint(this.endpoint);
      let values;
      const distinctParameters = (0, import_arrays.distinct)(options.map((o) => o.parameter));
      if (this.supportsCommand(import_Types.ConfigurationCommand.BulkGet) && (0, import_core.isConsecutiveArray)(distinctParameters)) {
        const cc2 = new ConfigurationCCBulkGet({
          nodeId: this.endpoint.nodeId,
          endpointIndex: this.endpoint.index,
          parameters: distinctParameters
        });
        const response = await this.host.sendCommand(cc2, this.commandOptions);
        if (response)
          values = response.values;
      } else {
        this.assertSupportsCommand(import_Types.ConfigurationCommand, import_Types.ConfigurationCommand.Get);
        const _values = /* @__PURE__ */ new Map();
        for (const parameter of distinctParameters) {
          const cc2 = new ConfigurationCCGet({
            nodeId: this.endpoint.nodeId,
            endpointIndex: this.endpoint.index,
            parameter
          });
          const response = await this.host.sendCommand(cc2, this.commandOptions);
          if (response) {
            _values.set(response.parameter, response.value);
          }
        }
        values = _values;
      }
      const cc = createConfigurationCCInstance(this.endpoint);
      return options.map((o) => {
        let value = values?.get(o.parameter);
        if (typeof value === "number" && o.bitMask) {
          const paramInfo = cc.getParamInformation(this.host, o.parameter, o.bitMask);
          value = (0, import_core.parsePartial)(value, o.bitMask, isSignedPartial(o.bitMask, paramInfo.format));
        }
        return { ...o, value };
      });
    }
    /**
     * Sets a new value for a given config parameter of the device.
     */
    async set(options) {
      if (options.parameter > 255) {
        return this.setBulk([options]);
      }
      this.assertSupportsCommand(import_Types.ConfigurationCommand, import_Types.ConfigurationCommand.Set);
      const normalized = normalizeConfigurationCCAPISetOptions(this.host, this.endpoint, options);
      let value = normalized.value;
      if (normalized.bitMask) {
        const ccc = createConfigurationCCInstance(this.endpoint);
        value = ccc.composePartialParamValue(this.host, normalized.parameter, normalized.bitMask, normalized.value);
      }
      const cc = new ConfigurationCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        resetToDefault: false,
        parameter: normalized.parameter,
        value,
        valueSize: normalized.valueSize,
        valueFormat: normalized.valueFormat
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    /**
     * Sets new values for multiple config parameters of the device. Uses the `BulkSet` command if supported, otherwise falls back to individual `Set` commands.
     */
    async setBulk(values) {
      const normalized = values.map((v) => normalizeConfigurationCCAPISetOptions(this.host, this.endpoint, v));
      const allParams = bulkMergePartialParamValues(this.host, this.endpoint, normalized);
      const canUseBulkSet = this.supportsCommand(import_Types.ConfigurationCommand.BulkSet) && (0, import_core.isConsecutiveArray)(allParams.map((v) => v.parameter)) && new Set(allParams.map((v) => v.valueFormat)).size === 1 && new Set(allParams.map((v) => v.valueSize)).size === 1;
      if (canUseBulkSet) {
        const cc = new ConfigurationCCBulkSet({
          nodeId: this.endpoint.nodeId,
          endpointIndex: this.endpoint.index,
          parameters: allParams.map((v) => v.parameter),
          valueSize: allParams[0].valueSize,
          valueFormat: allParams[0].valueFormat,
          values: allParams.map((v) => v.value),
          handshake: true
        });
        const result = await this.host.sendCommand(cc, this.commandOptions);
        if (result) {
          const sentValues = cc.values;
          const receivedValues = [...result.values.values()];
          const success = sentValues.length === receivedValues.length && sentValues.every((v, i) => v === receivedValues[i]);
          return {
            status: success ? import_core.SupervisionStatus.Success : import_core.SupervisionStatus.Fail
          };
        } else {
          return void 0;
        }
      } else {
        this.assertSupportsCommand(import_Types.ConfigurationCommand, import_Types.ConfigurationCommand.Set);
        const supervisionResults = [];
        for (const { parameter, value, valueSize, valueFormat } of allParams) {
          const cc = new ConfigurationCCSet({
            nodeId: this.endpoint.nodeId,
            endpointIndex: this.endpoint.index,
            parameter,
            value,
            valueSize,
            valueFormat
          });
          supervisionResults.push(await this.host.sendCommand(cc, this.commandOptions));
        }
        return (0, import_core.mergeSupervisionResults)(supervisionResults);
      }
    }
    /**
     * Resets a configuration parameter to its default value.
     *
     * WARNING: This will throw on legacy devices (ConfigurationCC v3 and below)
     */
    async reset(parameter) {
      if (parameter > 255) {
        return this.resetBulk([parameter]);
      }
      if (this.version <= 3) {
        throw new import_core.ZWaveError(`Resetting configuration parameters to default MUST not be done on nodes implementing ConfigurationCC V3 or below!`, import_core.ZWaveErrorCodes.ConfigurationCC_NoResetToDefaultOnLegacyDevices);
      }
      this.assertSupportsCommand(import_Types.ConfigurationCommand, import_Types.ConfigurationCommand.Set);
      const cc = new ConfigurationCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        parameter,
        resetToDefault: true
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    /**
     * Resets multiple configuration parameters to their default value. Uses BulkSet if supported, otherwise falls back to individual Set commands.
     *
     * WARNING: This will throw on legacy devices (ConfigurationCC v3 and below)
     */
    async resetBulk(parameters) {
      if ((0, import_core.isConsecutiveArray)(parameters) && this.supportsCommand(import_Types.ConfigurationCommand.BulkSet)) {
        const cc = new ConfigurationCCBulkSet({
          nodeId: this.endpoint.nodeId,
          endpointIndex: this.endpoint.index,
          parameters,
          resetToDefault: true
        });
        return this.host.sendCommand(cc, this.commandOptions);
      } else {
        this.assertSupportsCommand(import_Types.ConfigurationCommand, import_Types.ConfigurationCommand.Set);
        const CCs = (0, import_arrays.distinct)(parameters).map((parameter) => new ConfigurationCCSet({
          nodeId: this.endpoint.nodeId,
          endpointIndex: this.endpoint.index,
          parameter,
          resetToDefault: true
        }));
        for (const cc of CCs) {
          await this.host.sendCommand(cc, this.commandOptions);
        }
      }
    }
    /** Resets all configuration parameters to their default value */
    async resetAll() {
      this.assertPhysicalEndpoint(this.endpoint);
      this.assertSupportsCommand(import_Types.ConfigurationCommand, import_Types.ConfigurationCommand.DefaultReset);
      const cc = new ConfigurationCCDefaultReset({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      await this.host.sendCommand(cc, this.commandOptions);
    }
    async getProperties(parameter) {
      this.assertPhysicalEndpoint(this.endpoint);
      const cc = new ConfigurationCCPropertiesGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        parameter
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "valueSize",
          "valueFormat",
          "minValue",
          "maxValue",
          "defaultValue",
          "nextParameter",
          "altersCapabilities",
          "isReadonly",
          "isAdvanced",
          "noBulkSupport"
        ]);
      }
    }
    /** Requests the name of a configuration parameter from the node */
    async getName(parameter) {
      this.assertPhysicalEndpoint(this.endpoint);
      const cc = new ConfigurationCCNameGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        parameter
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.name;
    }
    /** Requests usage info for a configuration parameter from the node */
    async getInfo(parameter) {
      this.assertPhysicalEndpoint(this.endpoint);
      const cc = new ConfigurationCCInfoGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        parameter
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.info;
    }
    /**
     * This scans the node for the existing parameters. Found parameters will be reported
     * through the `value added` and `value updated` events.
     *
     * WARNING: This method throws for newer devices.
     *
     * WARNING: On nodes implementing V1 and V2, this process may take
     * **up to an hour**, depending on the configured timeout.
     *
     * WARNING: On nodes implementing V2, all parameters after 255 will be ignored.
     */
    async scanParametersLegacy() {
      if (this.version >= 3) {
        throw new import_core.ZWaveError("Use ConfigurationCC.interview instead of scanning parameters for versions 3 and above.", import_core.ZWaveErrorCodes.ConfigurationCC_NoLegacyScanOnNewDevices);
      }
      this.assertPhysicalEndpoint(this.endpoint);
      this.host.logNode(this.endpoint.nodeId, {
        endpoint: this.endpoint.index,
        message: `Scanning available parameters...`
      });
      const ccInstance = createConfigurationCCInstance(this.endpoint);
      for (let param = 1; param <= 255; param++) {
        let originalValue;
        this.host.logNode(this.endpoint.nodeId, {
          endpoint: this.endpoint.index,
          message: `  trying param ${param}...`,
          direction: "outbound"
        });
        try {
          originalValue = await this.get(param, {
            // When requesting a non-existing parameter, a node SHOULD respond with the
            // first available parameter. We use this for the first param only,
            // because delayed responses might otherwise confuse the interview process
            allowUnexpectedResponse: param === 1
          });
          if (originalValue != void 0) {
            const logMessage = `  Param ${param}:
    readable  = true
    valueSize = ${ccInstance.getParamInformation(this.host, param).valueSize}
    value     = ${originalValue.toString()}`;
            this.host.logNode(this.endpoint.nodeId, {
              endpoint: this.endpoint.index,
              message: logMessage,
              direction: "inbound"
            });
          }
        } catch (e) {
          if (e instanceof ConfigurationCCError && e.code === import_core.ZWaveErrorCodes.ConfigurationCC_FirstParameterNumber) {
            if (e.argument - 1 > param)
              param = e.argument - 1;
            continue;
          }
          throw e;
        }
      }
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return ConfigurationCCAPI2 = _classThis;
})();
let ConfigurationCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses.Configuration), (0, import_CommandClassDecorators.implementedVersion)(4), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.ConfigurationCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var ConfigurationCC2 = class extends _classSuper {
    static {
      __name(this, "ConfigurationCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ConfigurationCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses.Configuration, ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      const deviceConfig = ctx.getDeviceConfig?.(node.id);
      const paramInfo = getParamInformationFromConfigFile(ctx, node.id, this.endpointIndex);
      if (paramInfo) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `${this.constructor.name}: Loading configuration parameters from device config`,
          direction: "none"
        });
        this.deserializeParamInformationFromConfig(ctx, paramInfo);
      }
      const documentedParamNumbers = new Set(Array.from(paramInfo?.keys() ?? []).map((k) => k.parameter));
      if (api.version >= 3) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "finding first configuration parameter...",
          direction: "outbound"
        });
        const param0props = await api.getProperties(0);
        let param;
        if (param0props) {
          param = param0props.nextParameter;
          if (param === 0) {
            ctx.logNode(node.id, {
              endpoint: this.endpointIndex,
              message: `didn't report any config params, trying #1 just to be sure...`,
              direction: "inbound"
            });
            param = 1;
          }
        } else {
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: "Finding first configuration parameter timed out, skipping interview...",
            level: "warn"
          });
          return;
        }
        while (param > 0) {
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `querying parameter #${param} information...`,
            direction: "outbound"
          });
          const props = await api.getProperties(param).catch(
            // If querying the properties fails, don't abort the entire interview
            () => void 0
          );
          if (!props) {
            ctx.logNode(node.id, {
              endpoint: this.endpointIndex,
              message: `Querying parameter #${param} information timed out, skipping scan...`,
              level: "warn"
            });
            break;
          }
          const { nextParameter, ...properties } = props;
          let logMessage;
          if (properties.valueSize === 0) {
            logMessage = `Parameter #${param} is unsupported. Next parameter: ${nextParameter}`;
          } else {
            let name;
            if (!documentedParamNumbers.has(param)) {
              if (!deviceConfig?.compat?.skipConfigurationNameQuery) {
                name = await api.getName(param).catch(
                  // If querying the name fails, don't abort the entire interview
                  () => void 0
                );
              }
              if (!deviceConfig?.compat?.skipConfigurationInfoQuery) {
                await api.getInfo(param).catch(
                  // If querying the info fails, don't abort the entire interview
                  () => void 0
                );
              }
            }
            logMessage = `received information for parameter #${param}:`;
            if (name) {
              logMessage += `
parameter name:      ${name}`;
            }
            logMessage += `
value format:        ${(0, import_shared.getEnumMemberName)(import_core.ConfigValueFormat, properties.valueFormat)}
value size:          ${properties.valueSize} bytes
min value:           ${properties.minValue?.toString() ?? "undefined"}
max value:           ${properties.maxValue?.toString() ?? "undefined"}
default value:       ${properties.defaultValue?.toString() ?? "undefined"}
is read-only:        ${!!properties.isReadonly}
is advanced (UI):    ${!!properties.isAdvanced}
has bulk support:    ${!properties.noBulkSupport}
alters capabilities: ${!!properties.altersCapabilities}`;
          }
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage,
            direction: "inbound"
          });
          if (nextParameter > param) {
            param = nextParameter;
          } else {
            break;
          }
        }
      }
      await this.refreshValues(ctx);
      if (paramInfo !== void 0 && ctx.getInterviewOptions().applyRecommendedConfigParamValues === true) {
        await this.applyRecommendedValues(ctx, node, paramInfo, api);
      }
      this.setInterviewComplete(ctx, true);
    }
    /**
     * Applies all recommended values from the device config to this node
     * Applies only if the current value is still the default value and
     * the recommended value is different
     */
    async applyRecommendedValues(ctx, node, paramInfo, api) {
      const parametersNeededUpdate = [];
      for (const [paramKey, param] of paramInfo) {
        if (param.recommendedValue === void 0 || param.defaultValue === param.recommendedValue)
          continue;
        const currentValue = this.getValue(ctx, import_CCValues_generated.ConfigurationCCValues.paramInformation(paramKey.parameter, paramKey.valueBitMask));
        if (currentValue === param.defaultValue && currentValue !== param.recommendedValue) {
          const baseParam = {
            parameter: paramKey.parameter,
            value: param.recommendedValue
          };
          parametersNeededUpdate.push(param.valueBitMask !== void 0 ? { ...baseParam, bitMask: param.valueBitMask } : baseParam);
        }
      }
      if (parametersNeededUpdate.length === 0)
        return;
      let message = `Applying recommended config parameter values during interview:`;
      for (const param of parametersNeededUpdate) {
        const formatterBitMask = param.bitMask ? `[0x${(0, import_shared.num2hex)(param.bitMask)}]` : "";
        const fullParamKey = `${param.parameter}${formatterBitMask}`;
        message += `
\xB7 #${fullParamKey} => ${param.value}`;
      }
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message,
        direction: "none"
      });
      await api.setBulk(parametersNeededUpdate);
      await api.getBulk(parametersNeededUpdate.map((param) => ({
        parameter: param.parameter,
        bitMask: param.bitMask
      })));
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses.Configuration, ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      if (api.version < 3) {
        const paramInfo = getParamInformationFromConfigFile(ctx, node.id, this.endpointIndex);
        if (paramInfo?.size) {
          const alreadyQueried = /* @__PURE__ */ new Set();
          for (const param of paramInfo.keys()) {
            if (paramInfo.get(param)?.writeOnly)
              continue;
            if (alreadyQueried.has(param.parameter))
              continue;
            alreadyQueried.add(param.parameter);
            ctx.logNode(node.id, {
              endpoint: this.endpointIndex,
              message: `querying parameter #${param.parameter} value...`,
              direction: "outbound"
            });
            const paramValue = await api.get(param.parameter);
            if (typeof paramValue === "number") {
              ctx.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: `parameter #${param.parameter} has value: ${paramValue}`,
                direction: "inbound"
              });
            } else if (!paramValue) {
              ctx.logNode(node.id, {
                endpoint: this.endpointIndex,
                message: `received no value for parameter #${param.parameter}`,
                direction: "inbound",
                level: "warn"
              });
            }
          }
        } else {
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: `${this.constructor.name}: skipping interview because CC version is < 3 and there is no config file`,
            direction: "none"
          });
        }
      } else {
        const parameters = (0, import_arrays.distinct)(this.getDefinedValueIDs(ctx).map((v) => v.property).filter((p) => typeof p === "number"));
        for (const param of parameters) {
          if (this.getParamInformation(ctx, param).readable !== false) {
            ctx.logNode(node.id, {
              endpoint: this.endpointIndex,
              message: `querying parameter #${param} value...`,
              direction: "outbound"
            });
            await api.get(param);
          } else {
            ctx.logNode(node.id, {
              endpoint: this.endpointIndex,
              message: `not querying parameter #${param} value, because it is writeonly`,
              direction: "none"
            });
          }
        }
      }
    }
    /**
     * Whether this node's param information was loaded from a config file.
     * If this is true, we don't trust what the node reports
     */
    paramExistsInConfigFile(ctx, parameter, valueBitMask) {
      if (this.getValue(ctx, import_CCValues_generated.ConfigurationCCValues.isParamInformationFromConfig) !== true) {
        return false;
      }
      const paramInformation = getParamInformationFromConfigFile(ctx, this.nodeId, this.endpointIndex);
      if (!paramInformation)
        return false;
      if (paramInformation.has({ parameter, valueBitMask })) {
        return true;
      } else if (valueBitMask == void 0) {
        for (const key of paramInformation.keys()) {
          if (key.parameter === parameter)
            return true;
        }
      }
      return false;
    }
    /**
     * @internal
     * Stores config parameter metadata for this CC's node
     */
    extendParamInformation(ctx, parameter, valueBitMask, info) {
      if (valueBitMask === void 0 && this.paramExistsInConfigFile(ctx, parameter)) {
        return;
      }
      const metadata = this.getParamInformation(ctx, parameter, valueBitMask);
      Object.assign(metadata, info);
      this.setMetadata(ctx, import_CCValues_generated.ConfigurationCCValues.paramInformation(parameter, valueBitMask), metadata);
    }
    /**
     * @internal
     * Returns stored config parameter metadata for this CC's node
     */
    getParamInformation(ctx, parameter, valueBitMask) {
      return this.getMetadata(ctx, import_CCValues_generated.ConfigurationCCValues.paramInformation(parameter, valueBitMask)) ?? {
        ...import_core.ValueMetadata.Any
      };
    }
    /**
     * **INTERNAL:** Returns the param info that was queried for this node. This returns the information that was returned by the node
     * and does not include partial parameters.
     */
    getQueriedParamInfos(ctx) {
      const parameters = (0, import_arrays.distinct)(this.getDefinedValueIDs(ctx).map((v) => v.property).filter((p) => typeof p === "number"));
      return Object.fromEntries(parameters.map((p) => [
        p,
        this.getParamInformation(ctx, p)
      ]));
    }
    /**
     * Returns stored config parameter metadata for all partial config params addressed with the given parameter number
     */
    getPartialParamInfos(ctx, parameter) {
      const valueDB = this.getValueDB(ctx);
      return valueDB.findMetadata((id) => id.commandClass === this.ccId && (id.endpoint ?? 0) === this.endpointIndex && id.property === parameter && id.propertyKey != void 0);
    }
    /**
     * Computes the full value of a parameter after applying a partial param value
     */
    composePartialParamValue(ctx, parameter, bitMask, partialValue) {
      return this.composePartialParamValues(ctx, parameter, [
        { bitMask, partialValue }
      ]);
    }
    /**
     * Computes the full value of a parameter after applying multiple partial param values
     */
    composePartialParamValues(ctx, parameter, partials) {
      const valueDB = this.getValueDB(ctx);
      const otherValues = valueDB.findValues((id) => id.commandClass === this.ccId && (id.endpoint ?? 0) === this.endpointIndex && id.property === parameter && id.propertyKey != void 0 && !partials.some((p) => id.propertyKey === p.bitMask));
      let ret = 0;
      for (const { propertyKey: bitMask, value: partialValue } of otherValues) {
        ret = (0, import_core.encodePartial)(ret, partialValue, bitMask);
      }
      for (const { bitMask, partialValue } of partials) {
        ret = (0, import_core.encodePartial)(ret, partialValue, bitMask);
      }
      return ret;
    }
    /** Deserializes the config parameter info from a config file */
    deserializeParamInformationFromConfig(ctx, config) {
      const valueDB = this.getValueDB(ctx);
      for (const meta of valueDB.getAllMetadata(this.ccId)) {
        if (typeof meta.property === "number" && (meta.endpoint ?? 0) === this.endpointIndex) {
          valueDB.setMetadata(
            meta,
            void 0,
            // Don't emit the added/updated events, as this will spam applications with untranslated events
            { noEvent: true }
          );
        }
      }
      this.setValue(ctx, import_CCValues_generated.ConfigurationCCValues.isParamInformationFromConfig, false);
      for (const [param, info] of config.entries()) {
        const paramInfo = (0, import_core.stripUndefined)({
          // TODO: Make this smarter! (0...1 ==> boolean)
          type: "number",
          valueSize: info.valueSize,
          min: info.minValue,
          max: info.maxValue,
          default: info.defaultValue,
          recommended: info.recommendedValue,
          unit: info.unit,
          format: info.unsigned ? import_core.ConfigValueFormat.UnsignedInteger : import_core.ConfigValueFormat.SignedInteger,
          readable: !info.writeOnly,
          writeable: !info.readOnly,
          allowManualEntry: info.allowManualEntry,
          states: info.options.length > 0 ? Object.fromEntries(info.options.map(({ label, value }) => [
            value.toString(),
            label
          ])) : void 0,
          label: info.label,
          description: info.description,
          isFromConfig: true,
          destructive: info.destructive
        });
        this.extendParamInformation(ctx, param.parameter, param.valueBitMask, paramInfo);
      }
      this.setValue(ctx, import_CCValues_generated.ConfigurationCCValues.isParamInformationFromConfig, true);
    }
    translatePropertyKey(ctx, property, propertyKey) {
      if (typeof property === "number" && (propertyKey == void 0 || typeof propertyKey === "number")) {
        return void 0;
      }
      return super.translateProperty(ctx, property, propertyKey);
    }
    translateProperty(ctx, property, propertyKey) {
      if (typeof property === "number" && (propertyKey == void 0 || typeof propertyKey === "number")) {
        const paramInfo = this.getParamInformation(ctx, property, propertyKey);
        if (paramInfo.label)
          return paramInfo.label;
        let ret = `param${property.toString().padStart(3, "0")}`;
        if (propertyKey != void 0) {
          ret += "_" + propertyKey.toString();
        }
        return ret;
      }
      return super.translateProperty(ctx, property, propertyKey);
    }
  };
  return ConfigurationCC2 = _classThis;
})();
let ConfigurationCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ConfigurationCommand.Report)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ConfigurationCC;
  var ConfigurationCCReport2 = class extends _classSuper {
    static {
      __name(this, "ConfigurationCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ConfigurationCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.parameter = options.parameter;
      this.value = options.value;
      this.valueSize = options.valueSize;
      this.valueFormat = options.valueFormat;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length > 2);
      const parameter = raw.payload[0];
      const valueSize = raw.payload[1] & 7;
      (0, import_core.validatePayload)(valueSize >= 1, valueSize <= 4, raw.payload.length >= 2 + valueSize);
      const value = parseValue(raw.payload.subarray(2), valueSize, import_core.ConfigValueFormat.SignedInteger);
      return new this({
        nodeId: ctx.sourceNodeId,
        parameter,
        valueSize,
        value
      });
    }
    parameter;
    value;
    valueSize;
    valueFormat;
    // only used for serialization
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const ccVersion = (0, import_CommandClass.getEffectiveCCVersion)(ctx, this);
      const partialParams = this.getPartialParamInfos(ctx, this.parameter);
      let cachedValueFormat;
      if (partialParams.length > 0) {
        cachedValueFormat = partialParams[0].metadata.format;
      } else {
        const oldParamInformation = this.getParamInformation(ctx, this.parameter);
        cachedValueFormat = oldParamInformation.format;
        this.extendParamInformation(ctx, this.parameter, void 0, {
          valueSize: this.valueSize
        });
        if (ccVersion < 3 && !this.paramExistsInConfigFile(ctx, this.parameter) && oldParamInformation.min == void 0 && oldParamInformation.max == void 0) {
          const isSigned = oldParamInformation.format == void 0 || oldParamInformation.format === import_core.ConfigValueFormat.SignedInteger;
          this.extendParamInformation(ctx, this.parameter, void 0, (0, import_core.getIntegerLimits)(this.valueSize, isSigned));
        }
      }
      if (cachedValueFormat != void 0 && cachedValueFormat !== import_core.ConfigValueFormat.SignedInteger) {
        this.value = reInterpretSignedValue(this.value, this.valueSize, cachedValueFormat);
      }
      if (partialParams.length > 0) {
        for (const param of partialParams) {
          if (typeof param.propertyKey === "number") {
            this.setValue(ctx, import_CCValues_generated.ConfigurationCCValues.paramInformation(this.parameter, param.propertyKey), (0, import_core.parsePartial)(this.value, param.propertyKey, isSignedPartial(param.propertyKey, param.metadata.format)));
          }
        }
      } else {
        this.setValue(ctx, import_CCValues_generated.ConfigurationCCValues.paramInformation(this.parameter), this.value);
      }
      return true;
    }
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.parameter, this.valueSize & 7]),
        new import_shared.Bytes(this.valueSize)
      ]);
      serializeValue(this.payload, 2, this.valueSize, this.valueFormat ?? import_core.ConfigValueFormat.SignedInteger, this.value);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "parameter #": this.parameter,
          "value size": this.valueSize,
          value: configValueToString(this.value)
        }
      };
    }
  };
  return ConfigurationCCReport2 = _classThis;
})();
function testResponseForConfigurationGet(sent, received) {
  return sent.parameter === received.parameter || sent.allowUnexpectedResponse;
}
__name(testResponseForConfigurationGet, "testResponseForConfigurationGet");
let ConfigurationCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ConfigurationCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(ConfigurationCCReport, testResponseForConfigurationGet)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ConfigurationCC;
  var ConfigurationCCGet2 = class extends _classSuper {
    static {
      __name(this, "ConfigurationCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ConfigurationCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.parameter = options.parameter;
      this.allowUnexpectedResponse = options.allowUnexpectedResponse ?? false;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const parameter = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        parameter
      });
    }
    parameter;
    allowUnexpectedResponse;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.parameter]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "parameter #": this.parameter }
      };
    }
  };
  return ConfigurationCCGet2 = _classThis;
})();
let ConfigurationCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ConfigurationCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ConfigurationCC;
  var ConfigurationCCSet2 = class extends _classSuper {
    static {
      __name(this, "ConfigurationCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ConfigurationCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.parameter = options.parameter;
      this.resetToDefault = !!options.resetToDefault;
      if (!options.resetToDefault) {
        this.valueSize = options.valueSize;
        this.valueFormat = options.valueFormat ?? import_core.ConfigValueFormat.SignedInteger;
        this.value = options.value;
      }
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const parameter = raw.payload[0];
      const resetToDefault = !!(raw.payload[1] & 128);
      const valueSize = raw.payload[1] & 7;
      (0, import_core.validatePayload)(valueSize >= 1, valueSize <= 4, raw.payload.length >= 2 + valueSize);
      const value = parseValue(raw.payload.subarray(2), valueSize, import_core.ConfigValueFormat.SignedInteger);
      return new this({
        nodeId: ctx.sourceNodeId,
        parameter,
        resetToDefault,
        valueSize,
        value
      });
    }
    resetToDefault;
    parameter;
    valueSize;
    valueFormat;
    value;
    serialize(ctx) {
      const valueSize = this.resetToDefault ? 1 : this.valueSize;
      const payloadLength = 2 + valueSize;
      this.payload = import_shared.Bytes.alloc(payloadLength, 0);
      this.payload[0] = this.parameter;
      this.payload[1] = (this.resetToDefault ? 128 : 0) | valueSize & 7;
      if (!this.resetToDefault) {
        if (typeof this.value === "number" && !isSafeValue(this.value, valueSize, this.valueFormat)) {
          throwInvalidValueError(this.value, this.parameter, valueSize, this.valueFormat);
        }
        try {
          serializeValue(this.payload, 2, valueSize, this.valueFormat, this.value);
        } catch (e) {
          tryCatchOutOfBoundsError(e, this.value, this.parameter, valueSize, this.valueFormat);
        }
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "parameter #": this.parameter,
        "reset to default": this.resetToDefault
      };
      if (this.valueSize != void 0) {
        message["value size"] = this.valueSize;
      }
      if (this.valueFormat != void 0) {
        message["value format"] = (0, import_shared.getEnumMemberName)(import_core.ConfigValueFormat, this.valueFormat);
      }
      if (this.value != void 0) {
        message.value = configValueToString(this.value);
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return ConfigurationCCSet2 = _classThis;
})();
function getResponseForBulkSet(cc) {
  return cc.handshake ? ConfigurationCCBulkReport : void 0;
}
__name(getResponseForBulkSet, "getResponseForBulkSet");
let ConfigurationCCBulkSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ConfigurationCommand.BulkSet), (0, import_CommandClassDecorators.expectedCCResponse)(getResponseForBulkSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ConfigurationCC;
  var ConfigurationCCBulkSet2 = class extends _classSuper {
    static {
      __name(this, "ConfigurationCCBulkSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ConfigurationCCBulkSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this._parameters = options.parameters;
      if (this._parameters.length < 1) {
        throw new import_core.ZWaveError(`In a ConfigurationCC.BulkSet, parameters must be a non-empty array`, import_core.ZWaveErrorCodes.CC_Invalid);
      } else if (!(0, import_core.isConsecutiveArray)(this._parameters)) {
        throw new import_core.ZWaveError(`A ConfigurationCC.BulkSet can only be used for consecutive parameters`, import_core.ZWaveErrorCodes.CC_Invalid);
      }
      this._handshake = !!options.handshake;
      this._resetToDefault = !!options.resetToDefault;
      if (!!options.resetToDefault) {
        this._valueSize = 1;
        this._valueFormat = import_core.ConfigValueFormat.SignedInteger;
        this._values = this._parameters.map(() => 0);
      } else {
        this._valueSize = options.valueSize;
        this._valueFormat = options.valueFormat ?? import_core.ConfigValueFormat.SignedInteger;
        this._values = options.values;
      }
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    _parameters;
    get parameters() {
      return this._parameters;
    }
    _resetToDefault;
    get resetToDefault() {
      return this._resetToDefault;
    }
    _valueSize;
    get valueSize() {
      return this._valueSize;
    }
    _valueFormat;
    get valueFormat() {
      return this._valueFormat;
    }
    _values;
    get values() {
      return this._values;
    }
    _handshake;
    get handshake() {
      return this._handshake;
    }
    serialize(ctx) {
      const valueSize = this._resetToDefault ? 1 : this.valueSize;
      const payloadLength = 4 + valueSize * this.parameters.length;
      this.payload = import_shared.Bytes.alloc(payloadLength, 0);
      this.payload.writeUInt16BE(this.parameters[0], 0);
      this.payload[2] = this.parameters.length;
      this.payload[3] = (this._resetToDefault ? 128 : 0) | (this.handshake ? 64 : 0) | valueSize & 7;
      if (!this._resetToDefault) {
        for (let i = 0; i < this.parameters.length; i++) {
          const value = this._values[i];
          const param = this._parameters[i];
          if (!isSafeValue(value, valueSize, this._valueFormat)) {
            throwInvalidValueError(value, param, valueSize, this._valueFormat);
          }
          try {
            serializeValue(this.payload, 4 + i * valueSize, valueSize, this._valueFormat, value);
          } catch (e) {
            tryCatchOutOfBoundsError(e, value, param, valueSize, this._valueFormat);
          }
        }
      }
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        handshake: this.handshake,
        "reset to default": this.resetToDefault,
        "value size": this.valueSize
      };
      if (this._values.length > 0) {
        message.values = this._values.map((value, i) => `
\xB7 #${this._parameters[i]}: ${configValueToString(value)}`).join("");
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return ConfigurationCCBulkSet2 = _classThis;
})();
let ConfigurationCCBulkReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ConfigurationCommand.BulkReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ConfigurationCC;
  var ConfigurationCCBulkReport2 = class extends _classSuper {
    static {
      __name(this, "ConfigurationCCBulkReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ConfigurationCCBulkReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.reportsToFollow = options.reportsToFollow;
      this.defaultValues = options.defaultValues;
      this.isHandshakeResponse = options.isHandshakeResponse;
      this.valueSize = options.valueSize;
      for (const [param, value] of Object.entries(options.values)) {
        this._values.set(parseInt(param), value);
      }
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 5);
      const firstParameter = raw.payload.readUInt16BE(0);
      const numParams = raw.payload[2];
      const reportsToFollow = raw.payload[3];
      const defaultValues = !!(raw.payload[4] & 128);
      const isHandshakeResponse = !!(raw.payload[4] & 64);
      const valueSize = raw.payload[4] & 7;
      (0, import_core.validatePayload)(raw.payload.length >= 5 + numParams * valueSize);
      const values = {};
      for (let i = 0; i < numParams; i++) {
        const param = firstParameter + i;
        values[param] = parseValue(raw.payload.subarray(5 + i * valueSize), valueSize, import_core.ConfigValueFormat.SignedInteger);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        reportsToFollow,
        defaultValues,
        isHandshakeResponse,
        valueSize,
        values
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      for (let [parameter, value] of this._values.entries()) {
        const oldParamInformation = this.getParamInformation(ctx, parameter);
        if (oldParamInformation.format != void 0 && oldParamInformation.format !== import_core.ConfigValueFormat.SignedInteger) {
          value = reInterpretSignedValue(value, this.valueSize, oldParamInformation.format);
          this._values.set(parameter, value);
        }
        this.setValue(ctx, import_CCValues_generated.ConfigurationCCValues.paramInformation(parameter), value);
      }
      return true;
    }
    reportsToFollow;
    defaultValues;
    isHandshakeResponse;
    valueSize;
    _values = /* @__PURE__ */ new Map();
    get values() {
      return this._values;
    }
    getPartialCCSessionId() {
      return {};
    }
    expectMoreMessages() {
      return this.reportsToFollow > 0;
    }
    toLogEntry(ctx) {
      const message = {
        "handshake response": this.isHandshakeResponse,
        "default values": this.defaultValues,
        "value size": this.valueSize,
        "reports to follow": this.reportsToFollow
      };
      if (this._values.size > 0) {
        message.values = [...this._values].map(([param, value]) => `
\xB7 #${param}: ${configValueToString(value)}`).join("");
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return ConfigurationCCBulkReport2 = _classThis;
})();
let ConfigurationCCBulkGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ConfigurationCommand.BulkGet), (0, import_CommandClassDecorators.expectedCCResponse)(ConfigurationCCBulkReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ConfigurationCC;
  var ConfigurationCCBulkGet2 = class extends _classSuper {
    static {
      __name(this, "ConfigurationCCBulkGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ConfigurationCCBulkGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this._parameters = options.parameters.sort();
      if (!(0, import_core.isConsecutiveArray)(this.parameters)) {
        throw new import_core.ZWaveError(`A ConfigurationCC.BulkGet can only be used for consecutive parameters`, import_core.ZWaveErrorCodes.CC_Invalid);
      }
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    _parameters;
    get parameters() {
      return this._parameters;
    }
    serialize(ctx) {
      this.payload = new import_shared.Bytes(3);
      this.payload.writeUInt16BE(this.parameters[0], 0);
      this.payload[2] = this.parameters.length;
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { parameters: this.parameters.join(", ") }
      };
    }
  };
  return ConfigurationCCBulkGet2 = _classThis;
})();
let ConfigurationCCNameReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ConfigurationCommand.NameReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ConfigurationCC;
  var ConfigurationCCNameReport2 = class extends _classSuper {
    static {
      __name(this, "ConfigurationCCNameReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ConfigurationCCNameReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.parameter = options.parameter;
      this.name = options.name;
      this.reportsToFollow = options.reportsToFollow;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      const parameter = raw.payload.readUInt16BE(0);
      const reportsToFollow = raw.payload[2];
      if (reportsToFollow > 0) {
        (0, import_core.validatePayload)(raw.payload.length >= 4);
      }
      const name = raw.payload.subarray(3).toString("utf8");
      return new this({
        nodeId: ctx.sourceNodeId,
        parameter,
        reportsToFollow,
        name
      });
    }
    parameter;
    name;
    reportsToFollow;
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const partialParams = this.getPartialParamInfos(ctx, this.parameter);
      if (partialParams.length === 0) {
        this.extendParamInformation(ctx, this.parameter, void 0, {
          label: this.name
        });
      } else {
        for (const param of partialParams) {
          const paramNumber = param.property;
          const bitMask = param.propertyKey;
          const bitNumber = Math.log2(bitMask) % 1 === 0 ? Math.log2(bitMask) : void 0;
          let label = `${this.name} - ${bitMask}`;
          if (bitNumber != void 0) {
            label += ` (bit ${bitNumber})`;
          }
          this.extendParamInformation(ctx, paramNumber, bitMask, {
            label
          });
        }
      }
      return true;
    }
    serialize(ctx) {
      const nameBuffer = import_shared.Bytes.from(this.name, "utf8");
      this.payload = new import_shared.Bytes(3 + nameBuffer.length);
      this.payload.writeUInt16BE(this.parameter, 0);
      this.payload[2] = this.reportsToFollow;
      this.payload.set(nameBuffer, 3);
      return super.serialize(ctx);
    }
    getPartialCCSessionId() {
      return { parameter: this.parameter };
    }
    expectMoreMessages() {
      return this.reportsToFollow > 0;
    }
    mergePartialCCs(partials, _ctx) {
      this.name = [...partials, this].map((report) => report.name).reduce((prev, cur) => prev + cur, "");
      return Promise.resolve();
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "parameter #": this.parameter,
          name: this.name,
          "reports to follow": this.reportsToFollow
        }
      };
    }
  };
  return ConfigurationCCNameReport2 = _classThis;
})();
let ConfigurationCCNameGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ConfigurationCommand.NameGet), (0, import_CommandClassDecorators.expectedCCResponse)(ConfigurationCCNameReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ConfigurationCC;
  var ConfigurationCCNameGet2 = class extends _classSuper {
    static {
      __name(this, "ConfigurationCCNameGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ConfigurationCCNameGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.parameter = options.parameter;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const parameter = raw.payload.readUInt16BE(0);
      return new this({
        nodeId: ctx.sourceNodeId,
        parameter
      });
    }
    parameter;
    serialize(ctx) {
      this.payload = new import_shared.Bytes(2);
      this.payload.writeUInt16BE(this.parameter, 0);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "parameter #": this.parameter }
      };
    }
  };
  return ConfigurationCCNameGet2 = _classThis;
})();
let ConfigurationCCInfoReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ConfigurationCommand.InfoReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ConfigurationCC;
  var ConfigurationCCInfoReport2 = class extends _classSuper {
    static {
      __name(this, "ConfigurationCCInfoReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ConfigurationCCInfoReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.parameter = options.parameter;
      this.info = options.info;
      this.reportsToFollow = options.reportsToFollow;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      const parameter = raw.payload.readUInt16BE(0);
      const reportsToFollow = raw.payload[2];
      if (reportsToFollow > 0) {
        (0, import_core.validatePayload)(raw.payload.length >= 4);
      }
      const info = raw.payload.subarray(3).toString("utf8");
      return new this({
        nodeId: ctx.sourceNodeId,
        parameter,
        reportsToFollow,
        info
      });
    }
    parameter;
    info;
    reportsToFollow;
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const partialParams = this.getPartialParamInfos(ctx, this.parameter).sort((a, b) => (a.propertyKey ?? 0) - (b.propertyKey ?? 0));
      if (partialParams.length === 0) {
        this.extendParamInformation(ctx, this.parameter, void 0, {
          description: this.info
        });
      } else {
        let firstParamLabel;
        for (const param of partialParams) {
          const paramNumber = param.property;
          const bitMask = param.propertyKey;
          const description = firstParamLabel ? `Refer to ${firstParamLabel}` : this.info;
          this.extendParamInformation(ctx, paramNumber, bitMask, {
            description
          });
          if (firstParamLabel == void 0) {
            firstParamLabel = this.getParamInformation(ctx, paramNumber, bitMask).label ?? `parameter ${paramNumber} - ${bitMask}`;
          }
        }
      }
      return true;
    }
    serialize(ctx) {
      const infoBuffer = import_shared.Bytes.from(this.info, "utf8");
      this.payload = new import_shared.Bytes(3 + infoBuffer.length);
      this.payload.writeUInt16BE(this.parameter, 0);
      this.payload[2] = this.reportsToFollow;
      this.payload.set(infoBuffer, 3);
      return super.serialize(ctx);
    }
    getPartialCCSessionId() {
      return { parameter: this.parameter };
    }
    expectMoreMessages() {
      return this.reportsToFollow > 0;
    }
    mergePartialCCs(partials, _ctx) {
      this.info = [...partials, this].map((report) => report.info).reduce((prev, cur) => prev + cur, "");
      return Promise.resolve();
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "parameter #": this.parameter,
          info: this.info,
          "reports to follow": this.reportsToFollow
        }
      };
    }
  };
  return ConfigurationCCInfoReport2 = _classThis;
})();
let ConfigurationCCInfoGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ConfigurationCommand.InfoGet), (0, import_CommandClassDecorators.expectedCCResponse)(ConfigurationCCInfoReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ConfigurationCC;
  var ConfigurationCCInfoGet2 = class extends _classSuper {
    static {
      __name(this, "ConfigurationCCInfoGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ConfigurationCCInfoGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.parameter = options.parameter;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const parameter = raw.payload.readUInt16BE(0);
      return new this({
        nodeId: ctx.sourceNodeId,
        parameter
      });
    }
    parameter;
    serialize(ctx) {
      this.payload = new import_shared.Bytes(2);
      this.payload.writeUInt16BE(this.parameter, 0);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "parameter #": this.parameter }
      };
    }
  };
  return ConfigurationCCInfoGet2 = _classThis;
})();
let ConfigurationCCPropertiesReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ConfigurationCommand.PropertiesReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ConfigurationCC;
  var ConfigurationCCPropertiesReport2 = class extends _classSuper {
    static {
      __name(this, "ConfigurationCCPropertiesReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ConfigurationCCPropertiesReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.parameter = options.parameter;
      this.valueSize = options.valueSize;
      this.valueFormat = options.valueFormat;
      if (this.valueSize > 0) {
        if (options.minValue == void 0) {
          throw new import_core.ZWaveError("The minimum value must be set when the value size is non-zero", import_core.ZWaveErrorCodes.Argument_Invalid);
        } else if (options.maxValue == void 0) {
          throw new import_core.ZWaveError("The maximum value must be set when the value size is non-zero", import_core.ZWaveErrorCodes.Argument_Invalid);
        } else if (options.defaultValue == void 0) {
          throw new import_core.ZWaveError("The default value must be set when the value size is non-zero", import_core.ZWaveErrorCodes.Argument_Invalid);
        }
        this.minValue = options.minValue;
        this.maxValue = options.maxValue;
        this.defaultValue = options.defaultValue;
      }
      this.nextParameter = options.nextParameter;
      this.altersCapabilities = options.altersCapabilities;
      this.isReadonly = options.isReadonly;
      this.isAdvanced = options.isAdvanced;
      this.noBulkSupport = options.noBulkSupport;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 3);
      const parameter = raw.payload.readUInt16BE(0);
      const valueFormat = (raw.payload[2] & 56) >>> 3;
      const valueSize = raw.payload[2] & 7;
      let nextParameter;
      if (valueSize === 0 && raw.payload.length < 5) {
        nextParameter = 0;
        return new this({
          nodeId: ctx.sourceNodeId,
          parameter,
          valueFormat,
          valueSize,
          nextParameter
        });
      }
      const nextParameterOffset = 3 + 3 * valueSize;
      (0, import_core.validatePayload)(raw.payload.length >= nextParameterOffset + 2);
      let minValue;
      let maxValue;
      let defaultValue;
      if (valueSize > 0) {
        if (valueFormat === import_core.ConfigValueFormat.BitField) {
          minValue = 0;
        } else {
          minValue = parseValue(raw.payload.subarray(3), valueSize, valueFormat);
        }
        maxValue = parseValue(raw.payload.subarray(3 + valueSize), valueSize, valueFormat);
        defaultValue = parseValue(raw.payload.subarray(3 + 2 * valueSize), valueSize, valueFormat);
      }
      nextParameter = raw.payload.readUInt16BE(nextParameterOffset);
      let altersCapabilities;
      let isReadonly;
      let isAdvanced;
      let noBulkSupport;
      if (raw.payload.length >= nextParameterOffset + 3) {
        const options1 = raw.payload[2];
        const options2 = raw.payload[3 + 3 * valueSize + 2];
        altersCapabilities = !!(options1 & 128);
        isReadonly = !!(options1 & 64);
        isAdvanced = !!(options2 & 1);
        noBulkSupport = !!(options2 & 2);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        parameter,
        valueFormat,
        valueSize,
        nextParameter,
        minValue,
        maxValue,
        defaultValue,
        altersCapabilities,
        isReadonly,
        isAdvanced,
        noBulkSupport
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      if (this.valueSize > 0) {
        const baseInfo = {
          type: "number",
          format: this.valueFormat,
          valueSize: this.valueSize,
          requiresReInclusion: this.altersCapabilities,
          readable: true,
          writeable: !this.isReadonly,
          allowManualEntry: true,
          isAdvanced: this.isAdvanced,
          noBulkSupport: this.noBulkSupport,
          isFromConfig: false
        };
        if (this.valueFormat !== import_core.ConfigValueFormat.BitField) {
          if (!this.paramExistsInConfigFile(ctx, this.parameter)) {
            const paramInfo = (0, import_core.stripUndefined)({
              ...baseInfo,
              min: this.minValue,
              max: this.maxValue,
              default: this.defaultValue
            });
            this.extendParamInformation(ctx, this.parameter, void 0, paramInfo);
          }
        } else {
          const bits = this.maxValue;
          let mask = 1;
          while (mask <= bits) {
            if (
              // Only create partials that exist
              !!(mask & bits) && !this.paramExistsInConfigFile(ctx, this.parameter, mask)
            ) {
              const paramInfo = (0, import_core.stripUndefined)({
                ...baseInfo,
                min: 0,
                max: 1,
                default: this.defaultValue & mask ? 1 : 0
              });
              this.extendParamInformation(ctx, this.parameter, mask, paramInfo);
            }
            mask *= 2;
          }
        }
      }
      return true;
    }
    parameter;
    valueSize;
    valueFormat;
    minValue;
    maxValue;
    defaultValue;
    nextParameter;
    altersCapabilities;
    isReadonly;
    isAdvanced;
    noBulkSupport;
    serialize(ctx) {
      this.payload = new import_shared.Bytes(3 + 3 * this.valueSize + 2 + 1);
      this.payload.writeUInt16BE(this.parameter, 0);
      const options1 = (this.altersCapabilities ? 128 : 0) | (this.isReadonly ? 64 : 0) | (this.valueFormat & 7) << 3 | this.valueSize & 7;
      this.payload[2] = options1;
      let offset = 3;
      if (this.valueSize > 0) {
        serializeValue(this.payload, offset, this.valueSize, this.valueFormat, this.minValue);
        offset += this.valueSize;
        serializeValue(this.payload, offset, this.valueSize, this.valueFormat, this.maxValue);
        offset += this.valueSize;
        serializeValue(this.payload, offset, this.valueSize, this.valueFormat, this.defaultValue);
        offset += this.valueSize;
      }
      this.payload.writeUInt16BE(this.nextParameter, offset);
      offset += 2;
      const options2 = (this.isAdvanced ? 1 : 0) | (this.noBulkSupport ? 2 : 0);
      this.payload[offset] = options2;
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        "parameter #": this.parameter,
        "next param #": this.nextParameter,
        "value size": this.valueSize,
        "value format": (0, import_shared.getEnumMemberName)(import_core.ConfigValueFormat, this.valueFormat)
      };
      if (this.minValue != void 0) {
        message["min value"] = configValueToString(this.minValue);
      }
      if (this.maxValue != void 0) {
        message["max value"] = configValueToString(this.maxValue);
      }
      if (this.defaultValue != void 0) {
        message["default value"] = configValueToString(this.defaultValue);
      }
      if (this.altersCapabilities != void 0) {
        message["alters capabilities"] = this.altersCapabilities;
      }
      if (this.isReadonly != void 0) {
        message.readonly = this.isReadonly;
      }
      if (this.isAdvanced != void 0) {
        message.advanced = this.isAdvanced;
      }
      if (this.noBulkSupport != void 0) {
        message["bulk support"] = !this.noBulkSupport;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return ConfigurationCCPropertiesReport2 = _classThis;
})();
let ConfigurationCCPropertiesGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ConfigurationCommand.PropertiesGet), (0, import_CommandClassDecorators.expectedCCResponse)(ConfigurationCCPropertiesReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ConfigurationCC;
  var ConfigurationCCPropertiesGet2 = class extends _classSuper {
    static {
      __name(this, "ConfigurationCCPropertiesGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ConfigurationCCPropertiesGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.parameter = options.parameter;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const parameter = raw.payload.readUInt16BE(0);
      return new this({
        nodeId: ctx.sourceNodeId,
        parameter
      });
    }
    parameter;
    serialize(ctx) {
      this.payload = new import_shared.Bytes(2);
      this.payload.writeUInt16BE(this.parameter, 0);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: { "parameter #": this.parameter }
      };
    }
  };
  return ConfigurationCCPropertiesGet2 = _classThis;
})();
let ConfigurationCCDefaultReset = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.ConfigurationCommand.DefaultReset)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = ConfigurationCC;
  var ConfigurationCCDefaultReset2 = class extends _classSuper {
    static {
      __name(this, "ConfigurationCCDefaultReset");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      ConfigurationCCDefaultReset2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return ConfigurationCCDefaultReset2 = _classThis;
})();
function isSafeValue(value, size, format) {
  let minValue;
  let maxValue;
  switch (format) {
    case import_core.ConfigValueFormat.SignedInteger:
      minValue = -Math.pow(2, 8 * size - 1);
      maxValue = Math.pow(2, 8 * size - 1) - 1;
      break;
    case import_core.ConfigValueFormat.UnsignedInteger:
    case import_core.ConfigValueFormat.Enumerated:
    case import_core.ConfigValueFormat.BitField:
      minValue = 0;
      maxValue = Math.pow(2, 8 * size);
      break;
    default:
      throw new Error("not implemented");
  }
  return minValue <= value && value <= maxValue;
}
__name(isSafeValue, "isSafeValue");
function parseValue(raw, size, format) {
  switch (format) {
    case import_core.ConfigValueFormat.SignedInteger:
      return raw.readIntBE(0, size);
    case import_core.ConfigValueFormat.UnsignedInteger:
    case import_core.ConfigValueFormat.Enumerated:
    case import_core.ConfigValueFormat.BitField:
      return raw.readUIntBE(0, size);
  }
}
__name(parseValue, "parseValue");
function throwInvalidValueError(value, parameter, valueSize, valueFormat) {
  throw new import_core.ZWaveError(`The value ${value} is invalid for configuration parameter ${parameter} (size = ${valueSize}, format = ${(0, import_shared.getEnumMemberName)(import_core.ConfigValueFormat, valueFormat)})!`, import_core.ZWaveErrorCodes.Argument_Invalid);
}
__name(throwInvalidValueError, "throwInvalidValueError");
function tryCatchOutOfBoundsError(e, value, parameter, valueSize, valueFormat) {
  if (e.message.includes("out of bounds")) {
    throwInvalidValueError(value, parameter, valueSize, valueFormat);
  } else {
    throw e;
  }
}
__name(tryCatchOutOfBoundsError, "tryCatchOutOfBoundsError");
function serializeValue(payload, offset, size, format, value) {
  switch (format) {
    case import_core.ConfigValueFormat.SignedInteger:
      payload.writeIntBE(value, offset, size);
      return;
    case import_core.ConfigValueFormat.UnsignedInteger:
    case import_core.ConfigValueFormat.Enumerated:
    case import_core.ConfigValueFormat.BitField:
      payload.writeUIntBE(value, offset, size);
      return;
  }
}
__name(serializeValue, "serializeValue");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ConfigurationCC,
  ConfigurationCCAPI,
  ConfigurationCCBulkGet,
  ConfigurationCCBulkReport,
  ConfigurationCCBulkSet,
  ConfigurationCCDefaultReset,
  ConfigurationCCError,
  ConfigurationCCGet,
  ConfigurationCCInfoGet,
  ConfigurationCCInfoReport,
  ConfigurationCCNameGet,
  ConfigurationCCNameReport,
  ConfigurationCCPropertiesGet,
  ConfigurationCCPropertiesReport,
  ConfigurationCCReport,
  ConfigurationCCSet,
  ConfigurationCCValues,
  refreshMetadataStringsFromConfigFile
});
//# sourceMappingURL=ConfigurationCC.js.map
