"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var DoorLockCC_exports = {};
__export(DoorLockCC_exports, {
  DoorLockCC: () => DoorLockCC,
  DoorLockCCAPI: () => DoorLockCCAPI,
  DoorLockCCCapabilitiesGet: () => DoorLockCCCapabilitiesGet,
  DoorLockCCCapabilitiesReport: () => DoorLockCCCapabilitiesReport,
  DoorLockCCConfigurationGet: () => DoorLockCCConfigurationGet,
  DoorLockCCConfigurationReport: () => DoorLockCCConfigurationReport,
  DoorLockCCConfigurationSet: () => DoorLockCCConfigurationSet,
  DoorLockCCOperationGet: () => DoorLockCCOperationGet,
  DoorLockCCOperationReport: () => DoorLockCCOperationReport,
  DoorLockCCOperationSet: () => DoorLockCCOperationSet,
  DoorLockCCValues: () => import_CCValues_generated.DoorLockCCValues,
  shouldAutoCreateAutoRelockConfigValue: () => shouldAutoCreateAutoRelockConfigValue,
  shouldAutoCreateBlockToBlockConfigValue: () => shouldAutoCreateBlockToBlockConfigValue,
  shouldAutoCreateBoltStatusValue: () => shouldAutoCreateBoltStatusValue,
  shouldAutoCreateDoorStatusValue: () => shouldAutoCreateDoorStatusValue,
  shouldAutoCreateHoldAndReleaseConfigValue: () => shouldAutoCreateHoldAndReleaseConfigValue,
  shouldAutoCreateLatchStatusValue: () => shouldAutoCreateLatchStatusValue,
  shouldAutoCreateTwistAssistConfigValue: () => shouldAutoCreateTwistAssistConfigValue
});
module.exports = __toCommonJS(DoorLockCC_exports);
var __validateArgs = __toESM(require("./DoorLockCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_typeguards = require("alcalzone-shared/typeguards");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_DoorLockCCAPI_set, validateArgs_DoorLockCCAPI_setConfiguration } = __validateArgs;
function shouldAutoCreateLatchStatusValue(ctx, endpoint) {
  const valueDB = ctx.tryGetValueDB(endpoint.nodeId);
  if (!valueDB)
    return false;
  return !!valueDB.getValue(import_CCValues_generated.DoorLockCCValues.latchSupported.endpoint(endpoint.index));
}
__name(shouldAutoCreateLatchStatusValue, "shouldAutoCreateLatchStatusValue");
function shouldAutoCreateBoltStatusValue(ctx, endpoint) {
  const valueDB = ctx.tryGetValueDB(endpoint.nodeId);
  if (!valueDB)
    return false;
  return !!valueDB.getValue(import_CCValues_generated.DoorLockCCValues.boltSupported.endpoint(endpoint.index));
}
__name(shouldAutoCreateBoltStatusValue, "shouldAutoCreateBoltStatusValue");
function shouldAutoCreateDoorStatusValue(ctx, endpoint) {
  const valueDB = ctx.tryGetValueDB(endpoint.nodeId);
  if (!valueDB)
    return false;
  return !!valueDB.getValue(import_CCValues_generated.DoorLockCCValues.doorSupported.endpoint(endpoint.index));
}
__name(shouldAutoCreateDoorStatusValue, "shouldAutoCreateDoorStatusValue");
function shouldAutoCreateTwistAssistConfigValue(ctx, endpoint) {
  const valueDB = ctx.tryGetValueDB(endpoint.nodeId);
  if (!valueDB)
    return false;
  return !!valueDB.getValue(import_CCValues_generated.DoorLockCCValues.twistAssistSupported.endpoint(endpoint.index));
}
__name(shouldAutoCreateTwistAssistConfigValue, "shouldAutoCreateTwistAssistConfigValue");
function shouldAutoCreateBlockToBlockConfigValue(ctx, endpoint) {
  const valueDB = ctx.tryGetValueDB(endpoint.nodeId);
  if (!valueDB)
    return false;
  return !!valueDB.getValue(import_CCValues_generated.DoorLockCCValues.blockToBlockSupported.endpoint(endpoint.index));
}
__name(shouldAutoCreateBlockToBlockConfigValue, "shouldAutoCreateBlockToBlockConfigValue");
function shouldAutoCreateAutoRelockConfigValue(ctx, endpoint) {
  const valueDB = ctx.tryGetValueDB(endpoint.nodeId);
  if (!valueDB)
    return false;
  return !!valueDB.getValue(import_CCValues_generated.DoorLockCCValues.autoRelockSupported.endpoint(endpoint.index));
}
__name(shouldAutoCreateAutoRelockConfigValue, "shouldAutoCreateAutoRelockConfigValue");
function shouldAutoCreateHoldAndReleaseConfigValue(ctx, endpoint) {
  const valueDB = ctx.tryGetValueDB(endpoint.nodeId);
  if (!valueDB)
    return false;
  return !!valueDB.getValue(import_CCValues_generated.DoorLockCCValues.holdAndReleaseSupported.endpoint(endpoint.index));
}
__name(shouldAutoCreateHoldAndReleaseConfigValue, "shouldAutoCreateHoldAndReleaseConfigValue");
const configurationSetParameters = [
  "operationType",
  "outsideHandlesCanOpenDoorConfiguration",
  "insideHandlesCanOpenDoorConfiguration",
  "lockTimeoutConfiguration",
  "autoRelockTime",
  "holdAndReleaseTime",
  "twistAssist",
  "blockToBlock"
];
let DoorLockCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Door Lock"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.PhysicalCCAPI;
  let _instanceExtraInitializers = [];
  let _set_decorators;
  let _setConfiguration_decorators;
  var DoorLockCCAPI2 = class extends _classSuper {
    static {
      __name(this, "DoorLockCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _set_decorators = [validateArgs_DoorLockCCAPI_set({ strictEnums: true })];
      _setConfiguration_decorators = [validateArgs_DoorLockCCAPI_setConfiguration()];
      __esDecorate(this, null, _set_decorators, { kind: "method", name: "set", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "set" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.set, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _setConfiguration_decorators, { kind: "method", name: "setConfiguration", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setConfiguration" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setConfiguration, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      DoorLockCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.DoorLockCommand.OperationSet:
        case import_Types.DoorLockCommand.OperationGet:
        case import_Types.DoorLockCommand.ConfigurationSet:
        case import_Types.DoorLockCommand.ConfigurationGet:
          return true;
        // This is mandatory
        case import_Types.DoorLockCommand.CapabilitiesGet:
          return this.version >= 4;
      }
      return super.supportsCommand(cmd);
    }
    get [import_API.SET_VALUE]() {
      return async function({ property }, value) {
        if (property === "targetMode") {
          if (typeof value !== "number") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
          const result = await this.set(value);
          if ((0, import_core.supervisedCommandSucceeded)(result)) {
            this.getValueDB().setValue(import_CCValues_generated.DoorLockCCValues.currentMode.endpoint(this.endpoint.index), value);
          } else {
            this.schedulePoll({ property }, value);
          }
          return result;
        } else if (typeof property === "string" && configurationSetParameters.includes(property)) {
          const config = {
            [property]: value
          };
          for (const param of configurationSetParameters) {
            if (param !== property) {
              config[param] = this.tryGetValueDB()?.getValue({
                commandClass: this.ccId,
                endpoint: this.endpoint.index,
                property: param
              });
            }
          }
          const allTrue = [true, true, true, true];
          if (!config.insideHandlesCanOpenDoorConfiguration) {
            config.insideHandlesCanOpenDoorConfiguration = allTrue;
          }
          if (!config.outsideHandlesCanOpenDoorConfiguration) {
            config.outsideHandlesCanOpenDoorConfiguration = allTrue;
          }
          const result = await this.setConfiguration(config);
          if (!(0, import_core.supervisedCommandSucceeded)(result)) {
            this.schedulePoll({ property }, value);
          }
          return result;
        } else {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property }) {
        switch (property) {
          case "currentMode":
          case "targetMode":
          case "duration":
          case "outsideHandlesCanOpenDoor":
          case "insideHandlesCanOpenDoor":
          case "latchStatus":
          case "boltStatus":
          case "doorStatus":
          case "lockTimeout":
            return (await this.get())?.[property];
          case "operationType":
          case "outsideHandlesCanOpenDoorConfiguration":
          case "insideHandlesCanOpenDoorConfiguration":
          case "lockTimeoutConfiguration":
          case "autoRelockTime":
          case "holdAndReleaseTime":
          case "twistAssist":
          case "blockToBlock":
            return (await this.getConfiguration())?.[property];
          default:
            (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getCapabilities() {
      this.assertSupportsCommand(import_Types.DoorLockCommand, import_Types.DoorLockCommand.CapabilitiesGet);
      const cc = new DoorLockCCCapabilitiesGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "autoRelockSupported",
          "blockToBlockSupported",
          "boltSupported",
          "doorSupported",
          "holdAndReleaseSupported",
          "latchSupported",
          "twistAssistSupported",
          "supportedDoorLockModes",
          "supportedInsideHandles",
          "supportedOperationTypes",
          "supportedOutsideHandles"
        ]);
      }
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async get() {
      this.assertSupportsCommand(import_Types.DoorLockCommand, import_Types.DoorLockCommand.OperationGet);
      const cc = new DoorLockCCOperationGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "currentMode",
          "targetMode",
          "duration",
          "outsideHandlesCanOpenDoor",
          "insideHandlesCanOpenDoor",
          "latchStatus",
          "boltStatus",
          "doorStatus",
          "lockTimeout"
        ]);
      }
    }
    async set(mode) {
      this.assertSupportsCommand(import_Types.DoorLockCommand, import_Types.DoorLockCommand.OperationSet);
      const cc = new DoorLockCCOperationSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        mode
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async setConfiguration(configuration) {
      this.assertSupportsCommand(import_Types.DoorLockCommand, import_Types.DoorLockCommand.ConfigurationSet);
      const cc = new DoorLockCCConfigurationSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        ...configuration
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getConfiguration() {
      this.assertSupportsCommand(import_Types.DoorLockCommand, import_Types.DoorLockCommand.ConfigurationGet);
      const cc = new DoorLockCCConfigurationGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "operationType",
          "outsideHandlesCanOpenDoorConfiguration",
          "insideHandlesCanOpenDoorConfiguration",
          "lockTimeoutConfiguration",
          "autoRelockTime",
          "holdAndReleaseTime",
          "twistAssist",
          "blockToBlock"
        ]);
      }
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return DoorLockCCAPI2 = _classThis;
})();
let DoorLockCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Door Lock"]), (0, import_CommandClassDecorators.implementedVersion)(4), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.DoorLockCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var DoorLockCC2 = class extends _classSuper {
    static {
      __name(this, "DoorLockCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      DoorLockCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Door Lock"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      let hadCriticalTimeout = false;
      let doorSupported = true;
      let boltSupported = true;
      let latchSupported = true;
      if (api.version >= 4) {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "requesting lock capabilities...",
          direction: "outbound"
        });
        const resp = await api.getCapabilities();
        if (resp) {
          const logMessage = `received lock capabilities:
supported operation types: ${resp.supportedOperationTypes.map((t) => (0, import_shared.getEnumMemberName)(import_Types.DoorLockOperationType, t)).join(", ")}
supported door lock modes: ${resp.supportedDoorLockModes.map((t) => (0, import_shared.getEnumMemberName)(import_Types.DoorLockMode, t)).map((str) => `
\xB7 ${str}`).join("")}
supported outside handles: ${resp.supportedOutsideHandles.map(String).join(", ")}
supported inside handles:  ${resp.supportedInsideHandles.map(String).join(", ")}
supports door status:      ${resp.doorSupported}
supports bolt status:      ${resp.boltSupported}
supports latch status:     ${resp.latchSupported}
supports auto-relock:      ${resp.autoRelockSupported}
supports hold-and-release: ${resp.holdAndReleaseSupported}
supports twist assist:     ${resp.twistAssistSupported}
supports block to block:   ${resp.blockToBlockSupported}`;
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage,
            direction: "inbound"
          });
          doorSupported = resp.doorSupported;
          boltSupported = resp.boltSupported;
          latchSupported = resp.latchSupported;
          const targetModeValue = import_CCValues_generated.DoorLockCCValues.targetMode;
          this.setMetadata(ctx, targetModeValue, {
            ...targetModeValue.meta,
            states: (0, import_core.enumValuesToMetadataStates)(import_Types.DoorLockMode, resp.supportedDoorLockModes)
          });
          const operationTypeValue = import_CCValues_generated.DoorLockCCValues.operationType;
          this.setMetadata(ctx, operationTypeValue, {
            ...operationTypeValue.meta,
            states: (0, import_core.enumValuesToMetadataStates)(import_Types.DoorLockOperationType, resp.supportedOperationTypes)
          });
        } else {
          hadCriticalTimeout = true;
        }
      }
      if (!hadCriticalTimeout) {
        const doorStatusValue = import_CCValues_generated.DoorLockCCValues.doorStatus;
        if (doorSupported)
          this.setMetadata(ctx, doorStatusValue);
        this.setValue(ctx, import_CCValues_generated.DoorLockCCValues.doorSupported, doorSupported);
        const latchStatusValue = import_CCValues_generated.DoorLockCCValues.latchStatus;
        if (latchSupported)
          this.setMetadata(ctx, latchStatusValue);
        this.setValue(ctx, import_CCValues_generated.DoorLockCCValues.latchSupported, latchSupported);
        const boltStatusValue = import_CCValues_generated.DoorLockCCValues.boltStatus;
        if (boltSupported)
          this.setMetadata(ctx, boltStatusValue);
        this.setValue(ctx, import_CCValues_generated.DoorLockCCValues.boltSupported, boltSupported);
      }
      await this.refreshValues(ctx);
      if (!hadCriticalTimeout)
        this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Door Lock"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "requesting lock configuration...",
        direction: "outbound"
      });
      const config = await api.getConfiguration();
      if (config) {
        let logMessage = `received lock configuration:
operation type:                ${(0, import_shared.getEnumMemberName)(import_Types.DoorLockOperationType, config.operationType)}`;
        if (config.operationType === import_Types.DoorLockOperationType.Timed) {
          logMessage += `
lock timeout:                  ${config.lockTimeoutConfiguration} seconds
`;
        }
        logMessage += `
outside handles can open door: ${config.outsideHandlesCanOpenDoorConfiguration.map(String).join(", ")}
inside handles can open door:  ${config.insideHandlesCanOpenDoorConfiguration.map(String).join(", ")}`;
        if (api.version >= 4) {
          logMessage += `
auto-relock time               ${config.autoRelockTime ?? "-"} seconds
hold-and-release time          ${config.holdAndReleaseTime ?? "-"} seconds
twist assist                   ${!!config.twistAssist}
block to block                 ${!!config.blockToBlock}`;
        }
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: logMessage,
          direction: "inbound"
        });
      }
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "requesting current lock status...",
        direction: "outbound"
      });
      const status = await api.get();
      if (status) {
        let logMessage = `received lock status:
current mode:       ${(0, import_shared.getEnumMemberName)(import_Types.DoorLockMode, status.currentMode)}`;
        if (status.targetMode != void 0) {
          logMessage += `
target mode:        ${(0, import_shared.getEnumMemberName)(import_Types.DoorLockMode, status.targetMode)}
remaining duration: ${status.duration?.toString() ?? "undefined"}`;
        }
        if (status.lockTimeout != void 0) {
          logMessage += `
lock timeout:       ${status.lockTimeout} seconds`;
        }
        if (status.doorStatus != void 0) {
          logMessage += `
door status:        ${status.doorStatus}`;
        }
        if (status.boltStatus != void 0) {
          logMessage += `
bolt status:        ${status.boltStatus}`;
        }
        if (status.latchStatus != void 0) {
          logMessage += `
latch status:       ${status.latchStatus}`;
        }
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: logMessage,
          direction: "inbound"
        });
      }
    }
    /**
     * Returns whether the node supports auto relock.
     * This only works AFTER the node has been interviewed.
     */
    static supportsAutoRelockCached(ctx, endpoint) {
      return !!ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.DoorLockCCValues.autoRelockSupported.endpoint(endpoint.index));
    }
    /**
     * Returns whether the node supports hold and release.
     * This only works AFTER the node has been interviewed.
     */
    static supportsHoldAndReleaseCached(ctx, endpoint) {
      return !!ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.DoorLockCCValues.holdAndReleaseSupported.endpoint(endpoint.index));
    }
    /**
     * Returns whether the node supports twist assist.
     * This only works AFTER the node has been interviewed.
     */
    static supportsTwistAssistCached(ctx, endpoint) {
      return !!ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.DoorLockCCValues.twistAssistSupported.endpoint(endpoint.index));
    }
    /**
     * Returns whether the node supports block to block.
     * This only works AFTER the node has been interviewed.
     */
    static supportsBlockToBlockCached(ctx, endpoint) {
      return !!ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.DoorLockCCValues.blockToBlockSupported.endpoint(endpoint.index));
    }
    /**
     * Returns the supported outside handles.
     * This only works AFTER the node has been interviewed.
     */
    static getSupportedOutsideHandlesCached(ctx, endpoint) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.DoorLockCCValues.supportedOutsideHandles.endpoint(endpoint.index));
    }
    /**
     * Returns the supported inside handles.
     * This only works AFTER the node has been interviewed.
     */
    static getSupportedInsideHandlesCached(ctx, endpoint) {
      return ctx.getValueDB(endpoint.nodeId).getValue(import_CCValues_generated.DoorLockCCValues.supportedInsideHandles.endpoint(endpoint.index));
    }
  };
  return DoorLockCC2 = _classThis;
})();
let DoorLockCCOperationSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.DoorLockCommand.OperationSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = DoorLockCC;
  var DoorLockCCOperationSet2 = class extends _classSuper {
    static {
      __name(this, "DoorLockCCOperationSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      DoorLockCCOperationSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      if (options.mode === import_Types.DoorLockMode.Unknown) {
        throw new import_core.ZWaveError(`Unknown is not a valid door lock target state!`, import_core.ZWaveErrorCodes.Argument_Invalid);
      }
      this.mode = options.mode;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    mode;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.mode]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "target mode": (0, import_shared.getEnumMemberName)(import_Types.DoorLockMode, this.mode)
        }
      };
    }
  };
  return DoorLockCCOperationSet2 = _classThis;
})();
let DoorLockCCOperationReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.DoorLockCommand.OperationReport), (0, import_CommandClassDecorators.ccValueProperty)("currentMode", import_CCValues_generated.DoorLockCCValues.currentMode), (0, import_CommandClassDecorators.ccValueProperty)("targetMode", import_CCValues_generated.DoorLockCCValues.targetMode), (0, import_CommandClassDecorators.ccValueProperty)("duration", import_CCValues_generated.DoorLockCCValues.duration), (0, import_CommandClassDecorators.ccValueProperty)("outsideHandlesCanOpenDoor", import_CCValues_generated.DoorLockCCValues.outsideHandlesCanOpenDoor), (0, import_CommandClassDecorators.ccValueProperty)("insideHandlesCanOpenDoor", import_CCValues_generated.DoorLockCCValues.insideHandlesCanOpenDoor), (0, import_CommandClassDecorators.ccValueProperty)("lockTimeout", import_CCValues_generated.DoorLockCCValues.lockTimeout)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = DoorLockCC;
  var DoorLockCCOperationReport2 = class extends _classSuper {
    static {
      __name(this, "DoorLockCCOperationReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      DoorLockCCOperationReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.currentMode = options.currentMode;
      this.outsideHandlesCanOpenDoor = options.outsideHandlesCanOpenDoor;
      this.insideHandlesCanOpenDoor = options.insideHandlesCanOpenDoor;
      this.doorStatus = options.doorStatus;
      this.boltStatus = options.boltStatus;
      this.latchStatus = options.latchStatus;
      this.lockTimeout = options.lockTimeout;
      this.targetMode = options.targetMode;
      this.duration = options.duration;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 5);
      const currentMode = raw.payload[0];
      const outsideHandlesCanOpenDoor = [
        !!(raw.payload[1] & 16),
        !!(raw.payload[1] & 32),
        !!(raw.payload[1] & 64),
        !!(raw.payload[1] & 128)
      ];
      const insideHandlesCanOpenDoor = [
        !!(raw.payload[1] & 1),
        !!(raw.payload[1] & 2),
        !!(raw.payload[1] & 4),
        !!(raw.payload[1] & 8)
      ];
      const doorStatus = !!(raw.payload[2] & 1) ? "closed" : "open";
      const boltStatus = !!(raw.payload[2] & 2) ? "unlocked" : "locked";
      const latchStatus = !!(raw.payload[2] & 4) ? "closed" : "open";
      const lockTimeoutMinutes = raw.payload[3];
      const lockTimeoutSeconds = raw.payload[4];
      let lockTimeout;
      if (lockTimeoutMinutes <= 253 && lockTimeoutSeconds <= 59) {
        lockTimeout = lockTimeoutSeconds + lockTimeoutMinutes * 60;
      }
      let targetMode;
      let duration;
      if (raw.payload.length >= 7) {
        targetMode = raw.payload[5];
        duration = import_core.Duration.parseReport(raw.payload[6]);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        currentMode,
        outsideHandlesCanOpenDoor,
        insideHandlesCanOpenDoor,
        doorStatus,
        boltStatus,
        latchStatus,
        lockTimeout,
        targetMode,
        duration
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const supportsDoorStatus = !!this.getValue(ctx, import_CCValues_generated.DoorLockCCValues.doorSupported);
      if (supportsDoorStatus) {
        this.setValue(ctx, import_CCValues_generated.DoorLockCCValues.doorStatus, this.doorStatus);
      }
      const supportsBoltStatus = !!this.getValue(ctx, import_CCValues_generated.DoorLockCCValues.boltSupported);
      if (supportsBoltStatus) {
        this.setValue(ctx, import_CCValues_generated.DoorLockCCValues.boltStatus, this.boltStatus);
      }
      const supportsLatchStatus = !!this.getValue(ctx, import_CCValues_generated.DoorLockCCValues.latchSupported);
      if (supportsLatchStatus) {
        this.setValue(ctx, import_CCValues_generated.DoorLockCCValues.latchStatus, this.latchStatus);
      }
      return true;
    }
    currentMode;
    targetMode;
    duration;
    outsideHandlesCanOpenDoor;
    insideHandlesCanOpenDoor;
    latchStatus;
    boltStatus;
    doorStatus;
    lockTimeout;
    // in seconds
    toLogEntry(ctx) {
      const message = {
        "current mode": (0, import_shared.getEnumMemberName)(import_Types.DoorLockMode, this.currentMode),
        "active outside handles": this.outsideHandlesCanOpenDoor.join(", "),
        "active inside handles": this.insideHandlesCanOpenDoor.join(", ")
      };
      if (this.latchStatus != void 0) {
        message["latch status"] = this.latchStatus;
      }
      if (this.boltStatus != void 0) {
        message["bolt status"] = this.boltStatus;
      }
      if (this.doorStatus != void 0) {
        message["door status"] = this.doorStatus;
      }
      if (this.targetMode != void 0) {
        message["target mode"] = (0, import_shared.getEnumMemberName)(import_Types.DoorLockMode, this.targetMode);
      }
      if (this.duration != void 0) {
        message["remaining duration"] = this.duration.toString();
      }
      if (this.lockTimeout != void 0) {
        message["lock timeout"] = `${this.lockTimeout} seconds`;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return DoorLockCCOperationReport2 = _classThis;
})();
let DoorLockCCOperationGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.DoorLockCommand.OperationGet), (0, import_CommandClassDecorators.expectedCCResponse)(DoorLockCCOperationReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = DoorLockCC;
  var DoorLockCCOperationGet2 = class extends _classSuper {
    static {
      __name(this, "DoorLockCCOperationGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      DoorLockCCOperationGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return DoorLockCCOperationGet2 = _classThis;
})();
let DoorLockCCConfigurationReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.DoorLockCommand.ConfigurationReport), (0, import_CommandClassDecorators.ccValueProperty)("operationType", import_CCValues_generated.DoorLockCCValues.operationType), (0, import_CommandClassDecorators.ccValueProperty)("outsideHandlesCanOpenDoorConfiguration", import_CCValues_generated.DoorLockCCValues.outsideHandlesCanOpenDoorConfiguration), (0, import_CommandClassDecorators.ccValueProperty)("insideHandlesCanOpenDoorConfiguration", import_CCValues_generated.DoorLockCCValues.insideHandlesCanOpenDoorConfiguration), (0, import_CommandClassDecorators.ccValueProperty)("lockTimeoutConfiguration", import_CCValues_generated.DoorLockCCValues.lockTimeoutConfiguration)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = DoorLockCC;
  var DoorLockCCConfigurationReport2 = class extends _classSuper {
    static {
      __name(this, "DoorLockCCConfigurationReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      DoorLockCCConfigurationReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.operationType = options.operationType;
      this.outsideHandlesCanOpenDoorConfiguration = options.outsideHandlesCanOpenDoorConfiguration;
      this.insideHandlesCanOpenDoorConfiguration = options.insideHandlesCanOpenDoorConfiguration;
      this.lockTimeoutConfiguration = options.lockTimeoutConfiguration;
      this.autoRelockTime = options.autoRelockTime;
      this.holdAndReleaseTime = options.holdAndReleaseTime;
      this.twistAssist = options.twistAssist;
      this.blockToBlock = options.blockToBlock;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 4);
      const operationType = raw.payload[0];
      const outsideHandlesCanOpenDoorConfiguration = [
        !!(raw.payload[1] & 16),
        !!(raw.payload[1] & 32),
        !!(raw.payload[1] & 64),
        !!(raw.payload[1] & 128)
      ];
      const insideHandlesCanOpenDoorConfiguration = [
        !!(raw.payload[1] & 1),
        !!(raw.payload[1] & 2),
        !!(raw.payload[1] & 4),
        !!(raw.payload[1] & 8)
      ];
      let lockTimeoutConfiguration;
      if (operationType === import_Types.DoorLockOperationType.Timed) {
        const lockTimeoutMinutes = raw.payload[2];
        const lockTimeoutSeconds = raw.payload[3];
        if (lockTimeoutMinutes <= 253 && lockTimeoutSeconds <= 59) {
          lockTimeoutConfiguration = lockTimeoutSeconds + lockTimeoutMinutes * 60;
        }
      }
      let autoRelockTime;
      let holdAndReleaseTime;
      let twistAssist;
      let blockToBlock;
      if (raw.payload.length >= 5) {
        autoRelockTime = raw.payload.readUInt16BE(4);
        holdAndReleaseTime = raw.payload.readUInt16BE(6);
        const flags = raw.payload[8];
        twistAssist = !!(flags & 1);
        blockToBlock = !!(flags & 2);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        operationType,
        outsideHandlesCanOpenDoorConfiguration,
        insideHandlesCanOpenDoorConfiguration,
        lockTimeoutConfiguration,
        autoRelockTime,
        holdAndReleaseTime,
        twistAssist,
        blockToBlock
      });
    }
    operationType;
    outsideHandlesCanOpenDoorConfiguration;
    insideHandlesCanOpenDoorConfiguration;
    lockTimeoutConfiguration;
    // These are not always supported and have to be persisted manually
    // to avoid unsupported values being exposed to the user
    autoRelockTime;
    holdAndReleaseTime;
    twistAssist;
    blockToBlock;
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const supportsAutoRelock = !!this.getValue(ctx, import_CCValues_generated.DoorLockCCValues.autoRelockSupported);
      if (supportsAutoRelock) {
        this.setValue(ctx, import_CCValues_generated.DoorLockCCValues.autoRelockTime, this.autoRelockTime);
      }
      const supportsHoldAndRelease = !!this.getValue(ctx, import_CCValues_generated.DoorLockCCValues.holdAndReleaseSupported);
      if (supportsHoldAndRelease) {
        this.setValue(ctx, import_CCValues_generated.DoorLockCCValues.holdAndReleaseTime, this.holdAndReleaseTime);
      }
      const supportsTwistAssist = !!this.getValue(ctx, import_CCValues_generated.DoorLockCCValues.twistAssistSupported);
      if (supportsTwistAssist) {
        this.setValue(ctx, import_CCValues_generated.DoorLockCCValues.twistAssist, this.twistAssist);
      }
      const supportsBlockToBlock = !!this.getValue(ctx, import_CCValues_generated.DoorLockCCValues.blockToBlockSupported);
      if (supportsBlockToBlock) {
        this.setValue(ctx, import_CCValues_generated.DoorLockCCValues.blockToBlock, this.blockToBlock);
      }
      return true;
    }
    toLogEntry(ctx) {
      const message = {
        "operation type": (0, import_shared.getEnumMemberName)(import_Types.DoorLockOperationType, this.operationType),
        "outside handle configuration": this.outsideHandlesCanOpenDoorConfiguration.join(", "),
        "inside handle configuration": this.insideHandlesCanOpenDoorConfiguration.join(", ")
      };
      if (this.lockTimeoutConfiguration != void 0) {
        message["timed mode duration"] = `${this.lockTimeoutConfiguration} seconds`;
      }
      if (this.autoRelockTime != void 0) {
        message["auto-relock time"] = `${this.autoRelockTime} seconds`;
      }
      if (this.holdAndReleaseTime != void 0) {
        message["hold-and-release time"] = `${this.holdAndReleaseTime} seconds`;
      }
      if (this.twistAssist != void 0) {
        message["twist assist enabled"] = this.twistAssist;
      }
      if (this.blockToBlock != void 0) {
        message["block-to-block enabled"] = this.blockToBlock;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return DoorLockCCConfigurationReport2 = _classThis;
})();
let DoorLockCCConfigurationGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.DoorLockCommand.ConfigurationGet), (0, import_CommandClassDecorators.expectedCCResponse)(DoorLockCCConfigurationReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = DoorLockCC;
  var DoorLockCCConfigurationGet2 = class extends _classSuper {
    static {
      __name(this, "DoorLockCCConfigurationGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      DoorLockCCConfigurationGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return DoorLockCCConfigurationGet2 = _classThis;
})();
let DoorLockCCConfigurationSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.DoorLockCommand.ConfigurationSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = DoorLockCC;
  var DoorLockCCConfigurationSet2 = class extends _classSuper {
    static {
      __name(this, "DoorLockCCConfigurationSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      DoorLockCCConfigurationSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.operationType = options.operationType;
      this.outsideHandlesCanOpenDoorConfiguration = options.outsideHandlesCanOpenDoorConfiguration;
      this.insideHandlesCanOpenDoorConfiguration = options.insideHandlesCanOpenDoorConfiguration;
      this.lockTimeoutConfiguration = options.lockTimeoutConfiguration;
      this.autoRelockTime = options.autoRelockTime;
      this.holdAndReleaseTime = options.holdAndReleaseTime;
      this.twistAssist = options.twistAssist;
      this.blockToBlock = options.blockToBlock;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    operationType;
    outsideHandlesCanOpenDoorConfiguration;
    insideHandlesCanOpenDoorConfiguration;
    lockTimeoutConfiguration;
    autoRelockTime;
    holdAndReleaseTime;
    twistAssist;
    blockToBlock;
    serialize(ctx) {
      const insideHandles = (0, import_typeguards.isArray)(this.insideHandlesCanOpenDoorConfiguration) ? this.insideHandlesCanOpenDoorConfiguration : [];
      const outsideHandles = (0, import_typeguards.isArray)(this.outsideHandlesCanOpenDoorConfiguration) ? this.outsideHandlesCanOpenDoorConfiguration : [];
      const handles = [...insideHandles, ...outsideHandles].map((val, i) => val ? 1 << i : 0).reduce((acc, cur) => acc | cur, 0);
      let lockTimeoutMinutes;
      let lockTimeoutSeconds;
      if (this.operationType === import_Types.DoorLockOperationType.Constant) {
        lockTimeoutMinutes = lockTimeoutSeconds = 254;
      } else {
        lockTimeoutMinutes = Math.floor(this.lockTimeoutConfiguration / 60);
        lockTimeoutSeconds = this.lockTimeoutConfiguration % 60;
      }
      const flags = (this.twistAssist ? 1 : 0) | (this.blockToBlock ? 2 : 0);
      this.payload = import_shared.Bytes.from([
        this.operationType,
        handles,
        lockTimeoutMinutes,
        lockTimeoutSeconds,
        // placeholder for auto relock time
        0,
        0,
        // placeholder for hold and release time
        0,
        0,
        flags
      ]);
      this.payload.writeUInt16BE((this.autoRelockTime ?? 0) & 65535, 4);
      this.payload.writeUInt16BE((this.holdAndReleaseTime ?? 0) & 65535, 6);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const insideHandles = (0, import_typeguards.isArray)(this.insideHandlesCanOpenDoorConfiguration) ? this.insideHandlesCanOpenDoorConfiguration : [];
      const outsideHandles = (0, import_typeguards.isArray)(this.outsideHandlesCanOpenDoorConfiguration) ? this.outsideHandlesCanOpenDoorConfiguration : [];
      const message = {
        "operation type": (0, import_shared.getEnumMemberName)(import_Types.DoorLockOperationType, this.operationType),
        "outside handle configuration": outsideHandles.join(", "),
        "inside handle configuration": insideHandles.join(", ")
      };
      if (this.lockTimeoutConfiguration != void 0) {
        message["timed mode duration"] = `${this.lockTimeoutConfiguration} seconds`;
      }
      if (this.autoRelockTime != void 0) {
        message["auto-relock time"] = `${this.autoRelockTime} seconds`;
      }
      if (this.holdAndReleaseTime != void 0) {
        message["hold-and-release time"] = `${this.holdAndReleaseTime} seconds`;
      }
      if (this.twistAssist != void 0) {
        message["enable twist assist"] = this.twistAssist;
      }
      if (this.blockToBlock != void 0) {
        message["enable block-to-block"] = this.blockToBlock;
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return DoorLockCCConfigurationSet2 = _classThis;
})();
let DoorLockCCCapabilitiesReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.DoorLockCommand.CapabilitiesReport), (0, import_CommandClassDecorators.ccValueProperty)("supportedOutsideHandles", import_CCValues_generated.DoorLockCCValues.supportedOutsideHandles), (0, import_CommandClassDecorators.ccValueProperty)("supportedInsideHandles", import_CCValues_generated.DoorLockCCValues.supportedInsideHandles), (0, import_CommandClassDecorators.ccValueProperty)("autoRelockSupported", import_CCValues_generated.DoorLockCCValues.autoRelockSupported), (0, import_CommandClassDecorators.ccValueProperty)("holdAndReleaseSupported", import_CCValues_generated.DoorLockCCValues.holdAndReleaseSupported), (0, import_CommandClassDecorators.ccValueProperty)("twistAssistSupported", import_CCValues_generated.DoorLockCCValues.twistAssistSupported), (0, import_CommandClassDecorators.ccValueProperty)("blockToBlockSupported", import_CCValues_generated.DoorLockCCValues.blockToBlockSupported)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = DoorLockCC;
  var DoorLockCCCapabilitiesReport2 = class extends _classSuper {
    static {
      __name(this, "DoorLockCCCapabilitiesReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      DoorLockCCCapabilitiesReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportedOperationTypes = options.supportedOperationTypes;
      this.supportedDoorLockModes = options.supportedDoorLockModes;
      this.supportedOutsideHandles = options.supportedOutsideHandles;
      this.supportedInsideHandles = options.supportedInsideHandles;
      this.doorSupported = options.doorSupported;
      this.boltSupported = options.boltSupported;
      this.latchSupported = options.latchSupported;
      this.blockToBlockSupported = options.blockToBlockSupported;
      this.twistAssistSupported = options.twistAssistSupported;
      this.holdAndReleaseSupported = options.holdAndReleaseSupported;
      this.autoRelockSupported = options.autoRelockSupported;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const bitMaskLength = raw.payload[0] & 31;
      let offset = 1;
      (0, import_core.validatePayload)(raw.payload.length >= offset + bitMaskLength + 1);
      const supportedOperationTypes = (0, import_core.parseBitMask)(
        raw.payload.subarray(offset, offset + bitMaskLength),
        // bit 0 is reserved, bitmask starts at 1
        0
      );
      offset += bitMaskLength;
      const listLength = raw.payload[offset];
      offset += 1;
      (0, import_core.validatePayload)(raw.payload.length >= offset + listLength + 3);
      const supportedDoorLockModes = [
        ...raw.payload.subarray(offset, offset + listLength)
      ];
      offset += listLength;
      const supportedOutsideHandles = [
        !!(raw.payload[offset] & 16),
        !!(raw.payload[offset] & 32),
        !!(raw.payload[offset] & 64),
        !!(raw.payload[offset] & 128)
      ];
      const supportedInsideHandles = [
        !!(raw.payload[offset] & 1),
        !!(raw.payload[offset] & 2),
        !!(raw.payload[offset] & 4),
        !!(raw.payload[offset] & 8)
      ];
      const doorSupported = !!(raw.payload[offset + 1] & 1);
      const boltSupported = !!(raw.payload[offset + 1] & 2);
      const latchSupported = !!(raw.payload[offset + 1] & 4);
      const blockToBlockSupported = !!(raw.payload[offset + 2] & 1);
      const twistAssistSupported = !!(raw.payload[offset + 2] & 2);
      const holdAndReleaseSupported = !!(raw.payload[offset + 2] & 4);
      const autoRelockSupported = !!(raw.payload[offset + 2] & 8);
      return new this({
        nodeId: ctx.sourceNodeId,
        supportedOperationTypes,
        supportedDoorLockModes,
        supportedOutsideHandles,
        supportedInsideHandles,
        doorSupported,
        boltSupported,
        latchSupported,
        blockToBlockSupported,
        twistAssistSupported,
        holdAndReleaseSupported,
        autoRelockSupported
      });
    }
    supportedOperationTypes;
    supportedDoorLockModes;
    supportedOutsideHandles;
    supportedInsideHandles;
    // These 3 are not automatically persisted because in CC version 3
    // we have to assume them to be supported. In v4 we can query this.
    latchSupported;
    boltSupported;
    doorSupported;
    autoRelockSupported;
    holdAndReleaseSupported;
    twistAssistSupported;
    blockToBlockSupported;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          door: this.doorSupported,
          bolt: this.boltSupported,
          latch: this.latchSupported,
          "block-to-block feature": this.blockToBlockSupported,
          "twist assist feature": this.twistAssistSupported,
          "hold-and-release feature": this.holdAndReleaseSupported,
          "auto-relock feature": this.autoRelockSupported,
          "operation types": this.supportedOperationTypes.map((t) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_Types.DoorLockOperationType, t)}`).join(""),
          "door lock modes": this.supportedDoorLockModes.map((t) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_Types.DoorLockMode, t)}`).join(""),
          "outside handles": this.supportedOutsideHandles.join(", "),
          "inside handles": this.supportedInsideHandles.join(", ")
        }
      };
    }
  };
  return DoorLockCCCapabilitiesReport2 = _classThis;
})();
let DoorLockCCCapabilitiesGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.DoorLockCommand.CapabilitiesGet), (0, import_CommandClassDecorators.expectedCCResponse)(DoorLockCCCapabilitiesReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = DoorLockCC;
  var DoorLockCCCapabilitiesGet2 = class extends _classSuper {
    static {
      __name(this, "DoorLockCCCapabilitiesGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      DoorLockCCCapabilitiesGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return DoorLockCCCapabilitiesGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  DoorLockCC,
  DoorLockCCAPI,
  DoorLockCCCapabilitiesGet,
  DoorLockCCCapabilitiesReport,
  DoorLockCCConfigurationGet,
  DoorLockCCConfigurationReport,
  DoorLockCCConfigurationSet,
  DoorLockCCOperationGet,
  DoorLockCCOperationReport,
  DoorLockCCOperationSet,
  DoorLockCCValues,
  shouldAutoCreateAutoRelockConfigValue,
  shouldAutoCreateBlockToBlockConfigValue,
  shouldAutoCreateBoltStatusValue,
  shouldAutoCreateDoorStatusValue,
  shouldAutoCreateHoldAndReleaseConfigValue,
  shouldAutoCreateLatchStatusValue,
  shouldAutoCreateTwistAssistConfigValue
});
//# sourceMappingURL=DoorLockCC.js.map
