"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var HumidityControlSetpointCC_exports = {};
__export(HumidityControlSetpointCC_exports, {
  HumidityControlSetpointCC: () => HumidityControlSetpointCC,
  HumidityControlSetpointCCAPI: () => HumidityControlSetpointCCAPI,
  HumidityControlSetpointCCCapabilitiesGet: () => HumidityControlSetpointCCCapabilitiesGet,
  HumidityControlSetpointCCCapabilitiesReport: () => HumidityControlSetpointCCCapabilitiesReport,
  HumidityControlSetpointCCGet: () => HumidityControlSetpointCCGet,
  HumidityControlSetpointCCReport: () => HumidityControlSetpointCCReport,
  HumidityControlSetpointCCScaleSupportedGet: () => HumidityControlSetpointCCScaleSupportedGet,
  HumidityControlSetpointCCScaleSupportedReport: () => HumidityControlSetpointCCScaleSupportedReport,
  HumidityControlSetpointCCSet: () => HumidityControlSetpointCCSet,
  HumidityControlSetpointCCSupportedGet: () => HumidityControlSetpointCCSupportedGet,
  HumidityControlSetpointCCSupportedReport: () => HumidityControlSetpointCCSupportedReport,
  HumidityControlSetpointCCValues: () => import_CCValues_generated.HumidityControlSetpointCCValues
});
module.exports = __toCommonJS(HumidityControlSetpointCC_exports);
var __validateArgs = __toESM(require("./HumidityControlSetpointCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_HumidityControlSetpointCCAPI_get, validateArgs_HumidityControlSetpointCCAPI_set, validateArgs_HumidityControlSetpointCCAPI_getCapabilities, validateArgs_HumidityControlSetpointCCAPI_getSupportedScales } = __validateArgs;
function getScale(scale) {
  return (0, import_core.getNamedScale)("humidity", scale) ?? (0, import_core.getUnknownScale)(scale);
}
__name(getScale, "getScale");
function getSetpointUnit(scale) {
  return getScale(scale).unit ?? "";
}
__name(getSetpointUnit, "getSetpointUnit");
let HumidityControlSetpointCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Humidity Control Setpoint"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _get_decorators;
  let _set_decorators;
  let _getCapabilities_decorators;
  let _getSupportedScales_decorators;
  var HumidityControlSetpointCCAPI2 = class extends _classSuper {
    static {
      __name(this, "HumidityControlSetpointCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _get_decorators = [validateArgs_HumidityControlSetpointCCAPI_get()];
      _set_decorators = [validateArgs_HumidityControlSetpointCCAPI_set()];
      _getCapabilities_decorators = [validateArgs_HumidityControlSetpointCCAPI_getCapabilities()];
      _getSupportedScales_decorators = [validateArgs_HumidityControlSetpointCCAPI_getSupportedScales()];
      __esDecorate(this, null, _get_decorators, { kind: "method", name: "get", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "get" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.get, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _set_decorators, { kind: "method", name: "set", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "set" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.set, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getCapabilities_decorators, { kind: "method", name: "getCapabilities", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getCapabilities" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getCapabilities, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _getSupportedScales_decorators, { kind: "method", name: "getSupportedScales", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "getSupportedScales" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.getSupportedScales, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      HumidityControlSetpointCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.HumidityControlSetpointCommand.Get:
        case import_Types.HumidityControlSetpointCommand.SupportedGet:
        case import_Types.HumidityControlSetpointCommand.CapabilitiesGet:
          return this.isSinglecast();
        case import_Types.HumidityControlSetpointCommand.Set:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    get [import_API.SET_VALUE]() {
      return async function({ property, propertyKey }, value) {
        if (property !== "setpoint") {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
        if (typeof propertyKey !== "number") {
          throw new import_core.ZWaveError(`${import_core.CommandClasses[this.ccId]}: "${property}" must be further specified by a numeric property key`, import_core.ZWaveErrorCodes.Argument_Invalid);
        }
        if (typeof value !== "number") {
          (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
        }
        const scaleValueId = import_CCValues_generated.HumidityControlSetpointCCValues.setpointScale(propertyKey).endpoint(this.endpoint.index);
        const preferredScale = this.tryGetValueDB()?.getValue(scaleValueId);
        const result = await this.set(propertyKey, value, preferredScale ?? 0);
        if (this.isSinglecast() && !(0, import_core.supervisedCommandSucceeded)(result)) {
          this.schedulePoll({ property, propertyKey }, value);
        }
        return result;
      };
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property, propertyKey }) {
        switch (property) {
          case "setpoint":
            if (typeof propertyKey !== "number") {
              throw new import_core.ZWaveError(`${import_core.CommandClasses[this.ccId]}: "${property}" must be further specified by a numeric property key`, import_core.ZWaveErrorCodes.Argument_Invalid);
            }
            return (await this.get(propertyKey))?.value;
          default:
            (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    async get(setpointType) {
      this.assertSupportsCommand(import_Types.HumidityControlSetpointCommand, import_Types.HumidityControlSetpointCommand.Get);
      const cc = new HumidityControlSetpointCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        setpointType
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (!response)
        return;
      return response.type === import_Types.HumidityControlSetpointType["N/A"] ? void 0 : {
        value: response.value,
        scale: response.scale
      };
    }
    async set(setpointType, value, scale) {
      this.assertSupportsCommand(import_Types.HumidityControlSetpointCommand, import_Types.HumidityControlSetpointCommand.Set);
      const cc = new HumidityControlSetpointCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        setpointType,
        value,
        scale
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async getCapabilities(setpointType) {
      this.assertSupportsCommand(import_Types.HumidityControlSetpointCommand, import_Types.HumidityControlSetpointCommand.CapabilitiesGet);
      const cc = new HumidityControlSetpointCCCapabilitiesGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        setpointType
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "minValue",
          "maxValue",
          "minValueScale",
          "maxValueScale"
        ]);
      }
    }
    async getSupportedSetpointTypes() {
      this.assertSupportsCommand(import_Types.HumidityControlSetpointCommand, import_Types.HumidityControlSetpointCommand.SupportedGet);
      const cc = new HumidityControlSetpointCCSupportedGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.supportedSetpointTypes;
    }
    async getSupportedScales(setpointType) {
      this.assertSupportsCommand(import_Types.HumidityControlSetpointCommand, import_Types.HumidityControlSetpointCommand.SupportedGet);
      const cc = new HumidityControlSetpointCCScaleSupportedGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        setpointType
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return response.supportedScales.map((scale) => getScale(scale));
      }
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return HumidityControlSetpointCCAPI2 = _classThis;
})();
let HumidityControlSetpointCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Humidity Control Setpoint"]), (0, import_CommandClassDecorators.implementedVersion)(2), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.HumidityControlSetpointCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var HumidityControlSetpointCC2 = class extends _classSuper {
    static {
      __name(this, "HumidityControlSetpointCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      HumidityControlSetpointCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    translatePropertyKey(ctx, property, propertyKey) {
      if (property === "setpoint") {
        return (0, import_shared.getEnumMemberName)(import_Types.HumidityControlSetpointType, propertyKey);
      } else {
        return super.translatePropertyKey(ctx, property, propertyKey);
      }
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Humidity Control Setpoint"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      let setpointTypes = [];
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "retrieving supported setpoint types...",
        direction: "outbound"
      });
      const resp = await api.getSupportedSetpointTypes();
      if (resp) {
        setpointTypes = [...resp];
        const logMessage = "received supported setpoint types:\n" + setpointTypes.map((type) => (0, import_shared.getEnumMemberName)(import_Types.HumidityControlSetpointType, type)).map((name) => `\xB7 ${name}`).join("\n");
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: logMessage,
          direction: "inbound"
        });
      } else {
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "Querying supported setpoint types timed out, skipping interview...",
          level: "warn"
        });
        return;
      }
      for (const type of setpointTypes) {
        const setpointName = (0, import_shared.getEnumMemberName)(import_Types.HumidityControlSetpointType, type);
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `retrieving capabilities for setpoint ${setpointName}...`,
          direction: "outbound"
        });
        const setpointScaleSupported = await api.getSupportedScales(type);
        if (setpointScaleSupported) {
          const logMessage = `received supported scales for setpoint ${setpointName}: 
${setpointScaleSupported.map((t) => `
\xB7 ${t.key} ${t.unit} - ${t.label}`).join("")}`;
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage,
            direction: "inbound"
          });
          const scaleValue = import_CCValues_generated.HumidityControlSetpointCCValues.setpointScale(type);
          const states = {};
          for (const scale of setpointScaleSupported) {
            if (scale.unit)
              states[scale.key] = scale.unit;
          }
          this.setMetadata(ctx, scaleValue, {
            ...scaleValue.meta,
            states
          });
        }
        const setpointCaps = await api.getCapabilities(type);
        if (setpointCaps) {
          const minValueUnit = getSetpointUnit(setpointCaps.minValueScale);
          const maxValueUnit = getSetpointUnit(setpointCaps.maxValueScale);
          const logMessage = `received capabilities for setpoint ${setpointName}:
minimum value: ${setpointCaps.minValue} ${minValueUnit}
maximum value: ${setpointCaps.maxValue} ${maxValueUnit}`;
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage,
            direction: "inbound"
          });
        }
      }
      await this.refreshValues(ctx);
      this.setInterviewComplete(ctx, true);
    }
    async refreshValues(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Humidity Control Setpoint"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      const setpointTypes = this.getValue(ctx, import_CCValues_generated.HumidityControlSetpointCCValues.supportedSetpointTypes) ?? [];
      for (const type of setpointTypes) {
        const setpointName = (0, import_shared.getEnumMemberName)(import_Types.HumidityControlSetpointType, type);
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: `querying current value of setpoint ${setpointName}...`,
          direction: "outbound"
        });
        const setpoint = await api.get(type);
        if (setpoint) {
          const logMessage = `received current value of setpoint ${setpointName}: ${setpoint.value} ${getScale(setpoint.scale).unit ?? ""}`;
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage,
            direction: "inbound"
          });
        }
      }
    }
  };
  return HumidityControlSetpointCC2 = _classThis;
})();
let HumidityControlSetpointCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.HumidityControlSetpointCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = HumidityControlSetpointCC;
  var HumidityControlSetpointCCSet2 = class extends _classSuper {
    static {
      __name(this, "HumidityControlSetpointCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      HumidityControlSetpointCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.setpointType = options.setpointType;
      this.value = options.value;
      this.scale = options.scale;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    setpointType;
    value;
    scale;
    serialize(ctx) {
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([this.setpointType & 15]),
        (0, import_core.encodeFloatWithScale)(this.value, this.scale)
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const scale = getScale(this.scale);
      return {
        ...super.toLogEntry(ctx),
        message: {
          "setpoint type": (0, import_shared.getEnumMemberName)(import_Types.HumidityControlSetpointType, this.setpointType),
          value: `${this.value} ${scale.unit}`
        }
      };
    }
  };
  return HumidityControlSetpointCCSet2 = _classThis;
})();
let HumidityControlSetpointCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.HumidityControlSetpointCommand.Report)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = HumidityControlSetpointCC;
  var HumidityControlSetpointCCReport2 = class extends _classSuper {
    static {
      __name(this, "HumidityControlSetpointCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      HumidityControlSetpointCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.type = options.type;
      this.value = options.value;
      this.scale = options.scale;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const type = raw.payload[0] & 15;
      if (type === 0) {
        return new this({
          nodeId: ctx.sourceNodeId,
          type,
          value: 0,
          scale: 0
        });
      }
      const { value, scale } = (0, import_core.parseFloatWithScale)(raw.payload.subarray(1));
      return new this({
        nodeId: ctx.sourceNodeId,
        type,
        value,
        scale
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const scale = getScale(this.scale);
      const setpointValue = import_CCValues_generated.HumidityControlSetpointCCValues.setpoint(this.type);
      const existingMetadata = this.getMetadata(ctx, setpointValue);
      if (existingMetadata?.unit !== scale.unit) {
        this.setMetadata(ctx, setpointValue, {
          ...existingMetadata ?? setpointValue.meta,
          unit: scale.unit
        });
      }
      this.setValue(ctx, setpointValue, this.value);
      this.setValue(ctx, import_CCValues_generated.HumidityControlSetpointCCValues.setpointScale(this.type), this.scale);
      return true;
    }
    type;
    scale;
    value;
    toLogEntry(ctx) {
      const scale = getScale(this.scale);
      return {
        ...super.toLogEntry(ctx),
        message: {
          "setpoint type": (0, import_shared.getEnumMemberName)(import_Types.HumidityControlSetpointType, this.type),
          value: `${this.value} ${scale.unit}`
        }
      };
    }
  };
  return HumidityControlSetpointCCReport2 = _classThis;
})();
function testResponseForHumidityControlSetpointGet(sent, received) {
  return received.type === sent.setpointType;
}
__name(testResponseForHumidityControlSetpointGet, "testResponseForHumidityControlSetpointGet");
let HumidityControlSetpointCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.HumidityControlSetpointCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(HumidityControlSetpointCCReport, testResponseForHumidityControlSetpointGet)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = HumidityControlSetpointCC;
  var HumidityControlSetpointCCGet2 = class extends _classSuper {
    static {
      __name(this, "HumidityControlSetpointCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      HumidityControlSetpointCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.setpointType = options.setpointType;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    setpointType;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.setpointType & 15]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "setpoint type": (0, import_shared.getEnumMemberName)(import_Types.HumidityControlSetpointType, this.setpointType)
        }
      };
    }
  };
  return HumidityControlSetpointCCGet2 = _classThis;
})();
let HumidityControlSetpointCCSupportedReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.HumidityControlSetpointCommand.SupportedReport), (0, import_CommandClassDecorators.ccValueProperty)("supportedSetpointTypes", import_CCValues_generated.HumidityControlSetpointCCValues.supportedSetpointTypes)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = HumidityControlSetpointCC;
  var HumidityControlSetpointCCSupportedReport2 = class extends _classSuper {
    static {
      __name(this, "HumidityControlSetpointCCSupportedReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      HumidityControlSetpointCCSupportedReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportedSetpointTypes = options.supportedSetpointTypes;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const supportedSetpointTypes = (0, import_core.parseBitMask)(raw.payload, import_Types.HumidityControlSetpointType["N/A"]);
      return new this({
        nodeId: ctx.sourceNodeId,
        supportedSetpointTypes
      });
    }
    supportedSetpointTypes;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "supported setpoint types": this.supportedSetpointTypes.map((t) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_Types.HumidityControlSetpointType, t)}`).join("")
        }
      };
    }
  };
  return HumidityControlSetpointCCSupportedReport2 = _classThis;
})();
let HumidityControlSetpointCCSupportedGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.HumidityControlSetpointCommand.SupportedGet), (0, import_CommandClassDecorators.expectedCCResponse)(HumidityControlSetpointCCSupportedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = HumidityControlSetpointCC;
  var HumidityControlSetpointCCSupportedGet2 = class extends _classSuper {
    static {
      __name(this, "HumidityControlSetpointCCSupportedGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      HumidityControlSetpointCCSupportedGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return HumidityControlSetpointCCSupportedGet2 = _classThis;
})();
let HumidityControlSetpointCCScaleSupportedReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.HumidityControlSetpointCommand.ScaleSupportedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = HumidityControlSetpointCC;
  var HumidityControlSetpointCCScaleSupportedReport2 = class extends _classSuper {
    static {
      __name(this, "HumidityControlSetpointCCScaleSupportedReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      HumidityControlSetpointCCScaleSupportedReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportedScales = options.supportedScales;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const supportedScales = (0, import_core.parseBitMask)(import_shared.Bytes.from([raw.payload[0] & 15]), 0);
      return new this({
        nodeId: ctx.sourceNodeId,
        supportedScales
      });
    }
    supportedScales;
    toLogEntry(ctx) {
      const supportedScales = this.supportedScales.map((scale) => getScale(scale));
      return {
        ...super.toLogEntry(ctx),
        message: {
          "scale supported": supportedScales.map((t) => `
\xB7 ${t.key} ${t.unit} - ${t.label}`).join("")
        }
      };
    }
  };
  return HumidityControlSetpointCCScaleSupportedReport2 = _classThis;
})();
let HumidityControlSetpointCCScaleSupportedGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.HumidityControlSetpointCommand.ScaleSupportedGet), (0, import_CommandClassDecorators.expectedCCResponse)(HumidityControlSetpointCCScaleSupportedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = HumidityControlSetpointCC;
  var HumidityControlSetpointCCScaleSupportedGet2 = class extends _classSuper {
    static {
      __name(this, "HumidityControlSetpointCCScaleSupportedGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      HumidityControlSetpointCCScaleSupportedGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.setpointType = options.setpointType;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    setpointType;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.setpointType & 15]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "setpoint type": (0, import_shared.getEnumMemberName)(import_Types.HumidityControlSetpointType, this.setpointType)
        }
      };
    }
  };
  return HumidityControlSetpointCCScaleSupportedGet2 = _classThis;
})();
let HumidityControlSetpointCCCapabilitiesReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.HumidityControlSetpointCommand.CapabilitiesReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = HumidityControlSetpointCC;
  var HumidityControlSetpointCCCapabilitiesReport2 = class extends _classSuper {
    static {
      __name(this, "HumidityControlSetpointCCCapabilitiesReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      HumidityControlSetpointCCCapabilitiesReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.type = options.type;
      this.minValue = options.minValue;
      this.maxValue = options.maxValue;
      this.minValueScale = options.minValueScale;
      this.maxValueScale = options.maxValueScale;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const type = raw.payload[0] & 15;
      const { value: minValue, scale: minValueScale, bytesRead } = (0, import_core.parseFloatWithScale)(raw.payload.subarray(1));
      const { value: maxValue, scale: maxValueScale } = (0, import_core.parseFloatWithScale)(raw.payload.subarray(1 + bytesRead));
      return new this({
        nodeId: ctx.sourceNodeId,
        type,
        minValue,
        minValueScale,
        maxValue,
        maxValueScale
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const setpointValue = import_CCValues_generated.HumidityControlSetpointCCValues.setpoint(this.type);
      this.setMetadata(ctx, setpointValue, {
        ...setpointValue.meta,
        min: this.minValue,
        max: this.maxValue,
        unit: getSetpointUnit(this.minValueScale) || getSetpointUnit(this.maxValueScale)
      });
      return true;
    }
    type;
    minValue;
    maxValue;
    minValueScale;
    maxValueScale;
    toLogEntry(ctx) {
      const minValueScale = getScale(this.minValueScale);
      const maxValueScale = getScale(this.maxValueScale);
      return {
        ...super.toLogEntry(ctx),
        message: {
          "setpoint type": (0, import_shared.getEnumMemberName)(import_Types.HumidityControlSetpointType, this.type),
          "min value": `${this.minValue} ${minValueScale.unit}`,
          "max value": `${this.maxValue} ${maxValueScale.unit}`
        }
      };
    }
  };
  return HumidityControlSetpointCCCapabilitiesReport2 = _classThis;
})();
let HumidityControlSetpointCCCapabilitiesGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.HumidityControlSetpointCommand.CapabilitiesGet), (0, import_CommandClassDecorators.expectedCCResponse)(HumidityControlSetpointCCCapabilitiesReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = HumidityControlSetpointCC;
  var HumidityControlSetpointCCCapabilitiesGet2 = class extends _classSuper {
    static {
      __name(this, "HumidityControlSetpointCCCapabilitiesGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      HumidityControlSetpointCCCapabilitiesGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.setpointType = options.setpointType;
    }
    static from(_raw, _ctx) {
      throw new import_core.ZWaveError(`${this.name}: deserialization not implemented`, import_core.ZWaveErrorCodes.Deserialization_NotImplemented);
    }
    setpointType;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.setpointType & 15]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "setpoint type": (0, import_shared.getEnumMemberName)(import_Types.HumidityControlSetpointType, this.setpointType)
        }
      };
    }
  };
  return HumidityControlSetpointCCCapabilitiesGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  HumidityControlSetpointCC,
  HumidityControlSetpointCCAPI,
  HumidityControlSetpointCCCapabilitiesGet,
  HumidityControlSetpointCCCapabilitiesReport,
  HumidityControlSetpointCCGet,
  HumidityControlSetpointCCReport,
  HumidityControlSetpointCCScaleSupportedGet,
  HumidityControlSetpointCCScaleSupportedReport,
  HumidityControlSetpointCCSet,
  HumidityControlSetpointCCSupportedGet,
  HumidityControlSetpointCCSupportedReport,
  HumidityControlSetpointCCValues
});
//# sourceMappingURL=HumidityControlSetpointCC.js.map
