"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var WakeUpCC_exports = {};
__export(WakeUpCC_exports, {
  WakeUpCC: () => WakeUpCC,
  WakeUpCCAPI: () => WakeUpCCAPI,
  WakeUpCCIntervalCapabilitiesGet: () => WakeUpCCIntervalCapabilitiesGet,
  WakeUpCCIntervalCapabilitiesReport: () => WakeUpCCIntervalCapabilitiesReport,
  WakeUpCCIntervalGet: () => WakeUpCCIntervalGet,
  WakeUpCCIntervalReport: () => WakeUpCCIntervalReport,
  WakeUpCCIntervalSet: () => WakeUpCCIntervalSet,
  WakeUpCCNoMoreInformation: () => WakeUpCCNoMoreInformation,
  WakeUpCCValues: () => import_CCValues_generated.WakeUpCCValues,
  WakeUpCCWakeUpNotification: () => WakeUpCCWakeUpNotification
});
module.exports = __toCommonJS(WakeUpCC_exports);
var __validateArgs = __toESM(require("./WakeUpCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_math = require("alcalzone-shared/math");
var import_API = require("../lib/API.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_WakeUpCCAPI_setInterval } = __validateArgs;
let WakeUpCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Wake Up"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _setInterval_decorators;
  var WakeUpCCAPI2 = class extends _classSuper {
    static {
      __name(this, "WakeUpCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _setInterval_decorators = [validateArgs_WakeUpCCAPI_setInterval()];
      __esDecorate(this, null, _setInterval_decorators, { kind: "method", name: "setInterval", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "setInterval" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.setInterval, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      WakeUpCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.WakeUpCommand.IntervalGet:
          return this.isSinglecast();
        case import_Types.WakeUpCommand.IntervalSet:
        case import_Types.WakeUpCommand.NoMoreInformation:
          return true;
        // This is mandatory
        case import_Types.WakeUpCommand.IntervalCapabilitiesGet:
          return this.version >= 2 && this.isSinglecast();
      }
      return super.supportsCommand(cmd);
    }
    get [import_API.SET_VALUE]() {
      return async function({ property }, value) {
        if (property !== "wakeUpInterval") {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
        if (typeof value !== "number") {
          (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
        }
        const result = await this.setInterval(value, this.host.ownNodeId ?? 1);
        if (this.isSinglecast() && !(0, import_core.supervisedCommandSucceeded)(result)) {
          this.schedulePoll({ property }, value, { transition: "fast" });
        }
        return result;
      };
    }
    get [import_API.POLL_VALUE]() {
      return async function({ property }) {
        switch (property) {
          case "wakeUpInterval":
            return (await this.getInterval())?.[property];
          default:
            (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getInterval() {
      this.assertSupportsCommand(import_Types.WakeUpCommand, import_Types.WakeUpCommand.IntervalGet);
      const cc = new WakeUpCCIntervalGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["wakeUpInterval", "controllerNodeId"]);
      }
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    async getIntervalCapabilities() {
      this.assertSupportsCommand(import_Types.WakeUpCommand, import_Types.WakeUpCommand.IntervalCapabilitiesGet);
      const cc = new WakeUpCCIntervalCapabilitiesGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, [
          "defaultWakeUpInterval",
          "minWakeUpInterval",
          "maxWakeUpInterval",
          "wakeUpIntervalSteps",
          "wakeUpOnDemandSupported"
        ]);
      }
    }
    async setInterval(wakeUpInterval, controllerNodeId) {
      this.assertSupportsCommand(import_Types.WakeUpCommand, import_Types.WakeUpCommand.IntervalSet);
      const cc = new WakeUpCCIntervalSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        wakeUpInterval,
        controllerNodeId
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async sendNoMoreInformation() {
      this.assertSupportsCommand(import_Types.WakeUpCommand, import_Types.WakeUpCommand.NoMoreInformation);
      const cc = new WakeUpCCNoMoreInformation({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      await this.host.sendCommand(cc, {
        ...this.commandOptions,
        // This command must be sent as part of the wake up queue
        priority: import_core.MessagePriority.WakeUp,
        // Don't try to resend this - if we get no response, the node is most likely asleep
        maxSendAttempts: 1,
        // Also we don't want to wait for an ACK because this can lock up the network for seconds
        // if the target node is asleep and doesn't respond to the command
        transmitOptions: import_core.TransmitOptions.DEFAULT_NOACK
      });
    }
    constructor() {
      super(...arguments);
      __runInitializers(this, _instanceExtraInitializers);
    }
  };
  return WakeUpCCAPI2 = _classThis;
})();
let WakeUpCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Wake Up"]), (0, import_CommandClassDecorators.implementedVersion)(3), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.WakeUpCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var WakeUpCC2 = class extends _classSuper {
    static {
      __name(this, "WakeUpCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      WakeUpCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Wake Up"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      if (node.id === ctx.ownNodeId) {
        ctx.logNode(node.id, `skipping wakeup configuration for the controller`);
      } else if (node.isFrequentListening) {
        ctx.logNode(node.id, `skipping wakeup configuration for frequent listening device`);
      } else {
        let desiredInterval;
        let currentControllerNodeId;
        let minInterval;
        let maxInterval;
        if (api.version >= 2) {
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: "retrieving wakeup capabilities from the device...",
            direction: "outbound"
          });
          const wakeupCaps = await api.getIntervalCapabilities();
          if (wakeupCaps) {
            const logMessage = `received wakeup capabilities:
default wakeup interval: ${wakeupCaps.defaultWakeUpInterval} seconds
minimum wakeup interval: ${wakeupCaps.minWakeUpInterval} seconds
maximum wakeup interval: ${wakeupCaps.maxWakeUpInterval} seconds
wakeup interval steps:   ${wakeupCaps.wakeUpIntervalSteps} seconds
wakeup on demand supported: ${wakeupCaps.wakeUpOnDemandSupported}`;
            ctx.logNode(node.id, {
              endpoint: this.endpointIndex,
              message: logMessage,
              direction: "inbound"
            });
            minInterval = wakeupCaps.minWakeUpInterval;
            maxInterval = wakeupCaps.maxWakeUpInterval;
          }
        }
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: "retrieving wakeup interval from the device...",
          direction: "outbound"
        });
        const wakeupResp = await api.getInterval();
        if (wakeupResp) {
          const logMessage = `received wakeup configuration:
wakeup interval: ${wakeupResp.wakeUpInterval} seconds
controller node: ${wakeupResp.controllerNodeId}`;
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: logMessage,
            direction: "inbound"
          });
          desiredInterval = wakeupResp.wakeUpInterval;
          currentControllerNodeId = wakeupResp.controllerNodeId;
        } else {
          desiredInterval = 3600 * 6;
          currentControllerNodeId = 0;
        }
        const ownNodeId = ctx.ownNodeId;
        if (currentControllerNodeId !== ownNodeId) {
          if (desiredInterval !== 0 && minInterval != void 0 && maxInterval != void 0) {
            desiredInterval = (0, import_math.clamp)(desiredInterval, minInterval, maxInterval);
          }
          ctx.logNode(node.id, {
            endpoint: this.endpointIndex,
            message: "configuring wakeup destination node",
            direction: "outbound"
          });
          await api.setInterval(desiredInterval, ownNodeId);
          this.setValue(ctx, import_CCValues_generated.WakeUpCCValues.controllerNodeId, ownNodeId);
          ctx.logNode(node.id, "wakeup destination node changed!");
        }
      }
      this.setInterviewComplete(ctx, true);
    }
  };
  return WakeUpCC2 = _classThis;
})();
let WakeUpCCIntervalSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.WakeUpCommand.IntervalSet), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = WakeUpCC;
  var WakeUpCCIntervalSet2 = class extends _classSuper {
    static {
      __name(this, "WakeUpCCIntervalSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      WakeUpCCIntervalSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.wakeUpInterval = options.wakeUpInterval;
      this.controllerNodeId = options.controllerNodeId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 4);
      const wakeUpInterval = raw.payload.readUIntBE(0, 3);
      const controllerNodeId = raw.payload[3];
      return new this({
        nodeId: ctx.sourceNodeId,
        wakeUpInterval,
        controllerNodeId
      });
    }
    wakeUpInterval;
    controllerNodeId;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        0,
        0,
        0,
        // placeholder
        this.controllerNodeId
      ]);
      this.payload.writeUIntBE(this.wakeUpInterval, 0, 3);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "wake-up interval": `${this.wakeUpInterval} seconds`,
          "controller node id": this.controllerNodeId
        }
      };
    }
  };
  return WakeUpCCIntervalSet2 = _classThis;
})();
let WakeUpCCIntervalReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.WakeUpCommand.IntervalReport), (0, import_CommandClassDecorators.ccValueProperty)("wakeUpInterval", import_CCValues_generated.WakeUpCCValues.wakeUpInterval), (0, import_CommandClassDecorators.ccValueProperty)("controllerNodeId", import_CCValues_generated.WakeUpCCValues.controllerNodeId)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = WakeUpCC;
  var WakeUpCCIntervalReport2 = class extends _classSuper {
    static {
      __name(this, "WakeUpCCIntervalReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      WakeUpCCIntervalReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.wakeUpInterval = options.wakeUpInterval;
      this.controllerNodeId = options.controllerNodeId;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 4);
      const wakeUpInterval = raw.payload.readUIntBE(0, 3);
      const controllerNodeId = raw.payload[3];
      return new this({
        nodeId: ctx.sourceNodeId,
        wakeUpInterval,
        controllerNodeId
      });
    }
    wakeUpInterval;
    controllerNodeId;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "wake-up interval": `${this.wakeUpInterval} seconds`,
          "controller node id": this.controllerNodeId
        }
      };
    }
  };
  return WakeUpCCIntervalReport2 = _classThis;
})();
let WakeUpCCIntervalGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.WakeUpCommand.IntervalGet), (0, import_CommandClassDecorators.expectedCCResponse)(WakeUpCCIntervalReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = WakeUpCC;
  var WakeUpCCIntervalGet2 = class extends _classSuper {
    static {
      __name(this, "WakeUpCCIntervalGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      WakeUpCCIntervalGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return WakeUpCCIntervalGet2 = _classThis;
})();
let WakeUpCCWakeUpNotification = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.WakeUpCommand.WakeUpNotification)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = WakeUpCC;
  var WakeUpCCWakeUpNotification2 = class extends _classSuper {
    static {
      __name(this, "WakeUpCCWakeUpNotification");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      WakeUpCCWakeUpNotification2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return WakeUpCCWakeUpNotification2 = _classThis;
})();
let WakeUpCCNoMoreInformation = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.WakeUpCommand.NoMoreInformation)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = WakeUpCC;
  var WakeUpCCNoMoreInformation2 = class extends _classSuper {
    static {
      __name(this, "WakeUpCCNoMoreInformation");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      WakeUpCCNoMoreInformation2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return WakeUpCCNoMoreInformation2 = _classThis;
})();
let WakeUpCCIntervalCapabilitiesReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.WakeUpCommand.IntervalCapabilitiesReport), (0, import_CommandClassDecorators.ccValueProperty)("wakeUpOnDemandSupported", import_CCValues_generated.WakeUpCCValues.wakeUpOnDemandSupported)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = WakeUpCC;
  var WakeUpCCIntervalCapabilitiesReport2 = class extends _classSuper {
    static {
      __name(this, "WakeUpCCIntervalCapabilitiesReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      WakeUpCCIntervalCapabilitiesReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.minWakeUpInterval = options.minWakeUpInterval;
      this.maxWakeUpInterval = options.maxWakeUpInterval;
      this.defaultWakeUpInterval = options.defaultWakeUpInterval;
      this.wakeUpIntervalSteps = options.wakeUpIntervalSteps;
      this.wakeUpOnDemandSupported = options.wakeUpOnDemandSupported;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 12);
      const minWakeUpInterval = raw.payload.readUIntBE(0, 3);
      const maxWakeUpInterval = raw.payload.readUIntBE(3, 3);
      const defaultWakeUpInterval = raw.payload.readUIntBE(6, 3);
      const wakeUpIntervalSteps = raw.payload.readUIntBE(9, 3);
      let wakeUpOnDemandSupported = false;
      if (raw.payload.length >= 13) {
        wakeUpOnDemandSupported = !!(raw.payload[12] & 1);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        minWakeUpInterval,
        maxWakeUpInterval,
        defaultWakeUpInterval,
        wakeUpIntervalSteps,
        wakeUpOnDemandSupported
      });
    }
    persistValues(ctx) {
      if (!super.persistValues(ctx))
        return false;
      const valueDB = this.getValueDB(ctx);
      valueDB.setMetadata({
        commandClass: this.ccId,
        endpoint: this.endpointIndex,
        property: "wakeUpInterval"
      }, {
        ...import_core.ValueMetadata.WriteOnlyUInt24,
        min: this.minWakeUpInterval,
        max: this.maxWakeUpInterval,
        steps: this.wakeUpIntervalSteps,
        default: this.defaultWakeUpInterval
      });
      return true;
    }
    minWakeUpInterval;
    maxWakeUpInterval;
    defaultWakeUpInterval;
    wakeUpIntervalSteps;
    wakeUpOnDemandSupported;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "default interval": `${this.defaultWakeUpInterval} seconds`,
          "minimum interval": `${this.minWakeUpInterval} seconds`,
          "maximum interval": `${this.maxWakeUpInterval} seconds`,
          "interval steps": `${this.wakeUpIntervalSteps} seconds`,
          "wake up on demand supported": `${this.wakeUpOnDemandSupported}`
        }
      };
    }
  };
  return WakeUpCCIntervalCapabilitiesReport2 = _classThis;
})();
let WakeUpCCIntervalCapabilitiesGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.WakeUpCommand.IntervalCapabilitiesGet), (0, import_CommandClassDecorators.expectedCCResponse)(WakeUpCCIntervalCapabilitiesReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = WakeUpCC;
  var WakeUpCCIntervalCapabilitiesGet2 = class extends _classSuper {
    static {
      __name(this, "WakeUpCCIntervalCapabilitiesGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      WakeUpCCIntervalCapabilitiesGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return WakeUpCCIntervalCapabilitiesGet2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  WakeUpCC,
  WakeUpCCAPI,
  WakeUpCCIntervalCapabilitiesGet,
  WakeUpCCIntervalCapabilitiesReport,
  WakeUpCCIntervalGet,
  WakeUpCCIntervalReport,
  WakeUpCCIntervalSet,
  WakeUpCCNoMoreInformation,
  WakeUpCCValues,
  WakeUpCCWakeUpNotification
});
//# sourceMappingURL=WakeUpCC.js.map
