"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var WindowCoveringCC_exports = {};
__export(WindowCoveringCC_exports, {
  WindowCoveringCC: () => WindowCoveringCC,
  WindowCoveringCCAPI: () => WindowCoveringCCAPI,
  WindowCoveringCCGet: () => WindowCoveringCCGet,
  WindowCoveringCCReport: () => WindowCoveringCCReport,
  WindowCoveringCCSet: () => WindowCoveringCCSet,
  WindowCoveringCCStartLevelChange: () => WindowCoveringCCStartLevelChange,
  WindowCoveringCCStopLevelChange: () => WindowCoveringCCStopLevelChange,
  WindowCoveringCCSupportedGet: () => WindowCoveringCCSupportedGet,
  WindowCoveringCCSupportedReport: () => WindowCoveringCCSupportedReport,
  WindowCoveringCCValues: () => import_CCValues_generated.WindowCoveringCCValues
});
module.exports = __toCommonJS(WindowCoveringCC_exports);
var __validateArgs = __toESM(require("./WindowCoveringCC._validateArgs.js"), 1);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_API = require("../lib/API.js");
var import_CCValueUtils = require("../lib/CCValueUtils.js");
var import_CommandClass = require("../lib/CommandClass.js");
var import_CommandClassDecorators = require("../lib/CommandClassDecorators.js");
var import_Values = require("../lib/Values.js");
var import_Types = require("../lib/_Types.js");
var import_CCValues_generated = require("./_CCValues.generated.js");
var __runInitializers = function(thisArg, initializers, value) {
  var useValue = arguments.length > 2;
  for (var i = 0; i < initializers.length; i++) {
    value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
  }
  return useValue ? value : void 0;
};
var __esDecorate = function(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
  function accept(f) {
    if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected");
    return f;
  }
  __name(accept, "accept");
  var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
  var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
  var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
  var _, done = false;
  for (var i = decorators.length - 1; i >= 0; i--) {
    var context = {};
    for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
    for (var p in contextIn.access) context.access[p] = contextIn.access[p];
    context.addInitializer = function(f) {
      if (done) throw new TypeError("Cannot add initializers after decoration has completed");
      extraInitializers.push(accept(f || null));
    };
    var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
    if (kind === "accessor") {
      if (result === void 0) continue;
      if (result === null || typeof result !== "object") throw new TypeError("Object expected");
      if (_ = accept(result.get)) descriptor.get = _;
      if (_ = accept(result.set)) descriptor.set = _;
      if (_ = accept(result.init)) initializers.unshift(_);
    } else if (_ = accept(result)) {
      if (kind === "field") initializers.unshift(_);
      else descriptor[key] = _;
    }
  }
  if (target) Object.defineProperty(target, contextIn.name, descriptor);
  done = true;
};
const { validateArgs_WindowCoveringCCAPI_get, validateArgs_WindowCoveringCCAPI_set, validateArgs_WindowCoveringCCAPI_startLevelChange, validateArgs_WindowCoveringCCAPI_stopLevelChange } = __validateArgs;
let WindowCoveringCCAPI = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.API)(import_core.CommandClasses["Window Covering"])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_API.CCAPI;
  let _instanceExtraInitializers = [];
  let _get_decorators;
  let _set_decorators;
  let _startLevelChange_decorators;
  let _stopLevelChange_decorators;
  var WindowCoveringCCAPI2 = class extends _classSuper {
    static {
      __name(this, "WindowCoveringCCAPI");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      _get_decorators = [validateArgs_WindowCoveringCCAPI_get({ strictEnums: true })];
      _set_decorators = [validateArgs_WindowCoveringCCAPI_set()];
      _startLevelChange_decorators = [validateArgs_WindowCoveringCCAPI_startLevelChange({ strictEnums: true })];
      _stopLevelChange_decorators = [validateArgs_WindowCoveringCCAPI_stopLevelChange({ strictEnums: true })];
      __esDecorate(this, null, _get_decorators, { kind: "method", name: "get", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "get" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.get, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _set_decorators, { kind: "method", name: "set", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "set" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.set, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _startLevelChange_decorators, { kind: "method", name: "startLevelChange", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "startLevelChange" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.startLevelChange, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(this, null, _stopLevelChange_decorators, { kind: "method", name: "stopLevelChange", static: false, private: false, access: { has: /* @__PURE__ */ __name((obj) => "stopLevelChange" in obj, "has"), get: /* @__PURE__ */ __name((obj) => obj.stopLevelChange, "get") }, metadata: _metadata }, null, _instanceExtraInitializers);
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      WindowCoveringCCAPI2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    supportsCommand(cmd) {
      switch (cmd) {
        case import_Types.WindowCoveringCommand.Get:
        case import_Types.WindowCoveringCommand.Set:
        case import_Types.WindowCoveringCommand.SupportedGet:
        case import_Types.WindowCoveringCommand.StartLevelChange:
        case import_Types.WindowCoveringCommand.StopLevelChange:
          return true;
      }
      return super.supportsCommand(cmd);
    }
    get [import_API.SET_VALUE]() {
      return async function({ property, propertyKey }, value, options) {
        const valueId = {
          commandClass: this.ccId,
          property,
          propertyKey
        };
        if (import_CCValues_generated.WindowCoveringCCValues.targetValue.is(valueId)) {
          if (typeof propertyKey !== "number" || propertyKey % 2 === 0) {
            (0, import_API.throwUnsupportedPropertyKey)(this.ccId, property, propertyKey);
          }
          if (typeof value !== "number") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "number", typeof value);
          }
          const parameter = propertyKey;
          const duration = import_core.Duration.from(options?.transitionDuration);
          return this.set([{ parameter, value }], duration);
        } else if (import_CCValues_generated.WindowCoveringCCValues.levelChangeUp.is(valueId) || import_CCValues_generated.WindowCoveringCCValues.levelChangeDown.is(valueId)) {
          if (typeof value !== "boolean") {
            (0, import_API.throwWrongValueType)(this.ccId, property, "boolean", typeof value);
          }
          const parameter = propertyKey;
          const direction = import_CCValues_generated.WindowCoveringCCValues.levelChangeUp.is(valueId) ? "up" : "down";
          if (value) {
            const duration = import_core.Duration.from(options?.transitionDuration);
            return this.startLevelChange(parameter, direction, duration);
          } else {
            return this.stopLevelChange(parameter);
          }
        } else {
          (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    [import_API.SET_VALUE_HOOKS] = (__runInitializers(this, _instanceExtraInitializers), ({ property, propertyKey }, value, options) => {
      const valueId = {
        commandClass: this.ccId,
        property,
        propertyKey
      };
      if (import_CCValues_generated.WindowCoveringCCValues.targetValue.is(valueId)) {
        if (typeof propertyKey !== "number")
          return;
        const parameter = propertyKey;
        const duration = import_core.Duration.from(options?.transitionDuration);
        const currentValueValueId = import_CCValues_generated.WindowCoveringCCValues.currentValue(parameter).endpoint(this.endpoint.index);
        return {
          // Window Covering commands may take some time to be executed.
          // Therefore we try to supervise the command execution and delay the
          // optimistic update until the final result is received.
          supervisionDelayedUpdates: true,
          supervisionOnSuccess: /* @__PURE__ */ __name(async () => {
            if (typeof value === "number" && value >= 0 && value <= 99) {
              this.tryGetValueDB()?.setValue(currentValueValueId, value);
            } else if (value === 255) {
              try {
                await this.get(parameter);
              } catch {
              }
            }
          }, "supervisionOnSuccess"),
          supervisionOnFailure: /* @__PURE__ */ __name(async () => {
            try {
              await this.get(parameter);
            } catch {
            }
          }, "supervisionOnFailure"),
          optimisticallyUpdateRelatedValues: /* @__PURE__ */ __name((_supervisedAndSuccessful) => {
            if (typeof value === "number" && value >= 0 && value <= 99) {
              if (this.isSinglecast()) {
                this.tryGetValueDB()?.setValue(currentValueValueId, value);
              } else if (this.isMulticast()) {
                const affectedNodes = this.endpoint.node.physicalNodes.filter((node) => node.getEndpoint(this.endpoint.index)?.supportsCC(this.ccId));
                for (const node of affectedNodes) {
                  this.host.tryGetValueDB(node.id)?.setValue(currentValueValueId, value);
                }
              }
            }
          }, "optimisticallyUpdateRelatedValues"),
          verifyChanges: /* @__PURE__ */ __name(() => {
            if (this.isSinglecast()) {
              this.schedulePoll(currentValueValueId, value, {
                duration
              });
            } else {
            }
          }, "verifyChanges")
        };
      }
    });
    get [import_API.POLL_VALUE]() {
      return async function({ property, propertyKey }) {
        switch (property) {
          case "currentValue":
          case "targetValue":
          case "duration":
            if (propertyKey == void 0) {
              (0, import_API.throwMissingPropertyKey)(this.ccId, property);
            } else if (typeof propertyKey !== "number") {
              (0, import_API.throwUnsupportedPropertyKey)(this.ccId, property, propertyKey);
            }
            return (await this.get(propertyKey))?.[property];
          default:
            (0, import_API.throwUnsupportedProperty)(this.ccId, property);
        }
      };
    }
    async getSupported() {
      this.assertSupportsCommand(import_Types.WindowCoveringCommand, import_Types.WindowCoveringCommand.SupportedGet);
      const cc = new WindowCoveringCCSupportedGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      return response?.supportedParameters;
    }
    async get(parameter) {
      this.assertSupportsCommand(import_Types.WindowCoveringCommand, import_Types.WindowCoveringCommand.Get);
      const cc = new WindowCoveringCCGet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        parameter
      });
      const response = await this.host.sendCommand(cc, this.commandOptions);
      if (response) {
        return (0, import_shared.pick)(response, ["currentValue", "targetValue", "duration"]);
      }
    }
    async set(targetValues, duration) {
      this.assertSupportsCommand(import_Types.WindowCoveringCommand, import_Types.WindowCoveringCommand.StartLevelChange);
      const cc = new WindowCoveringCCSet({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        targetValues,
        duration
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async startLevelChange(parameter, direction, duration) {
      this.assertSupportsCommand(import_Types.WindowCoveringCommand, import_Types.WindowCoveringCommand.StartLevelChange);
      const cc = new WindowCoveringCCStartLevelChange({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        parameter,
        direction,
        duration
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
    async stopLevelChange(parameter) {
      this.assertSupportsCommand(import_Types.WindowCoveringCommand, import_Types.WindowCoveringCommand.StopLevelChange);
      const cc = new WindowCoveringCCStopLevelChange({
        nodeId: this.endpoint.nodeId,
        endpointIndex: this.endpoint.index,
        parameter
      });
      return this.host.sendCommand(cc, this.commandOptions);
    }
  };
  return WindowCoveringCCAPI2 = _classThis;
})();
let WindowCoveringCC = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.commandClass)(import_core.CommandClasses["Window Covering"]), (0, import_CommandClassDecorators.implementedVersion)(1), (0, import_CommandClassDecorators.ccValues)(import_CCValues_generated.WindowCoveringCCValues)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = import_CommandClass.CommandClass;
  var WindowCoveringCC2 = class extends _classSuper {
    static {
      __name(this, "WindowCoveringCC");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      WindowCoveringCC2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    async interview(ctx) {
      const node = this.getNode(ctx);
      const endpoint = this.getEndpoint(ctx);
      const api = import_API.CCAPI.create(import_core.CommandClasses["Window Covering"], ctx, endpoint).withOptions({
        priority: import_core.MessagePriority.NodeQuery
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: `Interviewing ${this.ccName}...`,
        direction: "none"
      });
      ctx.logNode(node.id, {
        endpoint: this.endpointIndex,
        message: "querying supported window covering parameters...",
        direction: "outbound"
      });
      const supported = await api.getSupported();
      if (supported?.length) {
        const logMessage = `supported window covering parameters:
${supported.map((p) => `\xB7 ${(0, import_shared.getEnumMemberName)(import_Types.WindowCoveringParameter, p)}`).join("\n")}`;
        ctx.logNode(node.id, {
          endpoint: this.endpointIndex,
          message: logMessage,
          direction: "inbound"
        });
        for (const param of supported) {
          this.setMetadata(ctx, import_CCValues_generated.WindowCoveringCCValues.currentValue(param));
          this.setMetadata(ctx, import_CCValues_generated.WindowCoveringCCValues.targetValue(param));
          this.setMetadata(ctx, import_CCValues_generated.WindowCoveringCCValues.duration(param));
          this.setMetadata(ctx, import_CCValues_generated.WindowCoveringCCValues.levelChangeUp(param));
          this.setMetadata(ctx, import_CCValues_generated.WindowCoveringCCValues.levelChangeDown(param));
          if (param % 2 === 1) {
            ctx.logNode(node.id, {
              endpoint: this.endpointIndex,
              message: `querying position for parameter ${(0, import_shared.getEnumMemberName)(import_Types.WindowCoveringParameter, param)}...`,
              direction: "outbound"
            });
            await api.get(param);
          }
        }
      }
      this.setInterviewComplete(ctx, true);
    }
    translatePropertyKey(ctx, property, propertyKey) {
      if (typeof propertyKey === "number") {
        return (0, import_shared.getEnumMemberName)(import_Types.WindowCoveringParameter, propertyKey);
      }
      return super.translatePropertyKey(ctx, property, propertyKey);
    }
  };
  return WindowCoveringCC2 = _classThis;
})();
let WindowCoveringCCSupportedReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.WindowCoveringCommand.SupportedReport), (0, import_CommandClassDecorators.ccValueProperty)("supportedParameters", import_CCValues_generated.WindowCoveringCCValues.supportedParameters)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = WindowCoveringCC;
  var WindowCoveringCCSupportedReport2 = class extends _classSuper {
    static {
      __name(this, "WindowCoveringCCSupportedReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      WindowCoveringCCSupportedReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.supportedParameters = options.supportedParameters;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const numBitmaskBytes = raw.payload[0] & 15;
      (0, import_core.validatePayload)(raw.payload.length >= 1 + numBitmaskBytes);
      const bitmask = raw.payload.subarray(1, 1 + numBitmaskBytes);
      const supportedParameters = (0, import_core.parseBitMask)(bitmask, import_Types.WindowCoveringParameter["Outbound Left (no position)"]);
      return new this({
        nodeId: ctx.sourceNodeId,
        supportedParameters
      });
    }
    supportedParameters;
    serialize(ctx) {
      const bitmask = (0, import_core.encodeBitMask)(this.supportedParameters, void 0, import_Types.WindowCoveringParameter["Outbound Left (no position)"]).subarray(0, 15);
      const numBitmaskBytes = bitmask.length & 15;
      this.payload = import_shared.Bytes.concat([
        import_shared.Bytes.from([numBitmaskBytes]),
        bitmask.subarray(0, numBitmaskBytes)
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          "supported parameters": this.supportedParameters.map((p) => `
\xB7 ${(0, import_shared.getEnumMemberName)(import_Types.WindowCoveringParameter, p)}`).join("")
        }
      };
    }
  };
  return WindowCoveringCCSupportedReport2 = _classThis;
})();
let WindowCoveringCCSupportedGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.WindowCoveringCommand.SupportedGet), (0, import_CommandClassDecorators.expectedCCResponse)(WindowCoveringCCSupportedReport)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = WindowCoveringCC;
  var WindowCoveringCCSupportedGet2 = class extends _classSuper {
    static {
      __name(this, "WindowCoveringCCSupportedGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      WindowCoveringCCSupportedGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
  };
  return WindowCoveringCCSupportedGet2 = _classThis;
})();
let WindowCoveringCCReport = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.WindowCoveringCommand.Report), (0, import_CommandClassDecorators.ccValueProperty)("currentValue", import_CCValues_generated.WindowCoveringCCValues.currentValue, (self) => [self.parameter]), (0, import_CommandClassDecorators.ccValueProperty)("targetValue", import_CCValues_generated.WindowCoveringCCValues.targetValue, (self) => [self.parameter]), (0, import_CommandClassDecorators.ccValueProperty)("duration", import_CCValues_generated.WindowCoveringCCValues.duration, (self) => [self.parameter])];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = WindowCoveringCC;
  var WindowCoveringCCReport2 = class extends _classSuper {
    static {
      __name(this, "WindowCoveringCCReport");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      WindowCoveringCCReport2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.parameter = options.parameter;
      this.currentValue = options.currentValue;
      this.targetValue = options.targetValue;
      this.duration = options.duration;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 4);
      const parameter = raw.payload[0];
      const currentValue = raw.payload[1];
      const targetValue = raw.payload[2];
      const duration = import_core.Duration.parseReport(raw.payload[3]) ?? import_core.Duration.unknown();
      return new this({
        nodeId: ctx.sourceNodeId,
        parameter,
        currentValue,
        targetValue,
        duration
      });
    }
    parameter;
    currentValue;
    targetValue;
    duration;
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          parameter: (0, import_shared.getEnumMemberName)(import_Types.WindowCoveringParameter, this.parameter),
          "current value": this.currentValue,
          "target value": this.targetValue,
          duration: this.duration.toString()
        }
      };
    }
  };
  return WindowCoveringCCReport2 = _classThis;
})();
function testResponseForWindowCoveringGet(sent, received) {
  return received.parameter === sent.parameter;
}
__name(testResponseForWindowCoveringGet, "testResponseForWindowCoveringGet");
let WindowCoveringCCGet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.WindowCoveringCommand.Get), (0, import_CommandClassDecorators.expectedCCResponse)(WindowCoveringCCReport, testResponseForWindowCoveringGet)];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = WindowCoveringCC;
  var WindowCoveringCCGet2 = class extends _classSuper {
    static {
      __name(this, "WindowCoveringCCGet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      WindowCoveringCCGet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.parameter = options.parameter;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const parameter = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        parameter
      });
    }
    parameter;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.parameter]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          parameter: (0, import_shared.getEnumMemberName)(import_Types.WindowCoveringParameter, this.parameter)
        }
      };
    }
  };
  return WindowCoveringCCGet2 = _classThis;
})();
let WindowCoveringCCSet = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.WindowCoveringCommand.Set), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = WindowCoveringCC;
  var WindowCoveringCCSet2 = class extends _classSuper {
    static {
      __name(this, "WindowCoveringCCSet");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      WindowCoveringCCSet2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.targetValues = options.targetValues;
      this.duration = import_core.Duration.from(options.duration);
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const numEntries = raw.payload[0] & 31;
      (0, import_core.validatePayload)(raw.payload.length >= 1 + numEntries * 2);
      const targetValues = [];
      for (let i = 0; i < numEntries; i++) {
        const offset = 1 + i * 2;
        targetValues.push({
          parameter: raw.payload[offset],
          value: raw.payload[offset + 1]
        });
      }
      let duration;
      if (raw.payload.length >= 2 + numEntries * 2) {
        duration = import_core.Duration.parseSet(raw.payload[1 + numEntries * 2]);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        targetValues,
        duration
      });
    }
    targetValues;
    duration;
    serialize(ctx) {
      const numEntries = this.targetValues.length & 31;
      this.payload = new import_shared.Bytes(2 + numEntries * 2);
      this.payload[0] = numEntries;
      for (let i = 0; i < numEntries; i++) {
        const offset = 1 + i * 2;
        this.payload[offset] = this.targetValues[i].parameter;
        this.payload[offset + 1] = this.targetValues[i].value;
      }
      this.payload[this.payload.length - 1] = (this.duration ?? import_core.Duration.default()).serializeSet();
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {};
      for (const { parameter, value } of this.targetValues) {
        message[(0, import_shared.getEnumMemberName)(import_Types.WindowCoveringParameter, parameter)] = value;
      }
      if (this.duration) {
        message.duration = this.duration.toString();
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return WindowCoveringCCSet2 = _classThis;
})();
let WindowCoveringCCStartLevelChange = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.WindowCoveringCommand.StartLevelChange), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = WindowCoveringCC;
  var WindowCoveringCCStartLevelChange2 = class extends _classSuper {
    static {
      __name(this, "WindowCoveringCCStartLevelChange");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      WindowCoveringCCStartLevelChange2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.parameter = options.parameter;
      this.direction = options.direction;
      this.duration = import_core.Duration.from(options.duration);
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 2);
      const direction = !!(raw.payload[0] & 64) ? "down" : "up";
      const parameter = raw.payload[1];
      let duration;
      if (raw.payload.length >= 3) {
        duration = import_core.Duration.parseSet(raw.payload[2]);
      }
      return new this({
        nodeId: ctx.sourceNodeId,
        direction,
        parameter,
        duration
      });
    }
    parameter;
    direction;
    duration;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([
        this.direction === "down" ? 64 : 0,
        this.parameter,
        (this.duration ?? import_core.Duration.default()).serializeSet()
      ]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      const message = {
        parameter: (0, import_shared.getEnumMemberName)(import_Types.WindowCoveringParameter, this.parameter),
        direction: this.direction
      };
      if (this.duration) {
        message.duration = this.duration.toString();
      }
      return {
        ...super.toLogEntry(ctx),
        message
      };
    }
  };
  return WindowCoveringCCStartLevelChange2 = _classThis;
})();
let WindowCoveringCCStopLevelChange = (() => {
  let _classDecorators = [(0, import_CommandClassDecorators.CCCommand)(import_Types.WindowCoveringCommand.StopLevelChange), (0, import_CommandClassDecorators.useSupervision)()];
  let _classDescriptor;
  let _classExtraInitializers = [];
  let _classThis;
  let _classSuper = WindowCoveringCC;
  var WindowCoveringCCStopLevelChange2 = class extends _classSuper {
    static {
      __name(this, "WindowCoveringCCStopLevelChange");
    }
    static {
      _classThis = this;
    }
    static {
      const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
      __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
      WindowCoveringCCStopLevelChange2 = _classThis = _classDescriptor.value;
      if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
      __runInitializers(_classThis, _classExtraInitializers);
    }
    constructor(options) {
      super(options);
      this.parameter = options.parameter;
    }
    static from(raw, ctx) {
      (0, import_core.validatePayload)(raw.payload.length >= 1);
      const parameter = raw.payload[0];
      return new this({
        nodeId: ctx.sourceNodeId,
        parameter
      });
    }
    parameter;
    serialize(ctx) {
      this.payload = import_shared.Bytes.from([this.parameter]);
      return super.serialize(ctx);
    }
    toLogEntry(ctx) {
      return {
        ...super.toLogEntry(ctx),
        message: {
          parameter: (0, import_shared.getEnumMemberName)(import_Types.WindowCoveringParameter, this.parameter)
        }
      };
    }
  };
  return WindowCoveringCCStopLevelChange2 = _classThis;
})();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  WindowCoveringCC,
  WindowCoveringCCAPI,
  WindowCoveringCCGet,
  WindowCoveringCCReport,
  WindowCoveringCCSet,
  WindowCoveringCCStartLevelChange,
  WindowCoveringCCStopLevelChange,
  WindowCoveringCCSupportedGet,
  WindowCoveringCCSupportedReport,
  WindowCoveringCCValues
});
//# sourceMappingURL=WindowCoveringCC.js.map
