"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Decorators_exports = {};
__export(Decorators_exports, {
  fibaroCC: () => fibaroCC,
  fibaroCCCommand: () => fibaroCCCommand,
  getFibaroCCCommand: () => getFibaroCCCommand,
  getFibaroCCCommandConstructor: () => getFibaroCCCommandConstructor,
  getFibaroCCConstructor: () => getFibaroCCConstructor,
  getFibaroCCId: () => getFibaroCCId,
  getManufacturerId: () => getManufacturerId,
  getManufacturerIdStatic: () => getManufacturerIdStatic,
  getManufacturerProprietaryAPI: () => getManufacturerProprietaryAPI,
  getManufacturerProprietaryCCConstructor: () => getManufacturerProprietaryCCConstructor,
  manufacturerId: () => manufacturerId,
  manufacturerProprietaryAPI: () => manufacturerProprietaryAPI
});
module.exports = __toCommonJS(Decorators_exports);
var import_error = require("@zwave-js/core/error");
var import_reflection = require("@zwave-js/core/reflection");
const manufacturerIdDecorator = (0, import_reflection.createSimpleReflectionDecorator)({
  name: "manufacturerId"
});
const manufacturerId = manufacturerIdDecorator.decorator;
const getManufacturerId = manufacturerIdDecorator.lookupValue;
function getManufacturerIdStatic(classConstructor) {
  const ret = manufacturerIdDecorator.lookupValueStatic(classConstructor);
  if (ret == void 0) {
    throw new import_error.ZWaveError(`No manufacturer ID defined for ${classConstructor.name}!`, import_error.ZWaveErrorCodes.CC_Invalid);
  }
  return ret;
}
__name(getManufacturerIdStatic, "getManufacturerIdStatic");
const getManufacturerProprietaryCCConstructor = manufacturerIdDecorator.lookupConstructor;
const manufacturerProprietaryAPIDecorator = (0, import_reflection.createSimpleReflectionDecorator)({
  name: "manufacturerProprietaryAPI"
});
const manufacturerProprietaryAPI = manufacturerProprietaryAPIDecorator.decorator;
const getManufacturerProprietaryAPI = manufacturerProprietaryAPIDecorator.lookupConstructor;
const FibaroCCAndCommandDecorator = (0, import_reflection.createReflectionDecoratorPair)({ superName: "fibaroCC", subName: "fibaroCCCommand" });
const fibaroCC = FibaroCCAndCommandDecorator.superDecorator;
const getFibaroCCId = FibaroCCAndCommandDecorator.lookupSuperValue;
const getFibaroCCConstructor = FibaroCCAndCommandDecorator.lookupSuperConstructor;
const fibaroCCCommand = FibaroCCAndCommandDecorator.subDecorator;
const getFibaroCCCommand = FibaroCCAndCommandDecorator.lookupSubValue;
const getFibaroCCCommandConstructor = FibaroCCAndCommandDecorator.lookupSubConstructor;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  fibaroCC,
  fibaroCCCommand,
  getFibaroCCCommand,
  getFibaroCCCommandConstructor,
  getFibaroCCConstructor,
  getFibaroCCId,
  getManufacturerId,
  getManufacturerIdStatic,
  getManufacturerProprietaryAPI,
  getManufacturerProprietaryCCConstructor,
  manufacturerId,
  manufacturerProprietaryAPI
});
//# sourceMappingURL=Decorators.js.map
