"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var CCValueUtils_exports = {};
__export(CCValueUtils_exports, {
  irrigationValveIdToMetadataPrefix: () => irrigationValveIdToMetadataPrefix,
  meterTypesToPropertyKey: () => meterTypesToPropertyKey,
  multilevelSwitchTypeProperties: () => multilevelSwitchTypeProperties,
  multilevelSwitchTypeToActions: () => multilevelSwitchTypeToActions,
  windowCoveringParameterToLevelChangeLabel: () => windowCoveringParameterToLevelChangeLabel,
  windowCoveringParameterToMetadataStates: () => windowCoveringParameterToMetadataStates
});
module.exports = __toCommonJS(CCValueUtils_exports);
var import_Types = require("./_Types.js");
function multilevelSwitchTypeToActions(switchType) {
  if (!switchType.includes("/"))
    switchType = import_Types.SwitchType[2];
  return switchType.split("/", 2);
}
__name(multilevelSwitchTypeToActions, "multilevelSwitchTypeToActions");
const multilevelSwitchTypeProperties = Object.keys(import_Types.SwitchType).filter((key) => key.includes("/")).map((key) => multilevelSwitchTypeToActions(key)).reduce((acc, cur) => acc.concat(...cur), []);
function windowCoveringParameterToMetadataStates(parameter) {
  switch (parameter) {
    case import_Types.WindowCoveringParameter["Vertical Slats Angle (no position)"]:
    case import_Types.WindowCoveringParameter["Vertical Slats Angle"]:
      return {
        0: "Closed (right inside)",
        50: "Open",
        99: "Closed (left inside)"
      };
    case import_Types.WindowCoveringParameter["Horizontal Slats Angle (no position)"]:
    case import_Types.WindowCoveringParameter["Horizontal Slats Angle"]:
      return {
        0: "Closed (up inside)",
        50: "Open",
        99: "Closed (down inside)"
      };
  }
  return {
    0: "Closed",
    99: "Open"
  };
}
__name(windowCoveringParameterToMetadataStates, "windowCoveringParameterToMetadataStates");
function windowCoveringParameterToLevelChangeLabel(parameter, direction) {
  switch (parameter) {
    // For angle control, both directions are closed, so we specify it explicitly
    case import_Types.WindowCoveringParameter["Vertical Slats Angle (no position)"]:
    case import_Types.WindowCoveringParameter["Vertical Slats Angle"]:
      return `Change tilt (${direction === "up" ? "left inside" : "right inside"})`;
    case import_Types.WindowCoveringParameter["Horizontal Slats Angle (no position)"]:
    case import_Types.WindowCoveringParameter["Horizontal Slats Angle"]:
      return `Change tilt (${direction === "up" ? "down inside" : "up inside"})`;
  }
  return direction === "up" ? "Open" : "Close";
}
__name(windowCoveringParameterToLevelChangeLabel, "windowCoveringParameterToLevelChangeLabel");
function meterTypesToPropertyKey(meterType, rateType, scale) {
  return meterType << 16 | scale << 8 | rateType;
}
__name(meterTypesToPropertyKey, "meterTypesToPropertyKey");
function irrigationValveIdToMetadataPrefix(valveId) {
  if (valveId === "master")
    return "Master valve";
  return `Valve ${valveId.toString().padStart(3, "0")}`;
}
__name(irrigationValveIdToMetadataPrefix, "irrigationValveIdToMetadataPrefix");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  irrigationValveIdToMetadataPrefix,
  meterTypesToPropertyKey,
  multilevelSwitchTypeProperties,
  multilevelSwitchTypeToActions,
  windowCoveringParameterToLevelChangeLabel,
  windowCoveringParameterToMetadataStates
});
//# sourceMappingURL=CCValueUtils.js.map
