"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var CommandClassDecorators_exports = {};
__export(CommandClassDecorators_exports, {
  API: () => API,
  CCCommand: () => CCCommand,
  ccValueProperty: () => ccValueProperty,
  ccValues: () => ccValues,
  commandClass: () => commandClass,
  expectedCCResponse: () => expectedCCResponse,
  getAPI: () => getAPI,
  getCCCommand: () => getCCCommand,
  getCCCommandConstructor: () => getCCCommandConstructor,
  getCCConstructor: () => getCCConstructor,
  getCCResponsePredicate: () => getCCResponsePredicate,
  getCCValueProperties: () => getCCValueProperties,
  getCCValues: () => getCCValues,
  getCommandClass: () => getCommandClass,
  getCommandClassStatic: () => getCommandClassStatic,
  getExpectedCCResponse: () => getExpectedCCResponse,
  getImplementedVersion: () => getImplementedVersion,
  getImplementedVersionStatic: () => getImplementedVersionStatic,
  implementedVersion: () => implementedVersion,
  shouldUseSupervision: () => shouldUseSupervision,
  useSupervision: () => useSupervision
});
module.exports = __toCommonJS(CommandClassDecorators_exports);
var import_core = require("@zwave-js/core");
var import_reflection = require("@zwave-js/core/reflection");
const CCAndCommandDecorator = (0, import_reflection.createReflectionDecoratorPair)({ superName: "ccId", subName: "ccCommand" });
const commandClass = CCAndCommandDecorator.superDecorator;
const getCCConstructor = CCAndCommandDecorator.lookupSuperConstructor;
const CCCommand = CCAndCommandDecorator.subDecorator;
const getCCCommand = CCAndCommandDecorator.lookupSubValue;
const getCCCommandConstructor = CCAndCommandDecorator.lookupSubConstructor;
function getCommandClassStatic(classConstructor) {
  const ret = CCAndCommandDecorator.lookupSuperValueStatic(classConstructor);
  if (ret == void 0) {
    throw new import_core.ZWaveError(`No command class defined for ${classConstructor.name}!`, import_core.ZWaveErrorCodes.CC_Invalid);
  }
  return ret;
}
__name(getCommandClassStatic, "getCommandClassStatic");
const apiDecorator = (0, import_reflection.createReflectionDecorator)({
  name: "API",
  valueFromArgs: /* @__PURE__ */ __name((cc) => cc, "valueFromArgs")
});
const API = apiDecorator.decorator;
function getAPI(cc) {
  return apiDecorator.lookupConstructorByValue(cc);
}
__name(getAPI, "getAPI");
function getCommandClass(cc) {
  const constr = cc.constructor;
  const ret = CCAndCommandDecorator.lookupSuperValueStatic(constr) ?? apiDecorator.lookupValueStatic(constr);
  if (ret == void 0) {
    throw new import_core.ZWaveError(`No command class defined for ${constr.name}!`, import_core.ZWaveErrorCodes.CC_Invalid);
  }
  return ret;
}
__name(getCommandClass, "getCommandClass");
const implementedVersionDecorator = (0, import_reflection.createReflectionDecorator)({
  name: "implementedVersion",
  valueFromArgs: /* @__PURE__ */ __name((version) => version, "valueFromArgs"),
  constructorLookupKey: false
});
const implementedVersion = implementedVersionDecorator.decorator;
function getImplementedVersion(cc) {
  let constr;
  if (typeof cc === "number") {
    constr = getCCConstructor(cc);
  } else {
    constr = cc.constructor;
  }
  if (!constr)
    return 0;
  return implementedVersionDecorator.lookupValueStatic(constr) ?? 0;
}
__name(getImplementedVersion, "getImplementedVersion");
function getImplementedVersionStatic(classConstructor) {
  return implementedVersionDecorator.lookupValueStatic(classConstructor) ?? 0;
}
__name(getImplementedVersionStatic, "getImplementedVersionStatic");
const expectedCCResponseDecorator = (0, import_reflection.createReflectionDecorator)({
  name: "expectedCCResponse",
  valueFromArgs: /* @__PURE__ */ __name((cc, predicate) => ({ cc, predicate }), "valueFromArgs"),
  // We don't need reverse lookup
  constructorLookupKey: false
});
function expectedCCResponse(cc, predicate) {
  return expectedCCResponseDecorator.decorator(cc, predicate);
}
__name(expectedCCResponse, "expectedCCResponse");
function getExpectedCCResponse(ccClass) {
  return expectedCCResponseDecorator.lookupValue(ccClass)?.cc;
}
__name(getExpectedCCResponse, "getExpectedCCResponse");
function getCCResponsePredicate(ccClass) {
  return expectedCCResponseDecorator.lookupValue(ccClass)?.predicate;
}
__name(getCCResponsePredicate, "getCCResponsePredicate");
const ccValuesDecorator = (0, import_reflection.createReflectionDecorator)({
  name: "ccValues",
  valueFromArgs: /* @__PURE__ */ __name((valueDefinition) => valueDefinition, "valueFromArgs"),
  // We don't need reverse lookup
  constructorLookupKey: false
});
const ccValues = ccValuesDecorator.decorator;
function getCCValues(cc) {
  let constr;
  if (typeof cc === "number") {
    constr = getCCConstructor(cc);
  } else {
    constr = cc.constructor;
  }
  if (constr)
    return ccValuesDecorator.lookupValueStatic(constr);
}
__name(getCCValues, "getCCValues");
const ccValue_METADATA = Symbol.for(`METADATA_ccValue`);
function ccValueProperty(property, ...args) {
  return /* @__PURE__ */ __name(function decorator_ccValueProperty(constr) {
    const metadata = Reflect.getMetadata(ccValue_METADATA, constr) ?? /* @__PURE__ */ new Map();
    let valueOrFactory;
    if (args.length === 1) {
      valueOrFactory = args[0];
    } else {
      const [value, getArgs] = args;
      valueOrFactory = /* @__PURE__ */ __name((self) => {
        const args2 = getArgs(self);
        const base = value(...args2);
        return {
          ...base,
          is: value.is,
          options: value.options
        };
      }, "valueOrFactory");
    }
    metadata.set(property, valueOrFactory);
    Reflect.defineMetadata(ccValue_METADATA, metadata, constr);
  }, "decorator_ccValueProperty");
}
__name(ccValueProperty, "ccValueProperty");
function getCCValueProperties(target) {
  return Reflect.getMetadata(ccValue_METADATA, target.constructor) ?? /* @__PURE__ */ new Map();
}
__name(getCCValueProperties, "getCCValueProperties");
const supervisionDecorator = (0, import_reflection.createValuelessReflectionDecorator)({
  name: "useSupervision"
});
const useSupervision = supervisionDecorator.decorator;
const shouldUseSupervision = supervisionDecorator.isDecorated;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  API,
  CCCommand,
  ccValueProperty,
  ccValues,
  commandClass,
  expectedCCResponse,
  getAPI,
  getCCCommand,
  getCCCommandConstructor,
  getCCConstructor,
  getCCResponsePredicate,
  getCCValueProperties,
  getCCValues,
  getCommandClass,
  getCommandClassStatic,
  getExpectedCCResponse,
  getImplementedVersion,
  getImplementedVersionStatic,
  implementedVersion,
  shouldUseSupervision,
  useSupervision
});
//# sourceMappingURL=CommandClassDecorators.js.map
