import { type CommandClassInfo, type CommandClasses, type ValueID } from "@zwave-js/core";
import { type JSONObject } from "@zwave-js/shared";
import { type ConditionalItem } from "./ConditionalItem.js";
import type { DeviceID } from "./shared.js";
export declare class ConditionalCompatConfig implements ConditionalItem<CompatConfig> {
    private valueIdRegex;
    constructor(filename: string, definition: JSONObject);
    readonly alarmMapping?: readonly CompatMapAlarm[];
    readonly addCCs?: ReadonlyMap<CommandClasses, CompatAddCC>;
    readonly removeCCs?: ReadonlyMap<CommandClasses, "*" | readonly number[]>;
    readonly disableAutoRefresh?: boolean;
    readonly disableStrictEntryControlDataValidation?: boolean;
    readonly disableStrictMeasurementValidation?: boolean;
    readonly disableCallbackFunctionTypeCheck?: number[];
    readonly encodeCCsUsingTargetVersion?: boolean;
    readonly forceNotificationIdleReset?: boolean;
    readonly forceSceneControllerGroupCount?: number;
    readonly manualValueRefreshDelayMs?: number;
    readonly mapRootReportsToEndpoint?: number;
    readonly mapBasicReport?: BasicReportMapping;
    readonly mapBasicSet?: BasicSetMapping;
    readonly overrideFloatEncoding?: {
        size?: number;
        precision?: number;
    };
    readonly overrideQueries?: CompatOverrideQueries;
    readonly preserveRootApplicationCCValueIDs?: boolean;
    readonly preserveEndpoints?: "*" | readonly number[];
    readonly removeEndpoints?: "*" | readonly number[];
    readonly reportTimeout?: number;
    readonly skipConfigurationNameQuery?: boolean;
    readonly skipConfigurationInfoQuery?: boolean;
    readonly treatMultilevelSwitchSetAsEvent?: boolean;
    readonly treatSetAsReport?: ReadonlySet<string>;
    readonly treatDestinationEndpointAsSource?: boolean;
    readonly useUTCInTimeParametersCC?: boolean;
    readonly queryOnWakeup?: readonly [
        string,
        string,
        ...(string | number | boolean | Pick<ValueID, "property" | "propertyKey">)[]
    ][];
    readonly condition?: string | undefined;
    evaluateCondition(deviceId?: DeviceID): CompatConfig | undefined;
}
export type CompatConfig = Omit<ConditionalCompatConfig, "condition" | "evaluateCondition">;
export declare class CompatAddCC {
    constructor(filename: string, definition: JSONObject);
    readonly endpoints: ReadonlyMap<number, Partial<CommandClassInfo>>;
}
export interface CompatMapAlarmFrom {
    alarmType: number;
    alarmLevel?: number;
}
export interface CompatMapAlarmTo {
    notificationType: number;
    notificationEvent: number;
    eventParameters?: Record<string, number | "alarmLevel">;
}
export declare class CompatMapAlarm {
    constructor(filename: string, definition: JSONObject, index: number);
    readonly from: CompatMapAlarmFrom;
    readonly to: CompatMapAlarmTo;
}
export declare class CompatOverrideQueries {
    constructor(filename: string, definition: JSONObject);
    private readonly overrides;
    hasOverride(ccId: CommandClasses): boolean;
    matchOverride(cc: CommandClasses, endpointIndex: number, method: string, args: any[]): Pick<CompatOverrideQuery, "result" | "persistValues" | "extendMetadata"> | undefined;
}
export interface CompatOverrideQuery {
    /** Which endpoint this override is for */
    endpoint?: number;
    /** For which API method this override is defined */
    method: string;
    /**
     * An array of method arguments that needs to match for this override to apply.
     * If `undefined`, no matching is performed.
     */
    matchArgs?: any[];
    /** The result to return from the API call */
    result: any;
    /**
     * An optional dictionary of values that will be persisted in the cache.
     * The keys are properties of the `...CCValues` objects that belong to this CC.
     */
    persistValues?: Record<string, any>;
    /**
     * An optional dictionary of value metadata that will be persisted in the cache.
     * The keys are properties of the `...CCValues` objects that belong to this CC.
     * The given metadata will be merged with statically defined value metadata.
     */
    extendMetadata?: Record<string, any>;
}
declare const basicReportMappings: readonly [false, "auto", "Binary Sensor"];
/**
 * Defines how to handle a received Basic CC Report:
 * - "auto": map it to a different CC based on the device type, with fallback to `false`
 * - false: treat the report verbatim without mapping
 * - "Binary Sensor": treat it as a Binary Sensor CC Report, regardless of device type
 */
export type BasicReportMapping = typeof basicReportMappings[number];
declare const basicSetMappings: readonly ["event", "report", "auto", "Binary Sensor"];
/**
 * Defines how to handle a received Basic CC Set:
 * - "event": emit an event for the special `event` CC value
 * - "report": treat it as as a Basic CC Report (default)
 * - "auto": map it to a different CC based on the device type, with fallback to Basic CC report
 * - "Binary Sensor": treat it as a Binary Sensor CC Report, regardless of device type
 */
export type BasicSetMapping = typeof basicSetMappings[number];
export {};
//# sourceMappingURL=CompatConfig.d.ts.map