"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var EndpointConfig_exports = {};
__export(EndpointConfig_exports, {
  ConditionalEndpointConfig: () => ConditionalEndpointConfig
});
module.exports = __toCommonJS(EndpointConfig_exports);
var import_typeguards = require("alcalzone-shared/typeguards");
var import_utils_safe = require("../utils_safe.js");
var import_AssociationConfig = require("./AssociationConfig.js");
var import_ConditionalItem = require("./ConditionalItem.js");
var import_ParamInformation = require("./ParamInformation.js");
class ConditionalEndpointConfig {
  static {
    __name(this, "ConditionalEndpointConfig");
  }
  constructor(parent, index, definition) {
    this.index = index;
    const filename = parent.filename;
    (0, import_ConditionalItem.validateCondition)(filename, definition, `Endpoint ${index} contains an`);
    this.condition = definition.$if;
    if (definition.label != void 0) {
      if (typeof definition.label !== "string") {
        (0, import_utils_safe.throwInvalidConfig)(`device`, `packages/config/config/devices/${filename}:
Endpoint ${index}: label is not a string`);
      }
      this.label = definition.label;
    }
    if (definition.associations != void 0) {
      const associations = /* @__PURE__ */ new Map();
      if (!(0, import_typeguards.isObject)(definition.associations)) {
        (0, import_utils_safe.throwInvalidConfig)(`device`, `packages/config/config/devices/${filename}:
Endpoint ${index}: associations is not an object`);
      }
      for (const [key, assocDefinition] of Object.entries(definition.associations)) {
        if (!/^[1-9][0-9]*$/.test(key)) {
          (0, import_utils_safe.throwInvalidConfig)(`device`, `packages/config/config/devices/${filename}:
Endpoint ${index}: found non-numeric group id "${key}" in associations`);
        }
        const keyNum = parseInt(key, 10);
        associations.set(keyNum, new import_AssociationConfig.ConditionalAssociationConfig(filename, keyNum, assocDefinition));
      }
      this.associations = associations;
    }
    if (definition.paramInformation != void 0) {
      this.paramInformation = (0, import_ParamInformation.parseConditionalParamInformationMap)(definition, parent, `Endpoint ${index}: `);
    }
  }
  index;
  associations;
  paramInformation;
  condition;
  label;
  evaluateCondition(deviceId) {
    if (!(0, import_ConditionalItem.conditionApplies)(this, deviceId))
      return;
    const ret = {
      index: this.index,
      label: this.label
    };
    const associations = (0, import_ConditionalItem.evaluateDeep)(this.associations, deviceId);
    if (associations)
      ret.associations = associations;
    const paramInformation = (0, import_ConditionalItem.evaluateDeep)(this.paramInformation, deviceId);
    if (paramInformation)
      ret.paramInformation = paramInformation;
    return ret;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ConditionalEndpointConfig
});
//# sourceMappingURL=EndpointConfig.js.map
