"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ParamInformation_exports = {};
__export(ParamInformation_exports, {
  ConditionalConfigOption: () => ConditionalConfigOption,
  ConditionalParamInformation: () => ConditionalParamInformation,
  parseConditionalParamInformationMap: () => parseConditionalParamInformationMap
});
module.exports = __toCommonJS(ParamInformation_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
var import_typeguards = require("alcalzone-shared/typeguards");
var import_utils_safe = require("../utils_safe.js");
var import_ConditionalItem = require("./ConditionalItem.js");
class ConditionalParamInformation {
  static {
    __name(this, "ConditionalParamInformation");
  }
  constructor(parent, parameterNumber, valueBitMask, definition) {
    this.parent = parent;
    this.parameterNumber = parameterNumber;
    this.valueBitMask = valueBitMask;
    this.condition = definition.$if;
    if (typeof definition.label !== "string") {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${parent.filename}:
Parameter #${parameterNumber} has a non-string label`);
    }
    this.label = definition.label;
    if (definition.description != void 0 && typeof definition.description !== "string") {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${parent.filename}:
Parameter #${parameterNumber} has a non-string description`);
    }
    this.description = definition.description;
    if (typeof definition.valueSize !== "number" || definition.valueSize <= 0) {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${parent.filename}:
Parameter #${parameterNumber} has an invalid value size`);
    }
    this.valueSize = definition.valueSize;
    if (definition.minValue != void 0 && typeof definition.minValue !== "number") {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${parent.filename}:
Parameter #${parameterNumber} has a non-numeric property minValue`);
    }
    this.minValue = definition.minValue;
    if (definition.maxValue != void 0 && typeof definition.maxValue !== "number") {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${parent.filename}:
Parameter #${parameterNumber} has a non-numeric property maxValue`);
    }
    this.maxValue = definition.maxValue;
    if (definition.unsigned != void 0 && typeof definition.unsigned !== "boolean") {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${parent.filename}:
Parameter #${parameterNumber} has a non-boolean property unsigned`);
    }
    this.unsigned = definition.unsigned === true;
    if (definition.unit != void 0 && typeof definition.unit !== "string") {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${parent.filename}:
Parameter #${parameterNumber} has a non-string unit`);
    }
    this.unit = definition.unit;
    if (definition.readOnly != void 0 && definition.readOnly !== true) {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${parent.filename}:
		Parameter #${parameterNumber}: readOnly must true or omitted!`);
    }
    this.readOnly = definition.readOnly;
    if (definition.writeOnly != void 0 && definition.writeOnly !== true) {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${parent.filename}:
		Parameter #${parameterNumber}: writeOnly must be true or omitted!`);
    }
    this.writeOnly = definition.writeOnly;
    if (definition.defaultValue == void 0) {
      if (!this.readOnly) {
        (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${parent.filename}:
Parameter #${parameterNumber} is missing defaultValue, which is required unless the parameter is readOnly`);
      }
    } else if (typeof definition.defaultValue !== "number") {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${parent.filename}:
Parameter #${parameterNumber} has a non-numeric property defaultValue`);
    }
    this.defaultValue = definition.defaultValue;
    if (definition.recommendedValue != void 0 && typeof definition.recommendedValue !== "number") {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${parent.filename}:
Parameter #${parameterNumber} has a non-numeric property recommendedValue`);
    }
    this.recommendedValue = definition.recommendedValue;
    if (definition.allowManualEntry != void 0 && definition.allowManualEntry !== false) {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${parent.filename}:
Parameter #${parameterNumber}: allowManualEntry must be false or omitted!`);
    }
    this.allowManualEntry = definition.allowManualEntry ?? (this.readOnly ? false : true);
    if (definition.destructive != void 0 && typeof definition.destructive !== "boolean") {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${parent.filename}:
Parameter #${parameterNumber} has a non-boolean property destructive`);
    }
    this.destructive = definition.destructive;
    if ((0, import_typeguards.isArray)(definition.options) && !definition.options.every((opt) => (0, import_typeguards.isObject)(opt) && typeof opt.label === "string" && typeof opt.value === "number")) {
      (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${parent.filename}:
Parameter #${parameterNumber}: options is malformed!`);
    }
    this.options = definition.options?.map((opt) => new ConditionalConfigOption(opt.value, opt.label, opt.$if)) ?? [];
  }
  parent;
  parameterNumber;
  valueBitMask;
  label;
  description;
  valueSize;
  minValue;
  maxValue;
  unsigned;
  defaultValue;
  recommendedValue;
  unit;
  readOnly;
  writeOnly;
  allowManualEntry;
  destructive;
  options;
  condition;
  evaluateCondition(deviceId) {
    if (!(0, import_ConditionalItem.conditionApplies)(this, deviceId))
      return;
    const ret = {
      ...(0, import_shared.pick)(this, [
        "parameterNumber",
        "valueBitMask",
        "label",
        "description",
        "valueSize",
        "minValue",
        "maxValue",
        "unsigned",
        "defaultValue",
        "recommendedValue",
        "unit",
        "readOnly",
        "writeOnly",
        "allowManualEntry",
        "destructive"
      ]),
      options: (0, import_ConditionalItem.evaluateDeep)(this.options, deviceId, true)
    };
    if (ret.minValue == void 0) {
      if (ret.allowManualEntry === false && ret.options.length > 0) {
        ret.minValue = Math.min(...ret.options.map((o) => o.value));
      } else {
        (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${this.parent.filename}:
Parameter #${this.parameterNumber} is missing required property "minValue"!`);
      }
    }
    if (ret.maxValue == void 0) {
      if (ret.allowManualEntry === false && ret.options.length > 0) {
        ret.maxValue = Math.max(...ret.options.map((o) => o.value));
      } else {
        (0, import_utils_safe.throwInvalidConfig)("devices", `packages/config/config/devices/${this.parent.filename}:
Parameter #${this.parameterNumber} is missing required property "maxValue"!`);
      }
    }
    return ret;
  }
}
class ConditionalConfigOption {
  static {
    __name(this, "ConditionalConfigOption");
  }
  value;
  label;
  condition;
  constructor(value, label, condition) {
    this.value = value;
    this.label = label;
    this.condition = condition;
  }
  evaluateCondition(deviceId) {
    if (!(0, import_ConditionalItem.conditionApplies)(this, deviceId))
      return;
    return (0, import_shared.pick)(this, ["value", "label"]);
  }
}
function parseConditionalParamInformationMap(definition, parent, errorPrefix = "") {
  const paramInformation = new import_shared.ObjectKeyMap();
  const filename = parent.filename;
  if ((0, import_typeguards.isArray)(definition.paramInformation)) {
    if (!definition.paramInformation.every((entry) => "#" in entry)) {
      (0, import_utils_safe.throwInvalidConfig)(`device`, `packages/config/config/devices/${filename}: 
${errorPrefix}required property "#" missing in at least one entry of paramInformation`);
    }
    for (const entry of definition.paramInformation) {
      (0, import_ConditionalItem.validateCondition)(filename, entry, `${errorPrefix}At least one entry of paramInformation contains an`);
    }
    for (const paramDefinition of definition.paramInformation) {
      const { ["#"]: paramNo, ...defn } = paramDefinition;
      const key = (0, import_core.tryParseParamNumber)(paramNo);
      if (!key) {
        (0, import_utils_safe.throwInvalidConfig)(`device`, `packages/config/config/devices/${filename}: 
${errorPrefix}found invalid param number "${paramNo}" in paramInformation`);
      }
      if (!paramInformation.has(key))
        paramInformation.set(key, []);
      paramInformation.get(key).push(new ConditionalParamInformation(parent, key.parameter, key.valueBitMask, defn));
    }
  } else if ((0, import_typeguards.isObject)(definition.paramInformation)) {
  } else {
    (0, import_utils_safe.throwInvalidConfig)(`device`, `packages/config/config/devices/${filename}:
${errorPrefix}paramInformation must be an array!`);
  }
  return paramInformation;
}
__name(parseConditionalParamInformationMap, "parseConditionalParamInformationMap");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  ConditionalConfigOption,
  ConditionalParamInformation,
  parseConditionalParamInformationMap
});
//# sourceMappingURL=ParamInformation.js.map
