import { isObject } from "alcalzone-shared/typeguards";
import { throwInvalidConfig } from "../utils_safe.js";
import { ConditionalAssociationConfig, } from "./AssociationConfig.js";
import { conditionApplies, evaluateDeep, validateCondition, } from "./ConditionalItem.js";
import { parseConditionalParamInformationMap, } from "./ParamInformation.js";
export class ConditionalEndpointConfig {
    constructor(parent, index, definition) {
        this.index = index;
        const filename = parent.filename;
        validateCondition(filename, definition, `Endpoint ${index} contains an`);
        this.condition = definition.$if;
        if (definition.label != undefined) {
            if (typeof definition.label !== "string") {
                throwInvalidConfig(`device`, `packages/config/config/devices/${filename}:
Endpoint ${index}: label is not a string`);
            }
            this.label = definition.label;
        }
        if (definition.associations != undefined) {
            const associations = new Map();
            if (!isObject(definition.associations)) {
                throwInvalidConfig(`device`, `packages/config/config/devices/${filename}:
Endpoint ${index}: associations is not an object`);
            }
            for (const [key, assocDefinition] of Object.entries(definition.associations)) {
                if (!/^[1-9][0-9]*$/.test(key)) {
                    throwInvalidConfig(`device`, `packages/config/config/devices/${filename}:
Endpoint ${index}: found non-numeric group id "${key}" in associations`);
                }
                const keyNum = parseInt(key, 10);
                associations.set(keyNum, new ConditionalAssociationConfig(filename, keyNum, assocDefinition));
            }
            this.associations = associations;
        }
        if (definition.paramInformation != undefined) {
            this.paramInformation = parseConditionalParamInformationMap(definition, parent, `Endpoint ${index}: `);
        }
    }
    index;
    associations;
    paramInformation;
    condition;
    label;
    evaluateCondition(deviceId) {
        if (!conditionApplies(this, deviceId))
            return;
        const ret = {
            index: this.index,
            label: this.label,
        };
        const associations = evaluateDeep(this.associations, deviceId);
        if (associations)
            ret.associations = associations;
        const paramInformation = evaluateDeep(this.paramInformation, deviceId);
        if (paramInformation)
            ret.paramInformation = paramInformation;
        return ret;
    }
}
//# sourceMappingURL=EndpointConfig.js.map