import { type BytesView } from "@zwave-js/shared";
import type { FSStats, FileHandle, FileSystem } from "@zwave-js/shared/bindings";
import fsp from "node:fs/promises";
/** An implementation of the FileSystem bindings for Node.js */
export declare const fs: FileSystem;
export declare class NodeFileHandle implements FileHandle {
    constructor(handle: fsp.FileHandle, flags: {
        read: boolean;
        write: boolean;
    });
    private open;
    private handle;
    private flags;
    private _readable?;
    private _writable?;
    get readable(): ReadableStream<BytesView>;
    get writable(): WritableStream<BytesView>;
    close(): Promise<void>;
    read(position?: number | null, length?: number): Promise<{
        data: BytesView;
        bytesRead: number;
    }>;
    write(data: BytesView, position?: number | null): Promise<{
        bytesWritten: number;
    }>;
    stat(): Promise<FSStats>;
}
//# sourceMappingURL=node.d.ts.map