"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var NodeInfo_exports = {};
__export(NodeInfo_exports, {
  NodeType: () => NodeType,
  encodeApplicationNodeInformation: () => encodeApplicationNodeInformation,
  encodeCCId: () => encodeCCId,
  encodeCCList: () => encodeCCList,
  encodeNodeID: () => encodeNodeID,
  encodeNodeInformationFrame: () => encodeNodeInformationFrame,
  encodeNodeProtocolInfo: () => encodeNodeProtocolInfo,
  encodeNodeProtocolInfoAndDeviceClass: () => encodeNodeProtocolInfoAndDeviceClass,
  encodeNodeUpdatePayload: () => encodeNodeUpdatePayload,
  parseApplicationNodeInformation: () => parseApplicationNodeInformation,
  parseCCId: () => parseCCId,
  parseCCList: () => parseCCList,
  parseNodeID: () => parseNodeID,
  parseNodeInformationFrame: () => parseNodeInformationFrame,
  parseNodeProtocolInfo: () => parseNodeProtocolInfo,
  parseNodeProtocolInfoAndDeviceClass: () => parseNodeProtocolInfoAndDeviceClass,
  parseNodeUpdatePayload: () => parseNodeUpdatePayload
});
module.exports = __toCommonJS(NodeInfo_exports);
var import_shared = require("@zwave-js/shared");
var import_misc = require("../util/misc.js");
var import_CommandClasses = require("./CommandClasses.js");
var import_NodeID = require("./NodeID.js");
function parseApplicationNodeInformation(nif) {
  (0, import_misc.validatePayload)(nif.length >= 2);
  return {
    genericDeviceClass: nif[0],
    specificDeviceClass: nif[1],
    supportedCCs: parseCCList(nif.subarray(2)).supportedCCs
  };
}
__name(parseApplicationNodeInformation, "parseApplicationNodeInformation");
function encodeApplicationNodeInformation(nif) {
  const ccList = encodeCCList(nif.supportedCCs, []);
  return import_shared.Bytes.concat([
    import_shared.Bytes.from([nif.genericDeviceClass, nif.specificDeviceClass]),
    ccList
  ]);
}
__name(encodeApplicationNodeInformation, "encodeApplicationNodeInformation");
function parseNodeUpdatePayload(nif, nodeIdType = import_NodeID.NodeIDType.Short) {
  let offset = 0;
  const { nodeId, bytesRead: nodeIdBytes } = parseNodeID(nif, nodeIdType, offset);
  offset += nodeIdBytes;
  const remainingLength = nif[offset++];
  (0, import_misc.validatePayload)(nif.length >= offset + remainingLength);
  return {
    nodeId,
    basicDeviceClass: nif[offset],
    ...parseApplicationNodeInformation(nif.subarray(offset + 1, offset + remainingLength))
  };
}
__name(parseNodeUpdatePayload, "parseNodeUpdatePayload");
function encodeNodeUpdatePayload(nif, nodeIdType = import_NodeID.NodeIDType.Short) {
  const ccList = encodeCCList(nif.supportedCCs, []);
  const nodeId = encodeNodeID(nif.nodeId, nodeIdType);
  return import_shared.Bytes.concat([
    nodeId,
    import_shared.Bytes.from([
      3 + ccList.length,
      nif.basicDeviceClass,
      nif.genericDeviceClass,
      nif.specificDeviceClass
    ]),
    ccList
  ]);
}
__name(encodeNodeUpdatePayload, "encodeNodeUpdatePayload");
function isExtendedCCId(ccId) {
  return ccId >= 241;
}
__name(isExtendedCCId, "isExtendedCCId");
function parseCCId(payload, offset = 0) {
  const isExtended = isExtendedCCId(payload[offset]);
  (0, import_misc.validatePayload)(payload.length >= offset + (isExtended ? 2 : 1));
  const view = import_shared.Bytes.view(payload);
  if (isExtended) {
    return { ccId: view.readUInt16BE(offset), bytesRead: 2 };
  } else {
    return { ccId: view.readUInt8(offset), bytesRead: 1 };
  }
}
__name(parseCCId, "parseCCId");
function encodeCCId(ccId, payload, offset = 0) {
  if (isExtendedCCId(ccId)) {
    payload.writeUInt16BE(ccId, offset);
    return 2;
  } else {
    payload.writeUInt8(ccId, offset);
    return 1;
  }
}
__name(encodeCCId, "encodeCCId");
function parseCCList(payload) {
  const ret = {
    supportedCCs: [],
    controlledCCs: []
  };
  let offset = 0;
  let isAfterMark = false;
  while (offset < payload.length) {
    const { ccId: cc, bytesRead } = parseCCId(payload, offset);
    offset += bytesRead;
    if (cc === import_CommandClasses.CommandClasses["Support/Control Mark"]) {
      isAfterMark = true;
      continue;
    }
    (isAfterMark ? ret.controlledCCs : ret.supportedCCs).push(cc);
  }
  return ret;
}
__name(parseCCList, "parseCCList");
function encodeCCList(supportedCCs, controlledCCs) {
  const bufferLength = (0, import_shared.sum)(supportedCCs.map((cc) => isExtendedCCId(cc) ? 2 : 1)) + (controlledCCs.length > 0 ? 1 : 0) + (0, import_shared.sum)(controlledCCs.map((cc) => isExtendedCCId(cc) ? 2 : 1));
  const ret = new import_shared.Bytes(bufferLength);
  let offset = 0;
  for (const cc of supportedCCs) {
    offset += encodeCCId(cc, ret, offset);
  }
  if (controlledCCs.length > 0) {
    ret[offset++] = import_CommandClasses.CommandClasses["Support/Control Mark"];
    for (const cc of controlledCCs) {
      offset += encodeCCId(cc, ret, offset);
    }
  }
  return ret;
}
__name(encodeCCList, "encodeCCList");
var NodeType;
(function(NodeType2) {
  NodeType2[NodeType2["Controller"] = 0] = "Controller";
  NodeType2[NodeType2["End Node"] = 1] = "End Node";
})(NodeType || (NodeType = {}));
function parseNodeProtocolInfo(buffer, offset, isLongRange = false) {
  (0, import_misc.validatePayload)(buffer.length >= offset + 3);
  const isListening = !!(buffer[offset] & 128);
  const isRouting = !!(buffer[offset] & 64);
  const supportedDataRates = [];
  const speed = buffer[offset] & 24;
  const speedExt = buffer[offset + 2] & 7;
  if (isLongRange) {
    if (speedExt & 2) {
      supportedDataRates.push(1e5);
    }
  } else {
    if (speed & 16) {
      supportedDataRates.push(4e4);
    }
    if (speed & 8) {
      supportedDataRates.push(9600);
    }
    if (speedExt & 1) {
      supportedDataRates.push(1e5);
    }
    if (supportedDataRates.length === 0) {
      supportedDataRates.push(9600);
    }
  }
  const protocolVersion = buffer[offset] & 7;
  const capability = buffer[offset + 1];
  const optionalFunctionality = !!(capability & 128);
  let isFrequentListening;
  switch (capability & 96) {
    case 64:
      isFrequentListening = "1000ms";
      break;
    case 32:
      isFrequentListening = "250ms";
      break;
    default:
      isFrequentListening = false;
  }
  const supportsBeaming = !!(capability & 16);
  let nodeType;
  switch (capability & 10) {
    case 2:
      nodeType = NodeType.Controller;
      break;
    case 8:
    // Routing end node
    default:
      nodeType = NodeType["End Node"];
      break;
  }
  const hasSpecificDeviceClass = !!(capability & 4);
  const supportsSecurity = !!(capability & 1);
  return {
    isListening,
    isFrequentListening,
    isRouting,
    supportedDataRates,
    protocolVersion,
    optionalFunctionality,
    nodeType,
    supportsSecurity,
    supportsBeaming,
    hasSpecificDeviceClass
  };
}
__name(parseNodeProtocolInfo, "parseNodeProtocolInfo");
function encodeNodeProtocolInfo(info, isLongRange = false) {
  const ret = import_shared.Bytes.alloc(3, 0);
  if (info.isListening)
    ret[0] |= 128;
  if (info.isRouting)
    ret[0] |= 64;
  if (isLongRange) {
    if (info.supportedDataRates.includes(1e5))
      ret[2] |= 2;
  } else {
    if (info.supportedDataRates.includes(4e4))
      ret[0] |= 16;
    if (info.supportedDataRates.includes(9600))
      ret[0] |= 8;
    if (info.supportedDataRates.includes(1e5))
      ret[2] |= 1;
  }
  ret[0] |= info.protocolVersion & 7;
  if (info.optionalFunctionality)
    ret[1] |= 128;
  if (info.isFrequentListening === "1000ms")
    ret[1] |= 64;
  else if (info.isFrequentListening === "250ms")
    ret[1] |= 32;
  if (info.supportsBeaming)
    ret[1] |= 16;
  if (info.supportsSecurity)
    ret[1] |= 1;
  if (info.nodeType === NodeType["End Node"])
    ret[1] |= 8;
  else
    ret[1] |= 2;
  if (info.hasSpecificDeviceClass)
    ret[1] |= 4;
  return ret;
}
__name(encodeNodeProtocolInfo, "encodeNodeProtocolInfo");
function parseNodeProtocolInfoAndDeviceClass(buffer, isLongRange = false) {
  (0, import_misc.validatePayload)(buffer.length >= 5);
  const protocolInfo = parseNodeProtocolInfo(buffer, 0, isLongRange);
  let offset = 3;
  const basic = buffer[offset++];
  const generic = buffer[offset++];
  let specific = 0;
  if (protocolInfo.hasSpecificDeviceClass) {
    (0, import_misc.validatePayload)(buffer.length >= offset + 1);
    specific = buffer[offset++];
  }
  return {
    info: {
      ...protocolInfo,
      basicDeviceClass: basic,
      genericDeviceClass: generic,
      specificDeviceClass: specific
    },
    bytesRead: offset
  };
}
__name(parseNodeProtocolInfoAndDeviceClass, "parseNodeProtocolInfoAndDeviceClass");
function encodeNodeProtocolInfoAndDeviceClass(info, isLongRange = false) {
  return import_shared.Bytes.concat([
    encodeNodeProtocolInfo({ ...info, hasSpecificDeviceClass: true }, isLongRange),
    import_shared.Bytes.from([
      info.basicDeviceClass,
      info.genericDeviceClass,
      info.specificDeviceClass
    ])
  ]);
}
__name(encodeNodeProtocolInfoAndDeviceClass, "encodeNodeProtocolInfoAndDeviceClass");
function parseNodeInformationFrame(buffer, isLongRange = false) {
  const result = parseNodeProtocolInfoAndDeviceClass(buffer, isLongRange);
  const info = result.info;
  let offset = result.bytesRead;
  let ccList;
  if (isLongRange) {
    const ccListLength = buffer[offset];
    offset += 1;
    (0, import_misc.validatePayload)(buffer.length >= offset + ccListLength);
    ccList = buffer.subarray(offset, offset + ccListLength);
  } else {
    ccList = buffer.subarray(offset);
  }
  const supportedCCs = parseCCList(ccList).supportedCCs;
  return {
    ...info,
    supportedCCs
  };
}
__name(parseNodeInformationFrame, "parseNodeInformationFrame");
function encodeNodeInformationFrame(info, isLongRange = false) {
  const protocolInfo = encodeNodeProtocolInfoAndDeviceClass(info, isLongRange);
  let ccList = encodeCCList(info.supportedCCs, []);
  if (isLongRange) {
    ccList = import_shared.Bytes.concat([import_shared.Bytes.from([ccList.length]), ccList]);
  }
  return import_shared.Bytes.concat([protocolInfo, ccList]);
}
__name(encodeNodeInformationFrame, "encodeNodeInformationFrame");
function parseNodeID(buffer, type = import_NodeID.NodeIDType.Short, offset = 0) {
  (0, import_misc.validatePayload)(buffer.length >= offset + type);
  const nodeId = import_shared.Bytes.view(buffer).readUIntBE(offset, type);
  return { nodeId, bytesRead: type };
}
__name(parseNodeID, "parseNodeID");
function encodeNodeID(nodeId, type = import_NodeID.NodeIDType.Short) {
  const ret = new import_shared.Bytes(type);
  ret.writeUIntBE(nodeId, 0, type);
  return ret;
}
__name(encodeNodeID, "encodeNodeID");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  NodeType,
  encodeApplicationNodeInformation,
  encodeCCId,
  encodeCCList,
  encodeNodeID,
  encodeNodeInformationFrame,
  encodeNodeProtocolInfo,
  encodeNodeProtocolInfoAndDeviceClass,
  encodeNodeUpdatePayload,
  parseApplicationNodeInformation,
  parseCCId,
  parseCCList,
  parseNodeID,
  parseNodeInformationFrame,
  parseNodeProtocolInfo,
  parseNodeProtocolInfoAndDeviceClass,
  parseNodeUpdatePayload
});
//# sourceMappingURL=NodeInfo.js.map
