"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var RoutingScheme_exports = {};
__export(RoutingScheme_exports, {
  RoutingScheme: () => RoutingScheme,
  routingSchemeToString: () => routingSchemeToString
});
module.exports = __toCommonJS(RoutingScheme_exports);
var import_shared = require("@zwave-js/shared");
var RoutingScheme;
(function(RoutingScheme2) {
  RoutingScheme2[RoutingScheme2["Idle"] = 0] = "Idle";
  RoutingScheme2[RoutingScheme2["Direct"] = 1] = "Direct";
  RoutingScheme2[RoutingScheme2["Priority"] = 2] = "Priority";
  RoutingScheme2[RoutingScheme2["LWR"] = 3] = "LWR";
  RoutingScheme2[RoutingScheme2["NLWR"] = 4] = "NLWR";
  RoutingScheme2[RoutingScheme2["Auto"] = 5] = "Auto";
  RoutingScheme2[RoutingScheme2["ResortDirect"] = 6] = "ResortDirect";
  RoutingScheme2[RoutingScheme2["Explore"] = 7] = "Explore";
})(RoutingScheme || (RoutingScheme = {}));
function routingSchemeToString(scheme) {
  switch (scheme) {
    case RoutingScheme.Idle:
      return "Idle";
    case RoutingScheme.Direct:
      return "Direct";
    case RoutingScheme.Priority:
      return "Priority Route";
    case RoutingScheme.LWR:
      return "LWR";
    case RoutingScheme.NLWR:
      return "NLWR";
    case RoutingScheme.Auto:
      return "Auto Route";
    case RoutingScheme.ResortDirect:
      return "Resort to Direct";
    case RoutingScheme.Explore:
      return "Explorer Frame";
    default:
      return `Unknown (${(0, import_shared.num2hex)(scheme)})`;
  }
}
__name(routingSchemeToString, "routingSchemeToString");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  RoutingScheme,
  routingSchemeToString
});
//# sourceMappingURL=RoutingScheme.js.map
