"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Supervision_exports = {};
__export(Supervision_exports, {
  MAX_SUPERVISION_SESSION_ID: () => MAX_SUPERVISION_SESSION_ID,
  SupervisionStatus: () => SupervisionStatus,
  isSupervisionResult: () => isSupervisionResult,
  isUnsupervisedOrSucceeded: () => isUnsupervisedOrSucceeded,
  mergeSupervisionResults: () => mergeSupervisionResults,
  supervisedCommandFailed: () => supervisedCommandFailed,
  supervisedCommandSucceeded: () => supervisedCommandSucceeded
});
module.exports = __toCommonJS(Supervision_exports);
var import_typeguards = require("alcalzone-shared/typeguards");
var import_Duration = require("../values/Duration.js");
var SupervisionStatus;
(function(SupervisionStatus2) {
  SupervisionStatus2[SupervisionStatus2["NoSupport"] = 0] = "NoSupport";
  SupervisionStatus2[SupervisionStatus2["Working"] = 1] = "Working";
  SupervisionStatus2[SupervisionStatus2["Fail"] = 2] = "Fail";
  SupervisionStatus2[SupervisionStatus2["Success"] = 255] = "Success";
})(SupervisionStatus || (SupervisionStatus = {}));
function isSupervisionResult(obj) {
  return (0, import_typeguards.isObject)(obj) && "status" in obj && typeof SupervisionStatus[obj.status] === "string";
}
__name(isSupervisionResult, "isSupervisionResult");
function supervisedCommandSucceeded(result) {
  return isSupervisionResult(result) && (result.status === SupervisionStatus.Success || result.status === SupervisionStatus.Working);
}
__name(supervisedCommandSucceeded, "supervisedCommandSucceeded");
function supervisedCommandFailed(result) {
  return isSupervisionResult(result) && (result.status === SupervisionStatus.Fail || result.status === SupervisionStatus.NoSupport);
}
__name(supervisedCommandFailed, "supervisedCommandFailed");
function isUnsupervisedOrSucceeded(result) {
  return !result || supervisedCommandSucceeded(result);
}
__name(isUnsupervisedOrSucceeded, "isUnsupervisedOrSucceeded");
function mergeSupervisionResults(results) {
  const supervisionResults = results.filter(isSupervisionResult);
  if (!supervisionResults.length)
    return void 0;
  if (supervisionResults.some((r) => r.status === SupervisionStatus.Fail)) {
    return {
      status: SupervisionStatus.Fail
    };
  } else if (supervisionResults.some((r) => r.status === SupervisionStatus.NoSupport)) {
    return {
      status: SupervisionStatus.NoSupport
    };
  }
  const working = supervisionResults.filter((r) => r.status === SupervisionStatus.Working);
  if (working.length > 0) {
    const durations = working.map((r) => r.remainingDuration.serializeSet());
    const maxDuration = durations.length > 0 && import_Duration.Duration.parseReport(Math.max(...durations)) || import_Duration.Duration.unknown();
    return {
      status: SupervisionStatus.Working,
      remainingDuration: maxDuration
    };
  }
  return {
    status: SupervisionStatus.Success
  };
}
__name(mergeSupervisionResults, "mergeSupervisionResults");
const MAX_SUPERVISION_SESSION_ID = 63;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  MAX_SUPERVISION_SESSION_ID,
  SupervisionStatus,
  isSupervisionResult,
  isUnsupervisedOrSucceeded,
  mergeSupervisionResults,
  supervisedCommandFailed,
  supervisedCommandSucceeded
});
//# sourceMappingURL=Supervision.js.map
