"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ZWaveChipTypes_exports = {};
__export(ZWaveChipTypes_exports, {
  getChipTypeAndVersion: () => getChipTypeAndVersion,
  getZWaveChipType: () => getZWaveChipType
});
module.exports = __toCommonJS(ZWaveChipTypes_exports);
const chipTypes = Object.freeze({
  [258]: "ZW0102",
  [513]: "ZW0201",
  [769]: "ZW0301",
  [1025]: "ZM0401 / ZM4102 / SD3402",
  [1280]: "ZW050x",
  [1792]: "EFR32ZG14 / ZGM130S",
  [2048]: "EFR32ZG23 / ZGM230S"
});
function getZWaveChipType(type, version) {
  return chipTypes[type << 8 | version] ?? {
    type,
    version
  };
}
__name(getZWaveChipType, "getZWaveChipType");
function getChipTypeAndVersion(zWaveChipType) {
  for (const [id, name] of Object.entries(chipTypes)) {
    if (name === zWaveChipType) {
      const idNum = parseInt(id);
      return {
        type: idNum >>> 8,
        version: idNum & 255
      };
    }
  }
}
__name(getChipTypeAndVersion, "getChipTypeAndVersion");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  getChipTypeAndVersion,
  getZWaveChipType
});
//# sourceMappingURL=ZWaveChipTypes.js.map
