"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var FSM_exports = {};
__export(FSM_exports, {
  StateMachine: () => StateMachine
});
module.exports = __toCommonJS(FSM_exports);
class StateMachine {
  static {
    __name(this, "StateMachine");
  }
  constructor(initialState, transitions) {
    this._initial = this._state = initialState;
    this.transitions = transitions;
  }
  transitions;
  /** Restarts the machine from the initial state */
  restart() {
    this._state = this._initial;
  }
  /** Determines the next transition to take */
  next(input) {
    if (this._state.done)
      return;
    return this.transitions(this._state)(input);
  }
  /** Transitions the machine to the next state. This does not execute effects */
  transition(next) {
    if (next == void 0)
      return;
    this._state = next;
  }
  _initial;
  _state;
  /** Returns the current state of the state machine */
  get state() {
    return this._state;
  }
  /** Returns whether this state machine is done */
  get done() {
    return !!this._state.done;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  StateMachine
});
//# sourceMappingURL=FSM.js.map
