"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var decorators_exports = {};
__export(decorators_exports, {
  createReflectionDecorator: () => createReflectionDecorator,
  createReflectionDecoratorPair: () => createReflectionDecoratorPair,
  createSimpleReflectionDecorator: () => createSimpleReflectionDecorator,
  createValuelessReflectionDecorator: () => createValuelessReflectionDecorator
});
module.exports = __toCommonJS(decorators_exports);
var import_reflect_metadata = require("reflect-metadata");
function createReflectionDecorator({
  name,
  valueFromArgs,
  // getConstructorLookupTarget,
  constructorLookupKey
}) {
  const key = Symbol.for(`METADATA_${name}`);
  const mapKey = Symbol.for(`METADATA_MAP_${name}`);
  const lookupTarget = /* @__PURE__ */ Object.create(null);
  const grp = {
    decorator: /* @__PURE__ */ __name((...args) => {
      const value = valueFromArgs(...args);
      function body(target, _context) {
        Reflect.defineMetadata(key, value, target);
        if (constructorLookupKey === false)
          return;
        const reverseLookupKey = constructorLookupKey?.(target, ...args) ?? String(value);
        const map = Reflect.getMetadata(mapKey, lookupTarget) || /* @__PURE__ */ new Map();
        map.set(reverseLookupKey, target);
        Reflect.defineMetadata(mapKey, map, lookupTarget);
      }
      __name(body, "body");
      Object.defineProperty(body, "name", {
        value: "decoratorBody_" + name
      });
      return body;
    }, "decorator"),
    lookupValue: /* @__PURE__ */ __name((target) => {
      return Reflect.getMetadata(key, target.constructor);
    }, "lookupValue"),
    lookupValueStatic: /* @__PURE__ */ __name((constr) => {
      return Reflect.getMetadata(key, constr);
    }, "lookupValueStatic"),
    lookupConstructorByValue: /* @__PURE__ */ __name((value) => {
      if (constructorLookupKey === false) {
        throw new Error("Constructor lookup is disabled for this decorator!");
      } else if (constructorLookupKey) {
        throw new Error("Cannot lookup constructor by value when constructorLookupKey is used");
      } else {
        return grp.lookupConstructorByKey(String(value));
      }
    }, "lookupConstructorByValue"),
    lookupConstructorByKey: /* @__PURE__ */ __name((key2) => {
      if (constructorLookupKey === false) {
        throw new Error("Constructor lookup is disabled for this decorator!");
      }
      const map = Reflect.getMetadata(mapKey, lookupTarget);
      return map?.get(key2);
    }, "lookupConstructorByKey")
  };
  for (const property of [
    "decorator",
    "lookupValue",
    "lookupValueStatic",
    "lookupConstructorByValue",
    "lookupConstructorByKey"
  ]) {
    grp[property] = Object.defineProperty(grp[property], "name", {
      value: `${property}_${name}`
    });
  }
  return grp;
}
__name(createReflectionDecorator, "createReflectionDecorator");
function createSimpleReflectionDecorator({ name }) {
  const decorator = createReflectionDecorator({
    name,
    valueFromArgs: /* @__PURE__ */ __name((arg) => arg, "valueFromArgs")
  });
  const ret = {
    decorator: decorator.decorator,
    lookupValue: decorator.lookupValue,
    lookupValueStatic: decorator.lookupValueStatic,
    lookupConstructor: decorator.lookupConstructorByValue
  };
  return ret;
}
__name(createSimpleReflectionDecorator, "createSimpleReflectionDecorator");
function createValuelessReflectionDecorator({ name }) {
  const decorator = createReflectionDecorator({
    name,
    valueFromArgs: /* @__PURE__ */ __name(() => true, "valueFromArgs")
  });
  const ret = {
    decorator: decorator.decorator,
    isDecorated: /* @__PURE__ */ __name((target) => !!decorator.lookupValue(target), "isDecorated"),
    isDecoratedStatic: /* @__PURE__ */ __name((constr) => !!decorator.lookupValueStatic(constr), "isDecoratedStatic")
  };
  return ret;
}
__name(createValuelessReflectionDecorator, "createValuelessReflectionDecorator");
function createReflectionDecoratorPair({ superName, subName }) {
  const superDecorator = createReflectionDecorator({
    name: superName,
    valueFromArgs: /* @__PURE__ */ __name((arg) => arg, "valueFromArgs")
  });
  const getLookupKey = /* @__PURE__ */ __name((superArg, subArg) => {
    return JSON.stringify({ [superName]: superArg, [subName]: subArg });
  }, "getLookupKey");
  const subDecorator = createReflectionDecorator({
    name: subName,
    valueFromArgs: /* @__PURE__ */ __name((arg) => arg, "valueFromArgs"),
    constructorLookupKey: /* @__PURE__ */ __name((target, subArg) => {
      const superArg = superDecorator.lookupValueStatic(target);
      return getLookupKey(superArg, subArg);
    }, "constructorLookupKey")
  });
  const ret = {
    superDecorator: superDecorator.decorator,
    subDecorator: subDecorator.decorator,
    lookupSuperValue: superDecorator.lookupValue,
    lookupSubValue: subDecorator.lookupValue,
    lookupSuperValueStatic: superDecorator.lookupValueStatic,
    lookupSubValueStatic: subDecorator.lookupValueStatic,
    lookupSuperConstructor: superDecorator.lookupConstructorByValue,
    lookupSubConstructor: /* @__PURE__ */ __name((...args) => {
      return subDecorator.lookupConstructorByKey(getLookupKey(args[0], args[1]));
    }, "lookupSubConstructor")
  };
  return ret;
}
__name(createReflectionDecoratorPair, "createReflectionDecoratorPair");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  createReflectionDecorator,
  createReflectionDecoratorPair,
  createSimpleReflectionDecorator,
  createValuelessReflectionDecorator
});
//# sourceMappingURL=decorators.js.map
