"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Manager_exports = {};
__export(Manager_exports, {
  SecurityManager: () => SecurityManager,
  generateAuthKey: () => generateAuthKey,
  generateEncryptionKey: () => generateEncryptionKey
});
module.exports = __toCommonJS(Manager_exports);
var import_shared = require("@zwave-js/shared");
var import_crypto = require("../crypto/index.js");
var import_ZWaveError = require("../error/ZWaveError.js");
const authKeyBase = new Uint8Array(16).fill(85);
const encryptionKeyBase = new Uint8Array(16).fill(170);
function generateAuthKey(networkKey) {
  return (0, import_crypto.encryptAES128ECB)(authKeyBase, networkKey);
}
__name(generateAuthKey, "generateAuthKey");
function generateEncryptionKey(networkKey) {
  return (0, import_crypto.encryptAES128ECB)(encryptionKeyBase, networkKey);
}
__name(generateEncryptionKey, "generateEncryptionKey");
class SecurityManager {
  static {
    __name(this, "SecurityManager");
  }
  constructor(options) {
    this.networkKey = options.networkKey;
    this.ownNodeId = options.ownNodeId;
    this.nonceTimeout = options.nonceTimeout;
  }
  ownNodeId;
  nonceTimeout;
  _networkKey;
  get networkKey() {
    return this._networkKey;
  }
  set networkKey(v) {
    if (v.length !== 16) {
      throw new import_ZWaveError.ZWaveError(`The network key must be 16 bytes long!`, import_ZWaveError.ZWaveErrorCodes.Argument_Invalid);
    }
    this._networkKey = v;
    this._authKey = void 0;
    this._encryptionKey = void 0;
  }
  _authKey;
  async getAuthKey() {
    if (!this._authKey) {
      this._authKey = await generateAuthKey(this.networkKey);
    }
    return this._authKey;
  }
  _encryptionKey;
  async getEncryptionKey() {
    if (!this._encryptionKey) {
      this._encryptionKey = await generateEncryptionKey(this.networkKey);
    }
    return this._encryptionKey;
  }
  _nonceStore = /* @__PURE__ */ new Map();
  _freeNonceIDs = /* @__PURE__ */ new Set();
  _nonceTimers = /* @__PURE__ */ new Map();
  normalizeId(id) {
    let ret;
    if (typeof id === "number") {
      ret = {
        issuer: this.ownNodeId,
        nonceId: id
      };
    } else {
      ret = {
        issuer: id.issuer,
        nonceId: id.nonceId
      };
    }
    return JSON.stringify(ret);
  }
  /** Generates a nonce for the current node */
  generateNonce(receiver, length) {
    let nonce;
    let nonceId;
    do {
      nonce = (0, import_crypto.randomBytes)(length);
      nonceId = this.getNonceId(nonce);
    } while (this.hasNonce(nonceId));
    this.setNonce(nonceId, { receiver, nonce }, { free: false });
    return nonce;
  }
  getNonceId(nonce) {
    return nonce[0];
  }
  setNonce(id, entry, { free = true } = {}) {
    const key = this.normalizeId(id);
    this._nonceTimers.get(key)?.clear();
    this._nonceStore.set(key, entry);
    if (free)
      this._freeNonceIDs.add(key);
    this._nonceTimers.set(key, (0, import_shared.setTimer)(() => {
      this.expireNonce(key);
    }, this.nonceTimeout).unref());
  }
  /** Deletes ALL nonces that were issued for a given node */
  deleteAllNoncesForReceiver(receiver) {
    for (const [key, entry] of this._nonceStore) {
      if (entry.receiver === receiver) {
        this.deleteNonceInternal(key);
      }
    }
  }
  deleteNonce(id) {
    const key = this.normalizeId(id);
    const nonceReceiver = this._nonceStore.get(key)?.receiver;
    this.deleteNonceInternal(key);
    if (nonceReceiver) {
      this.deleteAllNoncesForReceiver(nonceReceiver);
    }
  }
  deleteNonceInternal(key) {
    this._nonceTimers.get(key)?.clear();
    this._nonceStore.delete(key);
    this._nonceTimers.delete(key);
    this._freeNonceIDs.delete(key);
  }
  expireNonce(key) {
    this.deleteNonceInternal(key);
  }
  getNonce(id) {
    return this._nonceStore.get(this.normalizeId(id))?.nonce;
  }
  hasNonce(id) {
    return this._nonceStore.has(this.normalizeId(id));
  }
  getFreeNonce(nodeId) {
    for (const key of this._freeNonceIDs) {
      const nonceKey = JSON.parse(key);
      if (nonceKey.issuer === nodeId) {
        this._freeNonceIDs.delete(key);
        return this._nonceStore.get(key)?.nonce;
      }
    }
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  SecurityManager,
  generateAuthKey,
  generateEncryptionKey
});
//# sourceMappingURL=Manager.js.map
