"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var graph_exports = {};
__export(graph_exports, {
  GraphNode: () => GraphNode,
  topologicalSort: () => topologicalSort
});
module.exports = __toCommonJS(graph_exports);
class GraphNode {
  static {
    __name(this, "GraphNode");
  }
  constructor(value, edges = []) {
    this.value = value;
    this.edges = new Set(edges);
  }
  /** The value of this node */
  value;
  /** Which nodes this node depends on */
  edges;
}
function topologicalSort(graph) {
  const ret = [];
  while (graph.length) {
    const nodesWithoutDependencies = graph.filter((node) => node.edges.size === 0);
    if (!nodesWithoutDependencies.length) {
      throw new Error("Circular dependency detected!");
    }
    const newNodes = nodesWithoutDependencies.map((node) => node.value);
    ret.push(...newNodes);
    graph = graph.filter((node) => node.edges.size > 0);
    for (const node of graph) {
      for (const visited of nodesWithoutDependencies) {
        node.edges.delete(visited);
      }
    }
  }
  return ret;
}
__name(topologicalSort, "topologicalSort");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  GraphNode,
  topologicalSort
});
//# sourceMappingURL=graph.js.map
