"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var misc_exports = {};
__export(misc_exports, {
  getBitMaskWidth: () => getBitMaskWidth,
  getLegalRangeForBitMask: () => getLegalRangeForBitMask,
  getMinimumShiftForBitMask: () => getMinimumShiftForBitMask,
  isConsecutiveArray: () => isConsecutiveArray,
  stripUndefined: () => stripUndefined,
  validatePayload: () => validatePayload
});
module.exports = __toCommonJS(misc_exports);
var import_ZWaveError = require("../error/ZWaveError.js");
function isConsecutiveArray(values) {
  return values.every((v, i, arr) => i === 0 ? true : v - 1 === arr[i - 1]);
}
__name(isConsecutiveArray, "isConsecutiveArray");
function stripUndefined(obj) {
  const ret = {};
  for (const [key, value] of Object.entries(obj)) {
    if (value !== void 0)
      ret[key] = value;
  }
  return ret;
}
__name(stripUndefined, "stripUndefined");
function validatePayloadInternal(reason, ...assertions) {
  if (!assertions.every(Boolean)) {
    throw new import_ZWaveError.ZWaveError("The message payload is invalid!", import_ZWaveError.ZWaveErrorCodes.PacketFormat_InvalidPayload, reason);
  }
}
__name(validatePayloadInternal, "validatePayloadInternal");
const validatePayload = validatePayloadInternal.bind(void 0, void 0);
validatePayload.withReason = (reason) => validatePayloadInternal.bind(void 0, reason);
validatePayload.fail = (reason) => validatePayload.withReason(reason)(false);
function getMinimumShiftForBitMask(mask) {
  let i = 0;
  while (mask % 2 === 0) {
    mask >>>= 1;
    if (mask === 0)
      break;
    i++;
  }
  return i;
}
__name(getMinimumShiftForBitMask, "getMinimumShiftForBitMask");
function getBitMaskWidth(mask) {
  mask = mask >>> getMinimumShiftForBitMask(mask);
  let i = 0;
  while (mask > 0) {
    mask >>>= 1;
    i++;
  }
  return i;
}
__name(getBitMaskWidth, "getBitMaskWidth");
function getLegalRangeForBitMask(mask, unsigned) {
  if (mask === 0)
    return [0, 0];
  const bitMaskWidth = getBitMaskWidth(mask);
  const min = unsigned || bitMaskWidth == 1 ? 0 : -(2 ** (bitMaskWidth - 1));
  const max = unsigned || bitMaskWidth == 1 ? 2 ** bitMaskWidth - 1 : 2 ** (bitMaskWidth - 1) - 1;
  return [min, max];
}
__name(getLegalRangeForBitMask, "getLegalRangeForBitMask");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  getBitMaskWidth,
  getLegalRangeForBitMask,
  getMinimumShiftForBitMask,
  isConsecutiveArray,
  stripUndefined,
  validatePayload
});
//# sourceMappingURL=misc.js.map
