"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var mocks_exports = {};
__export(mocks_exports, {
  createTestingHost: () => createTestingHost
});
module.exports = __toCommonJS(mocks_exports);
var import_core = require("@zwave-js/core");
var import_shared = require("@zwave-js/shared");
function createTestingHost(options = {}) {
  const valuesStorage = /* @__PURE__ */ new Map();
  const metadataStorage = /* @__PURE__ */ new Map();
  const valueDBCache = /* @__PURE__ */ new Map();
  const nodes = (0, import_shared.createThrowingMap)((nodeId) => {
    throw new import_core.ZWaveError(`Node ${nodeId} was not found!`, import_core.ZWaveErrorCodes.Controller_NodeNotFound);
  });
  const ret = {
    homeId: options.homeId ?? 2119630849,
    ownNodeId: options.ownNodeId ?? 1,
    getDeviceConfig: options.getDeviceConfig ?? (() => void 0),
    logNode: /* @__PURE__ */ __name(() => {
    }, "logNode"),
    getNode(nodeId) {
      return nodes.get(nodeId);
    },
    getNodeOrThrow(nodeId) {
      return nodes.getOrThrow(nodeId);
    },
    getAllNodes() {
      return [...nodes.values()];
    },
    setNode(nodeId, node) {
      nodes.set(nodeId, node);
    },
    getSupportedCCVersion: /* @__PURE__ */ __name((cc, nodeId, endpoint) => {
      return nodes.get(nodeId)?.getEndpoint(endpoint ?? 0)?.getCCVersion(cc) ?? 0;
    }, "getSupportedCCVersion"),
    getValueDB: /* @__PURE__ */ __name((nodeId) => {
      if (!valueDBCache.has(nodeId)) {
        valueDBCache.set(nodeId, new import_core.ValueDB(nodeId, valuesStorage, metadataStorage));
      }
      return valueDBCache.get(nodeId);
    }, "getValueDB"),
    tryGetValueDB: /* @__PURE__ */ __name((nodeId) => {
      return ret.getValueDB(nodeId);
    }, "tryGetValueDB")
  };
  return ret;
}
__name(createTestingHost, "createTestingHost");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  createTestingHost
});
//# sourceMappingURL=mocks.js.map
