"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var import_node = require("@zwave-js/core/bindings/fs/node");
var import_shared = require("@zwave-js/shared");
var import_typeguards = require("alcalzone-shared/typeguards");
var import_yargs = __toESM(require("yargs"), 1);
var import_helpers = require("yargs/helpers");
var import_convert = require("./convert.js");
const yargsInstance = (0, import_yargs.default)((0, import_helpers.hideBin)(process.argv));
void yargsInstance.env("NVMEDIT").strict().usage("Z-Wave JS NVM converter utility\n\nUsage: $0 [options]").alias("h", "help").alias("v", "version").wrap(Math.min(100, yargsInstance.terminalWidth())).options({
  verbose: {
    alias: "vv",
    describe: "Print verbose output",
    type: "boolean"
  }
}).command("nvm2json", "Convert an NVM backup to JSON", (yargs2) => yargs2.usage("$0 nvm2json --in <input> --out <output>").options({
  in: {
    describe: "NVM backup filename",
    type: "string",
    required: true
  },
  out: {
    describe: "JSON output filename",
    type: "string",
    required: true
  }
}), async (argv) => {
  const buffer = await import_node.fs.readFile(argv.in);
  let json;
  try {
    json = await (0, import_convert.nvmToJSON)(buffer, argv.verbose);
  } catch (e) {
    try {
      json = await (0, import_convert.nvm500ToJSON)(buffer);
    } catch {
      console.error(e);
      process.exit(1);
    }
  }
  await (0, import_shared.writeTextFile)(import_node.fs, argv.out, JSON.stringify(json, null, "	"));
  console.error(`NVM (JSON) written to ${argv.out}`);
  process.exit(0);
}).command("json2nvm", "Convert the JSON representation of an NVM to binary", (yargs2) => yargs2.usage("$0 json2nvm --in <input> --out <output> --protocolVersion <version>").options({
  in: {
    describe: "JSON input filename",
    type: "string",
    required: true
  },
  out: {
    describe: "NVM output filename",
    type: "string",
    required: true
  },
  protocolVersion: {
    alias: "V",
    describe: "target protocol version, determines the NVM format",
    type: "string",
    required: true
  }
}), async (argv) => {
  const { protocolVersion } = argv;
  const versionIs500 = /^\d\.\d+$/.test(protocolVersion);
  const json = await (0, import_shared.readJSON)(import_node.fs, argv.in);
  const jsonIs500 = json.format === 500;
  if (versionIs500 && !jsonIs500) {
    console.error(`ERROR: Protocol version ${protocolVersion} looks like a 500-series version, but the JSON file does not belong to a 500-series NVM!
Convert it first using the 700to500 command.`);
    process.exit(1);
  } else if (jsonIs500 && !versionIs500) {
    console.error(`ERROR: Protocol version ${protocolVersion} looks like a 700-series version, but the JSON file belong to a 500-series NVM!
Convert it first using the 500to700 command.`);
    process.exit(1);
  }
  if (!(0, import_typeguards.isObject)(json.meta)) {
    console.error(`ERROR: The JSON file does not contain the meta section, which is required for the conversion to a binary NVM!
Create a backup of the target stick, use the nvm2json command to convert it to JSON and copy the meta section from there.`);
    process.exit(1);
  }
  const nvm = versionIs500 ? await (0, import_convert.jsonToNVM500)(json, protocolVersion) : await (0, import_convert.jsonToNVM)(json, protocolVersion);
  await import_node.fs.writeFile(argv.out, nvm);
  console.error(`NVM (binary) written to ${argv.out}`);
  process.exit(0);
}).command("500to700", "Convert a 500-series JSON file into a 700-series JSON file", (yargs2) => yargs2.usage("$0 500to700 --in <input> --out <output> [--truncate]").options({
  in: {
    describe: "500 series JSON input filename",
    type: "string",
    required: true
  },
  out: {
    describe: "700 series output filename",
    type: "string",
    required: true
  },
  truncate: {
    alias: "t",
    describe: "Truncate application data if it is too large (> 512 bytes)",
    type: "boolean",
    required: false,
    default: false
  }
}), async (argv) => {
  const json500 = await (0, import_shared.readJSON)(import_node.fs, argv.in);
  const json700 = (0, import_convert.json500To700)(json500, argv.truncate);
  await (0, import_shared.writeTextFile)(import_node.fs, argv.out, JSON.stringify(json700, null, "	"));
  console.error(`700-series NVM (JSON) written to ${argv.out}`);
  process.exit(0);
}).command("700to500", "Convert a 700-series JSON file into a 500-series JSON file", (yargs2) => yargs2.usage("$0 700to500 --in <input> --out <output>").options({
  in: {
    describe: "700 series JSON input filename",
    type: "string",
    required: true
  },
  out: {
    describe: "500 series output filename",
    type: "string",
    required: true
  }
}), async (argv) => {
  const json700 = await (0, import_shared.readJSON)(import_node.fs, argv.in);
  const json500 = (0, import_convert.json700To500)(json700);
  await (0, import_shared.writeTextFile)(import_node.fs, argv.out, JSON.stringify(json500, null, "	"));
  console.error(`500-series NVM (JSON) written to ${argv.out}`);
  process.exit(0);
}).command("convert", "Convert the format of an NVM backup between different Z-Wave modules", (yargs2) => yargs2.usage("$0 convert --source <source> --target <target> --out <output>").options({
  source: {
    describe: "The source NVM filename. This file will be converted to match the target NVM.",
    type: "string",
    required: true
  },
  target: {
    describe: "The target NVM filename. This file will used to determine how to convert the source NVM.",
    type: "string",
    required: true
  },
  out: {
    describe: "The output filename where the convert NVM will be written.",
    type: "string",
    required: true
  },
  noAppData: {
    describe: "Whether application data should be stripped during the migration",
    type: "boolean",
    default: false
  },
  noRoutes: {
    describe: "Whether known routes should be stripped during the migration",
    type: "boolean",
    default: false
  },
  noNeighbors: {
    describe: "Whether information about neighbors should be stripped during the migration",
    type: "boolean",
    default: false
  },
  noSUCEntries: {
    describe: "Whether SUC update entries should be stripped during the migration",
    type: "boolean",
    default: false
  },
  noOptional: {
    describe: "Strip all optional information from the NVM. Overrides all other noXYZ flags.",
    type: "boolean",
    default: false
  }
}), async (argv) => {
  const { noAppData, noNeighbors, noRoutes, noSUCEntries, noOptional } = argv;
  const options = {
    preserveApplicationData: !noOptional && !noAppData,
    preserveRoutes: !noOptional && !noRoutes,
    preserveNeighbors: !noOptional && !noNeighbors,
    preserveSUCUpdateEntries: !noOptional && !noSUCEntries
  };
  const source = await import_node.fs.readFile(argv.source);
  const target = await import_node.fs.readFile(argv.target);
  const output = await (0, import_convert.migrateNVM)(source, target, options);
  await import_node.fs.writeFile(argv.out, output);
  console.error(`Converted NVM written to ${argv.out}`);
  process.exit(0);
}).demandCommand(1, "Please specify a command").parseAsync();
//# sourceMappingURL=cli.js.map
